/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.mediation.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.List;
import java.util.Map;

@Service(Name="com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService", Desc="", Interface=INeMgrProtocolExtendService.class)
public class NeMgrProtocolExtendServiceImpl
extends IsmBaseService
implements INeMgrProtocolExtendService {
    private static final Log LOGGER = LogFactory.getInstance(NeMgrProtocolExtendServiceImpl.class);
    private static final String HQL_NE_MGR_PROTOCOL_EXTEND_BY_MOID = "FROM NeMgrProtocolExtend WHERE moId = ? ";

    public NeMgrProtocolExtend findByMoId(Long moId) {
        List list = CommonDAOLocator.getMoDao().getHibernateTemplate().find(HQL_NE_MGR_PROTOCOL_EXTEND_BY_MOID, new Object[]{moId});
        if (null == list || list.isEmpty()) {
            return null;
        }
        NeMgrProtocolExtend dbParam = (NeMgrProtocolExtend)list.get(0);
        NeMgrProtocolExtend extParam = new NeMgrProtocolExtend();
        extParam.setExtendParams(dbParam.getExtendParams());
        extParam.setMoId(dbParam.getMoId());
        extParam.setNetworkIpAddress(dbParam.getNetworkIpAddress());
        extParam.setNetworkPassword(dbParam.getNetworkPassword());
        extParam.setNetworkUserName(dbParam.getNetworkUserName());
        extParam.setOtherParam(dbParam.getOtherParam());
        String password = extParam.getNetworkPassword();
        if (null != password) {
            extParam.setNetworkPassword(WccEncryptor.decrypt((String)password));
        }
        this.decryptPass(extParam);
        return extParam;
    }

    public void save(NeMgrProtocolExtend ne) {
        this.save(ne, true);
    }

    public void save(NeMgrProtocolExtend ne, boolean needDecryptPwd) {
        if (null == ne) {
            return;
        }
        String password = ne.getNetworkPassword();
        if (null != password) {
            ne.setNetworkPassword(WccEncryptor.encrypt((String)password));
        }
        this.encryptPass(ne);
        CommonDAOLocator.getMoDao().getHibernateTemplate().saveOrUpdate((Object)ne);
        if (needDecryptPwd) {
            ne.setNetworkPassword(password);
            this.decryptPass(ne);
        }
    }

    public void delete(NeMgrProtocolExtend ne) {
        CommonDAOLocator.getMoDao().getHibernateTemplate().delete((Object)ne);
    }

    public void update(NeMgrProtocolExtend ne) {
        String password = ne.getNetworkPassword();
        ne.setNetworkPassword(WccEncryptor.encrypt((String)password));
        this.encryptPass(ne);
        CommonDAOLocator.getMoDao().getHibernateTemplate().update((Object)ne);
    }

    public NeMgrProtocolExtend findBySn(String sn) {
        return this.findByProperty("sn", sn);
    }

    public NeMgrProtocolExtend findByUuid(String uuid) {
        return this.findByProperty("uuid", uuid);
    }

    private NeMgrProtocolExtend findByProperty(String propertyName, String propertyValue) {
        NetworkEntity entity = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, propertyName, (Object)propertyValue);
        if (null == entity) {
            LOGGER.error((Object)"Cannot find NetworkEntity by property %s and value %s", new Object[]{propertyName, propertyValue});
            return null;
        }
        NeMgrProtocolExtend ne = this.findByMoId(entity.getMoId());
        if (null == ne) {
            LOGGER.error((Object)"Network Entity(%s, %s)'s NeMgrProtocolExtend(%s) not exists.", new Object[]{entity.getClass(), propertyValue, entity.getMoId()});
            return null;
        }
        return ne;
    }

    private void encryptPass(NeMgrProtocolExtend ne) {
        Map extendParams = ne.getExtendParams();
        for (Map.Entry entry : extendParams.entrySet()) {
            if (!((String)entry.getKey()).endsWith("Pass") && !((String)entry.getKey()).endsWith("pwd")) continue;
            entry.setValue(WccEncryptor.encrypt((String)((String)entry.getValue())));
        }
    }

    private void decryptPass(NeMgrProtocolExtend ne) {
        Map extendParams = ne.getExtendParams();
        for (Map.Entry entry : extendParams.entrySet()) {
            if (!((String)entry.getKey()).endsWith("Pass") && !((String)entry.getKey()).endsWith("pwd")) continue;
            entry.setValue(WccEncryptor.decrypt((String)((String)entry.getValue())));
        }
    }
}

