/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.mediation.status;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.mediation.status.Istatus;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import java.io.Serializable;
import java.util.HashMap;

public class DefaultOnlineToOfflineStatus
implements Istatus {
    private static final Log logger = LogFactory.getInstance(DefaultOnlineToOfflineStatus.class);

    @Override
    public void doAction(ManagedObject mo, int status) {
        if (!(mo instanceof NetworkEntity)) {
            return;
        }
        NetworkEntity entity = (NetworkEntity)mo;
        String id = "0x000803220005";
        if (-1 == status) {
            IMoDao modao = CommonDAOLocator.getMoDao();
            ManagedObject moInfo = (ManagedObject)modao.get((Serializable)mo.getMoId());
            if (null == moInfo) {
                logger.info((Object)("Mo not exist, sn=" + entity.getSn()));
                return;
            }
            this.sendDeviceAlarm(entity, id, moInfo.getUuid());
            this.sendOffLineMsg(entity);
        } else {
            this.sendRestoreAlarm(entity, id);
            this.sendOnlineMsg(entity, status);
        }
    }

    private void sendAlarm(String alarmId, String uuid, FaultEnum.AlarmSeverity alarmSeverity, String ... params) {
        LegoAlarm alarm = new LegoAlarm();
        alarm.setAlarmId(alarmId);
        alarm.setMoIP("127.0.0.1");
        alarm.setAlarmTime(System.currentTimeMillis());
        alarm.setAlarmLevel(alarmSeverity);
        alarm.setAlarmParam(params);
        alarm.setSourceId(uuid);
        alarm.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
        try {
            boolean isSuccessed = ((IFaultGenerateService)ServiceLocator.getInstance().getService(IFaultGenerateService.class)).generateLegoAlarm(alarm);
            if (!isSuccessed) {
                logger.error((Object)"generate fault alarm failed.see lego logs");
            }
        }
        catch (Exception e) {
            logger.error((Object)("generate fault alarm failed" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private String getMoIpAddress(NetworkEntity entity) {
        String ip = entity.getIpAddress() != null ? entity.getIpAddress() : entity.getLinkIp();
        return ip;
    }

    private void sendDeviceAlarm(NetworkEntity entity, String id, String uuid) {
        String[] alramParams = new String[]{entity.getName(), this.getMoIpAddress(entity), entity.getUuid(), entity.getSubType()};
        logger.error((Object)"Alarm : The device's status has changed from onlice to offline!", 90160758784520L);
        this.sendAlarm(id, uuid, FaultEnum.AlarmSeverity.CRITICAL, alramParams);
    }

    private synchronized void sendOffLineMsg(NetworkEntity mo) {
        HashMap<Long, Integer> moStatus = new HashMap<Long, Integer>();
        moStatus.put(mo.getMoId(), -1);
        IMessageCenter mc = (IMessageCenter)ServiceLocator.getInstance().getService(IMessageCenter.class);
        MessageUnit mu = new MessageUnit();
        mu.setSourceAppName("UBase/CBB_Discover");
        mu.setCmdcode(109L);
        mu.setObj(moStatus);
        mu.setMt(MessageTopic.COMMAND);
        mc.sendMessage(mu);
        logger.info((Object)("Send mo offline message, sn=" + mo.getSn() + ", uuid=" + mo.getUuid()));
    }

    private synchronized void sendOnlineMsg(NetworkEntity mo, int status) {
        HashMap<Long, Integer> moStatus = new HashMap<Long, Integer>();
        moStatus.put(mo.getMoId(), status);
        IMessageCenter mc = (IMessageCenter)ServiceLocator.getInstance().getService(IMessageCenter.class);
        MessageUnit mu = new MessageUnit();
        mu.setSourceAppName("UBase/CBB_Discover");
        mu.setCmdcode(110L);
        mu.setObj(moStatus);
        mu.setMt(MessageTopic.COMMAND);
        mc.sendMessage(mu);
        logger.info((Object)("Send mo online message, sn=" + mo.getSn() + ", uuid=" + mo.getUuid()));
    }

    private void sendRestoreAlarm(NetworkEntity ne, String id) {
        logger.info((Object)("The device's status alarm has restored, sn=" + ne.getSn() + ", uuid=" + ne.getUuid()));
        AlarmUtil.restoreAlarm((String)id, (String[])new String[]{ne.getUuid()});
    }
}

