/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.indication;

import com.huawei.ism.cbb.proxy.indication.IListener;
import com.huawei.ism.cbb.proxy.indication.ISubscription;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashSet;
import java.util.Set;

public class DefaultDeviceSubscription
implements ISubscription {
    private Log logger = LogFactory.getInstance((Object)this);
    private String deviceId;
    private Set<IListener> listeners = new HashSet<IListener>();

    public DefaultDeviceSubscription(String deviceId, Set<IListener> listeners) {
        if (deviceId == null || deviceId.length() < 1) {
            this.logger.fatal((Object)"DeviceId can not be null !", 90160758784004L);
        } else {
            this.deviceId = deviceId;
        }
        if (listeners == null) {
            this.logger.fatal((Object)"Listener can not be null !", 90160758784004L);
        } else {
            this.listeners.addAll(listeners);
        }
    }

    @Override
    public void notifyMsg(Notification nf) {
        Object tmp = null;
        try {
            for (IListener listener : this.listeners) {
                tmp = listener;
                tmp.notifyMsg(nf);
            }
        }
        catch (Exception e) {
            String className = null == tmp ? null : tmp.getClass().getSimpleName();
            this.logger.error((Object)("Exception raised while dealing with listener: " + className + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }
}

