/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.rest;

import com.huawei.ism.cbb.proxy.protocol.rest.RestRequestData;
import com.huawei.ism.cbb.proxy.protocol.rest.RestResponseData;
import com.huawei.ism.cbb.util.BufferedReaderDecorator;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;

public final class RestClient {
    private static Log logger = LogFactory.getInstance(RestClient.class);
    private static final int DEFAULT_VALUE_10 = 10;
    private static final int DEFAULT_VALUE_30 = 30;
    private static final int DEFAULT_VALUE_1000 = 1000;
    private static final int DEFAULT_VALUE_60 = 60;
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READDATA_TIMEOUT = 1800000;
    private static final int MAX_RETRY_TIME = 3;
    private static final long NEED_RETRY_TIME = 600000L;

    public static CloseableHttpClient buildHttpClient(String ip) {
        SSLConnectionSocketFactory sslFactory = RestClient.buildSocketFactory(ip);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslFactory).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(registry);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(Timeout.ofMilliseconds((long)30000L));
        builder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)1800000L));
        RequestConfig requestConfig = builder.build();
        CloseableHttpClient httpclient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connMgr).disableContentCompression().build();
        return httpclient;
    }

    public static RestResponseData processRequest(CloseableHttpClient httpclient, RestRequestData request) {
        logger.debug((Object)"Enter processRequest.");
        if (null == httpclient || null == request) {
            logger.error((Object)"Null parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        RestResponseData restResponse = new RestResponseData();
        String url = request.getUri();
        String method = request.getRequestMethod();
        HttpUriRequestBase httpRequest = null;
        int retryTimes = 0;
        while (retryTimes < 3) {
            long requestBegin = new Date().getTime();
            try {
                httpRequest = RestClient.buildHttpRequest(method, url, request);
                RestClient.setHttpHeaders(request, httpRequest);
                CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httpRequest);
                RestClient.receiveResponse(restResponse, response);
                logger.debug((Object)"ProcessRequest success");
                break;
            }
            catch (UnsupportedEncodingException ue) {
                logger.error((Object)("UnsupportedEncodingException, method=" + method + ", url=" + url), (Throwable)ue);
                throw new LegoCheckedException(1073947393L, (Throwable)ue);
            }
            catch (IOException ie) {
                logger.error((Object)("IOEx, method=" + method + ", url=" + url + ", retryTimes=" + ++retryTimes), (Throwable)ie);
                long requestEnd = new Date().getTime();
                logger.error((Object)("IOEx, method=" + method + ", url=" + url + ", time=" + (requestEnd - requestBegin)));
                if (retryTimes < 3 && requestEnd - requestBegin <= 600000L) continue;
                throw new LegoCheckedException(104403L, (Throwable)ie);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("Http request error! error code:" + e.getErrorCode()), (Throwable)e);
                throw e;
            }
            catch (Exception ex) {
                logger.error((Object)("Exception, method=" + method + ", url=" + url + ExceptionUtil.getErrorMessage((Throwable)ex)));
                throw new LegoCheckedException(-1L, (Throwable)ex);
            }
            finally {
                RestClient.releaseConnection(httpclient);
            }
        }
        logger.debug((Object)"Exit processRequest.");
        return restResponse;
    }

    private static void releaseConnection(CloseableHttpClient httpClient) {
        if (httpClient == null) {
            logger.error((Object)"HttpClient is null.");
            return;
        }
        try {
            httpClient.close();
        }
        catch (Exception ex) {
            logger.error((Object)("Release connection error." + ExceptionUtil.getErrorMessage((Throwable)ex)));
        }
    }

    private static HttpUriRequestBase buildHttpRequest(String method, String url, RestRequestData request) {
        HttpGet httpRequest;
        if ("GET".equals(method)) {
            httpRequest = new HttpGet(url);
        } else if ("POST".equals(method)) {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(request.getBody(), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            httpRequest = httpPost;
        } else if ("PUT".equals(method)) {
            HttpPut httpPut = new HttpPut(url);
            StringEntity stringEntity = new StringEntity(request.getBody(), ContentType.APPLICATION_JSON);
            httpPut.setEntity((HttpEntity)stringEntity);
            httpRequest = httpPut;
        } else if ("DELETE".equals(method)) {
            httpRequest = new HttpDelete(url);
        } else {
            logger.error((Object)("Illegal method: " + method));
            throw new LegoCheckedException(1073947393L);
        }
        return httpRequest;
    }

    private static void receiveResponse(RestResponseData response, CloseableHttpResponse httpResponse) throws IOException {
        try (BufferedReader reader = null;){
            int statusCode = httpResponse.getCode();
            if (statusCode >= 200 && statusCode < 300) {
                String line;
                HttpEntity entity = httpResponse.getEntity();
                reader = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));
                BufferedReaderDecorator decorator = new BufferedReaderDecorator(reader);
                StringBuilder sb = new StringBuilder();
                while (null != (line = decorator.readLine())) {
                    sb.append(line + "\n");
                }
                response.setBody(sb.toString());
                response.setSuccess(true);
                Header[] httpHeaders = httpResponse.getHeaders();
                RestClient.setResponse(response, httpHeaders);
            }
            response.setHttpStatusCode(statusCode);
            if ((long)statusCode == 404L) {
                logger.error((Object)("Http status code is :" + statusCode));
                throw new LegoCheckedException(404L);
            }
        }
    }

    private static void setResponse(RestResponseData response, Header[] httpHeaders) {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        if (null != httpHeaders && httpHeaders.length > 0) {
            for (Header header : httpHeaders) {
                String name = header.getName();
                String value = header.getValue();
                ArrayList<String> values = (ArrayList<String>)headerMap.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    headerMap.put(name, values);
                }
                values.add(value);
            }
        }
        response.setHeaders(headerMap);
    }

    private static void setHttpHeaders(RestRequestData request, HttpUriRequestBase httpRequest) {
        Map<String, String> headers = request.getHeaders();
        if (null != headers && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpRequest.addHeader(entry.getKey(), (Object)entry.getValue());
            }
        }
        String requestDate = RestClient.getHttpRequestDate();
        httpRequest.addHeader("Date", (Object)requestDate);
        httpRequest.addHeader("Host", (Object)request.getHostName());
    }

    private static SSLConnectionSocketFactory buildSocketFactory(String ip) {
        SSLConnectionSocketFactory socketFactory = null;
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{new BcmX509TrustManager(ip)}, null);
            HostnameVerifier verifier = new HostnameVerifier(){

                @Override
                public boolean verify(String paramString, SSLSession paramSSLSession) {
                    return true;
                }
            };
            socketFactory = new SSLConnectionSocketFactory(ctx, verifier);
        }
        catch (Exception ex) {
            logger.error((Object)("Manager.properties io error:" + ExceptionUtil.getErrorMessage((Throwable)ex)));
        }
        return socketFactory;
    }

    private static String getHttpRequestDate() {
        Locale aLocale = Locale.US;
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z", new DateFormatSymbols(aLocale));
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        return fmt.format(new Date());
    }
}

