/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.rest.connection;

import com.huawei.ism.cbb.proxy.protocol.rest.RestClient;
import com.huawei.ism.cbb.proxy.protocol.rest.RestRequestData;
import com.huawei.ism.cbb.proxy.protocol.rest.RestResponseData;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.util.ResourceHelper;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;

public class HvsRestConnection
extends RestConnection {
    private static Log logger = LogFactory.getInstance(HvsRestConnection.class);
    private static final long UNAUTH_ERROR_CODE = -401L;
    private CloseableHttpClient httpClient = null;
    private String authCookie;
    private String contextPath = ResourceHelper.getValue("hvs.contextpath");
    private int userScope = 0;

    public HvsRestConnection(String ipAddress, int port, String userName, String password) {
        super(ipAddress, port, userName, password);
        if (this.getPort() == 0) {
            this.setPort(NumberUtil.parseInteger((Object)ResourceHelper.getValue("hvs.port")));
        }
        this.setProtocol(NumberUtil.parseInteger((Object)ResourceHelper.getValue("hvs.protocol")));
    }

    @Override
    public void init(Map<String, String> properties) {
        this.setProtocol(NumberUtil.parseInteger((Object)ResourceHelper.getValue("hvs.protocol")));
        this.contextPath = ResourceHelper.getValue("hvs.contextpath");
        this.setPort(NumberUtil.parseInteger((Object)properties.get("PORT")));
        if (this.getPort() == 0) {
            this.setPort(NumberUtil.parseInteger((Object)ResourceHelper.getValue("hvs.port")));
        }
        this.setIpAddress(properties.get("IPADDRESS"));
        this.setUserName(properties.get("USERNAME"));
        this.setPassword(properties.get("PASSWORD"));
    }

    @Override
    public void authenticate() {
        RestResponseData response = this.getRestResponseData();
        if (null == response || null == response.getHeaders()) {
            logger.warn((Object)"response body is empty!");
            throw new LegoCheckedException(0x300001L);
        }
        List<String> cookies = response.getHeaders().get("Set-Cookie");
        if (!VerifyUtil.isEmpty(cookies)) {
            this.authCookie = cookies.get(0);
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)response.getBody());
        JSONObject error = JSONObject.fromObject((Object)jsonObject.get("error"));
        Long errorCode = error.getLong("code");
        String ipAddress = this.getIpAddress();
        String deviceId = this.getDeviceId();
        if (null != errorCode && 0L != errorCode) {
            logger.error((Object)("errorCode=" + errorCode + ", ip=" + ipAddress + ", devSn=" + deviceId), 90160758784000L);
            throw new LegoCheckedException(errorCode.longValue(), error.getString("description"));
        }
        JSONObject data = JSONObject.fromObject((Object)jsonObject.get("data"));
        deviceId = data.getString("deviceid");
        this.setDeviceId(deviceId);
        logger.info((Object)("Establish rest connection, devSn=" + deviceId + ", ip=" + ipAddress), 90160758784000L);
        try {
            this.setToken(data.getString("iBaseToken"));
        }
        catch (Exception e) {
            logger.error((Object)("Getting iBaseToken failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        if (!this.isValid()) {
            logger.error((Object)("connection is not valid. ip=" + ipAddress + ", devSn=" + deviceId), 90160758784000L);
            this.logout();
            throw new LegoCheckedException(1073947393L);
        }
    }

    private RestResponseData getRestResponseData() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("username", this.getUserName());
        paramMap.put("password", this.getPassword());
        paramMap.put("scope", String.valueOf(this.userScope));
        RestResponseData response = this.postAndGetResponseData("/rest/${deviceID}/sessions", paramMap);
        return response;
    }

    @Override
    public Map<String, String> post(String url, Map<String, String> paramMap) {
        RestResponseData response = this.postAndGetResponseData(url, paramMap);
        Map<String, String> resultData = this.parseResponseData(response);
        return resultData;
    }

    @Override
    public String postForObject(String url, Object object) {
        RestResponseData response = this.postAndGetResponseData(url, object);
        Map<String, String> resultData = this.parseResponseData(response);
        return JSONObject.fromObject(resultData).toString();
    }

    @Override
    public Map<String, String> put(String url, Map<String, String> paramMap) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("PUT");
        this.buildRestRequestData(url, paramMap, request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        Map<String, String> resultData = this.parseResponseData(response);
        return resultData;
    }

    private RestResponseData postAndGetResponseData(String url, Object requestData) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("POST");
        this.buildRestRequestData(url, requestData, request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return response;
    }

    @Override
    public Map<String, String> get(String url, Map<String, String> paramMap) {
        List<Map<String, String>> resultDatas = this.getBatch(url, paramMap, false);
        if (!VerifyUtil.isEmpty(resultDatas)) {
            return resultDatas.get(0);
        }
        return Collections.emptyMap();
    }

    @Override
    public List<Map<String, String>> getBatch(String url, Map<String, String> paramMap, boolean page) {
        logger.debug((Object)String.format("begin to send page query request for url(%s)", url));
        ArrayList<Map<String, String>> resultDatas = new ArrayList<Map<String, String>>();
        if (!page || !this.isPagingQuery(url)) {
            RestRequestData request = new RestRequestData();
            request.setRequestMethod("GET");
            this.buildRestRequestData(url, paramMap, request);
            RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
            JSONObject jsonObject = JSONObject.fromObject((Object)response.getBody());
            if (null == jsonObject || jsonObject.isEmpty()) {
                logger.warn((Object)"response body is empty!");
                return resultDatas;
            }
            JSONObject error = JSONObject.fromObject((Object)jsonObject.get("error"));
            Long errorCode = null;
            if (null != error && !error.isEmpty()) {
                errorCode = error.getLong("code");
            }
            if (null != errorCode && 0L != errorCode) {
                if (errorCode == -401L) {
                    logger.error((Object)"[%s] auth failed. re-authenticating..", new Object[]{this.getIpAddress()});
                    this.authenticate();
                    logger.info((Object)"[%s] re-auth success.", new Object[]{this.getIpAddress()});
                }
                throw new LegoCheckedException(errorCode.longValue(), error.getString("description"));
            }
            if (jsonObject.containsKey((Object)"data")) {
                this.retrieveResultData(resultDatas, jsonObject);
            }
            logger.debug((Object)String.format("send page query request for url(%s)", url));
        } else {
            this.queryByPage(url, paramMap, resultDatas);
        }
        return resultDatas;
    }

    private void queryByPage(String url, Map<String, String> paramMap, List<Map<String, String>> resultDatas) {
        int pageSize = 100;
        List<Map<String, String>> tempResultDatas = null;
        int s = 0;
        do {
            int e = s + pageSize;
            String a = url.replaceAll("([?&]range=\\[)\\d+-\\d+(\\](&|$))", String.format("$1%s-%s$2", s, e));
            s += pageSize;
            try {
                tempResultDatas = this.getBatch(a, paramMap, false);
            }
            catch (LegoCheckedException ee) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute paging query failed, error code is ");
                sb.append(ee.getErrorCode());
                sb.append(", error message is ");
                sb.append(ee.getMessage());
                sb.append(" May be the device does not support the rest interface.");
                logger.warn((Object)sb.toString());
                logger.warn((Object)("The rest url is " + a));
                break;
            }
            logger.info((Object)("url=" + a));
            if (VerifyUtil.isEmpty(tempResultDatas)) break;
            logger.info((Object)("record size is " + tempResultDatas.size()));
            resultDatas.addAll(tempResultDatas);
        } while (tempResultDatas.size() == pageSize);
    }

    @Override
    public Map<String, String> putForObject(String url, Object object) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("PUT");
        this.buildRestRequestData(url, JSONObject.fromObject((Object)object), request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return this.parseResponseData(response);
    }

    @Override
    public List<Map<String, String>> getBatch(String url, Map<String, String> paramMap) {
        return this.getBatch(url, paramMap, true);
    }

    @Override
    public void delete(String url, Map<String, String> paramMap) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("DELETE");
        this.buildRestRequestData(url, paramMap, request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        this.parseResponseData(response);
    }

    @Override
    public Map<String, String> deleteForObject(String url, Object object) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("DELETE");
        this.buildRestRequestData(url, this.convertJSONObject2Map(JSONObject.fromObject((Object)object)), request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return this.parseResponseData(response);
    }

    private CloseableHttpClient getHttpClient() {
        if (null == this.httpClient) {
            this.httpClient = RestClient.buildHttpClient(this.getIpAddress());
        }
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() {
        String deviceId = this.getDeviceId();
        String token = this.getToken();
        logger.info((Object)("Rest connection logout, devSn=" + deviceId), 90160758784000L);
        if (null != token && !token.isEmpty()) {
            this.delete("/rest/${deviceID}/sessions", null);
        }
        if (null != this.httpClient) {
            try {
                this.httpClient.close();
            }
            catch (IOException ex) {
                logger.error((Object)"close httpClient error.", (Throwable)ex);
            }
            finally {
                try {
                    this.httpClient.close();
                    logger.debug((Object)"success closing expired connections");
                }
                catch (Exception e) {
                    logger.error((Object)("failed closing expired connections, cause by " + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
            }
            this.httpClient = null;
        }
        logger.info((Object)("Logout, devSn=" + this.getDeviceId() + ", ip=" + this.getIpAddress()), 90160758784000L);
    }

    public void buildRestRequestData(String url, Object requestData, RestRequestData request) {
        if (null == url) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        String ip = this.getIpAddress();
        if (Ipv6AddressUtil.isIPv6Address((String)ip)) {
            ip = Ipv6AddressUtil.convertIpv6((String)ip);
        }
        request.setProtocol(this.getProtocol());
        request.setHostName(ip);
        request.setPort(this.getPort());
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProtocol() == 0 ? "http://" : "https://");
        sb.append(ip);
        sb.append(":").append(this.getPort());
        sb.append(this.contextPath);
        sb.append(url.replace("${deviceID}", this.getDeviceId()));
        request.setUri(sb.toString());
        if (!VerifyUtil.isEmpty((Object)requestData)) {
            JSONObject paramObject = JSONObject.fromObject((Object)requestData);
            request.setBody(paramObject.toString());
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Cookie", this.authCookie);
        String token = this.getToken();
        if (!VerifyUtil.isEmpty((String)token)) {
            headerMap.put("iBaseToken", token);
        }
        request.setHeaders(headerMap);
    }

    private Map<String, String> convertJSONObject2Map(JSONObject data) {
        logger.debug((Object)"enter convertJSONObject2Map");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (null == data) {
            return resultMap;
        }
        Iterator iterator = data.keys();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = data.get(key.toString());
            if (null == value) continue;
            resultMap.put(key.toString(), value.toString());
        }
        return resultMap;
    }

    private Map<String, String> parseResponseData(RestResponseData response) {
        logger.debug((Object)"enter parseResponseData");
        Map<String, String> resultData = Collections.emptyMap();
        if (null != response) {
            JSONObject jsonObject = JSONObject.fromObject((Object)response.getBody());
            JSONObject error = JSONObject.fromObject((Object)jsonObject.get("error"));
            Long errorCode = error.getLong("code");
            if (null != errorCode && 0L != errorCode) {
                String errorParam;
                if (errorCode == -401L) {
                    logger.error((Object)"[%s] auth failed. re-authenticating...", new Object[]{this.getIpAddress()});
                    this.authenticate();
                    logger.info((Object)"[%s] re-auth success.", new Object[]{this.getIpAddress()});
                }
                if (error.containsKey((Object)"errorParam") && !VerifyUtil.isEmpty((String)(errorParam = error.getString("errorParam")))) {
                    logger.error((Object)error.getString("description"));
                    String[] errParams = errorParam.split(",");
                    throw new LegoCheckedException(errorCode.longValue(), StringUtil.getErrorCodeParams((String[])errParams));
                }
                throw new LegoCheckedException(errorCode.longValue(), error.getString("description"));
            }
            if (jsonObject.containsKey((Object)"data")) {
                JSONObject data = JSONObject.fromObject((Object)jsonObject.get("data"));
                resultData = this.convertJSONObject2Map(data);
            }
        }
        return resultData;
    }

    private void retrieveResultData(List<Map<String, String>> resultDatas, JSONObject jsonObject) {
        logger.debug((Object)"enter retrieveResultData");
        Object data = jsonObject.get("data");
        if (data instanceof JSONObject) {
            Map<String, String> resultMap = this.convertJSONObject2Map((JSONObject)data);
            resultDatas.add(resultMap);
        } else if (data instanceof JSONArray) {
            JSONArray dataArray = (JSONArray)data;
            int len = dataArray.size();
            for (int i = 0; i < len; ++i) {
                Map<String, String> resultMap = this.convertJSONObject2Map(dataArray.getJSONObject(i));
                if (null == resultMap) continue;
                resultDatas.add(resultMap);
            }
        }
    }

    public String getAuthCookie() {
        return this.authCookie;
    }

    public void setAuthCookie(String authCookie) {
        this.authCookie = authCookie;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public int getUserScope() {
        return this.userScope;
    }

    public void setUserScope(int userScope) {
        this.userScope = userScope;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public boolean isConnected() {
        boolean isConnected = false;
        String deviceId = this.getDeviceId();
        String ipAddress = this.getIpAddress();
        try {
            Map<String, String> resultMap = this.get("/rest/${deviceID}/storagepool/count", null);
            if (!VerifyUtil.isEmpty(resultMap)) {
                isConnected = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Testing connection failed, devSn=" + deviceId + ", ip=" + ipAddress + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        return isConnected;
    }

    @Override
    public boolean isValid() {
        return this.isConnected();
    }

    @Override
    public List<Map<String, String>> pagingQuery(String url, int start, int end) {
        if (null == url) {
            logger.error((Object)"Request url is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        return this.getBatch(sb.toString(), null, false);
    }

    private boolean isPagingQuery(String url) {
        if (null == url) {
            return false;
        }
        try {
            Pattern urlRegex = Pattern.compile("[^?]*\\?([^=]+=(&amp;|[^&]*))*&?range=\\[(\\d+)-(\\d+)\\]([^=]+=(&amp;|[^&]*))*");
            Matcher matcher = urlRegex.matcher(url);
            return matcher.find();
        }
        catch (NumberFormatException exception) {
            logger.error((Object)("match paging query failed. " + ExceptionUtil.getErrorMessage((Throwable)exception)));
            return false;
        }
        catch (IllegalStateException exception) {
            logger.error((Object)("match paging query failed.. " + ExceptionUtil.getErrorMessage((Throwable)exception)));
            return false;
        }
    }
}

