/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.rest.connection;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncaughtExceptionHandler;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class RestConnectionManager {
    private static Log logger = LogFactory.getInstance(RestConnectionManager.class);
    private static RestConnectionManager instance = new RestConnectionManager();
    private Map<String, RestConnection> connMap = new ConcurrentHashMap<String, RestConnection>();

    public static RestConnectionManager getInstance() {
        return instance;
    }

    public RestConnection getConnection(String deviceID) {
        this.setUncaughtExceptionHandler();
        if (this.connMap.containsKey(deviceID)) {
            return this.connMap.get(deviceID);
        }
        INeMgrProtocolExtendService src = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend protocolExtend = src.findBySn(deviceID);
        if (null != protocolExtend) {
            RestConnection connection = this.buildConnection(protocolExtend);
            connection.authenticate();
            this.addConnection(deviceID, connection);
            return connection;
        }
        return null;
    }

    public RestConnection removeConnection(String devSn) {
        this.setUncaughtExceptionHandler();
        if (!this.connMap.containsKey(devSn)) {
            logger.info((Object)("Rest connection not exsit, devSn=" + devSn), 90160758784000L);
            return null;
        }
        try {
            logger.info((Object)("Begin logout rest connection, devSn=" + devSn), 90160758784000L);
            this.connMap.get(devSn).logout();
        }
        catch (Exception ex) {
            logger.error((Object)("Fail to logout rest connection." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758784000L);
        }
        RestConnection removed = this.connMap.remove(devSn);
        return removed;
    }

    public void addConnection(String devSn, RestConnection conn) {
        if (VerifyUtil.isEmpty((String)devSn) || null == conn) {
            return;
        }
        this.setUncaughtExceptionHandler();
        logger.info((Object)("Rest connection added, devSn=" + devSn), 90160758784000L);
        conn.setDeviceId(devSn);
        this.connMap.put(devSn, conn);
    }

    public RestConnection buildConnection(NeMgrProtocolExtend neMgrProtocolExtend) {
        if (null == neMgrProtocolExtend) {
            logger.error((Object)"protocol info is null.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        String ipAddress = neMgrProtocolExtend.getNetworkIpAddress();
        int port = NumberUtil.parseInteger(neMgrProtocolExtend.getExtendParams().get("port"));
        String userName = neMgrProtocolExtend.getNetworkUserName();
        String password = neMgrProtocolExtend.getNetworkPassword();
        HvsRestConnection connection = new HvsRestConnection(ipAddress, port, userName, password);
        return connection;
    }

    public void setConnection(String devSn, RestConnection connection) {
        this.setUncaughtExceptionHandler();
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)("devSn is empty, value=" + devSn), 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        if (null == connection) {
            logger.error((Object)"connection is null.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!connection.isValid()) {
            logger.error((Object)"connection is not valid.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection oldConnection = null;
        try {
            oldConnection = this.getConnection(devSn);
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred when get FusionStorage Rest Connection.", (Throwable)e);
        }
        if (oldConnection != null) {
            this.removeConnection(devSn);
        }
        this.addConnection(devSn, connection);
    }

    private void setUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler exceptionHandler = Thread.currentThread().getUncaughtExceptionHandler();
        if (null == exceptionHandler || exceptionHandler instanceof ThreadGroup) {
            Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LegoUncaughtExceptionHandler.getInstance());
        }
    }
}

