/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.constant;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class NetUtil {
    public static final int CONN_SSL_SOCKECT = 1;
    public static final String IPV4_LOOPBACK_ADDRESS = "127.0.0.1";
    public static final String IPV6_LOOPBACK_ADDRESS = "0:0:0:0:0:0:0:1";
    private static final Log logger = LogFactory.getInstance(NetUtil.class);
    private static final String REREX_IPV6_ADDRESS = "^\\s*((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})))(%.+)?\\s*$";

    public static int ipv4Str2Int(String ip) {
        NetUtil.checkIPV4(ip);
        String[] str = ip.split("\\.");
        int ipValue = 0;
        for (int i = 0; i < 4; ++i) {
            if (i >= str.length) continue;
            int tmp = NumberUtil.convertToInteger((Object)str[i]);
            ipValue |= tmp;
            if (i == 3) continue;
            ipValue <<= 8;
        }
        return ipValue;
    }

    public static void checkIPV4(String ip) throws IllegalArgumentException {
        Pattern pattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher mat = pattern.matcher(ip);
        if (!mat.matches()) {
            throw new IllegalArgumentException("wrong IP format\uff1a" + ip);
        }
        try {
            if (InetAddress.getByName(ip) == null) {
                return;
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("wrong IP scope\uff1a" + ip);
        }
    }

    private static List<String> queryAllLocalIP() {
        NetworkInterface[] networkInterfaces;
        ArrayList<String> ips = new ArrayList<String>();
        for (NetworkInterface networkInterface : networkInterfaces = NetUtil.availableInterface()) {
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                ips.add(address.getHostAddress());
            }
        }
        return ips;
    }

    public static NetworkInterface[] availableInterface() {
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            LogManager.warn((Object)("get localhost NIC error " + e));
            return new NetworkInterface[0];
        }
        if (networkInterfaces == null) {
            return new NetworkInterface[0];
        }
        ArrayList<NetworkInterface> netWorkInterfaces = new ArrayList<NetworkInterface>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInfterface = networkInterfaces.nextElement();
            boolean available = false;
            Enumeration<InetAddress> iNetAddress = networkInfterface.getInetAddresses();
            while (iNetAddress.hasMoreElements()) {
                InetAddress element = iNetAddress.nextElement();
                if (element.isLoopbackAddress()) continue;
                available = true;
                break;
            }
            if (!available) continue;
            netWorkInterfaces.add(networkInfterface);
        }
        return netWorkInterfaces.toArray(new NetworkInterface[netWorkInterfaces.size()]);
    }

    private static String getIPv4Address(List<String> ips) {
        for (String ip : ips) {
            if (!Ipv4AddressUtil.isValidIPv4((String)ip)) continue;
            return ip;
        }
        return IPV4_LOOPBACK_ADDRESS;
    }

    private static String getIPv6Address(List<String> ips) {
        for (String ip : ips) {
            if (!NetUtil.isValidIPV6(ip)) continue;
            return ip;
        }
        return IPV6_LOOPBACK_ADDRESS;
    }

    public static boolean isValidIPV6(String ipv6) {
        if (ipv6 == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(REREX_IPV6_ADDRESS);
        Matcher mat = pattern.matcher(ipv6);
        if (!mat.matches()) {
            return false;
        }
        try {
            Inet6Address address = (Inet6Address)InetAddress.getByName(ipv6);
            if (address != null) {
                return !address.isMulticastAddress() && !address.isLoopbackAddress() && !address.isAnyLocalAddress();
            }
            return false;
        }
        catch (UnknownHostException e) {
            LogManager.error((Object)("isValidIPV6 failed" + LogManager.getErrorMessage((Throwable)e)));
            return false;
        }
        catch (Exception e1) {
            LogManager.error((Object)("check is valid ipv6 error:" + LogManager.getErrorMessage((Throwable)e1)));
            return !NetUtil.isValidIPV4(ipv6);
        }
    }

    public static boolean isValidIPV4(String ip) {
        try {
            NetUtil.checkIPV4(ip);
            String[] str = ip.split("\\.");
            int ipField1 = Integer.parseInt(str[0]);
            int ipField2 = Integer.parseInt(str[1]);
            int ipField3 = Integer.parseInt(str[2]);
            int ipField4 = Integer.parseInt(str[3]);
            return ipField1 >= 1 && ipField1 <= 223 && ipField1 != 127 && ipField2 >= 0 && ipField2 <= 255 && ipField3 >= 0 && ipField3 <= 255 && ipField4 >= 0 && ipField4 <= 255;
        }
        catch (Throwable t) {
            LogManager.error((Object)("isValidIPV4 failed" + LogManager.getErrorMessage((Throwable)t)));
            return false;
        }
    }

    public static Socket connect(String ip, int port, Proxy proxy) {
        Socket socket = null;
        try {
            TrustManager[] tms = new TrustManager[]{new IsmTrustManager()};
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, tms, null);
            SSLSocketFactory ssf = context.getSocketFactory();
            socket = ssf.createSocket();
            InetSocketAddress address = new InetSocketAddress(ip, port);
            socket.connect(address, 30000);
            socket.setReuseAddress(true);
        }
        catch (IOException ex) {
            CommonUtil.close(socket);
            throw new LegoCheckedException(5L, (Throwable)ex);
        }
        catch (Exception ex) {
            CommonUtil.close(socket);
            throw new LegoCheckedException(5L, (Throwable)ex);
        }
        return socket;
    }

    public static String queryLocalIP(String ip, int port) {
        if (Ipv6AddressUtil.isIPv6Address((String)ip)) {
            return NetUtil.getIPv6LocalAddr(ip, port);
        }
        if (Ipv4AddressUtil.isIPv4Address((String)ip)) {
            return NetUtil.getIPv4LocalAddr(ip, port);
        }
        logger.error((Object)("input ip address not valid. ip:" + ip));
        return IPV4_LOOPBACK_ADDRESS;
    }

    private static String getIPv4LocalAddr(String ip, int port) {
        String localIp = IPV4_LOOPBACK_ADDRESS;
        List<String> ips = NetUtil.queryAllLocalIP();
        Collections.sort(ips);
        if (Ipv4AddressUtil.isValidIPv4((String)ip)) {
            String ipv4 = NetUtil.getLocalIPAddress(ip, port);
            localIp = IPV4_LOOPBACK_ADDRESS;
            String tmpIp = ip;
            int ind = tmpIp.lastIndexOf(46);
            while (ind != -1) {
                tmpIp = tmpIp.substring(0, ind);
                for (String string : ips) {
                    if (!string.contains(tmpIp)) continue;
                    localIp = string;
                    break;
                }
                ind = tmpIp.lastIndexOf(46);
            }
            if (IPV4_LOOPBACK_ADDRESS.equals(localIp) && !ips.isEmpty()) {
                localIp = NetUtil.getIPv4Address(ips);
            }
            if (!VerifyUtil.isEmpty((String)ipv4) && !"0.0.0.0".equals(ipv4)) {
                localIp = ipv4;
            }
            return localIp;
        }
        return localIp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLocalIPAddress(String ip, Integer port) {
        String localIp = null;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(ip, (int)port), 30000);
            localIp = socket.getLocalAddress().getHostAddress();
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
        }
        finally {
            CommonUtil.close((Closeable)socket);
        }
        return localIp;
    }

    private static String getIPv6LocalAddr(String ip, int port) {
        String localIp = IPV6_LOOPBACK_ADDRESS;
        List<String> ips = NetUtil.queryAllLocalIP();
        Collections.sort(ips);
        if (Ipv6AddressUtil.isValidIPv6((String)ip)) {
            String ipv6 = NetUtil.getLocalIPAddress(ip, port);
            String tmpIp = ip;
            int ind = tmpIp.lastIndexOf(58);
            while (ind != -1) {
                tmpIp = tmpIp.substring(0, ind);
                for (String string : ips) {
                    if (!string.contains(tmpIp)) continue;
                    localIp = string;
                    break;
                }
                ind = tmpIp.lastIndexOf(58);
            }
            if (IPV6_LOOPBACK_ADDRESS.equals(localIp) && !ips.isEmpty()) {
                localIp = NetUtil.getIPv6Address(ips);
            }
            if (!VerifyUtil.isEmpty((String)ipv6) && !"0:0:0:0:0:0:0:0".equals(ipv6)) {
                localIp = ipv6;
            }
            return localIp;
        }
        return localIp;
    }

    private static class IsmTrustManager
    implements X509TrustManager {
        private IsmTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

