/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.msg;

import com.huawei.ism.cbb.proxy.protocol.tlv.exception.TLVException;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.TLVTag;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class TLVMsgDefine {
    private SortedMap<Integer, TLVTag> tagsMap = null;

    public TLVTag getTag(int tagValue) {
        this.extractTLVTags();
        return (TLVTag)this.tagsMap.get(tagValue);
    }

    public List<TLVTag> getTLVTags() {
        this.extractTLVTags();
        return new ArrayList<TLVTag>(this.tagsMap.values());
    }

    private void extractTLVTags() {
        Field[] fields;
        if (null != this.tagsMap) {
            return;
        }
        this.tagsMap = Collections.synchronizedSortedMap(new TreeMap());
        for (Field field : fields = this.getClass().getFields()) {
            try {
                Object tag = field.get(this);
                if (!(tag instanceof TLVTag)) continue;
                TLVTag tlvTag = (TLVTag)tag;
                this.tagsMap.put(tlvTag.getParamIndex(), tlvTag);
            }
            catch (Exception e) {
                throw new TLVException("exception:", (Throwable)e);
            }
        }
    }
}

