/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.xve;

import com.huawei.ism.cbb.proxy.protocol.tlv.constant.ParamType;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmInteger;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Record;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.TLVTag;

public class TLVParamUtil {
    private static final long SECTOR_SIZE = 512L;

    public static Integer getEnumValue(Record record, TLVTag tlvTag) {
        if (record == null || tlvTag == null || tlvTag.getParamType() != ParamType.ENUM) {
            return null;
        }
        Object value = record.getParamValue(tlvTag.getParamIndex()).orElse(null);
        if (value != null && value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    public static Double getDoubleValue(Record record, TLVTag tlvTag) {
        if (record == null || tlvTag == null) {
            return null;
        }
        IsmInteger value = record.getParamIntValue(tlvTag.getParamIndex()).orElse(null);
        if (value != null) {
            return value.doubleValue();
        }
        return null;
    }

    public static Integer getIntValue(Record record, TLVTag tlvTag) {
        if (record == null || tlvTag == null) {
            return null;
        }
        IsmInteger value = record.getParamIntValue(tlvTag.getParamIndex()).orElse(null);
        if (value != null) {
            return value.intValue();
        }
        return null;
    }

    public static Long getLongValue(Record record, TLVTag tlvTag) {
        if (record == null || tlvTag == null) {
            return null;
        }
        IsmInteger value = record.getParamIntValue(tlvTag.getParamIndex()).orElse(null);
        if (value != null) {
            return value.longValue();
        }
        return null;
    }

    public static Long getCapacityBySectorValue(Record record, TLVTag tlvTag) {
        if (record == null || tlvTag == null) {
            return null;
        }
        IsmInteger value = record.getParamIntValue(tlvTag.getParamIndex()).orElse(null);
        if (value != null) {
            return value.longValue() * 512L;
        }
        return null;
    }

    public static Boolean getBooleanValue(Record record, TLVTag tlvTag) {
        if (record == null || tlvTag == null) {
            return Boolean.FALSE;
        }
        Object value = record.getParamValue(tlvTag.getParamIndex()).orElse(null);
        if (value != null && value instanceof Number) {
            return ((Number)value).intValue() > 0;
        }
        return Boolean.FALSE;
    }
}

