/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ubase.adaptor.hvs.discovery.process;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.array.sdk.model.Chassis;
import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.PowerSupply;
import com.huawei.ism.array.sdk.model.XveDisk;
import com.huawei.ism.array.sdk.model.XveIntfModule;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.array.sdk.model.XvePortGroup;
import com.huawei.ism.array.sdk.model.XveStoragePool;
import com.huawei.ism.array.sdk.model.XveTier;
import com.huawei.ism.base.port.sdk.model.FcHostPort;
import com.huawei.ism.base.port.sdk.model.IscsiHostPort;
import com.huawei.ism.base.port.sdk.model.LogicInterface;
import com.huawei.ism.base.port.sdk.model.ManagementPort;
import com.huawei.ism.base.port.sdk.model.SasHostPort;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.discover.array.ArrayDiscoverUtil;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreInfo;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.ubase.adaptor.hvs.discovery.util.HVSRestTransition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class HVSDeviceProxyImpl {
    private static Log logger = LogFactory.getInstance(HVSDeviceProxyImpl.class);

    public HvsUnit getComputerSystem(RestConnection connection) {
        Map<String, String> resultMap = connection.get("/rest/${deviceID}/system/201", null);
        return HVSRestTransition.transitionXveUnit(resultMap, connection.getIpAddress());
    }

    protected List<XveStoragePool> getStoragePools(RestConnection connection, HvsUnit hvsUnit) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/storagepool", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<XveStoragePool> storagePools = new ArrayList<XveStoragePool>();
        for (Map<String, String> resultMap : resultMapList) {
            XveStoragePool storagePool = HVSRestTransition.transitionXveStoragePool(hvsUnit.getDevSn(), resultMap);
            storagePool.setParentMo((ManagedObject)hvsUnit);
            hvsUnit.addChildMo((ManagedObject)storagePool);
            storagePools.add(storagePool);
        }
        this.getStorageTiers(connection, hvsUnit.getDevSn(), storagePools);
        return storagePools;
    }

    protected List<XveLun> getLuns(RestConnection connection, String deviceId, List<XveStoragePool> storagePools) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/lun?range=[0-65536]", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            logger.warn((Object)"result Map List si empty!");
            return Collections.emptyList();
        }
        HashMap<String, XveStoragePool> storagePoolsIDMap = new HashMap<String, XveStoragePool>();
        for (XveStoragePool pool : storagePools) {
            storagePoolsIDMap.put(pool.getPoolId(), pool);
        }
        ArrayList<XveLun> luns = new ArrayList<XveLun>();
        for (Map<String, String> resultMap : resultMapList) {
            XveLun lun = HVSRestTransition.transitionXveLun(deviceId, resultMap);
            XveStoragePool pool = (XveStoragePool)storagePoolsIDMap.get(lun.getStoragePoolId());
            if (pool != null) {
                pool.addChildMo((ManagedObject)lun);
                lun.setParentMo((ManagedObject)pool);
                luns.add(lun);
            }
            luns.add(lun);
        }
        return luns;
    }

    protected List<NasFileSystem> getFileSystem(RestConnection connection, String devSn, XveStoragePool storagePool, String vstoreId) {
        StringBuilder sb = new StringBuilder("/rest/${deviceID}/filesystem?range=[0-65536]");
        List<Map<String, String>> resultMapList = connection.getBatch(sb.toString(), null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<NasFileSystem> fsList = new ArrayList<NasFileSystem>();
        for (Map<String, String> resultMap : resultMapList) {
            NasFileSystem fs = HVSRestTransition.transitionFileSystem(devSn, resultMap);
            fsList.add(fs);
        }
        return fsList;
    }

    protected List<Controller> getControllers(RestConnection connection, HvsUnit hvsUnit) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/controller", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<Controller> controllers = new ArrayList<Controller>();
        for (Map<String, String> resultMap : resultMapList) {
            Controller controller = HVSRestTransition.transitionController(hvsUnit.getDevSn(), resultMap);
            controller.setParentMo((ManagedObject)hvsUnit);
            hvsUnit.addChildMo((ManagedObject)controller);
            controllers.add(controller);
        }
        return controllers;
    }

    protected List<XveDisk> getDisks(RestConnection connection, HvsUnit hvsUnit) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/disk", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<XveDisk> disks = new ArrayList<XveDisk>();
        for (Map<String, String> resultMap : resultMapList) {
            XveDisk disk = HVSRestTransition.transitionXveDisk(hvsUnit.getDevSn(), resultMap);
            disk.setParentMo((ManagedObject)hvsUnit);
            hvsUnit.addChildMo((ManagedObject)disk);
            disks.add(disk);
        }
        return disks;
    }

    protected List<FcHostPort> getHostFcPort(RestConnection connection, HvsUnit hvsUnit, List<XveIntfModule> intfModules, List<Controller> controllers) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/fc_port", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        HashMap<String, Controller> controllersIDMap = new HashMap<String, Controller>();
        for (Controller controller : controllers) {
            controllersIDMap.put(controller.getControllerId(), controller);
        }
        HashMap<String, XveIntfModule> intfsIDMap = new HashMap<String, XveIntfModule>();
        if (intfModules != null) {
            for (XveIntfModule intfModule : intfModules) {
                intfsIDMap.put(intfModule.getIntfId(), intfModule);
            }
        }
        ArrayList<FcHostPort> arrayList = new ArrayList<FcHostPort>();
        for (Map<String, String> resultMap : resultMapList) {
            HVSRestTransition.transitionFcHostPort(hvsUnit.getDevSn(), resultMap, arrayList, controllersIDMap, intfsIDMap);
        }
        return arrayList;
    }

    protected List<IscsiHostPort> getStorageEtherPort(RestConnection connection, HvsUnit hvsUnit, List<XveIntfModule> intfModules, List<Controller> controllers) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/eth_port", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        HashMap<String, Controller> controllersIDMap = new HashMap<String, Controller>();
        for (Controller controller : controllers) {
            controllersIDMap.put(controller.getControllerId(), controller);
        }
        HashMap<String, XveIntfModule> intfsIDMap = new HashMap<String, XveIntfModule>();
        if (intfModules != null) {
            for (XveIntfModule intfModule : intfModules) {
                intfsIDMap.put(intfModule.getIntfId(), intfModule);
            }
        }
        ArrayList<IscsiHostPort> arrayList = new ArrayList<IscsiHostPort>();
        HashMap<String, List<ManagementPort>> managePortsMap = new HashMap<String, List<ManagementPort>>();
        for (Map<String, String> resultMap : resultMapList) {
            HVSRestTransition.transitionEtherPort(hvsUnit.getDevSn(), resultMap, arrayList, intfsIDMap, controllersIDMap, managePortsMap);
        }
        ArrayDiscoverUtil.setControllerIp(managePortsMap, controllersIDMap, true);
        ArrayDiscoverUtil.setControllerIp(managePortsMap, controllersIDMap, false);
        return arrayList;
    }

    protected List<String> getManagementIps(RestConnection connection) {
        List<Map<String, String>> records = connection.getBatch("/rest/${deviceID}/eth_port?LOGICTYPE=" + XveEnumDefine.PORT_LOGIC_TYPE_E.MNGT.getValue(), null);
        if (VerifyUtil.isEmpty(records)) {
            return Collections.emptyList();
        }
        ArrayList<String> ips = new ArrayList<String>();
        for (Map<String, String> record : records) {
            String ipv4Address = record.get("IPV4ADDR");
            if (VerifyUtil.isEmpty((String)ipv4Address)) continue;
            ips.add(ipv4Address);
        }
        return ips;
    }

    protected List<SasHostPort> getStorageSasPort(RestConnection connection, HvsUnit hvsUnit, List<XveIntfModule> intfModules, List<Controller> controllers) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/sas_port", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        HashMap<String, Controller> controllersIDMap = new HashMap<String, Controller>();
        for (Controller controller : controllers) {
            controllersIDMap.put(controller.getControllerId(), controller);
        }
        HashMap<String, XveIntfModule> intfsIDMap = new HashMap<String, XveIntfModule>();
        if (intfModules != null) {
            for (XveIntfModule intfModule : intfModules) {
                intfsIDMap.put(intfModule.getIntfId(), intfModule);
            }
        }
        ArrayList<SasHostPort> arrayList = new ArrayList<SasHostPort>();
        for (Map<String, String> resultMap : resultMapList) {
            HVSRestTransition.transitionSasHostPort(hvsUnit.getDevSn(), resultMap, arrayList, controllersIDMap, intfsIDMap);
        }
        return arrayList;
    }

    private List<XveTier> getStorageTiers(RestConnection connection, String deviceId, List<XveStoragePool> storagePools) {
        ArrayList<XveTier> xveTiers = new ArrayList<XveTier>();
        for (XveStoragePool pool : storagePools) {
            String poolId = pool.getPoolId();
            List<Map<String, String>> resultMapList = null;
            try {
                resultMapList = connection.getBatch("/rest/${deviceID}/storagetier?PARENTID=" + poolId, null);
            }
            catch (LegoCheckedException e) {
                this.filterSepcialError(e, "get storage Tiers error!");
            }
            if (VerifyUtil.isEmpty(resultMapList)) continue;
            for (Map map : resultMapList) {
                XveTier xveTier = HVSRestTransition.transitionXveTier(deviceId, map);
                String tierId = xveTier.getTierId();
                if (tierId.equals(poolId + ".0")) {
                    pool.setTier0FreeCapacity(xveTier.getTierAvailableCapacity());
                    pool.setTier0UsedCapacity(xveTier.getTierConsumedCapacity());
                }
                if (tierId.equals(poolId + ".1")) {
                    pool.setTier1FreeCapacity(xveTier.getTierAvailableCapacity());
                    pool.setTier1UsedCapacity(xveTier.getTierConsumedCapacity());
                }
                if (tierId.equals(poolId + ".2")) {
                    pool.setTier2FreeCapacity(xveTier.getTierAvailableCapacity());
                    pool.setTier2UsedCapacity(xveTier.getTierConsumedCapacity());
                }
                xveTiers.add(xveTier);
            }
        }
        return xveTiers;
    }

    private void filterSepcialError(LegoCheckedException e, String errorMsg) {
        if (e.getErrorCode() != 404L) {
            logger.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
        logger.error((Object)(errorMsg + e.getErrorCode()));
    }

    protected List<XveIntfModule> getIntfModules(RestConnection connection, HvsUnit hvsUnit) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/intf_module", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<XveIntfModule> xveIntfModules = new ArrayList<XveIntfModule>();
        for (Map<String, String> resultMap : resultMapList) {
            XveIntfModule xveIntfModule = HVSRestTransition.transitionXveIntfModule(hvsUnit.getDevSn(), resultMap);
            xveIntfModules.add(xveIntfModule);
        }
        return xveIntfModules;
    }

    protected List<ArrayHost> getHosts(RestConnection connection, HvsUnit hvsUnit) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/host?range=[0-65536]", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<ArrayHost> arrayHosts = new ArrayList<ArrayHost>();
        for (Map<String, String> resultMap : resultMapList) {
            ArrayHost arrayHost = HVSRestTransition.transitionArrayHost(hvsUnit.getDevSn(), resultMap);
            arrayHost.setParentMo((ManagedObject)hvsUnit);
            hvsUnit.addChildMo((ManagedObject)arrayHost);
            arrayHosts.add(arrayHost);
        }
        return arrayHosts;
    }

    public List<Initiator> getInitiators(RestConnection connection, HvsUnit hvsUnit) {
        Initiator initiator;
        ArrayList<Initiator> initiators = new ArrayList<Initiator>();
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/iscsi_initiator?range=[0-65536]", null);
        if (!VerifyUtil.isEmpty(resultMapList)) {
            for (Map<String, String> resultMap : resultMapList) {
                initiator = HVSRestTransition.transitionIscsiInitiator(hvsUnit.getDevSn(), resultMap);
                initiator.setParentMo((ManagedObject)hvsUnit);
                hvsUnit.addChildMo((ManagedObject)initiator);
                initiator.setTopMoUuid(hvsUnit.getTopMoUuid());
                initiators.add(initiator);
            }
        }
        if (!VerifyUtil.isEmpty(resultMapList = connection.getBatch("/rest/${deviceID}/fc_initiator?range=[0-65536]", null))) {
            for (Map<String, String> resultMap : resultMapList) {
                initiator = HVSRestTransition.transitionFcInitiator(hvsUnit.getDevSn(), resultMap);
                initiator.setParentMo((ManagedObject)hvsUnit);
                hvsUnit.addChildMo((ManagedObject)initiator);
                initiator.setTopMoUuid(hvsUnit.getTopMoUuid());
                initiators.add(initiator);
            }
        }
        return initiators;
    }

    protected List<Chassis> getChassises(RestConnection connection, HvsUnit hvsUnit) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/enclosure", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<Chassis> chassises = new ArrayList<Chassis>();
        for (Map<String, String> resultMap : resultMapList) {
            Chassis chassis = HVSRestTransition.transitionChassis(hvsUnit.getDevSn(), resultMap);
            chassis.setParentMo((ManagedObject)hvsUnit);
            hvsUnit.addChildMo((ManagedObject)chassis);
            chassises.add(chassis);
        }
        return chassises;
    }

    protected List<MappingView> getMappingViews(RestConnection connection, HvsUnit hvsUnit) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/mappingview?range=[0-65536]", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<MappingView> mapingViews = new ArrayList<MappingView>();
        for (Map<String, String> resultMap : resultMapList) {
            MappingView mappingView = HVSRestTransition.transitionMappingView(hvsUnit.getDevSn(), resultMap);
            mappingView.setParentMo((ManagedObject)hvsUnit);
            hvsUnit.addChildMo((ManagedObject)mappingView);
            mapingViews.add(mappingView);
        }
        return mapingViews;
    }

    protected List<PowerSupply> getPowerSupplys(RestConnection connection, HvsUnit hvsUnit, List<Chassis> chassises) {
        if (VerifyUtil.isEmpty(chassises)) {
            return null;
        }
        HashMap<String, Chassis> chassisMap = new HashMap<String, Chassis>();
        for (Chassis chassis : chassises) {
            chassisMap.put(chassis.getChassisId(), chassis);
        }
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/power", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<PowerSupply> powers = new ArrayList<PowerSupply>();
        for (Map<String, String> resultMap : resultMapList) {
            PowerSupply powerSupply = HVSRestTransition.transitionPowerSupply(hvsUnit.getDevSn(), resultMap);
            Chassis chassis = (Chassis)chassisMap.get(powerSupply.getChassisId());
            if (null != chassis) {
                chassis.addChildMo((ManagedObject)powerSupply);
                powerSupply.setParentMo((ManagedObject)chassis);
            }
            powers.add(powerSupply);
        }
        return powers;
    }

    protected TimeZone getSystemTimeZoneInfo(RestConnection connection) {
        TimeZone timeZone = null;
        Map<String, String> resultMap = connection.get("/rest/${deviceID}/system_timezone", null);
        if (!VerifyUtil.isEmpty(resultMap)) {
            String timeZoneName = resultMap.get("CMO_SYS_TIME_ZONE_NAME");
            if (VerifyUtil.isEmpty((String)timeZoneName)) {
                logger.warn((Object)"timeZoneName is empty!");
                return timeZone;
            }
            timeZone = TimeZone.getTimeZone(timeZoneName);
        } else {
            logger.warn((Object)"getSystemTimeZoneInfo resultMap is empty!");
        }
        return timeZone;
    }

    protected List<XveLunGroup> getXveLunGroups(RestConnection connection, HvsUnit hvsUnit) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/lungroup?range=[0-65536]", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<XveLunGroup> xveLunGroups = new ArrayList<XveLunGroup>();
        for (Map<String, String> resultMap : resultMapList) {
            XveLunGroup xveLunGroup = HVSRestTransition.transitionXveLunGroup(hvsUnit.getDevSn(), resultMap);
            StringBuilder associateUrl = new StringBuilder("/rest/${deviceID}/lun/associate");
            associateUrl.append("?TYPE=").append(XveMOType.LUN.getValue()).append("&ASSOCIATEOBJTYPE=").append(XveMOType.LUNGROUP.getValue());
            associateUrl.append("&ASSOCIATEOBJID=").append(xveLunGroup.getLunGroupId());
            List<Map<String, String>> associateLunsMaps = connection.getBatch(associateUrl.toString(), null);
            if (!VerifyUtil.isEmpty(associateLunsMaps)) {
                ArrayList<String> associateLunIds = new ArrayList<String>();
                for (Map<String, String> lunMap : associateLunsMaps) {
                    associateLunIds.add(lunMap.get("ID"));
                }
                xveLunGroup.setLunIds(associateLunIds);
            }
            xveLunGroup.setParentMo((ManagedObject)hvsUnit);
            hvsUnit.addChildMo((ManagedObject)xveLunGroup);
            xveLunGroups.add(xveLunGroup);
        }
        return xveLunGroups;
    }

    protected List<XvePortGroup> getXvePortGroups(RestConnection connection, HvsUnit hvsUnit) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/portgroup?range=[0-65536]", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<XvePortGroup> xvePortGroups = new ArrayList<XvePortGroup>();
        for (Map<String, String> resultMap : resultMapList) {
            XvePortGroup xvePortGroup = HVSRestTransition.transitionXvePortGroup(hvsUnit.getDevSn(), resultMap);
            ArrayList<String> associatePortTypeAndIds = new ArrayList<String>();
            StringBuilder associateUrl = new StringBuilder("/rest/${deviceID}/fc_port/associate");
            associateUrl.append("?TYPE=").append(XveMOType.FC_PORT.getValue()).append("&ASSOCIATEOBJTYPE=").append(XveMOType.PORTGROUP.getValue());
            associateUrl.append("&ASSOCIATEOBJID=").append(xvePortGroup.getPortGroupId());
            List<Map<String, String>> associatePortsMaps = connection.getBatch(associateUrl.toString(), null);
            if (!VerifyUtil.isEmpty(associatePortsMaps)) {
                for (Map<String, String> portMap : associatePortsMaps) {
                    associatePortTypeAndIds.add(portMap.get("TYPE") + "," + portMap.get("ID"));
                }
            }
            associateUrl = new StringBuilder("/rest/${deviceID}/eth_port/associate");
            associateUrl.append("?TYPE=").append(XveMOType.ETH_PORT.getValue()).append("&ASSOCIATEOBJTYPE=").append(XveMOType.PORTGROUP.getValue());
            associateUrl.append("&ASSOCIATEOBJID=").append(xvePortGroup.getPortGroupId());
            associatePortsMaps = connection.getBatch(associateUrl.toString(), null);
            if (!VerifyUtil.isEmpty(associatePortsMaps)) {
                for (Map<String, String> portMap : associatePortsMaps) {
                    associatePortTypeAndIds.add(portMap.get("TYPE") + "," + portMap.get("ID"));
                }
            }
            xvePortGroup.setPortIds(associatePortTypeAndIds);
            associateUrl = new StringBuilder("/rest/${deviceID}/mappingview/associate");
            associateUrl.append("?TYPE=").append(XveMOType.MAPPINGVIEW.getValue()).append("&ASSOCIATEOBJTYPE=").append(XveMOType.PORTGROUP.getValue());
            associateUrl.append("&ASSOCIATEOBJID=").append(xvePortGroup.getPortGroupId());
            Map<String, String> associateMappingViewMap = connection.get(associateUrl.toString(), null);
            if (!VerifyUtil.isEmpty(associateMappingViewMap)) {
                String mappingViewId = associateMappingViewMap.get("ID");
                xvePortGroup.setMappingViewId(mappingViewId);
            }
            xvePortGroup.setParentMo((ManagedObject)hvsUnit);
            hvsUnit.addChildMo((ManagedObject)xvePortGroup);
            xvePortGroups.add(xvePortGroup);
        }
        return xvePortGroups;
    }

    protected List<ArrayHostGroup> getArrayHostGroups(RestConnection connection, HvsUnit hvsUnit) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/hostgroup?range=[0-65536]", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<ArrayHostGroup> arrayHostGroups = new ArrayList<ArrayHostGroup>();
        for (Map<String, String> resultMap : resultMapList) {
            ArrayHostGroup arrayHostGroup = HVSRestTransition.transitionArrayHostGroup(hvsUnit.getDevSn(), resultMap);
            arrayHostGroup.setParentMo((ManagedObject)hvsUnit);
            hvsUnit.addChildMo((ManagedObject)arrayHostGroup);
            arrayHostGroups.add(arrayHostGroup);
        }
        return arrayHostGroups;
    }

    protected List<LogicInterface> getLogicInterfaces(RestConnection connection, HvsUnit hvsUnit) {
        List<Map<String, String>> resultMapList = connection.getBatch("/rest/${deviceID}/LIF?range=[0-65536]", null);
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<LogicInterface> logicInterfaces = new ArrayList<LogicInterface>();
        for (Map<String, String> resultMap : resultMapList) {
            LogicInterface logicInterface = HVSRestTransition.transitionLogicInterface(hvsUnit.getDevSn(), resultMap);
            logicInterface.setParentMo((ManagedObject)hvsUnit);
            hvsUnit.addChildMo((ManagedObject)logicInterface);
        }
        return logicInterfaces;
    }

    protected List<VstoreInfo> getVStoreInfos(RestConnection connection, HvsUnit hvsUnit) {
        List<Map<String, String>> resultMapList;
        try {
            resultMapList = connection.getBatch("/rest/${deviceID}/vstore?range=[0-65536]", null);
        }
        catch (LegoCheckedException e) {
            if (404L == e.getErrorCode()) {
                logger.debug((Object)("the device can not support vstore, device id : " + connection.getDeviceId()));
                return new ArrayList<VstoreInfo>();
            }
            logger.error((Object)("query vstores by device error, device id : " + connection.getDeviceId()));
            throw e;
        }
        if (VerifyUtil.isEmpty(resultMapList)) {
            return Collections.emptyList();
        }
        ArrayList<VstoreInfo> infos = new ArrayList<VstoreInfo>();
        for (Map<String, String> resultMap : resultMapList) {
            VstoreInfo info = HVSRestTransition.transitionVStore(hvsUnit.getDevSn(), resultMap);
            info.setParentMo((ManagedObject)hvsUnit);
            info.setTopMoUuid(hvsUnit.getTopMoUuid());
            hvsUnit.addChildMo((ManagedObject)info);
            infos.add(info);
        }
        return infos;
    }
}

