/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ubase.adaptor.hvs.discovery.util;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.array.sdk.model.Chassis;
import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.array.sdk.model.HyperVaultCopy;
import com.huawei.ism.array.sdk.model.HyperVaultJob;
import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.PowerSupply;
import com.huawei.ism.array.sdk.model.RemoteDevice;
import com.huawei.ism.array.sdk.model.XveDisk;
import com.huawei.ism.array.sdk.model.XveIntfModule;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.array.sdk.model.XvePortGroup;
import com.huawei.ism.array.sdk.model.XveStoragePool;
import com.huawei.ism.array.sdk.model.XveTier;
import com.huawei.ism.base.port.sdk.model.FcHostPort;
import com.huawei.ism.base.port.sdk.model.IscsiHostPort;
import com.huawei.ism.base.port.sdk.model.LogicInterface;
import com.huawei.ism.base.port.sdk.model.ManagementPort;
import com.huawei.ism.base.port.sdk.model.SasHostPort;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.base.sdk.constant.DiskConstant;
import com.huawei.ism.cbb.base.sdk.constant.ProductModelType;
import com.huawei.ism.cbb.discover.service.impl.XveDeviceProxyImpl;
import com.huawei.ism.cbb.discover.xve.V2TypeMapper;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.ubase.adaptor.hvs.discovery.util.IScsiInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class HVSRestTransition {
    private static final double NUM_512D = 512.0;
    private static final Integer INTEGER_DEFAULT = -1;
    private static final Long LONG_DEFAULT = -1L;
    private static final Double DOUBLE_DEFAULT = -1.0;
    private static final String TAKE_OVER_LUN_WWN = "takeOverLunWwn";
    private static Log logger = LogFactory.getInstance(HVSRestTransition.class);
    private static List<ProductModelType> svpProductModelTypeValues = new ArrayList<ProductModelType>();

    public static HvsUnit transitionXveUnit(Map<String, String> resultMap, String linkIp) {
        logger.debug((Object)("record=" + resultMap + ", linkIp=" + linkIp));
        HvsUnit hvsUnit = new HvsUnit();
        hvsUnit.setDevSn(resultMap.get("ID"));
        if (resultMap.containsKey("productModeString")) {
            String productModeString = resultMap.get("productModeString");
            hvsUnit.setProductModel(productModeString);
            hvsUnit.setSubType(productModeString);
            logger.info((Object)("containsKey productModeString=" + productModeString));
        } else {
            int productMode = NumberUtil.convertToInteger((Object)resultMap.get("PRODUCTMODE"), (int)INTEGER_DEFAULT);
            ProductModelType productModelType = ProductModelType.getProductModel((int)productMode);
            if (svpProductModelTypeValues.contains(productModelType)) {
                hvsUnit.setHasSvp(true);
            }
            hvsUnit.setProductModel(productModelType.getName());
            hvsUnit.setSubType(productModelType.getName());
        }
        String version = resultMap.get("PRODUCTVERSION");
        hvsUnit.setName(resultMap.get("NAME"));
        hvsUnit.setDescription(resultMap.get("DESCRIPTION"));
        hvsUnit.setProductVersion(version);
        Integer healthStatus = V2TypeMapper.V2_ARRAY_HEALTH_STATE.get(NumberUtil.convertToInteger((Object)resultMap.get("HEALTHSTATUS"), (int)INTEGER_DEFAULT));
        if (null == healthStatus) {
            healthStatus = 0;
        }
        hvsUnit.setStatus(healthStatus);
        hvsUnit.setLinkIp(linkIp);
        hvsUnit.setUuid(hvsUnit.getDevSn());
        hvsUnit.setMainType("ism.deviceType.storage.mainType");
        HVSRestTransition.getTv2Capacity(resultMap, hvsUnit);
        return hvsUnit;
    }

    private static void getTv2Capacity(Map<String, String> resultMap, HvsUnit hvsUnit) {
        Double memberDisksCapacity = NumberUtil.convertToDouble((Object)resultMap.get("MEMBERDISKSCAPACITY"), (double)DOUBLE_DEFAULT);
        Double freeDisksCapacity = NumberUtil.convertToDouble((Object)resultMap.get("FREEDISKSCAPACITY"), (double)DOUBLE_DEFAULT);
        Integer sectorSize = NumberUtil.convertToInteger((Object)resultMap.get("SECTORSIZE"), (int)INTEGER_DEFAULT);
        if (null != memberDisksCapacity && null != freeDisksCapacity && null != sectorSize) {
            double totalCapacity = UnitConvert.convert((Double)((memberDisksCapacity + freeDisksCapacity) * (double)sectorSize.intValue()), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.GB);
            double usedCapacity = UnitConvert.convert((Double)(memberDisksCapacity * (double)sectorSize.intValue()), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.GB);
            hvsUnit.setTotalCapacity(Double.valueOf(totalCapacity));
            hvsUnit.setUsedCapacity(Double.valueOf(usedCapacity));
        }
        hvsUnit.setTotalCapacityUnit(CapabilityUnitType.GB.name());
        hvsUnit.setUsedCapacityUnit(CapabilityUnitType.GB.name());
    }

    public static XveStoragePool transitionXveStoragePool(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        String poolId = resultMap.get("ID");
        String name = resultMap.get("NAME");
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        healthStatus = V2TypeMapper.STORAGE_HEALTH_STUS.get(healthStatus);
        if (null == healthStatus) {
            healthStatus = 0;
        }
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        if (null == (runningStatus = V2TypeMapper.STORAGE_RUNNING_STUS.get(runningStatus))) {
            runningStatus = 0;
        }
        Long totalCapacity = NumberUtil.parseLong((Object)resultMap.get("USERTOTALCAPACITY"));
        Long usedCapacity = NumberUtil.parseLong((Object)resultMap.get("USERCONSUMEDCAPACITY"));
        Long freeCapacity = NumberUtil.parseLong((Object)resultMap.get("USERFREECAPACITY"));
        Long hotspareSpaceConsumedCapacity = NumberUtil.parseLong((Object)resultMap.get("HOTSPARESPACECONSUMEDCAPACITY"));
        Long hotspareSpaceTotalCapacity = NumberUtil.parseLong((Object)resultMap.get("HOTSPARESPACETOTALCAPACITY"));
        Integer threshold = NumberUtil.parseInteger((Object)resultMap.get("USERCONSUMEDCAPACITYTHRESHOLD"));
        int usageType = resultMap.containsKey("USAGETYPE") ? NumberUtil.convertToInteger((Object)resultMap.get("USAGETYPE"), (int)INTEGER_DEFAULT).intValue() : XveEnumDefine.STORAGEPOOL_USAGETYPE_E.LUN.getValue();
        XveStoragePool storagePool = new XveStoragePool();
        storagePool.setNeSN(deviceId);
        storagePool.setPoolId(poolId);
        storagePool.setName(name);
        storagePool.setHealthStatus(String.valueOf(healthStatus));
        storagePool.setStatus(healthStatus);
        storagePool.setRunningStatus(String.valueOf(runningStatus));
        storagePool.setThreshold(threshold);
        storagePool.setUsageType(usageType);
        storagePool.setUuid(new XveUUID(deviceId, XveMOType.STORAGEPOOL, poolId).toString());
        HVSRestTransition.setStoragePoolTierInfo(resultMap, storagePool);
        HVSRestTransition.setStoragePoolCapacity(storagePool, totalCapacity, usedCapacity, freeCapacity, hotspareSpaceConsumedCapacity, hotspareSpaceTotalCapacity);
        return storagePool;
    }

    private static void setStoragePoolTierInfo(Map<String, String> resultMap, XveStoragePool storagePool) {
        Integer tier0RaidLv = NumberUtil.parseInteger((Object)resultMap.get("TIER0RAIDLV"));
        Integer tier0DiskType = NumberUtil.parseInteger((Object)resultMap.get("TIER0DISKTYPE"));
        Integer tier0HotspareSpaceStrategy = NumberUtil.parseInteger((Object)resultMap.get("TIER0HOTSPARESPACESTRATEGY"));
        Integer tier0RaidDiskNum = NumberUtil.parseInteger((Object)resultMap.get("TIER0RAIDDISKNUM"));
        Integer tier0DiskNum = NumberUtil.parseInteger((Object)resultMap.get("TIER0DISKNUM"));
        Integer tier1RaidLv = NumberUtil.parseInteger((Object)resultMap.get("TIER1RAIDLV"));
        Integer tier1DiskType = NumberUtil.parseInteger((Object)resultMap.get("TIER1DISKTYPE"));
        Integer tier1HotspareSpaceStrategy = NumberUtil.parseInteger((Object)resultMap.get("TIER1HOTSPARESPACESTRATEGY"));
        Integer tier1RaidDiskNum = NumberUtil.parseInteger((Object)resultMap.get("TIER1RAIDDISKNUM"));
        Integer tier1DiskNum = NumberUtil.parseInteger((Object)resultMap.get("TIER1DISKNUM"));
        Integer tier2RaidLv = NumberUtil.parseInteger((Object)resultMap.get("TIER2RAIDLV"));
        Integer tier2DiskType = NumberUtil.parseInteger((Object)resultMap.get("TIER2DISKTYPE"));
        Integer tier2HotspareSpaceStrategy = NumberUtil.parseInteger((Object)resultMap.get("TIER2HOTSPARESPACESTRATEGY"));
        Integer tier2RaidDiskNum = NumberUtil.parseInteger((Object)resultMap.get("TIER2RAIDDISKNUM"));
        Integer tier2DiskNum = NumberUtil.parseInteger((Object)resultMap.get("TIER2DISKNUM"));
        storagePool.setTier0RaidLv(tier0RaidLv);
        storagePool.setTier0DiskType(tier0DiskType);
        storagePool.setTier0HotspareSpaceStrategy(tier0HotspareSpaceStrategy);
        storagePool.setTier0RaidDiskNum(tier0RaidDiskNum);
        storagePool.setTier0DiskNum(tier0DiskNum);
        storagePool.setTier1RaidLv(tier1RaidLv);
        storagePool.setTier1DiskType(tier1DiskType);
        storagePool.setTier1HotspareSpaceStrategy(tier1HotspareSpaceStrategy);
        storagePool.setTier1RaidDiskNum(tier1RaidDiskNum);
        storagePool.setTier1DiskNum(tier1DiskNum);
        storagePool.setTier2RaidLv(tier2RaidLv);
        storagePool.setTier2DiskType(tier2DiskType);
        storagePool.setTier2HotspareSpaceStrategy(tier2HotspareSpaceStrategy);
        storagePool.setTier2RaidDiskNum(tier2RaidDiskNum);
        storagePool.setTier2DiskNum(tier2DiskNum);
        String tier0disklist = resultMap.get("TIER0DISKLIST");
        String tier1disklist = resultMap.get("TIER1DISKLIST");
        String tier2disklist = resultMap.get("TIER2DISKLIST");
        storagePool.setTier0DiskList(tier0disklist);
        storagePool.setTier1DiskList(tier1disklist);
        storagePool.setTier2DiskList(tier2disklist);
    }

    private static void setStoragePoolCapacity(XveStoragePool storagePool, Long totalCapacity, Long usedCapacity, Long freeCapacity, Long hotspareSpaceConsumedCapacity, Long hotspareSpaceTotalCapacity) {
        if (null != totalCapacity) {
            storagePool.setTotalCapacity(Double.valueOf(UnitConvert.convert((Double)(NumberUtil.convertToDouble((Object)totalCapacity) * 512.0), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            storagePool.setTotalCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (null != usedCapacity) {
            storagePool.setUsedCapacity(Double.valueOf(UnitConvert.convert((Double)(NumberUtil.convertToDouble((Object)usedCapacity) * 512.0), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            storagePool.setUsedCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (null != freeCapacity) {
            storagePool.setFreeCapacity(Double.valueOf(UnitConvert.convert((Double)NumberUtil.convertToDouble((Object)freeCapacity), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            storagePool.setUsedCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (null != hotspareSpaceConsumedCapacity) {
            storagePool.setHotspareSpaceConsumedCapacity(Double.valueOf(UnitConvert.convert((Double)(NumberUtil.convertToDouble((Object)hotspareSpaceConsumedCapacity) * 512.0), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            storagePool.setHotspareSpaceConsumedCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (null != hotspareSpaceTotalCapacity) {
            storagePool.setHotspareSpaceTotalCapacity(Double.valueOf(UnitConvert.convert((Double)(NumberUtil.convertToDouble((Object)hotspareSpaceTotalCapacity) * 512.0), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            storagePool.setHotspareSpaceTotalCapacityUnit(CapabilityUnitType.MB.name());
        }
    }

    public static XveLun transitionXveLun(String deviceId, Map<String, String> resultMap) throws NullPointerException {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        XveLun lun = new XveLun();
        String lunId = resultMap.get("ID");
        String poolId = resultMap.get("PARENTID");
        String name = resultMap.get("NAME");
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        healthStatus = V2TypeMapper.V2_LUN_HEALTH_STATE.get(healthStatus);
        if (null == healthStatus) {
            healthStatus = 0;
        }
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        if (null == (runningStatus = V2TypeMapper.V2_LUN_RUNNING_STATE.get(runningStatus))) {
            runningStatus = 0;
        }
        Integer dataTransferPolicy = NumberUtil.parseInteger((Object)resultMap.get("DATATRANSFERPOLICY"));
        String dataDistributing = resultMap.get("DATADISTRIBUTING");
        String wwn = resultMap.get("WWN");
        if (resultMap.containsKey(TAKE_OVER_LUN_WWN) && !"--".equals(resultMap.get(TAKE_OVER_LUN_WWN))) {
            lun.setDeviceLunWwn(wwn);
            wwn = resultMap.get(TAKE_OVER_LUN_WWN);
        }
        Integer lunType = NumberUtil.parseInteger((Object)resultMap.get("ALLOCTYPE"));
        String owningController = resultMap.get("OWNINGCONTROLLER");
        Boolean mapped = "true".equalsIgnoreCase(resultMap.get("EXPOSEDTOINITIATOR"));
        lun.setLunId(lunId);
        lun.setStoragePoolId(poolId);
        lun.setDevSn(deviceId);
        lun.setUuid(new XveUUID(deviceId, XveMOType.LUN, lunId).toString());
        lun.setName(name);
        lun.setStatus(healthStatus);
        lun.setRunningStatus(String.valueOf(runningStatus));
        lun.setHealthStatus(String.valueOf(healthStatus));
        lun.setDataDistributing(dataDistributing);
        lun.setDataTransferPolicy(dataTransferPolicy);
        lun.setWwn(wwn);
        lun.setLunType(lunType);
        lun.setResourceType(V2TypeMapper.LUN_ALLOC_TYPE.get(lunType));
        lun.setMapped(mapped);
        lun.setControllerId(owningController);
        lun.setLunCgId(resultMap.get("lunCgId"));
        String isClone = resultMap.get("ISCLONE");
        if (!VerifyUtil.isEmpty((String)isClone)) {
            lun.setClone(isClone.equals("ISCLONE"));
        }
        HVSRestTransition.setLunCapacity(resultMap, lun);
        return lun;
    }

    private static void setLunCapacity(Map<String, String> resultMap, XveLun lun) {
        Integer sectorSize = NumberUtil.parseInteger((Object)resultMap.get("SECTORSIZE"));
        Long capacity = NumberUtil.parseLong((Object)resultMap.get("CAPACITY"));
        Long usedCapacity = NumberUtil.parseLong((Object)resultMap.get("ALLOCCAPACITY"));
        if (capacity != null) {
            lun.setCapacity(Long.valueOf(capacity << 9));
            lun.setTotalCapacity(Double.valueOf(UnitConvert.convert((Double)Double.valueOf(capacity * (long)sectorSize.intValue()), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            lun.setTotalCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (usedCapacity != null) {
            lun.setUsedCapacity(Double.valueOf(UnitConvert.convert((Double)Double.valueOf(usedCapacity * (long)sectorSize.intValue()), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            lun.setUsedCapacityUnit(CapabilityUnitType.MB.name());
        }
    }

    public static NasFileSystem transitionFileSystem(String devSn, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + devSn + ", record=" + resultMap));
        String id = resultMap.get("ID");
        String name = resultMap.get("NAME");
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        healthStatus = V2TypeMapper.V2_LUN_HEALTH_STATE.get(healthStatus);
        if (null == healthStatus) {
            healthStatus = 0;
        }
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        if (null == (runningStatus = V2TypeMapper.V2_LUN_RUNNING_STATE.get(runningStatus))) {
            runningStatus = 0;
        }
        Long capacity = NumberUtil.convertToLong((Object)resultMap.get("CAPACITY"), (long)LONG_DEFAULT);
        Long allocCapacity = null == resultMap.get("ALLOCCAPACITY") ? null : NumberUtil.convertToLong((Object)resultMap.get("ALLOCCAPACITY"), (long)LONG_DEFAULT);
        NasFileSystem fs = new NasFileSystem();
        fs.setResourceId(id);
        fs.setName(name);
        fs.setStoragePoolId(resultMap.get("PARENTID"));
        fs.setStatus(healthStatus);
        fs.setHealthStatus(String.valueOf(healthStatus));
        fs.setRunningStatus(String.valueOf(runningStatus));
        if (capacity != null) {
            fs.setCapacity(Long.valueOf(capacity << 9));
            fs.setTotalCapacity(Double.valueOf(UnitConvert.convert((Double)Double.valueOf(capacity << 9), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            fs.setTotalCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (allocCapacity != null) {
            fs.setUsedCapacity(Double.valueOf(UnitConvert.convert((Double)Double.valueOf(allocCapacity << 9), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            fs.setUsedCapacityUnit(CapabilityUnitType.MB.name());
        }
        fs.setDevSn(devSn);
        String vstoreId = resultMap.get("vstoreId");
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            fs.setUuid(new XveUUID(devSn, XveMOType.FILESYSTEM, id + "_vstoreId=" + vstoreId).toString());
            fs.setVstoreId(vstoreId);
        } else {
            fs.setUuid(new XveUUID(devSn, XveMOType.FILESYSTEM, id).toString());
        }
        return fs;
    }

    public static Controller transitionController(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        Controller restCtrl = new Controller();
        String controllerId = resultMap.get("ID");
        String location = resultMap.get("LOCATION");
        String name = resultMap.get("NAME");
        String chassisId = resultMap.get("PARENTID");
        Integer healthStatus = NumberUtil.convertToInteger((Object)resultMap.get("HEALTHSTATUS"), (int)INTEGER_DEFAULT);
        healthStatus = V2TypeMapper.CONTROLLER_HEALTH_STUS.get(healthStatus);
        if (null == healthStatus) {
            healthStatus = 0;
        }
        Integer runningStatus = NumberUtil.convertToInteger((Object)resultMap.get("RUNNINGSTATUS"), (int)INTEGER_DEFAULT);
        if (null == (runningStatus = V2TypeMapper.CONTROLLER_RUNNING_STUS.get(runningStatus))) {
            runningStatus = 0;
        }
        Boolean isMaster = "true".equalsIgnoreCase(resultMap.get("ISMASTER"));
        Double cacheSize = NumberUtil.convertToDouble((Object)resultMap.get("MEMORYSIZE"), (double)DOUBLE_DEFAULT);
        String pcbVer = resultMap.get("PCBVER");
        String softVer = resultMap.get("SOFTVER");
        restCtrl.setUuid(new XveUUID(deviceId, XveMOType.CONTROLLER, controllerId).toString());
        restCtrl.setControllerId(controllerId);
        restCtrl.setLocation(location);
        restCtrl.setName(name);
        restCtrl.setStatus(healthStatus);
        restCtrl.setRunningStatus(runningStatus);
        restCtrl.setHealthStatus(healthStatus);
        restCtrl.setIsMaster(isMaster);
        restCtrl.setCacheSize(cacheSize);
        restCtrl.setCacheSizeUnit(CapabilityUnitType.MB.name());
        restCtrl.setPcbVersion(pcbVer);
        restCtrl.setSystemVersion(softVer);
        restCtrl.setChassisId(chassisId);
        return restCtrl;
    }

    public static XveDisk transitionXveDisk(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        String diskId = resultMap.get("ID");
        XveDisk xveDisk = new XveDisk();
        HVSRestTransition.setXveDiskProperties(deviceId, resultMap, diskId, xveDisk);
        HVSRestTransition.setPhysicalDiskProperties(deviceId, resultMap, diskId, xveDisk);
        return xveDisk;
    }

    private static void setPhysicalDiskProperties(String deviceId, Map<String, String> resultMap, String diskId, XveDisk xveDisk) {
        String location = resultMap.get("LOCATION");
        String model = resultMap.get("MODEL");
        Integer diskType = NumberUtil.convertToInteger((Object)resultMap.get("DISKTYPE"), (int)INTEGER_DEFAULT);
        Integer logicType = NumberUtil.convertToInteger((Object)resultMap.get("LOGICTYPE"), (int)INTEGER_DEFAULT);
        String poolId = resultMap.get("POOLID");
        Long sectors = NumberUtil.convertToLong((Object)resultMap.get("SECTORS"), (long)LONG_DEFAULT);
        Integer sectorSize = NumberUtil.convertToInteger((Object)resultMap.get("SECTORSIZE"), (int)INTEGER_DEFAULT);
        Integer healthStatus = NumberUtil.convertToInteger((Object)resultMap.get("HEALTHSTATUS"), (int)INTEGER_DEFAULT);
        if (null == (healthStatus = V2TypeMapper.V2_DISK_HEALTH_STATE.get(healthStatus))) {
            healthStatus = 0;
        }
        Integer runningStatus = NumberUtil.convertToInteger((Object)resultMap.get("RUNNINGSTATUS"), (int)INTEGER_DEFAULT);
        if (null == (runningStatus = V2TypeMapper.V2_DISK_RUNNING_STATE.get(runningStatus))) {
            runningStatus = 0;
        }
        Integer speedRPM = NumberUtil.convertToInteger((Object)resultMap.get("SPEEDRPM"), (int)INTEGER_DEFAULT);
        Integer runTime = NumberUtil.convertToInteger((Object)resultMap.get("RUNTIME"), (int)INTEGER_DEFAULT);
        String diskSN = resultMap.get("SERIALNUMBER");
        String firmwareVer = resultMap.get("FIRMWAREVER");
        String manufacturer = resultMap.get("MANUFACTURER");
        Integer temperature = NumberUtil.convertToInteger((Object)resultMap.get("TEMPERATURE"), (int)INTEGER_DEFAULT);
        String parentId = resultMap.get("PARENTID");
        Integer parentType = NumberUtil.convertToInteger((Object)resultMap.get("PARENTTYPE"), (int)INTEGER_DEFAULT);
        xveDisk.setChassisUUID(new XveUUID(deviceId, parentType, parentId).toString());
        xveDisk.setUuid(new XveUUID(deviceId, XveMOType.DISK, diskId).toString());
        xveDisk.setDiskPos(location);
        String phyType = DiskConstant.DiskPhysicalType.getPhysicalType((int)diskType).name();
        if (phyType.equalsIgnoreCase("NLSAS")) {
            phyType = "NL SAS";
        }
        xveDisk.setDiskType(phyType);
        xveDisk.setBoxId(NumberUtil.convertToInteger((Object)parentId, (int)INTEGER_DEFAULT));
        xveDisk.setLogicalType(logicType);
        if (null != sectors && null != sectorSize) {
            xveDisk.setTotalCapacity(Double.valueOf(UnitConvert.convert((Double)NumberUtil.convertToDouble((Object)(sectors * (long)sectorSize.intValue())), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.GB)));
            xveDisk.setTotalCapacityUnit(CapabilityUnitType.GB.name());
        }
        xveDisk.setHealthStatus(healthStatus);
        xveDisk.setStatus(healthStatus);
        xveDisk.setSpinSpeed(NumberUtil.convertToLong((Object)speedRPM));
        xveDisk.setDiskRuntime(runTime);
        xveDisk.setDiskSN(StringUtil.trim((String)diskSN));
        xveDisk.setSerialNo(StringUtil.trim((String)diskSN));
        xveDisk.setDiskPos(location);
        xveDisk.setMoVersion(model);
        xveDisk.setPhysicalModel(model);
        xveDisk.setRunningStatus(runningStatus);
        xveDisk.setPoolId(poolId);
        xveDisk.setFirmwareNo(firmwareVer);
        xveDisk.setManufacture(manufacturer);
        xveDisk.setTemperature(temperature);
    }

    private static void setXveDiskProperties(String deviceId, Map<String, String> resultMap, String diskId, XveDisk xveDisk) {
        String poolTierId = resultMap.get("POOLTIERID");
        String poolName = resultMap.get("POOLNAME");
        String barCode = resultMap.get("BARCODE");
        xveDisk.setDiskId(diskId);
        xveDisk.setBarCode(barCode);
        xveDisk.setPoolTierUuid(new XveUUID(deviceId, XveMOType.DISK, poolTierId).toString());
        xveDisk.setPoolName(poolName);
    }

    public static XveIntfModule transitionXveIntfModule(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        XveIntfModule xveIntfModule = new XveIntfModule();
        String intfId = resultMap.get("ID");
        String location = resultMap.get("LOCATION");
        String controllerId = resultMap.get("PARENTID");
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        healthStatus = V2TypeMapper.MODULES_HEALTH_STATE.get(healthStatus);
        if (null == healthStatus) {
            healthStatus = 0;
        }
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        if (null == (runningStatus = V2TypeMapper.MODULES_RUNNING_STATE.get(runningStatus))) {
            runningStatus = 0;
        }
        Integer model = NumberUtil.parseInteger((Object)resultMap.get("MODEL"));
        xveIntfModule.setUuid(new XveUUID(deviceId, XveMOType.INTF_MODULE, intfId).toString());
        xveIntfModule.setLocation(location);
        xveIntfModule.setStatus(healthStatus);
        xveIntfModule.setHealthStatus(healthStatus);
        xveIntfModule.setRunningStatus(runningStatus);
        xveIntfModule.setIntfId(intfId);
        xveIntfModule.setControllerId(controllerId);
        if (model != null) {
            xveIntfModule.setModel(model.toString());
        }
        return xveIntfModule;
    }

    public static void transitionFcHostPort(String devSn, Map<String, String> resultMap, List<FcHostPort> fcPorts, Map<String, Controller> controllersIDMap, Map<String, XveIntfModule> intfsIDMap) {
        logger.debug((Object)("sn=" + devSn + ", record=" + resultMap));
        logger.debug((Object)("fcPorts=" + fcPorts + ", controllersIdMap=" + controllersIDMap + ", intfsIdMap=" + intfsIDMap));
        String fcPortId = resultMap.get("ID");
        String name = resultMap.get("NAME");
        Integer parentType = NumberUtil.parseInteger((Object)resultMap.get("PARENTTYPE"));
        String parentId = resultMap.get("PARENTID");
        Integer logicType = NumberUtil.parseInteger((Object)resultMap.get("LOGICTYPE"));
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        healthStatus = V2TypeMapper.FC_PORT_HEALTH_STATE.get(healthStatus);
        if (null == healthStatus) {
            healthStatus = 0;
        }
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        if (null == (runningStatus = V2TypeMapper.FC_PORT_RUNNING_STATE.get(runningStatus))) {
            runningStatus = 32;
        }
        Integer runSpeed = NumberUtil.parseInteger((Object)resultMap.get("RUNSPEED"));
        String wwn = resultMap.get("WWN");
        String location = resultMap.get("LOCATION");
        FcHostPort restFcPort = new FcHostPort();
        restFcPort.setUuid(new XveUUID(devSn, XveMOType.FC_PORT, fcPortId).toString());
        restFcPort.setNeSN(devSn);
        restFcPort.setWwn(wwn);
        restFcPort.setHealthStatus(healthStatus);
        restFcPort.setRunningStatus(runningStatus);
        restFcPort.setStatus(healthStatus);
        restFcPort.setIntfModuleId(parentId);
        restFcPort.setLocation(location);
        if (null != runSpeed) {
            restFcPort.setSpeed(Long.valueOf(runSpeed.longValue()));
        }
        restFcPort.setName(name);
        try {
            restFcPort.setPortId(NumberUtil.convertToLong((Object)fcPortId, (long)LONG_DEFAULT));
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)nfe, 90160777658373L);
        }
        restFcPort.setConnectStatus(runningStatus);
        if (null != parentType && null != logicType) {
            Integer[] type = new Integer[]{parentType, logicType};
            XveDeviceProxyImpl.getFcPortByType(type, restFcPort, fcPorts, parentId, controllersIDMap, intfsIDMap);
        }
    }

    public static void transitionEtherPort(String deviceId, Map<String, String> resultMap, List<IscsiHostPort> iscsiHostPorts, Map<String, XveIntfModule> intfsIDMap, Map<String, Controller> controllersIDMap, Map<String, List<ManagementPort>> managePortsMap) {
        String macAddress;
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap + "iscsiHostPorts=" + iscsiHostPorts + ", controllersIdMap=" + controllersIDMap + ", intfsIdMap=" + intfsIDMap));
        String sasPortId = resultMap.get("ID");
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        healthStatus = V2TypeMapper.ETH_PORT_HEALTH_STATE.get(healthStatus);
        if (null == healthStatus) {
            healthStatus = 0;
        }
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        if (null == (runningStatus = V2TypeMapper.ETH_PORT_RUNNING_STATE.get(runningStatus))) {
            runningStatus = 32;
        }
        if (null != (macAddress = resultMap.get("MACADDRESS"))) {
            macAddress = macAddress.replace(":", "").toLowerCase(Locale.US);
        }
        IscsiHostPort iscsiPort = new IscsiHostPort();
        iscsiPort.setUuid(deviceId + (Object)((Object)XveMOType.ETH_PORT) + sasPortId);
        iscsiPort.setName(resultMap.get("NAME"));
        iscsiPort.setNeSN(deviceId);
        iscsiPort.setIpAddress(resultMap.get("IPV4ADDR"));
        iscsiPort.setMask(resultMap.get("IPV4MASK"));
        iscsiPort.setGateway(resultMap.get("IPV4GATEWAY"));
        iscsiPort.setIpv4Gateway(resultMap.get("IPV4GATEWAY"));
        iscsiPort.setIpv4Mask(resultMap.get("IPV4MASK"));
        iscsiPort.setIpv6Gateway(resultMap.get("IPV6GATEWAY"));
        iscsiPort.setIpv6Mask(resultMap.get("IPV6MASK"));
        iscsiPort.setIpv6Address(resultMap.get("IPV6ADDR"));
        iscsiPort.setIpv6Profix(resultMap.get("IPV6MASK"));
        iscsiPort.setMac(macAddress);
        iscsiPort.setBondName(resultMap.get("BONDNAME"));
        iscsiPort.setHealthStatus(healthStatus);
        iscsiPort.setRunningStatus(runningStatus);
        iscsiPort.setConnectStatus(runningStatus);
        iscsiPort.setStatus(healthStatus);
        iscsiPort.setIscsiName(resultMap.get("ISCSINAME"));
        iscsiPort.setLocation(resultMap.get("LOCATION"));
        Integer speed = NumberUtil.parseInteger((Object)resultMap.get("SPEED"));
        if (speed != null) {
            iscsiPort.setSpeed(Long.valueOf(speed.longValue()));
        }
        try {
            iscsiPort.setPortId(NumberUtil.convertToLong((Object)sasPortId, (long)LONG_DEFAULT));
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)nfe, 90160777658373L);
        }
        HVSRestTransition.setIScsiInfo(resultMap, iscsiHostPorts, intfsIDMap, controllersIDMap, managePortsMap, iscsiPort);
    }

    private static void setIScsiInfo(Map<String, String> resultMap, List<IscsiHostPort> iscsiHostPorts, Map<String, XveIntfModule> intfsIDMap, Map<String, Controller> controllersIDMap, Map<String, List<ManagementPort>> managePortsMap, IscsiHostPort iscsiPort) {
        Integer parentType = NumberUtil.parseInteger((Object)resultMap.get("PARENTTYPE"));
        String parentId = resultMap.get("PARENTID");
        Integer logicType = NumberUtil.parseInteger((Object)resultMap.get("LOGICTYPE"));
        if (null != parentType && null != logicType) {
            IScsiInfo info = new IScsiInfo();
            info.setIscsiPort(iscsiPort);
            info.setParentId(parentId);
            info.setControllersIDMap(controllersIDMap);
            info.setIscsiHostPorts(iscsiHostPorts);
            info.setManagePortsMap(managePortsMap);
            info.setIntfsIDMap(intfsIDMap);
            info.setParentType(parentType);
            info.setLogicType(logicType);
            XveDeviceProxyImpl.getIscPortInfoByType(info);
        }
    }

    public static void transitionSasHostPort(String deviceId, Map<String, String> resultMap, List<SasHostPort> sasPorts, Map<String, Controller> controllersIDMap, Map<String, XveIntfModule> intfsIDMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        logger.debug((Object)("sasPorts=" + sasPorts + ", controllersIdMap=" + controllersIDMap + ", intfsIdMap=" + intfsIDMap));
        SasHostPort sasPort = new SasHostPort();
        String sasPortId = resultMap.get("ID");
        String name = resultMap.get("NAME");
        Integer parentType = NumberUtil.parseInteger((Object)resultMap.get("PARENTTYPE"));
        String parentId = resultMap.get("PARENTID");
        Integer logicType = NumberUtil.parseInteger((Object)resultMap.get("LOGICTYPE"));
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        healthStatus = V2TypeMapper.SAS_PORT_HEALTH_STATE.get(healthStatus);
        if (null == healthStatus) {
            healthStatus = 0;
        }
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        if (null == (runningStatus = V2TypeMapper.SAS_PORT_RUNNING_STATE.get(runningStatus))) {
            runningStatus = 32;
        }
        Integer runSpeed = NumberUtil.parseInteger((Object)resultMap.get("RUNSPEED"));
        String wwn = resultMap.get("WWN");
        String location = resultMap.get("LOCATION");
        sasPort.setUuid(deviceId + XveMOType.SAS_PORT.getValue() + sasPortId);
        sasPort.setNeSN(deviceId);
        sasPort.setWwn(wwn);
        sasPort.setHealthStatus(healthStatus);
        sasPort.setRunningStatus(runningStatus);
        sasPort.setStatus(healthStatus);
        if (runSpeed != null) {
            sasPort.setSpeed(Long.valueOf(runSpeed.longValue()));
        }
        sasPort.setName(name);
        sasPort.setLocation(location);
        try {
            sasPort.setPortId(NumberUtil.convertToLong((Object)sasPortId, (long)LONG_DEFAULT));
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)nfe, 90160777658373L);
        }
        sasPort.setConnectStatus(runningStatus);
        if (null != parentType && null != logicType) {
            Integer[] type = new Integer[]{parentType, logicType};
            XveDeviceProxyImpl.getSasPortInfoByType(type, parentId, sasPort, sasPorts, controllersIDMap, intfsIDMap);
        }
    }

    public static ArrayHost transitionArrayHost(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        ArrayHost arrayHost = new ArrayHost();
        String hostId = resultMap.get("ID");
        String name = resultMap.get("NAME");
        String mappingViewID = resultMap.get("PARENTID");
        Integer os = NumberUtil.parseInteger((Object)resultMap.get("OPERATIONSYSTEM"));
        String description = resultMap.get("DESCRIPTION");
        String location = resultMap.get("LOCATION");
        String ipAddress = resultMap.get("IP");
        String model = resultMap.get("MODEL");
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        healthStatus = V2TypeMapper.HOST_HEALTH_STATE.get(healthStatus);
        if (null == healthStatus) {
            healthStatus = 0;
        }
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        if (null == (runningStatus = V2TypeMapper.HOST_RUNNING_STATE.get(runningStatus))) {
            runningStatus = 0;
        }
        arrayHost.setUuid(new XveUUID(deviceId, XveMOType.HOST, hostId).toString());
        arrayHost.setName(name);
        arrayHost.setStatus(healthStatus);
        arrayHost.setHealthStatus(String.valueOf(healthStatus));
        arrayHost.setRunningStatus(String.valueOf(runningStatus));
        arrayHost.setHostId(hostId);
        XveEnumDefinePParent.OS_TYPE_E osType = XveEnumDefinePParent.OS_TYPE_E.valueOf(os);
        if (null == osType) {
            arrayHost.setOs("--");
        } else {
            arrayHost.setOs(osType.name());
        }
        arrayHost.setDescription(description);
        arrayHost.setIpAddress(ipAddress);
        arrayHost.setModel(model);
        arrayHost.setLocation(location);
        if (!VerifyUtil.isEmpty((String)mappingViewID)) {
            String mappingViewUUID = new XveUUID(deviceId, XveMOType.MAPPINGVIEW, mappingViewID).toString();
            arrayHost.setHostGroupUuid(mappingViewUUID);
        }
        return arrayHost;
    }

    public static Initiator transitionIscsiInitiator(String deviceId, Map<String, String> resultMap) {
        Initiator initiator = new Initiator();
        String initiatorId = resultMap.get("ID");
        String aliasName = resultMap.get("NAME");
        String hostId = resultMap.get("PARENTID");
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        logger.debug((Object)"sn: %s, aliasName: %s, hostId: %s, status: %s", new Object[]{deviceId, aliasName, hostId, runningStatus});
        runningStatus = V2TypeMapper.ISC_INITIATO_RUNNING_STATE.get(runningStatus);
        if (null == runningStatus) {
            runningStatus = 0;
        }
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        if (null == (healthStatus = V2TypeMapper.ISC_INITIATO_HEALTH_STATE.get(healthStatus))) {
            healthStatus = 0;
        }
        boolean isFree = Boolean.parseBoolean(resultMap.get("ISFREE"));
        initiator.setUuid(new XveUUID(deviceId, XveMOType.ISCSI_INITIATOR, String.valueOf(String.valueOf(initiatorId).hashCode())).toString());
        initiator.setAlias(aliasName);
        initiator.setHbaType("ISCSI");
        initiator.setIdentity(initiatorId);
        initiator.setName(initiatorId);
        initiator.setStatus(healthStatus);
        initiator.setHealthStatus(healthStatus);
        initiator.setRunningStatus(runningStatus);
        initiator.setIsFree(Boolean.valueOf(isFree));
        if (!VerifyUtil.isEmpty((String)hostId)) {
            initiator.setHostUUID(new XveUUID(deviceId, XveMOType.HOST, hostId).toString());
        }
        return initiator;
    }

    public static Initiator transitionFcInitiator(String deviceId, Map<String, String> resultMap) {
        Initiator initiator = new Initiator();
        String initiatorId = resultMap.get("ID");
        String aliasName = resultMap.get("NAME");
        String hostId = resultMap.get("PARENTID");
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        logger.debug((Object)"sn: %s, aliasName: %s, hostId: %s, status: %s", new Object[]{deviceId, aliasName, hostId, runningStatus});
        runningStatus = V2TypeMapper.FC_INITIATO_RUNNING_STATE.get(runningStatus);
        if (null == runningStatus) {
            runningStatus = 0;
        }
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        if (null == (healthStatus = V2TypeMapper.FC_INITIATO_HEALTH_STATE.get(healthStatus))) {
            healthStatus = 0;
        }
        boolean isFree = Boolean.parseBoolean(resultMap.get("ISFREE"));
        initiator.setUuid(new XveUUID(deviceId, XveMOType.FC_INITIATOR, String.valueOf(String.valueOf(initiatorId).hashCode())).toString());
        initiator.setAlias(aliasName);
        initiator.setHbaType("FC");
        initiator.setIdentity(initiatorId);
        initiator.setName(initiatorId);
        initiator.setStatus(healthStatus);
        initiator.setHealthStatus(healthStatus);
        initiator.setRunningStatus(runningStatus);
        initiator.setIsFree(Boolean.valueOf(isFree));
        if (!VerifyUtil.isEmpty((String)hostId)) {
            initiator.setHostUUID(new XveUUID(deviceId, XveMOType.HOST, hostId).toString());
        }
        return initiator;
    }

    public static Chassis transitionChassis(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        Chassis chassis = new Chassis();
        String chassisId = resultMap.get("ID");
        String name = resultMap.get("NAME");
        Integer temperature = NumberUtil.parseInteger((Object)resultMap.get("TEMPERATURE"));
        Integer height = NumberUtil.parseInteger((Object)resultMap.get("HEIGHT"));
        String serialNum = resultMap.get("SERIALNUM");
        String location = resultMap.get("LOCATION");
        Integer logicType = NumberUtil.parseInteger((Object)resultMap.get("LOGICTYPE"));
        Integer model = NumberUtil.parseInteger((Object)resultMap.get("MODEL"));
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        healthStatus = V2TypeMapper.CHASSISES_HEALTH_STATE.get(healthStatus);
        if (null == healthStatus) {
            healthStatus = 0;
        }
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        if (null == (runningStatus = V2TypeMapper.CHASSISES_RUNNING_STATE.get(runningStatus))) {
            runningStatus = 0;
        }
        chassis.setUuid(new XveUUID(deviceId, XveMOType.ENCLOSURE, chassisId).toString());
        chassis.setName(name);
        chassis.setStatus(healthStatus);
        chassis.setHealthState(String.valueOf(healthStatus));
        chassis.setRunningState(String.valueOf(runningStatus));
        chassis.setTemperature(temperature);
        chassis.setHeight(height);
        chassis.setSerialNum(serialNum);
        chassis.setLocation(location);
        chassis.setChassisModel(V2TypeMapper.CHASSIS_MODEL.get(model));
        chassis.setLogicType(V2TypeMapper.CHASSIS_LOGIC_TYPE.get(logicType));
        chassis.setChassisId(chassisId);
        return chassis;
    }

    public static MappingView transitionMappingView(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        MappingView mappingView = new MappingView();
        String mappingViewId = resultMap.get("ID");
        String name = resultMap.get("NAME");
        String description = resultMap.get("DESCRIPTION");
        mappingView.setUuid(new XveUUID(deviceId, XveMOType.MAPPINGVIEW, mappingViewId).toString());
        mappingView.setMappingViewId(mappingViewId);
        mappingView.setName(name);
        mappingView.setDescription(description);
        return mappingView;
    }

    public static PowerSupply transitionPowerSupply(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        PowerSupply power = new PowerSupply();
        String powerId = resultMap.get("ID");
        String name = resultMap.get("NAME");
        String parentId = resultMap.get("PARENTID");
        String manufacturer = resultMap.get("MANUFACTURER");
        Integer powerType = NumberUtil.parseInteger((Object)resultMap.get("POWERTYPE"));
        String produceDate = resultMap.get("PRODUCEDATE");
        String version = resultMap.get("VERSION");
        String productModel = resultMap.get("MODEL");
        Long temperature = NumberUtil.parseLong((Object)resultMap.get("TEMPERATURE"));
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        power.setUuid(new XveUUID(deviceId, XveMOType.POWER, powerId).toString());
        power.setPowerId(powerId);
        power.setName(name);
        power.setManufacturer(manufacturer);
        if (null != powerType) {
            try {
                power.setPowerType(XveEuumDefineParent.POWER_TYPE_E.valueOf(powerType).name());
            }
            catch (Exception e) {
                logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 90160777658373L);
            }
        }
        power.setChassisId(parentId);
        power.setProduceDate(produceDate);
        power.setPowerVersion(version);
        power.setProductModel(productModel);
        power.setTemperature(temperature);
        runningStatus = V2TypeMapper.POWER_RUNNING_STATE.get(runningStatus);
        if (null != runningStatus) {
            power.setRunningState(String.valueOf(runningStatus));
        }
        if (null != (healthStatus = V2TypeMapper.POWER_HEALTH_STATE.get(healthStatus))) {
            power.setStatus(healthStatus);
            power.setHealthState(String.valueOf(healthStatus));
        }
        return power;
    }

    public static XveLunGroup transitionXveLunGroup(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        XveLunGroup xveLunGroup = new XveLunGroup();
        String lunGroupId = resultMap.get("ID");
        String name = resultMap.get("NAME");
        String description = resultMap.get("DESCRIPTION");
        xveLunGroup.setUuid(new XveUUID(deviceId, XveMOType.LUNGROUP, lunGroupId).toString());
        xveLunGroup.setName(name);
        xveLunGroup.setLunGroupId(lunGroupId);
        xveLunGroup.setDescription(description);
        return xveLunGroup;
    }

    public static XvePortGroup transitionXvePortGroup(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        XvePortGroup xvePortGroup = new XvePortGroup();
        String portGroupId = resultMap.get("ID");
        String name = resultMap.get("NAME");
        String description = resultMap.get("DESCRIPTION");
        xvePortGroup.setUuid(new XveUUID(deviceId, XveMOType.PORTGROUP, portGroupId).toString());
        xvePortGroup.setName(name);
        xvePortGroup.setPortGroupId(portGroupId);
        xvePortGroup.setDescription(description);
        return xvePortGroup;
    }

    public static ArrayHostGroup transitionArrayHostGroup(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        ArrayHostGroup arrayHostGroup = new ArrayHostGroup();
        String hostGroupId = resultMap.get("ID");
        String name = resultMap.get("NAME");
        String description = resultMap.get("DESCRIPTION");
        arrayHostGroup.setUuid(new XveUUID(deviceId, XveMOType.HOSTGROUP, hostGroupId).toString());
        arrayHostGroup.setName(name);
        arrayHostGroup.setHostGroupId(hostGroupId);
        arrayHostGroup.setDescription(description);
        return arrayHostGroup;
    }

    public static XveTier transitionXveTier(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        XveTier xveTier = new XveTier();
        String tierId = resultMap.get("ID");
        String poolId = resultMap.get("PARENTID");
        String tierName = resultMap.get("NAME");
        Integer healthStatus = NumberUtil.parseInteger((Object)resultMap.get("HEALTHSTATUS"));
        healthStatus = V2TypeMapper.STORAGE_TIER_HEALTH_STUS.get(healthStatus);
        if (null == healthStatus) {
            healthStatus = 0;
        }
        Integer runningStatus = NumberUtil.parseInteger((Object)resultMap.get("RUNNINGSTATUS"));
        if (null == (runningStatus = V2TypeMapper.STORAGE_TIER_RUNNING_STUS.get(runningStatus))) {
            runningStatus = 0;
        }
        Integer raidLevel = NumberUtil.parseInteger((Object)resultMap.get("RAIDLV"));
        Integer diskType = NumberUtil.parseInteger((Object)resultMap.get("DISKTYPE"));
        Integer diskNum = NumberUtil.parseInteger((Object)resultMap.get("DISKNUM"));
        Long totalCapacity = NumberUtil.parseLong((Object)resultMap.get("TIERUSERCAPACITY"));
        Long usedCapacity = NumberUtil.parseLong((Object)resultMap.get("TIERCONSUMEDCAPACITY"));
        Long freeCapacity = NumberUtil.parseLong((Object)resultMap.get("TIERAVAILABLECAPACITY"));
        xveTier.setUuid(new XveUUID(deviceId, XveMOType.STORAGETIER, tierId).toString());
        xveTier.setTierId(tierId);
        xveTier.setName(tierName);
        xveTier.setHealthStatus(healthStatus);
        xveTier.setStatus(healthStatus);
        xveTier.setRunningStatus(runningStatus);
        xveTier.setRaidLv(raidLevel);
        xveTier.setDiskType(diskType);
        xveTier.setDiskNum(diskNum);
        xveTier.setPoolId(poolId);
        xveTier.setPoolUuid(new XveUUID(deviceId, XveMOType.STORAGEPOOL, poolId).toString());
        if (totalCapacity != null) {
            xveTier.setTierUserCapacity(Double.valueOf(UnitConvert.convert((Double)(NumberUtil.convertToDouble((Object)totalCapacity) * 512.0), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            xveTier.setTierUserCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (usedCapacity != null) {
            xveTier.setTierConsumedCapacity(Double.valueOf(UnitConvert.convert((Double)(NumberUtil.convertToDouble((Object)usedCapacity) * 512.0), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            xveTier.setTierConsumedCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (freeCapacity != null) {
            xveTier.setTierAvailableCapacity(Double.valueOf(UnitConvert.convert((Double)(NumberUtil.convertToDouble((Object)freeCapacity) * 512.0), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            xveTier.setTierAvailableCapacityUnit(CapabilityUnitType.MB.name());
        }
        return xveTier;
    }

    public static LogicInterface transitionLogicInterface(String deviceId, Map<String, String> resultMap) {
        logger.debug((Object)("sn=" + deviceId + ", record=" + resultMap));
        LogicInterface lif = new LogicInterface();
        lif.setDevSn(deviceId);
        lif.setAddressFamily(NumberUtil.parseInteger((Object)resultMap.get("ADDRESSFAMILY")).intValue());
        lif.setCanFailover(Boolean.valueOf(resultMap.get("CANFAILOVER")));
        lif.setCurrentNodeId(resultMap.get("CURRENTNODEID"));
        lif.setCurrentPortId(resultMap.get("CURRENTPORTID"));
        lif.setCurrentPortName(resultMap.get("CURRENTPORTNAME"));
        lif.setCurrentPortType(NumberUtil.parseInteger((Object)resultMap.get("CURRENTPORTTYPE")).intValue());
        lif.setFailBackMode(NumberUtil.parseInteger((Object)resultMap.get("FAILBACKMODE")).intValue());
        lif.setFailOverGroupId(resultMap.get("FAILOVERGROUPID"));
        lif.setFailOverGroupName(resultMap.get("FAILOVERGROUPNAME"));
        lif.setHomeNodeId(resultMap.get("HOMENODEID"));
        lif.setHomePortId(resultMap.get("HOMEPORTID"));
        lif.setHomePortName(resultMap.get("HOMEPORTNAME"));
        lif.setHomePortType(NumberUtil.parseInteger((Object)resultMap.get("HOMEPORTTYPE")).intValue());
        String id = resultMap.get("ID");
        lif.setId(id);
        lif.setIpv4Addr(resultMap.get("IPV4ADDR"));
        lif.setIpv4Gateway(resultMap.get("IPV4GATEWAY"));
        lif.setIpv4Mask(resultMap.get("IPV4MASK"));
        lif.setIpv6Addr(resultMap.get("IPV6ADDR"));
        lif.setIpv6Gateway(resultMap.get("IPV6GATEWAY"));
        lif.setIpv6Mask(resultMap.get("IPV6MASK"));
        lif.setIsPrivate(Boolean.valueOf(resultMap.get("ISPRIVATE")));
        lif.setName(resultMap.get("NAME"));
        lif.setOperationalStatus(Boolean.valueOf(resultMap.get("OPERATIONALSTATUS")));
        lif.setRole(NumberUtil.parseInteger((Object)resultMap.get("ROLE")).intValue());
        lif.setRunningState(resultMap.get("RUNNINGSTATUS"));
        lif.setSupportProtocol(NumberUtil.parseInteger((Object)resultMap.get("SUPPORTPROTOCOL")).intValue());
        lif.setTenancyId(resultMap.get("TENANCYID"));
        lif.setUuid(new XveUUID(deviceId, XveMOType.LOGICINTERFACE, id).toString());
        return lif;
    }

    public static HyperVault transitionHyperVault(String sn, Map<String, String> record) {
        logger.debug((Object)("sn=" + sn + ", record=" + record));
        if (VerifyUtil.isEmpty((String)sn) || VerifyUtil.isEmpty(record)) {
            logger.error((Object)("parameter error, sn=" + sn));
            throw new LegoCheckedException(1073947393L);
        }
        HyperVault vault = new HyperVault();
        vault.setDevSn(sn);
        vault.setId(record.get("ID"));
        vault.setHealthState(record.get("HEALTHSTATUS"));
        vault.setRunningState(record.get("RUNNINGSTATUS"));
        vault.setResourceType(NumberUtil.convertToInteger((Object)record.get("RESOURCETYPE"), (int)XveMOType.FILESYSTEM.getValue()));
        vault.setLocalResourceId(record.get("LOCALRESOURCEID"));
        vault.setLocalResourceName(record.get("LOCALRESOURCENAME"));
        vault.setEnableRemoteBackup(Boolean.valueOf("0".equals(record.get("ENABLEREMOTEBACKUP"))));
        vault.setRemoteDeviceId(record.get("REMOTEDEVICEID"));
        vault.setRemoteResourceName(record.get("REMOTERESOURCENAME"));
        vault.setRemoteResourceId(record.get("REMOTERESOURCEID"));
        vault.setIsPrimary(Boolean.valueOf("0".equals(record.get("ISPRIMARY"))));
        return vault;
    }

    public static HyperVaultCopy transitionHyperVaultCopy(String sn, Map<String, String> record) {
        logger.debug((Object)("sn=" + sn + ", record=" + record));
        if (VerifyUtil.isEmpty((String)sn) || VerifyUtil.isEmpty(record)) {
            logger.error((Object)("parameter error, sn=" + sn));
            throw new LegoCheckedException(1073947393L);
        }
        HyperVaultCopy copy = new HyperVaultCopy();
        copy.setDevSn(sn);
        copy.setId(record.get("ID"));
        copy.setName(record.get("NAME"));
        copy.setHealthState(record.get("HEALTHSTATUS"));
        copy.setPolicyId(record.get("POLICYID"));
        copy.setPolicyName(record.get("POLICYNAME"));
        copy.setPolicyType(NumberUtil.convertToInteger((Object)record.get("POLICYTYPE"), (int)-1));
        copy.setRestoreAble(Boolean.valueOf("0".equals(record.get("RESTOREABLE"))));
        return copy;
    }

    public static HyperVaultJob transitionHyperVaultJob(String sn, Map<String, String> record) {
        logger.debug((Object)("sn=" + sn + ", record=" + record));
        if (VerifyUtil.isEmpty((String)sn) || VerifyUtil.isEmpty(record)) {
            logger.error((Object)("parameter error, sn=" + sn));
            throw new LegoCheckedException(1073947393L);
        }
        HyperVaultJob job = new HyperVaultJob();
        job.setDevSn(sn);
        job.setName(record.get("NAME"));
        job.setRunningState(record.get("RUNNINGSTATUS"));
        job.setCopyId(record.get("COPYID"));
        job.setCopyName(record.get("COPYNAME"));
        job.setPolicyId(record.get("POLICYID"));
        job.setPolicyType(NumberUtil.convertToInteger((Object)record.get("POLICYTYPE"), (int)-1));
        job.setPolicyName(record.get("POLICYNAME"));
        job.setJobType(NumberUtil.convertToInteger((Object)record.get("JOBTYPE"), (int)-1));
        job.setStartupMode(NumberUtil.convertToInteger((Object)record.get("STARTUPMODE"), (int)-1));
        return job;
    }

    public static RemoteDevice transitionRemoteDevice(String sn, Map<String, String> record) {
        logger.debug((Object)("sn=" + sn + ", record=" + record));
        if (VerifyUtil.isEmpty((String)sn) || VerifyUtil.isEmpty(record)) {
            logger.error((Object)("parameter error, sn=" + sn));
            throw new LegoCheckedException(1073947393L);
        }
        RemoteDevice remoteDevice = new RemoteDevice();
        remoteDevice.setDevSn(sn);
        remoteDevice.setName(record.get("NAME"));
        remoteDevice.setHealthState(record.get("HEALTHSTATUS"));
        remoteDevice.setRunningState(record.get("RUNNINGSTATUS"));
        remoteDevice.setId(record.get("ID"));
        remoteDevice.setWwn(record.get("WWN"));
        remoteDevice.setSn(record.get("SN"));
        remoteDevice.setArrayType(NumberUtil.convertToInteger((Object)record.get("ARRAYTYPE"), (int)XveEnumDefinePParent.EPL_ARRAY_TYPE_E.EPL_ARRAY_UNKNOWN.getValue()));
        return remoteDevice;
    }

    public static VstoreInfo transitionVStore(String sn, Map<String, String> record) {
        logger.debug((Object)("sn=" + sn + ", record=" + record));
        if (VerifyUtil.isEmpty((String)sn) || VerifyUtil.isEmpty(record)) {
            logger.error((Object)("parameter error, sn=" + sn));
            throw new LegoCheckedException(1073947393L);
        }
        VstoreInfo info = new VstoreInfo();
        info.setDevSn(sn);
        info.setRunningState(record.get("RUNNINGSTATUS"));
        info.setVstoreId(record.get("ID"));
        info.setName(record.get("NAME"));
        info.setDescription(record.get("DESCRIPTION"));
        info.setUuid(new XveUUID(sn, XveMOType.VSTORE, record.get("ID")).toString());
        return info;
    }

    static {
        svpProductModelTypeValues.add(ProductModelType.HVS85T);
        svpProductModelTypeValues.add(ProductModelType.HVS88T);
        svpProductModelTypeValues.add(ProductModelType.HVS_18500);
        svpProductModelTypeValues.add(ProductModelType.HVS_18800);
        svpProductModelTypeValues.add(ProductModelType.HVS_18800F);
        svpProductModelTypeValues.add(ProductModelType.HVS_18500_V3);
        svpProductModelTypeValues.add(ProductModelType.HVS_18800_V3);
    }
}

