/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sdk.dcs;

import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.connector.http.RequestInvocation;
import com.huawei.sdk.connector.http.RestHttpClient;
import com.huawei.sdk.connector.utils.RequestUtil;
import com.huawei.sdk.dcs.model.InstanceInfo;
import com.huawei.sdk.dcs.model.RegionAZInfo;
import com.huawei.sdk.dcs.model.request.ListInstancesRequest;
import com.huawei.sdk.dcs.model.response.ListGroupResponse;
import com.huawei.sdk.dcs.model.response.ListInstancesResponse;
import java.io.IOException;

public class DcsClient {
    public ListInstancesResponse listInstances(ListInstancesRequest instancesRequest, Credential credential) throws ResponseException, ClientException, IOException {
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(credential.getProjectId() + "/instances?" + RequestUtil.buildQueryParamsStr((Object)instancesRequest));
        return (ListInstancesResponse)client.get(invocation, ListInstancesResponse.class);
    }

    public void changeMasterStandby(String instanceId, Credential credential) throws ResponseException, ClientException, IOException {
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(credential.getProjectId() + "/instances/" + instanceId + "/swap");
        RestHttpClient client = new RestHttpClient(credential);
        client.put(invocation);
    }

    public InstanceInfo getInstance(String instanceId, Credential credential) throws ResponseException, ClientException, IOException {
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(credential.getProjectId() + "/instances/" + instanceId);
        RestHttpClient client = new RestHttpClient(credential);
        return (InstanceInfo)client.get(invocation, InstanceInfo.class);
    }

    public RegionAZInfo getRegionAZInfo(Credential credential) throws ResponseException, ClientException, IOException {
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl("available-zones");
        RestHttpClient client = new RestHttpClient(credential);
        return (RegionAZInfo)client.get(invocation, RegionAZInfo.class);
    }

    public ListGroupResponse getGroupReplicationInfo(Credential credential, String instanceId) throws ResponseException, ClientException, IOException {
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(credential.getProjectId() + "/instance/" + instanceId + "/groups");
        RestHttpClient client = new RestHttpClient(credential);
        return (ListGroupResponse)client.get(invocation, ListGroupResponse.class);
    }
}

