/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.arbitration.security;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.security.ArbSecurityCertificateManager;
import com.huawei.ism.drm.arbitration.util.ArbProperties;
import com.huawei.jetcd.client.EtcdConfig;
import com.huawei.jetcd.exception.EtcdServerException;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ArbX509TrustManager
implements X509TrustManager {
    private static final String RUNTIME_DIR;
    private static final String KEYSTORE_FILE;
    private X509TrustManager trustManager = null;

    public ArbX509TrustManager(EtcdConfig etcdConfig) throws EtcdServerException {
        KeyStore keyStore = ArbSecurityCertificateManager.getDefaultKeyStore(KEYSTORE_FILE, etcdConfig);
        this.trustManager = this.getTrustManager(keyStore);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (null == this.trustManager) {
            LogManager.error("The trust manager is not initialized");
            throw new CertificateException();
        }
        this.checkValidity(chain);
        this.checkTrusted(chain, authType);
    }

    private void checkValidity(X509Certificate[] chain) throws CertificateException {
        try {
            for (int i = 0; i < chain.length; ++i) {
                chain[i].checkValidity();
            }
        }
        catch (CertificateException e) {
            LogManager.error("Checking server certificate failed, cause by: " + LogManager.getErrorMessage(e));
            throw e;
        }
        catch (Exception e) {
            LogManager.error("Checking server certificate failed, cause by: " + LogManager.getErrorMessage(e));
            throw e;
        }
    }

    private void checkTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            LogManager.error("Checking server certificate failed, cause by: " + LogManager.getErrorMessage(e));
            throw e;
        }
        catch (Exception e) {
            LogManager.error("Checking server certificate failed, cause by: " + LogManager.getErrorMessage(e));
            throw e;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    private X509TrustManager getTrustManager(KeyStore keyStore) throws EtcdServerException {
        if (null == keyStore) {
            LogManager.warn("The keyStore is null.");
            throw new EtcdServerException(207);
        }
        X509TrustManager defaultTrustManager = null;
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        }
        catch (Exception e) {
            LogManager.error("Initialized TrustManager failed by the certificate, cause by: " + LogManager.getErrorMessage(e));
            throw new EtcdServerException(207);
        }
        return defaultTrustManager;
    }

    static {
        ArbProperties.getInstance();
        RUNTIME_DIR = ArbProperties.getRuntimePath();
        KEYSTORE_FILE = RUNTIME_DIR + File.separator + "LegoRuntime" + File.separator + "certs" + File.separator + "arb.keystore";
    }
}

