/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.arbitration.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.huawei.ism.drm.arbitration.exception.ArbitrationException;
import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.util.CustomSerializerProvider;
import com.huawei.ism.drm.arbitration.util.JSONArray;
import com.huawei.ism.drm.arbitration.util.VerifyUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ListOrderedMap;

public class JSONObject
implements Map,
Serializable {
    private static final long serialVersionUID = -54719329954411374L;
    private static ObjectMapper defaultObjMapper = new ObjectMapper();
    private Map properties = new ListOrderedMap();

    public static JSONObject fromObject(Object obj) {
        if (null == obj) {
            return new JSONObject();
        }
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        JSONObject json = new JSONObject();
        try {
            Map ret = null;
            if (obj instanceof String) {
                ret = (Map)defaultObjMapper.readValue(obj.toString(), Map.class);
            } else {
                String jsonString = defaultObjMapper.writeValueAsString(obj);
                ret = (Map)defaultObjMapper.readValue(jsonString, Map.class);
            }
            if (null != ret) {
                JSONObject.convertProperty(json, ret, null);
            }
        }
        catch (Exception e) {
            LogManager.error("fromObject failed:" + LogManager.getErrorMessage(e));
        }
        return json;
    }

    private static void convertProperty(JSONObject json, Map ret, Set<String> ignoreProperties) {
        Iterator iterator = ret.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            String key = entry.getKey().toString();
            if (null != ignoreProperties && ignoreProperties.contains(key)) continue;
            Object value = entry.getValue();
            Object tempValue = JSONObject.transforValueToJson(value);
            json.properties.put(entry.getKey(), tempValue);
        }
    }

    private static Object transforValueToJson(Object value) {
        Object tempValue = value;
        if (value instanceof Map && !(value instanceof JSONObject)) {
            tempValue = JSONObject.fromObject(value);
        } else if (value instanceof Collection && !(value instanceof JSONArray)) {
            tempValue = JSONArray.fromObject(value);
        }
        return tempValue;
    }

    public static JSONObject fromObject(Object obj, String[] ignoreProperties) {
        HashSet<String> ignoreSet = new HashSet<String>();
        if (null != ignoreProperties) {
            for (String property : ignoreProperties) {
                ignoreSet.add(property);
            }
        }
        return JSONObject.fromObject(obj, ignoreSet);
    }

    public static JSONObject fromObject(Object obj, Set<String> ignoreProperties) {
        if (null == obj) {
            LogManager.error("fromObject param is emtpy");
            throw new ArbitrationException(1073947393L);
        }
        JSONObject json = new JSONObject();
        try {
            Map ret = null;
            ObjectWriter objWriter = defaultObjMapper.writer();
            if (!VerifyUtil.isEmpty(ignoreProperties)) {
                objWriter = JSONObject.getWriterWithFilter(obj, ignoreProperties);
            }
            if (obj instanceof String) {
                ret = (Map)defaultObjMapper.readValue(obj.toString(), Map.class);
            } else {
                String jsonString = objWriter.writeValueAsString(obj);
                ret = (Map)defaultObjMapper.readValue(jsonString, Map.class);
            }
            if (null != ret) {
                JSONObject.convertProperty(json, ret, ignoreProperties);
            }
        }
        catch (Exception e) {
            LogManager.error("fromObject failed:" + LogManager.getErrorMessage(e));
        }
        return json;
    }

    private static ObjectWriter getWriterWithFilter(Object obj, Set<String> ignoreProperties) {
        ObjectMapper objMapper = new ObjectMapper();
        objMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        CustomSerializerProvider sp = new CustomSerializerProvider();
        objMapper.setSerializerProvider((DefaultSerializerProvider)sp);
        objMapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){
            private static final long serialVersionUID = 7803579234214249536L;

            public Object findFilterId(Annotated ac) {
                return ac.getName();
            }
        });
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter(obj.getClass().getName(), SimpleBeanPropertyFilter.serializeAllExcept(ignoreProperties));
        ObjectWriter objWriter = objMapper.writer((FilterProvider)filters);
        return objWriter;
    }

    public static <T> T toBean(JSONObject jsonObject, Class<T> beanClass) {
        return JSONObject.toBean(jsonObject.toString(), beanClass);
    }

    public static <T> T toBean(String jsonStr, Class<T> clazz) {
        if (null == jsonStr || jsonStr.isEmpty() || null == clazz) {
            LogManager.error("parameter error");
            throw new ArbitrationException(1073947393L);
        }
        Object body = null;
        try {
            body = defaultObjMapper.readValue(jsonStr, clazz);
        }
        catch (Exception e) {
            LogManager.error("json to bean failed:" + LogManager.getErrorMessage(e));
        }
        return (T)body;
    }

    public Object get(String key) {
        if (null == key || key.isEmpty()) {
            LogManager.error("the key is empty");
            throw new ArbitrationException(1073947393L);
        }
        return this.properties.get(key);
    }

    public boolean getBoolean(String key) {
        if (null == key || key.isEmpty()) {
            LogManager.error("key is empty");
            throw new ArbitrationException(1073947393L);
        }
        Object value = this.properties.get(key);
        if (null != value) {
            if (Boolean.FALSE.equals(value) || value instanceof String && ((String)value).equalsIgnoreCase("false")) {
                return false;
            }
            if (Boolean.TRUE.equals(value) || value instanceof String && ((String)value).equalsIgnoreCase("true")) {
                return true;
            }
        }
        LogManager.error("JSONObject getBoolean failed,value is null or doesn't contain this key.key=" + key);
        throw new ArbitrationException(-1L);
    }

    public double getDouble(String key) {
        if (null == key || key.isEmpty()) {
            LogManager.error("key is empty");
            throw new ArbitrationException(1073947393L);
        }
        Object value = this.properties.get(key);
        if (null != value) {
            try {
                return value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
            }
            catch (Exception e) {
                LogManager.error("getDouble failed:" + LogManager.getErrorMessage(e));
            }
        }
        LogManager.error("JSONObject getDouble failed,value is null or doesn't contain this key.key=" + key);
        throw new ArbitrationException(-1L);
    }

    public int getInt(String key) {
        if (null == key || key.isEmpty()) {
            LogManager.error("key is empty");
            throw new ArbitrationException(1073947393L);
        }
        Object o = this.get(key);
        if (o != null) {
            return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
        }
        LogManager.error("JSONObject getInt failed,value is null or doesn't contain this key.key=" + key);
        throw new ArbitrationException(-1L);
    }

    public long getLong(String key) {
        StackTraceElement[] trace = new Exception().getStackTrace();
        if (!trace[1].toString().contains("com.huawei.lego.core.sdk.util")) {
            LogManager.error("jackson-debug:" + trace[1] + trace[0]);
        }
        if (null == key || key.isEmpty()) {
            LogManager.error("key is empty");
            throw new ArbitrationException(1073947393L);
        }
        Object o = this.get(key);
        if (o != null) {
            return o instanceof Number ? ((Number)o).longValue() : (long)((int)this.getDouble(key));
        }
        LogManager.error("JSONObject getLong failed,value is null or doesn't contain this key.key=" + key);
        throw new ArbitrationException(-1L);
    }

    public String getString(String key) {
        if (null == key || key.isEmpty()) {
            LogManager.error("the key is empty");
            throw new ArbitrationException(1073947393L);
        }
        if (!this.properties.containsKey(key)) {
            LogManager.debug("JSONObject getString failed,the object doesn't contain this key.key=" + key);
            throw new ArbitrationException(-1L);
        }
        Object o = this.get(key);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public String toString() {
        try {
            return defaultObjMapper.writeValueAsString((Object)this.properties);
        }
        catch (JsonProcessingException e) {
            LogManager.error("toString failed:" + LogManager.getErrorMessage(e));
            throw new ArbitrationException(-1L, (Throwable)e);
        }
    }

    public JSONObject getJSONObject(String key) {
        if (null == key || key.isEmpty()) {
            LogManager.error("the key is empty");
            throw new ArbitrationException(1073947393L);
        }
        Object o = this.get(key);
        if (null != o) {
            JSONObject json = null;
            json = !(o instanceof JSONObject) ? JSONObject.fromObject(o) : (JSONObject)o;
            return json;
        }
        return null;
    }

    public JSONArray getJSONArray(String key) {
        if (null == key || key.isEmpty()) {
            LogManager.error("the key is empty");
            throw new ArbitrationException(1073947393L);
        }
        Object o = this.get(key);
        if (null != o) {
            JSONArray array = null;
            array = !(o instanceof JSONArray) ? JSONArray.fromObject(o) : (JSONArray)o;
            return array;
        }
        return null;
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    public Set entrySet() {
        return this.properties.entrySet();
    }

    public Object get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Iterator keys() {
        return this.properties.keySet().iterator();
    }

    public Set keySet() {
        return this.properties.keySet();
    }

    public Object put(Object key, Object value) {
        if (null == key) {
            LogManager.error("the key is empty");
            throw new ArbitrationException(1073947393L);
        }
        if (null == value) {
            LogManager.info("the value will put is null");
            return this;
        }
        Object tempValue = value;
        if (value instanceof String) {
            tempValue = this.convertStr2Json(value);
        } else if (value instanceof Map && !(value instanceof JSONObject)) {
            tempValue = JSONObject.fromObject(value);
        } else if (value instanceof Collection && !(value instanceof JSONArray)) {
            tempValue = JSONArray.fromObject(value);
        }
        return this.properties.put(key, tempValue);
    }

    private Object convertStr2Json(Object value) {
        Object tempValue = value;
        try {
            if (((String)value).startsWith("{") && ((String)value).endsWith("}")) {
                tempValue = JSONObject.fromObject(value);
            } else if (((String)value).startsWith("[") && ((String)value).endsWith("]")) {
                tempValue = JSONArray.fromObject(value);
            }
        }
        catch (ArbitrationException e) {
            LogManager.error("can't convert string to JSON Object:str=" + value);
        }
        return tempValue;
    }

    public void putAll(Map map) {
        if (null == map) {
            LogManager.error("the map is null");
            throw new ArbitrationException(1073947393L);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.put(key, value);
        }
    }

    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    public Collection values() {
        return this.properties.values();
    }

    static {
        try {
            defaultObjMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            defaultObjMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            CustomSerializerProvider sp = new CustomSerializerProvider();
            defaultObjMapper.setSerializerProvider((DefaultSerializerProvider)sp);
        }
        catch (Exception e) {
            LogManager.error("Initialize ObjectMapper failed:" + LogManager.getErrorMessage(e));
        }
    }
}

