/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.jetcd.client;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.jetcd.client.AllNodeDownSelectPolicy;

public class EtcdConfig {
    private int retryCount = 3;
    private boolean keepAlive = false;
    private int readTimeout = 3000;
    private int connectTimeOut = 3000;
    private boolean healthCheck = false;
    private int checkIntervalTime = 3;
    private int checkTimesBeforeMarkedUp = 1;
    private AllNodeDownSelectPolicy allNodeDownSelectPolicy;
    private String[] server;
    private int loopWatchTimeOut = 10000;
    private int loopWatchFailedWaitTime = 2000;
    private String username;
    private String password;
    private String keyStorePwd;

    public String[] getServer() {
        return this.server;
    }

    public void setServer(String[] server) {
        this.server = server;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public boolean isHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(boolean healthCheck) {
        this.healthCheck = healthCheck;
    }

    public int getCheckIntervalTime() {
        return this.checkIntervalTime;
    }

    public void setCheckIntervalTime(int checkIntervalTime) {
        this.checkIntervalTime = checkIntervalTime;
    }

    public int getCheckTimesBeforeMarkedUp() {
        return this.checkTimesBeforeMarkedUp;
    }

    public void setCheckTimesBeforeMarkedUp(int checkTimesBeforeMarkedUp) {
        this.checkTimesBeforeMarkedUp = checkTimesBeforeMarkedUp;
    }

    public AllNodeDownSelectPolicy getAllNodeDownSelectPolicy() {
        return this.allNodeDownSelectPolicy;
    }

    public void setAllNodeDownSelectPolicy(AllNodeDownSelectPolicy allNodeDownSelectPolicy) {
        this.allNodeDownSelectPolicy = allNodeDownSelectPolicy;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public int getLoopWatchTimeOut() {
        return this.loopWatchTimeOut;
    }

    public void setLoopWatchTimeOut(int loopWatchTimeOut) {
        this.loopWatchTimeOut = loopWatchTimeOut;
    }

    public int getLoopWatchFailedWaitTime() {
        return this.loopWatchFailedWaitTime;
    }

    public void setLoopWatchFailedWaitTime(int loopWatchFailedWaitTime) {
        this.loopWatchFailedWaitTime = loopWatchFailedWaitTime;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getKeyStorePwd() {
        return this.keyStorePwd;
    }

    public void setKeyStorePwd(String keyStorePwd) {
        this.keyStorePwd = keyStorePwd;
    }

    public static class Builder {
        private int retryCount = 3;
        private boolean keepAlive = false;
        private int readTimeout = 3000;
        private int connectTimeOut = 3000;
        private boolean healthCheck = false;
        private int checkIntervalTime = 3000;
        private int checkTimesBeforeMarkedUp = 1;
        private int loopWatchTimeOut = 10000;
        private int loopWatchFailedWaitTime = 2000;
        private String username;
        private String password;
        private AllNodeDownSelectPolicy allNodeDownSelectPolicy = AllNodeDownSelectPolicy.RANDOM_SELECT_ONE;
        private String[] server;
        private String keyStorePwd;

        public Builder setRetryCount(int retryCount) {
            if (retryCount < 0) {
                LogManager.error("retryCount in invalid : " + retryCount);
                throw new IllegalArgumentException("retryCount in invalid : " + retryCount);
            }
            this.retryCount = retryCount;
            return this;
        }

        public Builder setKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            if (readTimeout >= 0) {
                this.readTimeout = readTimeout;
            }
            return this;
        }

        public Builder setConnectTimeOut(int connectTimeOut) {
            if (connectTimeOut >= 0) {
                this.connectTimeOut = connectTimeOut;
            }
            return this;
        }

        public Builder setHealthCheck(boolean healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder setCheckIntervalTime(int checkIntervalTime) {
            if (checkIntervalTime > 0) {
                this.checkIntervalTime = checkIntervalTime;
            }
            return this;
        }

        public Builder setCheckTimesBeforeMarkedUp(int checkTimesBeforeMarkedUp) {
            if (checkTimesBeforeMarkedUp > 0) {
                this.checkTimesBeforeMarkedUp = checkTimesBeforeMarkedUp;
            }
            return this;
        }

        public Builder setAllNodeDownSelectPolicy(AllNodeDownSelectPolicy allNodeDownSelectPolicy) {
            this.allNodeDownSelectPolicy = allNodeDownSelectPolicy;
            return this;
        }

        public Builder setServer(String[] server) {
            this.server = server;
            return this;
        }

        public Builder setLoopWatchTimeOut(int loopWatchTimeOut) {
            if (loopWatchTimeOut > 0) {
                this.loopWatchTimeOut = loopWatchTimeOut;
            }
            return this;
        }

        public Builder setLoopWatchFailedWaitTime(int loopWatchFailedWaitTime) {
            if (loopWatchFailedWaitTime > 0) {
                this.loopWatchFailedWaitTime = loopWatchFailedWaitTime;
            }
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setKeyStorePwd(String keyStorePwd) {
            this.keyStorePwd = keyStorePwd;
            return this;
        }

        public EtcdConfig build() {
            if (this.server == null || this.server.length == 0) {
                throw new IllegalArgumentException("server is empty.");
            }
            EtcdConfig etcdConfig = new EtcdConfig();
            etcdConfig.setServer(this.server);
            etcdConfig.setAllNodeDownSelectPolicy(this.allNodeDownSelectPolicy);
            etcdConfig.setCheckIntervalTime(this.checkIntervalTime);
            etcdConfig.setCheckTimesBeforeMarkedUp(this.checkTimesBeforeMarkedUp);
            etcdConfig.setHealthCheck(this.healthCheck);
            etcdConfig.setKeepAlive(this.keepAlive);
            etcdConfig.setReadTimeout(this.readTimeout);
            etcdConfig.setConnectTimeOut(this.connectTimeOut);
            etcdConfig.setRetryCount(this.retryCount);
            etcdConfig.setLoopWatchFailedWaitTime(this.loopWatchFailedWaitTime);
            etcdConfig.setLoopWatchTimeOut(this.loopWatchTimeOut);
            etcdConfig.setUsername(this.username);
            etcdConfig.setPassword(this.password);
            etcdConfig.setKeyStorePwd(this.keyStorePwd);
            return etcdConfig;
        }
    }
}

