/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.jetcd.client.form;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.jetcd.client.form.Form;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class KeyForm
extends Form {
    protected String key;

    KeyForm(String key) {
        super("/v2/keys");
        this.key = key;
    }

    @Override
    public String getURI() {
        StringBuilder sb = new StringBuilder();
        if (this.key != null) {
            if (this.key.startsWith("/")) {
                this.key = this.key.substring(1);
            }
            for (String token : this.key.split("/")) {
                sb.append("/");
                sb.append(this.urlEscape(token));
            }
        }
        return super.getURI() + sb.toString();
    }

    protected String urlEscape(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LogManager.warn("URLEncoder Error, cause by " + LogManager.getErrorMessage(e));
            return url;
        }
    }

    public String getKey() {
        return this.key;
    }
}

