/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.jetcd.client.impl;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.jetcd.client.EtcdConfig;
import com.huawei.jetcd.client.IClient;
import com.huawei.jetcd.client.form.Form;
import com.huawei.jetcd.client.form.KeyGetForm;
import com.huawei.jetcd.client.form.VersionForm;
import com.huawei.jetcd.client.impl.AbstractClient;
import com.huawei.jetcd.client.parser.EtcdResultTranslator;
import com.huawei.jetcd.exception.EtcdException;
import com.huawei.jetcd.model.EtcdNode;
import com.huawei.jetcd.model.EtcdResult;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.asynchttpclient.Response;

public final class ClientImpl
extends AbstractClient
implements IClient {
    public ClientImpl(EtcdConfig config) {
        super(config, null);
    }

    public ClientImpl(EtcdConfig config, SslContext sslcontext) {
        super(config, sslcontext);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String version() throws EtcdException {
        VersionForm form = new VersionForm();
        try {
            Response response = this.syncExecuteHttp(form);
            this.setUri(response.getUri().toUrl().substring(0, response.getUri().toUrl().indexOf("/version")));
            return EtcdResultTranslator.translateVersion(response);
        }
        catch (EtcdException e) {
            LogManager.error("connected etcd server failed, cause by: " + LogManager.getErrorMessage(e));
            throw new EtcdException("connected etcd server failed.");
        }
    }

    @Override
    public EtcdResult get(String key) throws EtcdException {
        KeyGetForm form = new KeyGetForm(key);
        return this.syncExecute(form);
    }

    @Override
    public List<EtcdNode> listDir(String dir) throws EtcdException {
        KeyGetForm form = new KeyGetForm(dir);
        EtcdResult result = this.syncExecute(form);
        if (result.getNode() == null || result.getNode().getNodes() == null) {
            List<EtcdNode> nodeList = Collections.emptyList();
            return nodeList;
        }
        return result.getNode().getNodes();
    }

    private EtcdResult syncExecute(Form form) throws EtcdException {
        Response response = this.syncExecuteHttp(form);
        return EtcdResultTranslator.translateKeyResult(response);
    }
}

