/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.jetcd.client.impl;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.util.JSONObject;
import com.huawei.ism.drm.arbitration.util.VerifyUtil;
import com.huawei.jetcd.client.internal.BaseUri;
import com.huawei.jetcd.model.EtcdHealth;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

public class HealthCheckHandler
extends AsyncCompletionHandler<Void> {
    private static final int CHECK_READ_TIMEOUT = 2000;
    private BaseUri baseUri;
    private Request request;
    private AsyncHttpClient httpClient;
    private boolean checking = false;
    private int upCheckTime = 0;
    private int maxUpCheckTime = 1;
    private ListenableFuture<Response> futureResponse;

    public HealthCheckHandler(BaseUri baseUri, AsyncHttpClient httpClient, int maxUpCheckTime) {
        this.httpClient = httpClient;
        this.baseUri = baseUri;
        this.request = ((BoundRequestBuilder)httpClient.prepareGet(baseUri.getEtcdUri() + "/health").setRequestTimeout(2000)).build();
        this.maxUpCheckTime = maxUpCheckTime;
    }

    public void startMoniter() {
        this.checking = true;
        this.httpClient.executeRequest(this.request, (AsyncHandler)this);
    }

    public void startFutureMoniter() {
        this.futureResponse = this.httpClient.executeRequest(this.request);
    }

    public boolean isFutureCheckHealth() throws InterruptedException, ExecutionException, IOException {
        String ipAddress = this.baseUri.getEtcdUri();
        if (this.futureResponse != null) {
            Response response = (Response)this.futureResponse.get();
            boolean isHealth = this.isHealth(response);
            LogManager.debug(String.format("the health result is: %s and the server address is: %s", isHealth, ipAddress));
            return isHealth;
        }
        LogManager.debug(String.format("the health result is: false and the server address is: %s", ipAddress));
        return false;
    }

    public boolean isChecking() {
        return this.checking;
    }

    public Void onCompleted(Response response) throws Exception {
        this.checking = false;
        if (this.isHealth(response)) {
            if (!this.baseUri.isHealth()) {
                ++this.upCheckTime;
                if (this.upCheckTime >= this.maxUpCheckTime) {
                    this.baseUri.setHealth(true);
                } else {
                    LogManager.debug(this.maxUpCheckTime - this.upCheckTime + " more times to make sure it is Up.");
                }
            } else {
                LogManager.debug("onCompleted is Normal.");
            }
        } else if (this.baseUri.isHealth()) {
            this.upCheckTime = 0;
            this.baseUri.setHealth(false);
            LogManager.warn("status is: " + response.getStatusCode());
        }
        return null;
    }

    public void onThrowable(Throwable t) {
        this.checking = false;
        this.upCheckTime = 0;
        if (this.baseUri.isHealth()) {
            this.baseUri.setHealth(false);
        } else {
            LogManager.error("asyncExecuteHttp is still down.cause by " + LogManager.getErrorMessage(t));
        }
    }

    public boolean isHealth(Response response) throws IOException {
        String responseBody;
        if (response.getStatusCode() == 200 && (responseBody = response.getResponseBody()) != null) {
            EtcdHealth etcdHealth = JSONObject.toBean(responseBody, EtcdHealth.class);
            if (VerifyUtil.isEmpty(etcdHealth)) {
                LogManager.error("etcdHealth object is null.");
                return false;
            }
            this.baseUri.setHealth(etcdHealth.isHealth());
            this.baseUri.setEtcdUri(this.request.getUrl().substring(0, this.request.getUrl().indexOf("/health")));
            return etcdHealth.isHealth();
        }
        return false;
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(this.request.getUrl());
        strBuffer.append(" ");
        return strBuffer.toString();
    }
}

