/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.alarm.service;

import com.huawei.ism.drm.rest.service.framework.alarm.model.AlarmTransferStorageConfigVo;
import com.huawei.ism.drm.rest.service.framework.alarm.model.AlarmVO;
import com.huawei.ism.drm.rest.service.framework.alarm.model.ThirdAlarmVo;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.nem.fault.sdk.model.AlertExperience;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public interface IAlarmRestService {
    @GET
    @Path(value="/statistic")
    public String getAlarmStatisticAndAudio();

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getAlarmList(@QueryParam(value="severity") Set<Integer> var1, @QueryParam(value="confirmStatus") Integer var2, @QueryParam(value="alarmSource") String var3, @QueryParam(value="alarmType") Integer var4, @QueryParam(value="location") String var5);

    @GET
    @Path(value="/{alarmId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public AlarmVO getAlarm(@PathParam(value="alarmId") String var1);

    @GET
    @Path(value="/action/queryHistoryAlarms")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getHistoryAlarmList(@QueryParam(value="severity") Set<Integer> var1, @QueryParam(value="confirmStatus") Integer var2, @QueryParam(value="alarmSource") String var3, @QueryParam(value="alarmType") Integer var4, @QueryParam(value="location") String var5);

    @PUT
    @Path(value="/action/confirm")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public BatchOperationResult confirmAlarm(Set<BatchOperation> var1);

    @PUT
    @Path(value="/action/cancelConfirm")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public BatchOperationResult cancelConfirmAlarm(Set<BatchOperation> var1);

    @PUT
    @Path(value="/action/clearAlarmConfirm")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public BatchOperationResult clearAlarms(Set<BatchOperation> var1);

    @GET
    @Path(value="/action/exportSelectedAlarms")
    @Produces(value={"application/x-download"})
    @Consumes(value={"application/json"})
    public Response exportSelectedAlarms(@QueryParam(value="alarmIdSet") Set<String> var1, @QueryParam(value="orderBy") String var2, @QueryParam(value="orderType") String var3);

    @GET
    @Path(value="/action/exportSelectedHistoryAlarms")
    @Produces(value={"application/x-download"})
    @Consumes(value={"application/json"})
    public Response exportSelectedHistoryAlarms(@QueryParam(value="alarmIdSet") Set<String> var1, @QueryParam(value="orderBy") String var2, @QueryParam(value="orderType") String var3);

    @GET
    @Path(value="/action/exportAllHistoryAlarms")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response exportAllHistoryAlarms(@QueryParam(value="severity") Set<Integer> var1, @QueryParam(value="confirmStatus") Integer var2, @QueryParam(value="alarmSource") String var3, @QueryParam(value="alarmType") Integer var4, @QueryParam(value="location") String var5);

    @GET
    @Path(value="/action/exportAllAlarms")
    @Produces(value={"application/x-download"})
    @Consumes(value={"application/json"})
    public Response exportAllAlarms(@QueryParam(value="severity") Set<Integer> var1, @QueryParam(value="confirmStatus") Integer var2, @QueryParam(value="alarmSource") String var3, @QueryParam(value="alarmType") Integer var4, @QueryParam(value="location") String var5);

    @GET
    @Path(value="/action/queryTransferStorageConfig")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public AlarmTransferStorageConfigVo queryAlarmTransferStorageCfg();

    @PUT
    @Path(value="/action/modifyTransferStorageConfig")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response modfiyAlarmTransferStorageCfg(AlarmTransferStorageConfigVo var1);

    @GET
    @Path(value="/action/queryTransferStorageHistory")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String queryAlarmTransferStorageTaskList(@QueryParam(value="startPage") int var1, @DefaultValue(value="10") @QueryParam(value="pageSize") int var2);

    @DELETE
    @Path(value="/action/deleteTransferStorageHistory")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public BatchOperationResult deleteTaskResults(Set<Long> var1);

    @GET
    @Path(value="/{alarmId}/action/alarmExperiences")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<AlertExperience> getAdviseList(@PathParam(value="alarmId") String var1);

    @POST
    @Path(value="/{alarmId}/action/alarmExperiences")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addAlertExperience(@PathParam(value="alarmId") String var1, AlertExperience var2);

    @DELETE
    @Path(value="/action/alarmExperiences/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public BatchOperationResult deleteExperience(Set<Long> var1);

    @GET
    @Path(value="/{alarmId}/alarmCountDetail")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getAlarmCountDetail(@PathParam(value="alarmId") String var1, @QueryParam(value="startPage") int var2, @QueryParam(value="orderBy") String var3, @QueryParam(value="orderType") String var4, @DefaultValue(value="10") @QueryParam(value="pageSize") int var5);

    @GET
    @Path(value="/action/exportAlarmTransferStorage")
    @Produces(value={"application/x-download"})
    @Consumes(value={"application/json"})
    public Response exportAlarmTransferStorage(@DefaultValue(value="-1") @QueryParam(value="fileId") long var1);

    @POST
    @Path(value="/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response sendAlarm(ThirdAlarmVo var1);
}

