/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.alarm.util;

import com.huawei.ism.drm.rest.service.framework.alarm.util.FileUtil;
import com.huawei.lego.cbb.resource.sdk.model.DeviceConfigData;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CsvFileUtil
extends FileUtil {
    private static final String SIGN_COMMA = ",";
    private CSVPrinter csvPrinter;

    public CsvFileUtil() {
        this.setStrExtend("csv");
    }

    public CSVPrinter getCsvPrinter() {
        return this.csvPrinter;
    }

    public void setCsvPrinter(CSVPrinter csvPrinter) {
        this.csvPrinter = csvPrinter;
    }

    @Override
    public void closeFile() throws IOException {
        this.csvPrinter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(List<List<String>> dataList) {
        if (null == dataList) {
            return;
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        PrintWriter pw = null;
        CSVFormat format = CSVFormat.DEFAULT.withHeader(new String[]{SIGN_COMMA}).withSkipHeaderRecord();
        try {
            fos = new FileOutputStream(this.getWriteFileName());
            osw = new OutputStreamWriter((OutputStream)fos, Charset.forName(this.getStrChar()));
            pw = new PrintWriter(osw);
            this.csvPrinter = new CSVPrinter((Appendable)pw, format);
            int iIndex = 0;
            Object[] arrTemp = new String[this.getColTitle().size()];
            this.csvPrinter.printRecord((Object[])new String[]{this.getStrUsrName(), CsvFileUtil.getNowTime()});
            for (String string : this.getColTitle()) {
                arrTemp[iIndex++] = string;
            }
            this.csvPrinter.printRecord(arrTemp);
            for (List list : dataList) {
                this.csvPrinter.printRecord((Iterable)list);
            }
            this.csvPrinter.flush();
            this.closeWriter(pw);
            this.closeStream(fos, osw);
        }
        catch (IOException e) {
            try {
                log.error((Object)("error:" + ExceptionUtil.getErrorMessage((Throwable)e)));
                this.closeWriter(pw);
                this.closeStream(fos, osw);
            }
            catch (Throwable throwable) {
                this.closeWriter(pw);
                this.closeStream(fos, osw);
                throw throwable;
            }
        }
    }

    private void closeWriter(PrintWriter pw) {
        if (null != this.csvPrinter) {
            try {
                this.csvPrinter.close();
            }
            catch (Exception e) {
                log.error((Object)"Close failed.", 90160758784001L);
            }
        }
        if (null != pw) {
            try {
                pw.close();
            }
            catch (Exception e) {
                log.error((Object)"Close failed.", 90160758784001L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(List<List<String>> dataLst, String detailLink) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        PrintWriter pw = null;
        CSVFormat format = CSVFormat.DEFAULT.withHeader(new String[]{SIGN_COMMA}).withSkipHeaderRecord();
        try {
            fos = new FileOutputStream(this.getWriteFileName());
            osw = new OutputStreamWriter((OutputStream)fos, Charset.forName(this.getStrChar()));
            pw = new PrintWriter(osw);
            this.csvPrinter = new CSVPrinter((Appendable)pw, format);
            int iIndex = 0;
            Object[] arrTemp = new String[this.getColTitle().size()];
            if (arrTemp.length > 1) {
                arrTemp[0] = this.getStrUsrName();
                arrTemp[1] = CsvFileUtil.getNowTime();
                this.csvPrinter.printRecord(arrTemp);
            }
            for (String string : this.getColTitle()) {
                arrTemp[iIndex++] = string;
            }
            this.csvPrinter.printRecord(arrTemp);
            for (List list : dataLst) {
                iIndex = 0;
                Object[] arrTemps = new String[list.size()];
                for (int i = 0; i < list.size() - 1; ++i) {
                    arrTemps[iIndex++] = (String)list.get(i);
                }
                this.csvPrinter.printRecord(arrTemps);
            }
            this.csvPrinter.flush();
            this.closeWriter(pw);
            this.closeStream(fos, osw);
        }
        catch (IOException e) {
            try {
                log.error((Object)"writeFile failed.", 90160758784001L);
                this.closeWriter(pw);
                this.closeStream(fos, osw);
            }
            catch (Throwable throwable) {
                this.closeWriter(pw);
                this.closeStream(fos, osw);
                throw throwable;
            }
        }
    }

    private void closeStream(FileOutputStream fos, OutputStreamWriter osw) {
        if (null != osw) {
            try {
                osw.close();
            }
            catch (IOException e) {
                log.error((Object)"Close file failed.", 90160758784001L);
            }
        }
        if (null != fos) {
            try {
                fos.close();
            }
            catch (IOException e) {
                log.error((Object)"Close file failed.", 90160758784001L);
            }
        }
    }

    @Override
    public void writeConfigData(List<List<DeviceConfigData>> configList) {
    }
}

