/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.alarm.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.framework.alarm.model.AlarmDetailVO;
import com.huawei.ism.drm.rest.service.framework.alarm.model.AlarmVO;
import com.huawei.ism.drm.util.Base64;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.AlarmDetail;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IConvertStringService;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class FaultActionUtil {
    private static Log logger = FELogFactory.getInstance((String)"ui");
    private static SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private FaultActionUtil() {
    }

    public static String getSeverityDesc(int severity) {
        String desc;
        switch (severity) {
            case 1: {
                desc = "lego.lab.fault.alarmLevel.warning";
                break;
            }
            case 2: {
                desc = "lego.lab.fault.alarmLevel.minor";
                break;
            }
            case 3: {
                desc = "lego.lab.fault.alarmLevel.major";
                break;
            }
            case 4: {
                desc = "lego.lab.fault.alarmLevel.critical";
                break;
            }
            default: {
                desc = String.valueOf(severity);
            }
        }
        return desc;
    }

    public static String getConfirmationDesc(int confirmation) {
        String desc;
        logger.trace((Object)"enter getConfirmationDesc");
        switch (confirmation) {
            case 0: {
                desc = "lego.dic.confirmstatus.unconfirmed";
                break;
            }
            case 1: {
                desc = "lego.dic.confirmstatus.confirmed";
                break;
            }
            default: {
                desc = String.valueOf(confirmation);
            }
        }
        return desc;
    }

    public static String getFaultTypeDesc(int type) {
        String desc;
        switch (type) {
            case 1: {
                desc = "lego.dic.warningtype.comm";
                break;
            }
            case 2: {
                desc = "lego.dic.warningtype.env";
                break;
            }
            case 3: {
                desc = "lego.dic.warningtype.dev";
                break;
            }
            case 4: {
                desc = "lego.dic.warningtype.business";
                break;
            }
            case 5: {
                desc = "lego.dic.warningtype.operation";
                break;
            }
            case 6: {
                desc = "lego.dic.warningtype.security";
                break;
            }
            default: {
                desc = String.valueOf(type);
            }
        }
        return desc;
    }

    private static String[] getAlarmParamArray(String[] param) {
        if (null == param || param.length <= 0) {
            return new String[0];
        }
        for (int i = 0; i < param.length; ++i) {
            try {
                param[i] = FaultActionUtil.replaceParam(param[i]);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("getAlarmParamArray exception." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        return param;
    }

    public static String replaceParam(String param) {
        logger.trace((Object)"enter replaceParam");
        if (null == param) {
            return "";
        }
        return param.replaceAll("\r", "").replaceAll("\n", "");
    }

    public static boolean isValidKey(String key) {
        if (VerifyUtil.isEmpty((String)key)) {
            logger.debug((Object)("key:" + key));
            return false;
        }
        int length = key.length();
        for (int i = 0; i < length; ++i) {
            char ch = key.charAt(i);
            if (!FaultActionUtil.checkChar(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkChar(char ch) {
        logger.trace((Object)"enter checkChar");
        return !FaultActionUtil.checkChar(ch, 'a', 'z') && !FaultActionUtil.checkChar(ch, 'A', 'Z') && !FaultActionUtil.checkChar(ch, '0', '9') && ch != '.' && ch != '_';
    }

    private static boolean checkChar(char ch, char start, char end) {
        return ch >= start && ch <= end;
    }

    public static List<AlarmVO> convertAlarmPO2VO(List<LegoAlarm> legoAlarms, Locale locale) {
        ArrayList<AlarmVO> alarmVOs = new ArrayList<AlarmVO>();
        IConvertStringService convertStringService = FaultActionUtil.getConvertStringService();
        if (null == convertStringService || null == legoAlarms) {
            logger.error((Object)"convertStringService or legoAlarms is null.");
            return alarmVOs;
        }
        AlarmVO alarmVO = null;
        for (LegoAlarm legoAlarm : legoAlarms) {
            alarmVO = FaultActionUtil.convertAlarmPO2VO(legoAlarm, convertStringService, locale);
            if (null == alarmVO) continue;
            alarmVOs.add(alarmVO);
        }
        return alarmVOs;
    }

    public static AlarmVO convertAlarmPO2VO(LegoAlarm legoAlarm, IConvertStringService convertStringService, Locale locale) {
        String alarmId = "";
        try {
            String[] param = FaultActionUtil.getAlarmParamArray(legoAlarm.getAlarmParam());
            alarmId = legoAlarm.getAlarmId();
            AlarmVO alarmVO = new AlarmVO();
            alarmVO.setParams(param);
            String entity = legoAlarm.getEntity();
            alarmVO.setEntity(FaultActionUtil.convertEntity(entity));
            alarmVO.setAlarmId(legoAlarm.getAlarmId());
            alarmVO.setAlarmName(legoAlarm.getAlarmName());
            alarmVO.setAlarmNameKey(legoAlarm.getAlarmName());
            alarmVO.setSeverity(String.valueOf(legoAlarm.getAlarmLevel().getValue()));
            alarmVO.setAlarmSource(String.valueOf(legoAlarm.getMoId()));
            alarmVO.setNmsIp(legoAlarm.getNmsIp());
            alarmVO.setCount(legoAlarm.getAlarmCount());
            alarmVO.setFirstTime(legoAlarm.getFirstTime());
            alarmVO.setAlarmTime(legoAlarm.getAlarmTime());
            alarmVO.setAlarmType(String.valueOf(legoAlarm.getAlarmType()));
            String description = legoAlarm.getAlarmDesc();
            description = FaultActionUtil.convertString(description, convertStringService);
            alarmVO.setAlarmDesc(description);
            String advice = legoAlarm.getAdvice();
            alarmVO.setAdvice(advice);
            alarmVO.setSysEffect(legoAlarm.getSysEffect());
            alarmVO.setMoName(legoAlarm.getMoName());
            alarmVO.setClearStatus(legoAlarm.getClearStatus().getValue());
            alarmVO.setClearTime(legoAlarm.getClearTime());
            alarmVO.setClearTimeStr(FaultActionUtil.formateTime(legoAlarm.getGmt(), legoAlarm.getClearTime()));
            alarmVO.setClearUser(legoAlarm.getClearUser());
            alarmVO.setConfirmStatus(String.valueOf(legoAlarm.getConfirmStatus().getValue()));
            alarmVO.setConfirmTime(legoAlarm.getConfirmTime());
            alarmVO.setConfirmUser(legoAlarm.getConfirmUser());
            String location = legoAlarm.getLocation();
            if (null == location || location.trim().isEmpty()) {
                alarmVO.setLocation("--");
            } else {
                alarmVO.setLocation(location);
            }
            alarmVO.setMoId(String.valueOf(legoAlarm.getMoId()));
            FaultActionUtil.setMo(legoAlarm, alarmVO);
            long firstTime = legoAlarm.getFirstTime();
            if (firstTime > 0L) {
                alarmVO.setFirstTimeStr(FaultActionUtil.formateTime(legoAlarm.getGmt(), firstTime));
            } else {
                alarmVO.setFirstTimeStr("--");
            }
            FaultActionUtil.convertPlugin(legoAlarm, alarmVO);
            return alarmVO;
        }
        catch (Exception e) {
            logger.error((Object)("convert AlarmPO to VO failed, alarmId: " + alarmId + ExceptionUtil.getErrorMessage((Throwable)e)));
            return null;
        }
    }

    public static String formateTime(String gmt, long date) {
        return CommUtils.formatDate(new Date(date));
    }

    private static String convertEntity(String entity) {
        logger.trace((Object)"enter convertEntity");
        if (entity == null) {
            return "";
        }
        return Base64.byteArrayToBase64((byte[])entity.getBytes(Charset.defaultCharset()));
    }

    private static void setMo(LegoAlarm legoAlarm, AlarmVO alarmVO) {
        StringBuilder moType = new StringBuilder();
        String moMainType = legoAlarm.getMoMainType();
        String moSubType = legoAlarm.getMoSubType();
        alarmVO.setMoMainType(moMainType);
        alarmVO.setMoSubType(moSubType);
        if (null != moMainType && !moMainType.isEmpty()) {
            moType.append(moMainType);
        }
        if (null != moSubType && !moSubType.isEmpty()) {
            if (null != moType.toString() && !moType.toString().isEmpty()) {
                moType.append("--");
            }
            moType.append(moSubType);
        }
        alarmVO.setMoType(moType.toString());
    }

    private static void convertPlugin(LegoAlarm legoAlarm, AlarmVO alarmVO) {
        logger.trace((Object)"enter convertPlugin");
        long alarmTime = legoAlarm.getAlarmTime();
        if (alarmTime > 0L) {
            alarmVO.setAlarmTimeStr(FaultActionUtil.formateTime(legoAlarm.getGmt(), alarmTime));
        } else {
            alarmVO.setAlarmTimeStr("--");
        }
        long clearTime = legoAlarm.getClearTime();
        if (clearTime > 0L) {
            alarmVO.setClearTimeStr(FaultActionUtil.formateTime(legoAlarm.getGmt(), clearTime));
        } else {
            alarmVO.setClearTimeStr("--");
        }
        FaultActionUtil.convertPluginExtend(legoAlarm, alarmVO);
    }

    private static void convertPluginExtend(LegoAlarm legoAlarm, AlarmVO alarmVO) {
        long confirmTime = legoAlarm.getConfirmTime();
        if (confirmTime > 0L) {
            alarmVO.setConfirmTimeStr(FaultActionUtil.formateTime(legoAlarm.getGmt(), confirmTime));
        } else {
            alarmVO.setConfirmTimeStr("--");
        }
        String clearUser = alarmVO.getClearUser();
        if (null == clearUser || clearUser.isEmpty()) {
            alarmVO.setClearUser("--");
        }
    }

    public static SimpleDateFormat getDateFormat() {
        logger.trace((Object)"enter getDateFormat");
        if (null == sFormat) {
            sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return sFormat;
    }

    private static String convertString(String description, IConvertStringService convertStringService) {
        if (null == convertStringService) {
            return description;
        }
        try {
            return convertStringService.format(description);
        }
        catch (Exception ex) {
            logger.error((Object)("convert ex: " + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160784212002L);
            return description;
        }
    }

    public static IConvertStringService getConvertStringService() {
        IConvertStringService convertStringService;
        try {
            ServiceContext context = ServiceContext.getInstance();
            convertStringService = (IConvertStringService)context.lookup("fault/convertStringService");
        }
        catch (Exception e) {
            logger.error((Object)("get convertStringService failue" + ExceptionUtil.getErrorMessage((Throwable)e)));
            convertStringService = null;
        }
        return convertStringService;
    }

    public static String decode(String encodedChar) {
        if (null == encodedChar) {
            return "";
        }
        return encodedChar.replaceAll("&quot;", "\"").replaceAll("&#39;", "'").replaceAll("&#96;", "`").replaceAll("&#37;", "%").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&#40;", "\\(").replaceAll("&#41;", "\\)");
    }

    public static List<AlarmDetailVO> convertAlarmDetailVO(List<AlarmDetail> detailList) {
        logger.trace((Object)"enter convertAlarmDetailVO");
        ArrayList<AlarmDetailVO> resultList = new ArrayList<AlarmDetailVO>();
        if (null != detailList) {
            for (AlarmDetail detail : detailList) {
                if (null == detail) continue;
                AlarmDetailVO alarmDetail = new AlarmDetailVO();
                alarmDetail.setId(detail.getId());
                alarmDetail.setEntity(detail.getEntity());
                alarmDetail.setTtime(detail.getTtime());
                alarmDetail.setClearStatus(detail.getClearStatus());
                alarmDetail.setClearTime(detail.getClearTime());
                alarmDetail.setClearUser(detail.getClearUser());
                alarmDetail.setConfirmStatus(detail.getConfirmStatus());
                alarmDetail.setConfirmTime(detail.getConfirmTime());
                alarmDetail.setConfirmUser(detail.getConfirmUser());
                alarmDetail.setGmt(detail.getGmt());
                resultList.add(alarmDetail);
            }
        }
        return resultList;
    }
}

