/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.audio.service;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.audio.model.AlertAudioSettingInput;
import com.huawei.ism.drm.rest.service.framework.audio.service.IAudioRestService;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.nem.fault.sdk.model.AlertAudioSetting;
import com.huawei.lego.nem.fault.sdk.service.IAlertNotifyService;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;

public class AudioRestServiceImpl
extends AbstractRestService
implements IAudioRestService {
    @Override
    public String getAudioSetting() {
        User currentUser = this.getCurrentUser();
        this.checkUserOperationAuthority("alarm_queryVoiceRule_operateName", 2, "lego.event.voice.scan");
        IAlertNotifyService audioService = (IAlertNotifyService)this.getBundleService("fault", "alertNotifyService");
        JSONObject resultObject = new JSONObject();
        if (null != audioService) {
            AlertAudioSetting setting = audioService.getAudioSetting(currentUser.getUserId().longValue());
            AlertAudioSettingInput.constructJSONObjectResult(resultObject, setting);
        }
        return resultObject.toString();
    }

    @Override
    public Response setAudioSetting(AlertAudioSettingInput setting) {
        this.checkUserOperationAuthority("alarm_modifyVoiceRule_operateName", 3, "lego.event.voice.modify");
        AlertAudioSetting alertAudioSetting = setting.getAlertAudioSetting();
        this.checkParam(alertAudioSetting);
        alertAudioSetting.setUserId(this.getCurrentUserId().longValue());
        try {
            IAlertNotifyService service = (IAlertNotifyService)this.getBundleService("fault", "alertNotifyService");
            AlertAudioSetting oldAutoSetting = service.getAudioSetting(this.getCurrentUserId().longValue());
            if (oldAutoSetting != null) {
                alertAudioSetting.setId(oldAutoSetting.getId());
            }
            service.setAudioSetting(alertAudioSetting);
            this.writeSucOperationLog("alarm_modifyVoiceRule_operateName", 3, "voiceNotificationSetting_objectName", null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("alarm_modifyVoiceRule_operateName", 3, "", e);
        }
        return Response.ok().build();
    }

    private void checkParam(AlertAudioSetting setting) {
        CommUtils.checkParamEmpty(setting);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(setting.getAudioCritical());
        params.add(setting.getAudioMajor());
        params.add(setting.getAudioWarn());
        params.add(setting.getAudioInfo());
        this.checkObjectIsNull(params);
        boolean isEnabledCritical = setting.isEnabledCritical();
        boolean isEnabledInfo = setting.isEnabledInfo();
        boolean isEnabledMajor = setting.isEnabledMajor();
        boolean isEnabledWarn = setting.isEnabledWarn();
        if (isEnabledCritical) {
            this.checkAudioType(setting.getAudioCritical());
        } else {
            setting.setAudioCritical(-1);
        }
        if (isEnabledMajor) {
            this.checkAudioType(setting.getAudioMajor());
        } else {
            setting.setAudioMajor(-1);
        }
        this.checkParam(setting, isEnabledInfo, isEnabledWarn);
    }

    private void checkParam(AlertAudioSetting setting, boolean isEnabledInfo, boolean isEnabledWarn) {
        if (isEnabledWarn) {
            this.checkAudioType(setting.getAudioWarn());
        } else {
            setting.setAudioWarn(-1);
        }
        if (isEnabledInfo) {
            this.checkAudioType(setting.getAudioInfo());
        } else {
            setting.setAudioInfo(-1);
        }
    }

    private void checkAudioType(int audioType) {
        if (audioType != 1 && audioType != 2) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkObjectIsNull(List<Object> objs) {
        for (int i = 0; i < objs.size(); ++i) {
            if (null != objs.get(i)) continue;
            throw new LegoCheckedException(250L);
        }
    }

    @Override
    public Response modifyAudioStatus() {
        Boolean isEnabled = true;
        try {
            IAlertNotifyService service = (IAlertNotifyService)this.getBundleService("fault", "alertNotifyService");
            User currentUser = this.getCurrentUser();
            if (null == service) {
                throw new LegoCheckedException(102410L);
            }
            long userId = currentUser.getUserId();
            isEnabled = service.getAudioSetting(userId).isEnabled();
            isEnabled = isEnabled != false ? Boolean.valueOf(false) : Boolean.valueOf(true);
            service.modifyAudioStatus(userId, isEnabled.booleanValue());
            Object[] params = this.getOperationParam(isEnabled);
            this.writeSucOperationLog(params[0].toString(), Integer.parseInt(params[1].toString()), "voiceNotification_objectName", null, null);
        }
        catch (Exception e) {
            Object[] params = this.getOperationParam(isEnabled);
            this.writeFailedOperationLog(params[0].toString(), NumberUtil.convertToInteger((Object)params[1].toString(), (int)0), "", e);
        }
        return Response.ok().build();
    }

    private Object[] getOperationParam(Boolean isEnabled) {
        Object[] params = new Object[3];
        if (isEnabled.booleanValue()) {
            params[0] = "alarm_openVoiceNotification_operateName";
            params[1] = 1;
            params[2] = "";
        } else {
            params[0] = "alarm_closeVoiceNotification_operateName";
            params[1] = 1;
            params[2] = "";
        }
        return params;
    }
}

