/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.license.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.license.sdk.LicenseCalcBean;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.license.model.FunctionItemVo;
import com.huawei.ism.drm.rest.service.framework.license.model.LicenseInfoVo;
import com.huawei.ism.drm.rest.service.framework.license.service.ILicenseBusiService;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.ResourceUtil;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.CodeLog;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.activation.DataHandler;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;

public class LicenseBusiServiceImpl
extends AbstractRestService
implements ILicenseBusiService {
    private static final int LIC_SIZE_THREADHOUD = 204800;
    private final transient CodeLog logger = LogFactory.getInstance((Object)this, (long)653110170615808L);

    @Override
    public LicenseInfoVo queryBasicInfo() {
        this.checkUserOperationAuthority("license_query_operateName", 1, "ism.drm.license.mgt.scan.operateID");
        ILicenseInter mgr = (ILicenseInter)this.getBundleService("DRM_Base", ILicenseInter.class.getSimpleName());
        LicenseInfoBo bo = mgr.getLicense();
        if (null == bo) {
            if (mgr.isLicenseProbationTimeout()) {
                return this.createBasicLicense();
            }
            return new LicenseInfoVo();
        }
        Locale locale = this.getLocale();
        LicenseInfoVo licenseVo = new LicenseInfoVo(bo, locale);
        return licenseVo;
    }

    private LicenseInfoVo createBasicLicense() {
        LicenseInfoVo licenseVo = new LicenseInfoVo();
        licenseVo.setFormatVersion("--");
        licenseVo.setLicenseSn("--");
        licenseVo.setActiveTime("--");
        Locale locale = this.getLocale();
        FunctionItemVo fvo = new FunctionItemVo();
        fvo.setFuncName(ResourceUtil.getInstance().getText("LSTQDPMH", locale));
        licenseVo.getFunList().add(fvo);
        return licenseVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response exportLicense() {
        this.checkUserOperationAuthority("license_export_operateName", 1, "ism.drm.license.mgt.set.operateID");
        BufferedOutputStream bos = null;
        try {
            ILicenseInter mgr = (ILicenseInter)this.getBundleService("DRM_Base", ILicenseInter.class.getSimpleName());
            LicenseInfoBo licenseBo = mgr.getLicenseNotUpdateUseNum();
            if (null == licenseBo) {
                if (mgr.isLicenseProbationTimeout()) {
                    throw new LegoCheckedException(1073947437L);
                }
                throw new LegoCheckedException(1073947419L);
            }
            if (!this.isExportChecked().booleanValue()) {
                Response response = Response.ok().build();
                return response;
            }
            String displayName = "license.xml";
            HttpServletResponse response = this.getResponse();
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-store, must-revalidate");
            response.addHeader("Content-Disposition", "attachment;filename=" + displayName);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = licenseBo.getFile();
            bos.write(buff, 0, buff.length);
            bos.flush();
            this.writeSucOperationLog("license_export_operateName", 1, "licenseInfo_object_name", "", new String[0]);
            CommUtils.closeOutputStream(bos);
        }
        catch (IOException e) {
            this.logger.error((Object)"exportLicense IOException");
            this.writeFailedOperationLog("license_export_operateName", 1, "licenseInfo_object_name", e);
        }
        catch (Exception e) {
            this.logger.error((Object)("exportLicense Exception" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.writeFailedOperationLog("license_export_operateName", 1, "licenseInfo_object_name", e);
        }
        finally {
            CommUtils.closeOutputStream(bos);
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Response importLicense(Attachment file) {
        this.checkUserOperationAuthority("license_import_operateName", 2, "ism.drm.license.mgt.set.operateID");
        InputStream is = null;
        try {
            if (VerifyUtil.isEmpty((Object)file)) {
                throw new LegoCheckedException(1073947393L);
            }
            DataHandler dh = file.getDataHandler();
            int length = this.getRequest().getContentLength();
            if (length >= 204800) {
                throw new LegoCheckedException(1073947421L);
            }
            byte[] bytes = new byte[204800];
            is = dh.getInputStream();
            if (is == null) {
                throw new LegoCheckedException(1073947420L);
            }
            int read = is.read(bytes);
            if (-1 == read) {
                throw new LegoCheckedException(1073947420L);
            }
            byte[] licenseBytes = new byte[read];
            System.arraycopy(bytes, 0, licenseBytes, 0, read);
            ILicenseInter mgr = (ILicenseInter)this.getBundleService("DRM_Base", ILicenseInter.class.getSimpleName());
            mgr.activateLic(licenseBytes);
            this.writeSucOperationLog("license_import_operateName", 2, "licenseInfo_object_name", "", new String[0]);
            CommUtils.closeInputStream(is);
        }
        catch (IOException e) {
            this.logger.error((Object)"importLicense IOException failed.");
            this.writeFailedOperationLog("license_import_operateName", 2, "licenseInfo_object_name", e);
        }
        catch (Exception e2) {
            this.logger.error((Object)("importLicense failed." + ExceptionUtil.getErrorMessage((Throwable)e2)));
            this.writeFailedOperationLog("license_import_operateName", 2, "licenseInfo_object_name", e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            CommUtils.closeInputStream(is);
        }
        finally {
            CommUtils.closeInputStream(is);
        }
        return Response.ok().build();
    }

    @Override
    public LicenseCalcBean calculateLicenseConsume(String calculatedSiteIds, String resTypes) {
        this.checkUserOperationAuthority("license_query_operateName", 3, "ism.drm.license.mgt.scan.operateID");
        ILicenseInter mgr = (ILicenseInter)this.getBundleService("DRM_Base", ILicenseInter.class.getSimpleName());
        try {
            if (VerifyUtil.isEmpty((String)calculatedSiteIds) || !ParamChecker.checkLongText((String)calculatedSiteIds)) {
                throw new LegoCheckedException(1073947393L, "calculatedSiteIds is incorrect.");
            }
            if (VerifyUtil.isEmpty((String)resTypes) || !ParamChecker.checkLongText((String)resTypes)) {
                throw new LegoCheckedException(1073947393L, "resTypes is incorrect.");
            }
            List<String> siteList = this.parseJsonArray(calculatedSiteIds);
            List<String> resTypeList = this.parseJsonArray(resTypes);
            if (siteList.size() > 32) {
                throw new LegoCheckedException(1073947393L, "Too many site in request.");
            }
            if (!siteList.stream().allMatch(ParamChecker::checkGeneralId)) {
                throw new LegoCheckedException(1073947393L, "uuid in calculatedSiteIds is incorrect.");
            }
            if (resTypeList.size() > 128) {
                throw new LegoCheckedException(1073947393L, "Too many resType in request.");
            }
            return mgr.calcLicenseConsume(siteList, resTypeList);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"getRemoteLicenseConsume LegoCheckedException failed.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.logger.error((Object)("calculateLicenseConsume failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            return new LicenseCalcBean();
        }
    }

    private List<String> parseJsonArray(String jsonArray) {
        JSONArray obj = JSONArray.fromObject((Object)jsonArray);
        ArrayList<String> jsonList = new ArrayList<String>();
        for (int i = 0; i < obj.size(); ++i) {
            jsonList.add(obj.getString(i));
        }
        return jsonList;
    }
}

