/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.role.service;

import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.resource.model.TreeNodeVo;
import com.huawei.ism.drm.rest.service.framework.role.service.IRoleRestService;
import com.huawei.ism.drm.rest.service.framework.user.util.TreeNodeUtil;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.comm.SortUnit;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.tree.RootDataElement;
import com.huawei.lego.nem.topo.sdk.model.UIElement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;

public class RoleRestServiceImpl
extends AbstractRestService
implements IRoleRestService {
    private static final List<Integer> FOBIDDENPRIVILEGELIST = Arrays.asList(9352, 141, 143, 142, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 149, 147, 149, 202, 203, 204, 160, 161, 162, 163, 9373, 9378, 9374, 9385, 9386, 9387, 9318, 9319, 9320);
    private transient Log log = LogFactory.getInstance((Object)this);

    @Override
    public Response createRole(Role role) {
        this.checkUserOperationAuthority("user_createManagerGroup_operateName", 1, "lego.sys.role.add");
        if (VerifyUtil.isEmpty((Object)role)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!Validator.regExpCheck(role.getRoleName(), "^[a-zA-Z_\u4e00-\u9fa5]{1}[\u4e00-\u9fa5\\w-]*$")) {
            throw new LegoUncheckedException(250L);
        }
        int length = 100;
        int length2 = 64;
        if (!Validator.checkStringLength(role.getRoleDes(), 100) || !Validator.checkStringLength(role.getRoleName(), 64)) {
            throw new LegoCheckedException(250L);
        }
        Set privileIds = role.getOptIdsSet();
        CommUtils.isNullCollection(privileIds);
        if (privileIds.size() > 1024) {
            this.log.error((Object)"items of optIdsSet is too many.");
            throw new LegoCheckedException(1073947393L);
        }
        privileIds.remove(0L);
        for (Integer authId : FOBIDDENPRIVILEGELIST) {
            Long id = (long)authId;
            if (!privileIds.contains(id)) continue;
            throw new LegoCheckedException(250L);
        }
        try {
            this.doCreateRole(role, privileIds);
            this.writeSucOperationLog("user_createManagerGroup_operateName", 1, role.getRoleName(), null, null);
        }
        catch (Exception e) {
            this.log.error((Object)("create role error!" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.writeFailedOperationLog("user_createManagerGroup_operateName", 1, role.getRoleName(), e);
        }
        return Response.ok().build();
    }

    private void doCreateRole(Role role, Set<Long> privileIds) {
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        role.setCreateTime(dateFormat.format(date));
        this.log.info((Object)("add admin group:" + role.getRoleName()), 653110169894912L);
        ArrayList<Long> privilegesList = new ArrayList<Long>();
        privilegesList.addAll(privileIds);
        mgr.addRoleInfo(role, privilegesList);
    }

    @Override
    public Response modifyRole(Long roleId, Role role) {
        this.log.trace((Object)"enter modifyRole");
        this.checkUserOperationAuthority("user_modifyManagerGroup_operateName", 3, "lego.sys.role.edit");
        role.setRoleId(roleId);
        int length = 100;
        if (!Validator.checkStringLength(role.getRoleDes(), 100)) {
            throw new LegoCheckedException(250L);
        }
        Set privileIds = role.getOptIdsSet();
        CommUtils.isNullCollection(privileIds);
        if (privileIds.size() > 1024) {
            this.log.error((Object)"items of optIdsSet is too many.");
            throw new LegoCheckedException(1073947393L);
        }
        privileIds.remove(0L);
        for (Integer authId : FOBIDDENPRIVILEGELIST) {
            Long id = (long)authId;
            if (!privileIds.contains(id)) continue;
            throw new LegoCheckedException(250L);
        }
        try {
            this.doModifyRole(role, privileIds);
            this.writeSucOperationLog("user_modifyManagerGroup_operateName", 3, role.getRoleName(), null, null);
        }
        catch (Exception e) {
            if (role.getRoleName() != null) {
                this.writeFailedOperationLog("user_modifyManagerGroup_operateName", 3, role.getRoleName(), e);
            }
            this.writeFailedOperationLog("user_modifyManagerGroup_operateName", 3, String.valueOf(roleId), e);
        }
        return Response.ok().build();
    }

    private void doModifyRole(Role role, Set<Long> privileIds) {
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        role.setCreateTime(dateFormat.format(date));
        Role oldrole = mgr.getRoleInf(role.getRoleId().longValue());
        if (null != oldrole) {
            if ("true".equals(oldrole.getDefaultStr())) {
                this.log.error((Object)"can not edit the default role.", 653110169894912L);
                throw new LegoCheckedException(250L);
            }
            role.setRoleName(oldrole.getRoleName());
        }
        this.log.info((Object)("modify admin group:" + role.getRoleName()), 653110169894912L);
        ArrayList<Long> privilegesList = new ArrayList<Long>();
        privilegesList.addAll(privileIds);
        mgr.updataRole(role, privilegesList);
        Role ruRole = mgr.getRoleInfRelUser(role.getRoleId().longValue(), true);
        Set usrSet = ruRole.getUserSet();
        List userlist = mgr.getAllOnlineUser(null);
        for (User tempUsr : usrSet) {
            this.forceLogout(mgr, userlist, tempUsr);
        }
    }

    private void forceLogout(IUserMgr mgr, List<User> userlist, User tempUsr) {
        for (User u : userlist) {
            if (!tempUsr.getUserName().equals(u.getUserName())) continue;
            this.log.info((Object)("Force user logout. User: " + tempUsr.getUserName()), 653110169894912L);
            try {
                mgr.forceLogout(u.getSession());
                this.writeSucOperationLog("user_forceOffline_operateName", 2, tempUsr.getUserName(), null, null);
            }
            catch (Exception e) {
                this.writeFailedOperationLogNoException("user_forceOffline_operateName", 2, tempUsr.getUserName(), e);
            }
            break;
        }
    }

    @Override
    public BatchOperationResult deleteRoles(Set<Long> roleIds) {
        this.checkUserOperationAuthority("user_deleteManagerGroup_operateName", 2, "lego.sys.role.delete");
        CommUtils.isNullCollection(roleIds);
        if (roleIds.size() > 128) {
            this.log.error((Object)"Too many roles to delete at once.");
            throw new LegoCheckedException(1073947393L);
        }
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        for (long roleId : roleIds) {
            BatchOperation tempBatch = new BatchOperation();
            Role oldrole = mgr.getRoleInf(roleId);
            tempBatch.setTargetId(roleId);
            bathOprLst.add(tempBatch);
            if (oldrole == null) continue;
            tempBatch.setTargetName(oldrole.getRoleName());
            if (!"true".equals(oldrole.getDefaultStr())) continue;
            this.log.error((Object)"can not delete the default role.", 653110169894912L);
            throw new LegoCheckedException(250L);
        }
        StringBuffer sbf = new StringBuffer();
        for (long strTemp : roleIds) {
            sbf.append(strTemp).append(',');
        }
        this.log.warn((Object)("delete roles:" + sbf.toString()), 653110169894912L);
        BatchOperationResult batchOperationResult = null;
        try {
            batchOperationResult = mgr.batchDelRoles(bathOprLst);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("user_deleteManagerGroup_operateName", 2, "", e);
        }
        this.batchOptLog(batchOperationResult, "user_deleteManagerGroup_operateName", 2);
        return batchOperationResult;
    }

    @Override
    public Role queryRole(Long roleId) {
        this.log.trace((Object)"enter queryRole");
        this.checkUserOperationAuthority("user_queryManagerGroup_operateName", 2, "lego.sys.role.scan");
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        Role role = mgr.getRoleInf(roleId.longValue());
        if (role == null) {
            return new Role();
        }
        this.dealRoleDesc(role);
        Role roleRelUser = mgr.getRoleInfRelUser(roleId.longValue(), true);
        role.setOptsSet(null);
        role.setUserSet(roleRelUser.getUserSet());
        Set userSet = role.getUserSet();
        if (!VerifyUtil.isEmpty((Collection)userSet)) {
            for (User user : userSet) {
                user.setRolesSet(null);
                user.setMoAutSeth(null);
                user.setUserAclSet(null);
                user.setUserPassword("");
                user.setUserPasswordSalt("");
            }
        }
        return role;
    }

    private void dealRoleDesc(Role role) {
        this.log.trace((Object)"enter dealRoleDesc");
        if ("administrator".equals(role.getRoleName())) {
            role.setRoleDes(this.getText("lego.lab.defult.administrator"));
        } else if ("auditor".equals(role.getRoleName())) {
            role.setRoleDes(this.getText("lego.lab.defult.auditor"));
        } else if ("operator".equals(role.getRoleName())) {
            role.setRoleDes(this.getText("lego.lab.defult.operator"));
        } else if ("NBIRole".equals(role.getRoleName())) {
            role.setRoleDes(this.getText("lego.lab.defult.nbirole"));
        } else if (role.getRoleId() == -1L) {
            role.setRoleDes(this.getText("lego.lab.defult.OCAdmin"));
        }
    }

    @Override
    public List<TreeNodeVo> getPrivilegeTree(Long roleId) {
        this.log.trace((Object)"enter getPrivilegeTree");
        this.checkUserOperationAuthority("user_queryManagerGroup_operateName", 2, "lego.sys.role.scan");
        return this.getPrivilegeTree(roleId, true);
    }

    private List<TreeNodeVo> getPrivilegeTree(Long roleId, boolean removeHiddenEelement) {
        this.log.trace((Object)"enter getPrivilegeTree");
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        RootDataElement optRetree = null;
        Long invalidRoleId = -2L;
        if (!invalidRoleId.equals(roleId)) {
            Role role = mgr.getRoleInf(roleId.longValue());
            CommUtils.checkObjectExists(role);
            optRetree = mgr.getOptTree(role.getRoleId());
        } else {
            optRetree = mgr.getOptTree(invalidRoleId);
            if (removeHiddenEelement) {
                this.deleteHiddenEelement(optRetree);
            }
        }
        ArrayList<TreeNodeVo> treeNodes = new ArrayList<TreeNodeVo>();
        optRetree.setDisName("lego.lab.usr.operations");
        TreeNodeUtil.constructNodeList(optRetree, treeNodes);
        Collections.sort(treeNodes, new CommonComparator("sortId", true));
        return treeNodes;
    }

    private void deleteHiddenEelement(RootDataElement rootdata) {
        this.log.trace((Object)"enter deleteHiddenEelement");
        if (null != rootdata) {
            this.delAddResEle(rootdata);
            this.delLicenseEle(rootdata);
            this.delSysMgrEle(rootdata);
            this.delDataStorageEle(rootdata);
            this.delServersEle(rootdata);
        }
    }

    private void delServersEle(RootDataElement rootdata) {
        this.log.trace((Object)"enter delServersEle");
        UIElement opeEle = rootdata.getUIElementById(9316L);
        if (null != opeEle) {
            UIElement addResEle = rootdata.getUIElementById(9318L);
            if (null != addResEle) {
                opeEle.removeChildEleUI(addResEle);
            }
            if (null != (addResEle = rootdata.getUIElementById(9319L))) {
                opeEle.removeChildEleUI(addResEle);
            }
            if (null != (addResEle = rootdata.getUIElementById(9320L))) {
                opeEle.removeChildEleUI(addResEle);
            }
        }
    }

    private void delDataStorageEle(RootDataElement rootdata) {
        UIElement debugEle;
        this.log.trace((Object)"enter delDataStorageEle");
        UIElement opeEle = rootdata.getUIElementById(159L);
        if (null != opeEle) {
            UIElement logDataEle = rootdata.getUIElementById(160L);
            opeEle.removeChildEleUI(logDataEle);
        }
        if (null != (debugEle = rootdata.getUIElementById(168L))) {
            UIElement debugLogDataEle = rootdata.getUIElementById(9373L);
            debugEle.removeChildEleUI(debugLogDataEle);
        }
    }

    private void delSysMgrEle(RootDataElement rootdata) {
        UIElement newOperatorEle;
        this.log.trace((Object)"enter delSysMgrEle");
        UIElement opeEle = rootdata.getUIElementById(130L);
        if (null != opeEle && null != (newOperatorEle = rootdata.getUIElementById(131L))) {
            opeEle.removeChildEleUI(newOperatorEle);
        }
    }

    private void delLicenseEle(RootDataElement rootdata) {
        UIElement addResEle;
        this.log.trace((Object)"enter delLicenseEle");
        UIElement opeEle = rootdata.getUIElementById(130L);
        if (null != opeEle && null != (addResEle = rootdata.getUIElementById(9385L))) {
            opeEle.removeChildEleUI(addResEle);
        }
    }

    private void delAddResEle(RootDataElement rootdata) {
        UIElement addResEle;
        this.log.trace((Object)"enter delAddResEle");
        UIElement opeEle = rootdata.getUIElementById(9350L);
        if (null != opeEle && null != (addResEle = rootdata.getUIElementById(9352L))) {
            opeEle.removeChildEleUI(addResEle);
        }
    }

    @Override
    public String getAllRoles(String orderBy, String orderType, int start, int pageSize) {
        this.log.trace((Object)"enter getAllRoles");
        if (!Validator.checkPageQueryParams(pageSize, start)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("user_queryManagerGroup_operateName", 2, "lego.sys.role.scan");
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        if (VerifyUtil.isEmpty((String)orderBy)) {
            orderBy = "iRoleID";
        } else {
            Validator.canOrderBy(orderBy);
        }
        SortUnit su = new SortUnit();
        su.setFieldName(orderBy);
        orderType = VerifyUtil.isEmpty((String)orderType) || "asc".equals(orderType) ? "asc" : "desc";
        su.setSortType(orderType);
        Paging page = mgr.getAllRole(start * pageSize, pageSize, su);
        int total = page.getiCount();
        List listRole = page.getData();
        for (Role role : listRole) {
            this.dealRoleDesc(role);
        }
        JSONObject returnObject = new JSONObject();
        returnObject.put((Object)"total", (Object)total);
        returnObject.put((Object)"roleList", (Object)listRole);
        return returnObject.toString();
    }
}

