/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.rollbacktask.service;

import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.common.sdk.service.IRollBackTaskService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.rollbacktask.service.IRollBackTaskRestService;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import javax.ws.rs.core.Response;

public class RollBackTaskRestServiceImpl
extends AbstractRestService
implements IRollBackTaskRestService {
    private static final Log logger = LogFactory.getInstance(RollBackTaskRestServiceImpl.class);

    @Override
    public Response runTask(String taskInfo) {
        if (VerifyUtil.isEmpty((String)taskInfo)) {
            logger.error((Object)"the taskInfo is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkLongText((String)taskInfo)) {
            logger.error((Object)"the taskInfo is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("backendTask_clear_VM_drconfig_operateName", 2, "ism.drm.protectgroup.auth.delete");
        JSONObject taskInfoJson = JSONObject.fromObject((Object)taskInfo);
        String taskId = taskInfoJson.getString("taskId");
        if (VerifyUtil.isEmpty((String)taskId)) {
            logger.error((Object)"the taskId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)taskId)) {
            logger.error((Object)"the taskId is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        String targetName = "";
        try {
            IRollBackTaskService taskService = this.getBundleService(IRollBackTaskService.class);
            RollBackTaskInfo task = taskService.queryTask(taskId);
            if (VerifyUtil.isEmpty((Object)task)) {
                logger.error((Object)("task is not exist:taskId=" + taskId));
                throw new LegoCheckedException(2117645L);
            }
            targetName = task.getTargetName();
            taskService.runTask(taskId);
            this.writeSucOperationLog("backendTask_clear_VM_drconfig_operateName", 1, targetName, null, null);
        }
        catch (Exception e) {
            logger.error((Object)("run rollback task failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.writeFailedOperationLog("backendTask_clear_VM_drconfig_operateName", 1, targetName, e);
        }
        return Response.ok().build();
    }
}

