/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.securitypolicy.service;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.securitypolicy.model.SecurityPolicyVo;
import com.huawei.ism.drm.rest.service.framework.securitypolicy.service.ISecurityPolicyRestService;
import com.huawei.lego.cbb.user.sdk.model.UserLoginPolicy;
import com.huawei.lego.cbb.user.sdk.model.UserSecPolicy;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.LegoProperties;
import java.text.Normalizer;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;

public class SecurityPolicyRestServiceImpl
extends AbstractRestService
implements ISecurityPolicyRestService {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int EIGHT = 8;
    private static final int NINE = 9;
    private static final int TEN = 10;
    private static final int HUNDRED = 100;
    private static final int DEFAULT_MINLIFETIME = 3;
    private static final Integer SESSION_OUT_TIME = Integer.MAX_VALUE;
    private static final Log logger = FELogFactory.getInstance((String)"ui");

    @Override
    public SecurityPolicyVo querySecurityPolicy() {
        SecurityPolicyVo vo = new SecurityPolicyVo();
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        UserSecPolicy usrPolicy = mgr.getUserSecPolicy();
        UserLoginPolicy usrLogPolicy = mgr.getLoginPolicy();
        vo.setPassErrNum(usrLogPolicy.getLgoinCount());
        int i = -1;
        if (usrLogPolicy.getLockTime() == -1) {
            vo.setPassLockTime(3);
        } else {
            vo.setPassLockTime(usrLogPolicy.getLockTime());
        }
        vo.setSessionTime(usrLogPolicy.getSessionTimeOut());
        vo.setPassLenVal(usrPolicy.getPswLenth());
        String pwdComplex = usrPolicy.getComplex();
        int pwdComplexInt = 8;
        try {
            pwdComplexInt = Integer.parseInt(pwdComplex);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e, 90160758784000L);
        }
        vo.setPassComplexVal(pwdComplexInt);
        if (usrPolicy.getUnseal() == 1) {
            vo.setPassCtrl(true);
        } else {
            vo.setPassCtrl(false);
        }
        vo.setUsefulLife(usrPolicy.getUsefulLife());
        int minlifetime = usrPolicy.getMinlifetime() == null ? 3 : usrPolicy.getMinlifetime();
        vo.setMinlifetime(minlifetime);
        return vo;
    }

    @Override
    public Response modifySecurityPolicy(SecurityPolicyVo vo) {
        this.checkUserOperationAuthority("user_setSecurityPolicy_operateName", 3, "lego.sys.sysLoginPolicy.modify");
        this.checkPara(vo);
        try {
            this.doModifySecurityPolicy(vo);
            this.writeSucOperationLog("user_setSecurityPolicy_operateName", 3, "securityPolicy_objectName", null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("user_setSecurityPolicy_operateName", 3, "securityPolicy_objectName", e);
        }
        return Response.ok().build();
    }

    private void doModifySecurityPolicy(SecurityPolicyVo vo) {
        int passErrNum = vo.getPassErrNum();
        int passLockTime = vo.getPassLockTime();
        int passwordLength = vo.getPassLenVal();
        int passComplexVal = vo.getPassComplexVal();
        Boolean passCtrl = vo.getPassCtrl();
        int sessionTime = vo.getSessionTime();
        int usefulLife = vo.getUsefulLife();
        int minlifetime = vo.getMinlifetime();
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        UserLoginPolicy usrLogPolicytemp = mgr.getLoginPolicy();
        if (LegoProperties.isInstalledIntegrated()) {
            sessionTime = SESSION_OUT_TIME;
        }
        usrLogPolicytemp.setSessionTimeOut(sessionTime);
        usrLogPolicytemp.setLgoinCount(passErrNum);
        usrLogPolicytemp.setLockTime(passLockTime);
        mgr.updateLoginPolicy(usrLogPolicytemp);
        UserSecPolicy usrPolicy = mgr.getUserSecPolicy();
        usrPolicy.setPswLenth(Integer.valueOf(passwordLength));
        usrPolicy.setComplex(String.valueOf(passComplexVal));
        if (passCtrl != null && passCtrl.booleanValue()) {
            usrPolicy.setUnseal(Integer.valueOf(1));
            usrPolicy.setUsefulLife(Integer.valueOf(usefulLife));
            usrPolicy.setMinlifetime(Integer.valueOf(minlifetime));
        } else {
            usrPolicy.setUnseal(Integer.valueOf(0));
        }
        mgr.updateUserSecPolicy(usrPolicy);
    }

    private void checkPara(SecurityPolicyVo vo) {
        String sessionTimeStr;
        int sessionTime = vo.getSessionTime();
        int passErrNum = vo.getPassErrNum();
        int passLockTime = vo.getPassLockTime();
        Boolean passCtrl = vo.getPassCtrl();
        int usefulLife = vo.getUsefulLife();
        int minlifetime = vo.getMinlifetime();
        int passwordLength = vo.getPassLenVal();
        int passComplexVal = vo.getPassComplexVal();
        Pattern pattern = Pattern.compile("[0-9]*");
        if (!pattern.matcher(Normalizer.normalize(sessionTimeStr = String.valueOf(sessionTime), Normalizer.Form.NFKC)).matches()) {
            throw new LegoCheckedException(250L);
        }
        if (sessionTime < 1 || sessionTime > 100) {
            throw new LegoCheckedException(250L);
        }
        this.chekLogCtrlParam(passErrNum, passLockTime, pattern);
        if (passCtrl != null && passCtrl.booleanValue()) {
            this.checkPassCtrlParam(usefulLife, minlifetime, pattern);
        }
        if (8 != passwordLength && 10 != passwordLength) {
            throw new LegoCheckedException(250L);
        }
        if (2 != passComplexVal && 4 != passComplexVal) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkPassCtrlParam(int usefulLife, int minlifetime, Pattern pattern) {
        String usefulLifeStr = String.valueOf(usefulLife);
        if (!pattern.matcher(Normalizer.normalize(usefulLifeStr, Normalizer.Form.NFKC)).matches()) {
            throw new LegoCheckedException(250L);
        }
        int i = 60;
        int j = 360;
        if (usefulLife < 60 || usefulLife > 360) {
            throw new LegoCheckedException(250L);
        }
        String minlifeTimeStr = String.valueOf(minlifetime);
        if (!pattern.matcher(Normalizer.normalize(minlifeTimeStr, Normalizer.Form.NFKC)).matches()) {
            throw new LegoCheckedException(250L);
        }
        int k = 9999;
        if (minlifetime < 1 || minlifetime > 9999) {
            throw new LegoCheckedException(250L);
        }
    }

    private void chekLogCtrlParam(int passErrNum, int passLockTime, Pattern pattern) {
        String passErrNumStr = String.valueOf(passErrNum);
        if (!pattern.matcher(Normalizer.normalize(passErrNumStr, Normalizer.Form.NFKC)).matches()) {
            throw new LegoCheckedException(250L);
        }
        if (passErrNum < 1 || passErrNum > 9) {
            throw new LegoCheckedException(250L);
        }
        String passLockTimeStr = String.valueOf(passLockTime);
        if (!pattern.matcher(Normalizer.normalize(passLockTimeStr, Normalizer.Form.NFKC)).matches()) {
            throw new LegoCheckedException(250L);
        }
        int i = 2000;
        if (passLockTime < 3 || passLockTime > 2000) {
            throw new LegoCheckedException(250L);
        }
    }
}

