/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.system.service;

import com.huawei.ism.cbb.base.sdk.util.ValidateUtil;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.coreenum.SyslogEncryptionModeEnum;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.system.model.SystemThresholdVo;
import com.huawei.ism.drm.rest.service.framework.system.service.ISystemRestService;
import com.huawei.ism.drm.rest.service.framework.system.util.SystemFileUtil;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.ism.drm.system.cfgdata.sdk.model.FtpServerInfo;
import com.huawei.ism.drm.system.cfgdata.sdk.service.IConfigDataBackupService;
import com.huawei.ism.drm.system.info.sdk.model.SoftwareInfo;
import com.huawei.ism.drm.system.info.sdk.service.ISoftwareInfoService;
import com.huawei.ism.drm.system.thirdservice.sdk.model.LogNotifyServer;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ILogNotifierService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.lego.cbb.nms.north.sdk.service.INorthNmsService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.ILogConfigService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.huawei.lego.core.system.sysmonitor.sdk.model.HostServerMonitorInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.SysmTreshold;
import com.huawei.lego.core.system.sysmonitor.sdk.model.SysmTresholdType;
import com.huawei.lego.core.system.sysmonitor.sdk.service.ISysMonitor;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SystemRestServiceImpl
extends AbstractRestService
implements ISystemRestService {
    private static Log logger = FELogFactory.getInstance((String)"ui");
    private static final String LOCAL_HOST_IP_FIRST = "127";
    private static final String AUTO_BACKUP_FLAG_TRUE = "true";
    private static final String AUTO_BACKUP_FLAG_FALSE = "false";
    private static final int PORT_MIN_VAL = 1;
    private static final int PORT_MAX_VAL = 65535;
    private static final long DEFALTPERCENT = 90L;
    private static final String LOGGER_LEGO_NAME = "com.huawei.lego";
    private static final String LOGGER_ISM_NAME = "com.huawei.ism";
    private static final String EXPORT_CHECKED_TOKEN = "EXPORT_CHECKED_TOKEN";
    private static final String LOWER_CHAR = "[a-z]+";
    private static final String NUMBER = "[0-9]+";
    private static final String SPECIAL_CHAR = "[\\`|\\~|!|@|#|$|%|\\^|&|\\*|\\(|\\)|\\-|_|=|+|\\\\|\\||\\{|\\}|\\[|\\]|;|:|\\'|\\\"|\\,|\\.|\\<|\\>|\\/|\\s|?]+";
    private static final String UPPER_CHAR = "[A-Z]+";
    private static final int PWDMAXLEN = 15;
    private static final int PWDMINLEN = 8;
    private static final String CTS = "CTS";
    private static final String SYSLOG = "SYSLOG";
    private static final String ELK = "ELK";
    private static final List<String> LOG_TYPES = Arrays.asList("administratorlog", "tenantlog");
    private static Map<String, Level> levels = new HashMap<String, Level>(6);
    private static Object logExportLocker = new Object();

    @Override
    public SystemThresholdVo querySystemThreshold() {
        logger.trace((Object)"enter querySystemThreshold");
        this.checkUserOperationAuthority("performance_query_operateName", 2, "lego.sys.systemMonitor.scan");
        SystemThresholdVo vo = new SystemThresholdVo();
        long cpuPercent = 90L;
        long diskPercent = 90L;
        long memPercent = 90L;
        ISysMonitor mgr = (ISysMonitor)this.getBundleService("system", "sysMonitor");
        List list = mgr.getSysmTreshold();
        if (null != list && !list.isEmpty()) {
            for (SysmTreshold sysmTreshold : list) {
                if (sysmTreshold.getId().longValue() == SysmTresholdType.cpu.getValue()) {
                    cpuPercent = sysmTreshold.getPercent();
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.disk.getValue()) {
                    diskPercent = sysmTreshold.getPercent();
                    continue;
                }
                if (sysmTreshold.getId().longValue() != SysmTresholdType.mem.getValue()) continue;
                memPercent = sysmTreshold.getPercent();
            }
        }
        vo.setCpuPercent(cpuPercent);
        vo.setDiskPercent(diskPercent);
        vo.setMemPercent(memPercent);
        return vo;
    }

    @Override
    public Response modifySysmTreshold(SystemThresholdVo vo) {
        logger.trace((Object)"enter modifySysmTreshold");
        this.checkUserOperationAuthority("performance_setThreshold_operateName", 3, "lego.sys.systemMonitor.Threshold.modify");
        this.checkParm(vo);
        ISysMonitor mgr = (ISysMonitor)this.getBundleService("system", "sysMonitor");
        List list = mgr.getSysmTreshold();
        if (!VerifyUtil.isEmpty((Collection)list)) {
            for (SysmTreshold sysmTreshold : list) {
                if (sysmTreshold.getId().longValue() == SysmTresholdType.cpu.getValue()) {
                    sysmTreshold.setPercent(vo.getCpuPercent().longValue());
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.db.getValue()) {
                    sysmTreshold.setPercent(0L);
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.disk.getValue()) {
                    sysmTreshold.setPercent(vo.getDiskPercent().longValue());
                    continue;
                }
                if (sysmTreshold.getId().longValue() != SysmTresholdType.mem.getValue()) continue;
                sysmTreshold.setPercent(vo.getMemPercent().longValue());
            }
        }
        try {
            mgr.updateSysmTreshold(list);
            this.writeSucOperationLog("performance_setThreshold_operateName", 3, "performanceThreshold_objectName", null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("performance_setThreshold_operateName", 3, "performanceThreshold_objectName", e);
        }
        return Response.ok().build();
    }

    private void checkParm(SystemThresholdVo vo) {
        logger.trace((Object)"enter checkParm");
        long cpuPercent = vo.getCpuPercent();
        long diskPercent = vo.getDiskPercent();
        long memPercent = vo.getMemPercent();
        int i = 99;
        boolean j = true;
        if (cpuPercent < 1L || cpuPercent > 99L) {
            throw new LegoCheckedException(250L);
        }
        if (diskPercent < 1L || diskPercent > 99L) {
            throw new LegoCheckedException(250L);
        }
        if (memPercent < 1L || memPercent > 99L) {
            throw new LegoCheckedException(250L);
        }
    }

    @Override
    public String queryCpuStatus() {
        JSONObject resultObject;
        block3: {
            Iterator iterator;
            this.checkUserOperationAuthority("performance_query_operateName", 2, "lego.sys.systemMonitor.scan");
            resultObject = new JSONObject();
            Object object = null;
            try {
                object = this.getBundleService("system", "sysMonitor");
            }
            catch (Exception e) {
                logger.error((Object)(" queryCpuStatus getBundleService error :" + (ISysMonitor)this.getBundleService("system", "sysMonitor")), 653110170615808L);
                throw new LegoCheckedException("queryCpuStatus getBundleService error", (Throwable)e);
            }
            ISysMonitor mgr = (ISysMonitor)object;
            List list = mgr.getHistoryhostInfo();
            List treshold = mgr.getSysmTreshold();
            if (VerifyUtil.isEmpty((Collection)treshold)) {
                logger.error((Object)"treshold is empty.", 653110170615808L);
                throw new LegoCheckedException(1073947393L);
            }
            String maxCpu = String.valueOf(((SysmTreshold)treshold.get(0)).getPercent());
            resultObject.put((Object)"cpuMax", (Object)maxCpu);
            if (VerifyUtil.isEmpty((Collection)list) || !(iterator = list.iterator()).hasNext()) break block3;
            Map map = (Map)iterator.next();
            Set<Map.Entry<Long, HostServerMonitorInfo>> set = map.entrySet();
            this.getTimeAndPercent(resultObject, set);
        }
        return resultObject.toString();
    }

    private void getTimeAndPercent(JSONObject resultObject, Set<Map.Entry<Long, HostServerMonitorInfo>> set) {
        block2: {
            long time;
            logger.trace((Object)"enter getTimeAndPercent");
            Iterator<Map.Entry<Long, HostServerMonitorInfo>> iterator = set.iterator();
            if (!iterator.hasNext()) break block2;
            Map.Entry<Long, HostServerMonitorInfo> entry = iterator.next();
            Long key = entry.getKey();
            if (key == null) {
                time = 0L;
            } else {
                Date date = new Date(key);
                time = date.getTime();
            }
            resultObject.put((Object)"time", (Object)time);
            HostServerMonitorInfo temp = entry.getValue();
            String cpuPer = temp.getCpuInfo().getPercent().trim().replace("%", "");
            resultObject.put((Object)"cpuPer", (Object)cpuPer);
        }
    }

    @Override
    public String queryMemStatus() {
        this.checkUserOperationAuthority("performance_query_operateName", 2, "lego.sys.systemMonitor.scan");
        JSONObject resultObject = new JSONObject();
        ISysMonitor mgr = null;
        try {
            mgr = (ISysMonitor)this.getBundleService("system", "sysMonitor");
        }
        catch (Exception e) {
            logger.error((Object)(" queryMemStatus getBundleService error :" + (ISysMonitor)this.getBundleService("system", "sysMonitor")), 653110170615808L);
            throw new LegoCheckedException("queryMemStatus getBundleService error", (Throwable)e);
        }
        List list = mgr.getHistoryhostInfo();
        List treshold = mgr.getSysmTreshold();
        if (VerifyUtil.isEmpty((Collection)treshold) || treshold.size() < 2) {
            logger.error((Object)"treshold is empty.", 653110170615808L);
            throw new LegoCheckedException(1073947393L);
        }
        String maxMemo = String.valueOf(((SysmTreshold)treshold.get(1)).getPercent());
        resultObject.put((Object)"memoMax", (Object)maxMemo);
        if (null != list && !list.isEmpty()) {
            this.getMemo(resultObject, list);
        }
        return resultObject.toString();
    }

    private void getMemo(JSONObject resultObject, List<Map<Long, HostServerMonitorInfo>> list) {
        block2: {
            long time;
            Map<Long, HostServerMonitorInfo> map;
            Set<Map.Entry<Long, HostServerMonitorInfo>> set;
            Iterator<Map.Entry<Long, HostServerMonitorInfo>> iterator;
            logger.trace((Object)"enter getMemo");
            Iterator<Map<Long, HostServerMonitorInfo>> iterator2 = list.iterator();
            if (!iterator2.hasNext() || !(iterator = (set = (map = iterator2.next()).entrySet()).iterator()).hasNext()) break block2;
            Map.Entry<Long, HostServerMonitorInfo> entry = iterator.next();
            Long key = entry.getKey();
            if (key == null) {
                time = 0L;
            } else {
                Date date = new Date(key);
                time = date.getTime();
            }
            resultObject.put((Object)"time", (Object)time);
            HostServerMonitorInfo temp = entry.getValue();
            String memoPer = temp.getMemoryInfo().getPercent().trim().replace("%", "");
            resultObject.put((Object)"memoPer", (Object)memoPer);
        }
    }

    @Override
    public String queryDiskStatus() {
        logger.trace((Object)"enter queryDiskStatus");
        this.checkUserOperationAuthority("performance_query_operateName", 2, "lego.sys.systemMonitor.scan");
        JSONArray resultArray = new JSONArray();
        Object object = this.getBundleService("system", "sysMonitor");
        ISysMonitor mgr = (ISysMonitor)object;
        Map tempMap = mgr.getCurrentHostServerInfo();
        if (tempMap != null) {
            double ten = 10.0;
            double diskMax = 10.0;
            StringBuffer diskString = new StringBuffer();
            diskString.append("<item>");
            Collection setKey = tempMap.values();
            diskMax = this.addEachObject(resultArray, diskMax, diskString, setKey);
            double diskStepMax = diskMax / 10.0;
            Iterator iterator = resultArray.iterator();
            while (iterator.hasNext()) {
                JSONObject obj = JSONObject.fromObject(iterator.next());
                obj.put((Object)"stepMax", (Object)diskStepMax);
            }
        }
        return resultArray.toString();
    }

    private double addEachObject(JSONArray resultArray, double diskMax, StringBuffer diskString, Collection<?> setKey) {
        logger.trace((Object)"enter addEachObject");
        for (Object obj : setKey) {
            HostServerMonitorInfo tempHsInf = (HostServerMonitorInfo)obj;
            for (DiskResouceUse temp : tempHsInf.getDiskInfo()) {
                JSONObject resultObject = new JSONObject();
                String usedStr = temp.getUsed().trim().replace("G", "");
                String leftStr = temp.getAvail().trim().replace("G", "");
                if (null == usedStr || 0 == usedStr.length()) {
                    usedStr = "0";
                }
                if (null == leftStr || 0 == leftStr.length()) {
                    leftStr = "0";
                }
                diskString.append("<items label='" + temp.getDiskName().trim().replace(":", "") + "' data1='" + usedStr + "' data2='" + leftStr + "'/>");
                resultObject.put((Object)"partitionName", (Object)temp.getDiskName().trim().replace(":", ""));
                resultObject.put((Object)"used", (Object)usedStr.trim());
                resultObject.put((Object)"unused", (Object)leftStr.trim());
                double tempDiskStepMax = NumberUtil.parseDouble((Object)usedStr.trim()) + NumberUtil.parseDouble((Object)leftStr.trim());
                if (tempDiskStepMax > diskMax) {
                    diskMax = tempDiskStepMax;
                }
                resultArray.add((Object)resultObject);
            }
        }
        return diskMax;
    }

    @Override
    public String queryDBStatus() {
        logger.trace((Object)"enter queryDBStatus");
        this.checkUserOperationAuthority("performance_query_operateName", 2, "lego.sys.systemMonitor.scan");
        DecimalFormat df = new DecimalFormat("##0.0 ");
        JSONArray resultArray = new JSONArray();
        Object object = this.getBundleService("system", "sysMonitor");
        ISysMonitor mgr = (ISysMonitor)object;
        Map tempMap1 = mgr.getDataBaseInfo();
        if (tempMap1 != null) {
            double ten = 10.0;
            double dbMax = 10.0;
            StringBuffer databaseString = new StringBuffer();
            databaseString.append("<item>");
            Collection setKey1 = tempMap1.values();
            List listDataBase = new ArrayList();
            for (Object obj : setKey1) {
                listDataBase = (List)obj;
            }
            for (DataBaseInfo temp : listDataBase) {
                JSONObject resultObject = new JSONObject();
                String usedStr = temp.getUsed().trim().replace("MB", "");
                String totalStr = temp.getTotal().trim().replace("MB", "");
                String leftStr = df.format(NumberUtil.parseDouble((Object)totalStr) - NumberUtil.parseDouble((Object)usedStr));
                if (VerifyUtil.isEmpty((String)usedStr)) {
                    usedStr = "0";
                }
                if (VerifyUtil.isEmpty((String)leftStr)) {
                    leftStr = "0";
                }
                resultObject.put((Object)"dbName", (Object)temp.getDataBaseName());
                resultObject.put((Object)"used", (Object)usedStr.trim());
                resultObject.put((Object)"unused", (Object)leftStr.trim());
                double tempdbStepMax = NumberUtil.parseDouble((Object)usedStr.trim()) + NumberUtil.parseDouble((Object)leftStr.trim());
                if (tempdbStepMax > dbMax) {
                    dbMax = tempdbStepMax;
                }
                resultArray.add((Object)resultObject);
            }
            double dbStepMax = dbMax / 10.0;
            Iterator iterator = resultArray.iterator();
            while (iterator.hasNext()) {
                JSONObject obj = JSONObject.fromObject(iterator.next());
                obj.put((Object)"stepMax", (Object)dbStepMax);
            }
        }
        return resultArray.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response exportSysConfigData() {
        this.checkUserOperationAuthority("dataMaintainence_exportConfigData_operateName", 1, "ism.drm.dump.configdata.scan");
        HttpServletRequest request = this.getRequest();
        String encryptPwd = request.getHeader("dataPassword");
        String confirmPwd = request.getHeader("confirmPassword");
        String tempIsDataAnonymous = request.getHeader("isDataAnonymous");
        if (!VerifyUtil.isEmpty((String)encryptPwd)) {
            if (!encryptPwd.equals(confirmPwd)) {
                logger.error((Object)"The encryptPwd and confirmPwd do not match.");
                throw new LegoCheckedException(1073947393L, "The two passwords do not match.");
            }
            request.getSession().setAttribute("dataPassword", (Object)encryptPwd);
            request.getSession().setAttribute("isDataAnonymous", (Object)tempIsDataAnonymous);
        }
        IConfigDataBackupService confDataBackupService = this.getBundleService(IConfigDataBackupService.class);
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        try {
            File fileToDownload;
            String tmpPwd = (String)request.getSession().getAttribute("dataPassword");
            String tmpIsDataAnonymous = (String)request.getSession().getAttribute("isDataAnonymous");
            if (!this.checkPasswordComplex(tmpPwd)) {
                logger.error((Object)"the encrypt password is error, export config data failed.", 653110170615808L);
                throw new LegoCheckedException(1073947393L);
            }
            boolean isDataAnonymous = false;
            if (!VerifyUtil.isEmpty((String)tmpIsDataAnonymous)) {
                isDataAnonymous = Boolean.parseBoolean(tmpIsDataAnonymous);
            }
            if ((fileToDownload = confDataBackupService.backupConfig(tmpPwd, isDataAnonymous)) == null) {
                throw new FileNotFoundException();
            }
            SystemFileUtil.downloadFile(this.getResponse(), fileToDownload, confDataBackupService, "ConfigData.zip");
            this.writeSucOperationLog("dataMaintainence_exportConfigData_operateName", 1, "configuredData_objectName", null, null);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"exportConfigData error: file not found!", 653110170615808L);
            this.writeFailedOperationLog("dataMaintainence_exportConfigData_operateName", 1, "configuredData_objectName", e);
        }
        catch (Exception e) {
            logger.error((Object)("exportConfigData error." + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            this.writeFailedOperationLog("dataMaintainence_exportConfigData_operateName", 1, "configuredData_objectName", e);
        }
        finally {
            request.getSession().removeAttribute("dataPassword");
        }
        return Response.ok().build();
    }

    private boolean checkPasswordComplex(String password) {
        boolean case3;
        logger.trace((Object)"enter checkPasswordComplex");
        boolean isMatch = true;
        if (null == password || password.length() < 8 || password.length() > 15) {
            return false;
        }
        if (password.contains(" ")) {
            return false;
        }
        password = Normalizer.normalize(password, Normalizer.Form.NFKC);
        boolean case1 = !Pattern.compile(LOWER_CHAR).matcher(password).find() || !Pattern.compile(NUMBER).matcher(password).find() || !Pattern.compile(SPECIAL_CHAR).matcher(password).find();
        boolean case2 = !Pattern.compile(UPPER_CHAR).matcher(password).find() || !Pattern.compile(LOWER_CHAR).matcher(password).find() || !Pattern.compile(SPECIAL_CHAR).matcher(password).find();
        boolean bl = case3 = !Pattern.compile(UPPER_CHAR).matcher(password).find() || !Pattern.compile(NUMBER).matcher(password).find() || !Pattern.compile(SPECIAL_CHAR).matcher(password).find();
        if (case1 && case2 && case3) {
            isMatch = false;
        }
        return isMatch;
    }

    @Override
    public Response exportSoftwareArchive() {
        this.checkUserOperationAuthority("dataMaintainence_exportSoftwareArchive_operateName", 1, "ism.drm.dump.software.doc.scan");
        ISoftwareInfoService softwareService = this.getBundleService(ISoftwareInfoService.class.getName(), ISoftwareInfoService.class);
        String templateFileName = "BCManager_template.xml";
        String downloadFileName = "SoftwareArchive.xml";
        String type = this.getText("ultraapm.rd.base.about.title");
        String version = this.getText("ultraapm.rd.base.about.version.value");
        String typePrefix = type + "_";
        try {
            boolean ret;
            SoftwareInfo info = softwareService.getSoftwareInfo();
            ClassLoader clsLoader = this.getClass().getClassLoader();
            if (null == clsLoader) {
                logger.error((Object)"Can not get the clas loader.", 653110170615808L);
                return Response.ok().build();
            }
            URL url = clsLoader.getResource("");
            if (null == url) {
                logger.error((Object)"Can not get the clas loader.", 653110170615808L);
                return Response.ok().build();
            }
            String fileName = url.toURI().getPath() + templateFileName;
            DocumentBuilder db = this.getDocumentBuilder();
            Document doc = db.parse(new File(fileName));
            Element docEle = doc.getDocumentElement();
            this.setNodeAttributeInfo(type, version, typePrefix, info, docEle);
            String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + UserConstant.FILEPATH_EXPORT_DIR;
            File file = new File(downloadPath);
            if (!file.exists() && !(ret = file.mkdir())) {
                logger.error((Object)"create export file directory failed");
                return Response.ok().build();
            }
            File f = new File(downloadPath + File.separator + downloadFileName);
            this.outputXml(doc, f);
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            SystemFileUtil.downloadFile(this.getResponse(), f, null, null);
            this.writeSucOperationLog("dataMaintainence_exportSoftwareArchive_operateName", 1, "softwareInfo_objectName", null, null);
        }
        catch (Exception e) {
            logger.error((Object)"exportConfigData", 653110170615808L);
            this.writeFailedOperationLog("dataMaintainence_exportSoftwareArchive_operateName", 1, "softwareInfo_objectName", e);
        }
        return Response.ok().build();
    }

    private void setNodeAttributeInfo(String type, String version, String typePrefix, SoftwareInfo info, Element docEle) {
        HashMap<String, String> neInfoAttr = new HashMap<String, String>();
        neInfoAttr.put("Type", type);
        neInfoAttr.put("NE_ID", typePrefix + info.getSn());
        neInfoAttr.put("Name", typePrefix + info.getIpAddress());
        neInfoAttr.put("Version", version);
        this.setNodeAttribute(docEle, "NEInformation", neInfoAttr);
        HashMap<String, String> softwareVerAttr = new HashMap<String, String>();
        softwareVerAttr.put("Type", "HOSTVER");
        softwareVerAttr.put("SN", typePrefix + info.getSn());
        softwareVerAttr.put("Version", version);
        this.setNodeAttribute(docEle, "SoftwareVersion", softwareVerAttr);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> dateEndAttr = new HashMap<String, String>();
        dateEndAttr.put("datetime", format.format(new Date()));
        this.setNodeAttribute(docEle, "DataEnd", dateEndAttr);
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return CommonUtil.createDocumentBuilder((boolean)false);
    }

    private void outputXml(Document doc, File file) {
        logger.trace((Object)"enter outputXml");
        OutputStreamWriter outputWriter = null;
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource source = new DOMSource(doc);
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            outputWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.defaultCharset());
            StreamResult result = new StreamResult(outputWriter);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            try {
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                CommonUtil.close(outputWriter);
                throw throwable;
            }
        }
        CommonUtil.close((Closeable)outputWriter);
    }

    private void setNodeAttribute(Element el, String nodeName, Map<String, String> attributes) {
        logger.trace((Object)"enter setNodeAttribute");
        NodeList neInfo = el.getElementsByTagName(nodeName);
        if (neInfo != null && neInfo.getLength() > 0) {
            Node node = neInfo.item(0);
            NamedNodeMap nnm = node.getAttributes();
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                nnm.getNamedItem(entry.getKey()).setNodeValue(entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response exportDebugLog() {
        this.checkUserOperationAuthority("dataMaintainence_exportDebugLog_operateName", 1, "ism.drm.sys.exportrlog.scan");
        String file = null;
        Object object = logExportLocker;
        synchronized (object) {
            boolean fileGenerated;
            HttpSession currentSession = this.getRequest().getSession(false);
            String exportToken = (String)currentSession.getAttribute(EXPORT_CHECKED_TOKEN);
            boolean bl = fileGenerated = !VerifyUtil.isEmpty((String)exportToken);
            if (!fileGenerated) {
                try {
                    ISoftwareInfoService softwareService = this.getBundleService(ISoftwareInfoService.class.getName(), ISoftwareInfoService.class);
                    file = softwareService.exportLogs();
                    currentSession.setAttribute(EXPORT_CHECKED_TOKEN, (Object)file);
                    return Response.ok().build();
                }
                catch (Exception e) {
                    logger.error((Object)("exportLogs" + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
                    this.writeFailedOperationLog("dataMaintainence_exportDebugLog_operateName", 1, "debugLog_objectName", e);
                }
            } else {
                file = exportToken;
            }
            currentSession.removeAttribute(EXPORT_CHECKED_TOKEN);
            try {
                File fileToDownload = new File(file);
                IConfigDataBackupService confDataBackupService = this.getBundleService(IConfigDataBackupService.class);
                SystemFileUtil.downloadFile(this.getResponse(), fileToDownload, confDataBackupService, null);
                this.writeSucOperationLog("dataMaintainence_exportDebugLog_operateName", 1, "debugLog_objectName", null, null);
            }
            catch (Exception e) {
                logger.error((Object)"exportLogs", 653110170615808L);
                this.writeFailedOperationLog("dataMaintainence_exportDebugLog_operateName", 1, "debugLog_objectName", e);
            }
        }
        return Response.ok().build();
    }

    @Override
    public Response setFTPInfo(FtpServerInfo info) {
        FtpServerInfo oldFtpServerInfo;
        this.checkUserOperationAuthority("dataMaintainence_modifyBackupInfo_operateName", 3, "ism.drm.dump.configdata.setting.operateID");
        if (VerifyUtil.isEmpty((Object)info)) {
            throw new LegoCheckedException(1073947393L);
        }
        String ftpServerId = info.getFtpServerId();
        String ftpIp = info.getIp();
        String ftpPort = info.getPort() + "";
        String ftpUserName = info.getFtpUserName();
        String ftpPwd = info.getFtpPassword();
        String autoBackupFlag = info.isAutoBackupFlag() + "";
        String dataPwd = info.getDataPassword();
        String hostKey = info.getHostKey();
        ftpUserName = HtmlStringConverter.decodeByLength(ftpUserName);
        boolean isAuthChanged = false;
        boolean exportPwdChanged = false;
        FtpServerInfo ftpServerInfo = new FtpServerInfo();
        INorthNmsService nmsService = (INorthNmsService)this.getBundleService("slave", "northNmsService");
        if (!VerifyUtil.isEmpty((String)dataPwd)) {
            exportPwdChanged = true;
            if (!this.checkPasswordComplex(dataPwd)) {
                logger.error((Object)"change ftp server failed, check password error.", 653110170615808L);
                throw new LegoCheckedException(1073947393L);
            }
            ftpServerInfo.setDataPassword(nmsService.encrypt(dataPwd));
        }
        if (!VerifyUtil.isEmpty((String)ftpPwd)) {
            isAuthChanged = true;
            ftpServerInfo.setFtpPassword(nmsService.encrypt(ftpPwd));
        }
        this.checkFtpParams(isAuthChanged, info);
        IConfigDataBackupService confDataBackupService = this.getBundleService(IConfigDataBackupService.class);
        if (!Boolean.parseBoolean(autoBackupFlag) && (oldFtpServerInfo = confDataBackupService.queryFtpServerInfo(null)) != null) {
            ftpServerId = oldFtpServerInfo.getFtpServerId();
            ftpIp = oldFtpServerInfo.getIp();
            ftpUserName = oldFtpServerInfo.getFtpUserName();
            ftpPort = "" + oldFtpServerInfo.getPort();
        }
        ftpServerInfo.setFtpServerId(ftpServerId);
        ftpServerInfo.setIp(ftpIp);
        ftpServerInfo.setFtpUserName(ftpUserName);
        ftpServerInfo.setPort(NumberUtil.convertToInteger((Object)ftpPort).intValue());
        if (!VerifyUtil.isEmpty((String)hostKey)) {
            ftpServerInfo.setHostKey(nmsService.encrypt(hostKey));
        }
        this.setAutoBackup(autoBackupFlag, ftpServerInfo);
        try {
            confDataBackupService.save(ftpServerInfo, isAuthChanged, exportPwdChanged);
            this.writeSucOperationLog("dataMaintainence_modifyBackupInfo_operateName", 3, "systemDataBackupParams_objectName", null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("dataMaintainence_modifyBackupInfo_operateName", 3, "systemDataBackupParams_objectName", e);
        }
        return Response.ok().build();
    }

    private void setAutoBackup(String autoBackupFlag, FtpServerInfo ftpServerInfo) {
        logger.trace((Object)"enter setAutoBackup");
        try {
            ftpServerInfo.setAutoBackupFlag(Boolean.parseBoolean(autoBackupFlag));
            if (Boolean.parseBoolean(autoBackupFlag)) {
                this.writeSucOperationLog("dataMaintainence_enableAutoBackup_operateName", 3, "systemDataBackupSetting_objectName", null, null);
            } else {
                this.writeSucOperationLog("dataMaintainence_disableAutoBackup_operateName", 2, "systemDataBackupSetting_objectName", null, null);
            }
        }
        catch (Exception e) {
            if (Boolean.parseBoolean(autoBackupFlag)) {
                this.writeFailedOperationLog("dataMaintainence_enableAutoBackup_operateName", 3, "systemDataBackupSetting_objectName", e);
            }
            this.writeFailedOperationLog("dataMaintainence_disableAutoBackup_operateName", 2, "systemDataBackupSetting_objectName", e);
        }
    }

    private void checkFtpParams(boolean isAuthChanged, FtpServerInfo info) {
        String ftpServerId = info.getFtpServerId();
        String ftpIp = info.getIp();
        String ftpPort = info.getPort() + "";
        String ftpUserName = info.getFtpUserName();
        String ftpPwd = info.getFtpPassword();
        String autoBackupFlag = info.isAutoBackupFlag() + "";
        ftpUserName = HtmlStringConverter.decodeByLength(ftpUserName);
        boolean paraValidFlag = this.isAutoBackFlagValid(autoBackupFlag);
        if (paraValidFlag && !Boolean.parseBoolean(autoBackupFlag)) {
            return;
        }
        if (!ParamChecker.checkGeneralId((String)ftpServerId)) {
            paraValidFlag = false;
        }
        String ipType = AddressUtil.ipType((String)ftpIp);
        boolean ipIsValid = false;
        if ("IPV4".equals(ipType)) {
            if (this.isIpValid(ftpIp)) {
                ipIsValid = true;
            }
        } else if ("IPV6".equals(ipType)) {
            if (Ipv6AddressUtil.isValidIPv6((String)ftpIp)) {
                ipIsValid = true;
            }
        } else {
            ipIsValid = false;
        }
        boolean bl = paraValidFlag = paraValidFlag && ipIsValid && this.isPortValid(ftpPort);
        if (this.checkParamsEmpty(ftpServerId, ftpUserName, ftpPwd)) {
            paraValidFlag = false;
        }
        if (isAuthChanged && !this.between(ftpPwd.length(), 1, 255)) {
            paraValidFlag = false;
        }
        if (!this.between(ftpUserName.length(), 1, 255)) {
            paraValidFlag = false;
        }
        if (!ParamChecker.checkLongText((String)info.getHostKey())) {
            paraValidFlag = false;
        }
        if (!paraValidFlag) {
            logger.error((Object)"At least one of ftp server parameters is invalid.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean checkParamsEmpty(String ftpServerId, String ftpUserName, String ftpPwd) {
        return VerifyUtil.isEmpty((String)ftpUserName) || VerifyUtil.isEmpty((String)ftpServerId) && VerifyUtil.isEmpty((String)ftpPwd);
    }

    private boolean isAutoBackFlagValid(String autoBackupFlag) {
        if (VerifyUtil.isEmpty((String)autoBackupFlag)) {
            logger.error((Object)"The parameter (autoBackupFlag) is empty.", 90160758787071L);
            return false;
        }
        if (!AUTO_BACKUP_FLAG_FALSE.equalsIgnoreCase(autoBackupFlag) && !AUTO_BACKUP_FLAG_TRUE.equalsIgnoreCase(autoBackupFlag)) {
            logger.error((Object)"The parameter (autoBackupFlag) is not valid.", 90160758787071L);
            return false;
        }
        return true;
    }

    private boolean isIpValid(String ftpIp) {
        if (VerifyUtil.isEmpty((String)ftpIp) || ftpIp.startsWith(LOCAL_HOST_IP_FIRST)) {
            logger.error((Object)"The parameter (ftpPort) is empty or localhost.", 90160758787071L);
            return false;
        }
        String reg = "(([1-9])|([1-9]\\d)|([1]\\d{2})|(22[0-3])|(2[0-1]\\d))(\\.((\\d)|([1-9]\\d)|([1]\\d{2})|([2][0-4]\\d)|([2][5][0-5]))){2}(\\.(([1-9])|([1-9]\\d)|([1]\\d{2})|([2][0-4]\\d)|([2][5][0-5])))";
        Matcher matcher = Pattern.compile(reg).matcher(Normalizer.normalize(ftpIp, Normalizer.Form.NFKC));
        if (!matcher.matches()) {
            logger.error((Object)"The parameter (ftpPort) is invalid.", 90160758787071L);
            return false;
        }
        return true;
    }

    private boolean between(int length, int min, int max) {
        return min <= length && length <= max;
    }

    private boolean isPortValid(String ftpPort) {
        int port;
        if (VerifyUtil.isEmpty((String)ftpPort)) {
            logger.error((Object)"The parameter (ftpPort) is empty.", 90160758787071L);
            return false;
        }
        try {
            port = Integer.parseInt(ftpPort);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"The parameter (ftpPort) is invalid.", (Throwable)e, 90160758787071L);
            return false;
        }
        return port >= 1 && port <= 65535;
    }

    @Override
    public FtpServerInfo getFTPInfo() {
        logger.trace((Object)"enter getFTPInfo");
        this.checkUserOperationAuthority("dataMaintainence_queryBackupInfo_operateName", 2, "ism.drm.dump.configdata.setting.operateID");
        IConfigDataBackupService confDataBackupService = this.getBundleService(IConfigDataBackupService.class);
        FtpServerInfo serverInfo = confDataBackupService.queryFtpServerInfo(null);
        if (serverInfo != null) {
            serverInfo.setFtpPassword("");
            serverInfo.setDataPassword("");
            serverInfo.setBaseDir("");
        }
        return serverInfo;
    }

    public Response changeLogLevel(Map<String, String> entity) {
        if (entity == null || entity.isEmpty()) {
            logger.warn((Object)"Wrong param, level:");
            throw new LegoCheckedException(1073947393L);
        }
        String level = entity.get("level");
        if (level == null || level.trim().length() == 0 || levels.get(level.toUpperCase(Locale.US)) == null) {
            logger.warn((Object)("Wrong param, level:" + level));
            throw new LegoCheckedException(1073947393L);
        }
        level = level.toUpperCase(Locale.US);
        this.checkUserOperationAuthority("dataMaintainence_modifyDebugLog_operateName", 1, "ism.drm.sys.exportrlog.setting.operateID");
        String preLevel = LogManager.getLogger((String)LOGGER_LEGO_NAME).getLevel().toString().toUpperCase(Locale.US);
        try {
            Configurator.setAllLevels((String)LOGGER_LEGO_NAME, (Level)levels.get(level));
            Configurator.setAllLevels((String)LOGGER_ISM_NAME, (Level)levels.get(level));
        }
        catch (Exception e) {
            this.writeFailedOperationLog("dataMaintainence_modifyDebugLog_operateName", 1, "debugLog_objectName", (Exception)((Object)new LegoCheckedException(1073947434L, (Throwable)e)));
        }
        boolean success = this.configBackgroundLog(level);
        if (!success) {
            Configurator.setAllLevels((String)LOGGER_LEGO_NAME, (Level)levels.get(preLevel));
            Configurator.setAllLevels((String)LOGGER_ISM_NAME, (Level)levels.get(preLevel));
            this.writeFailedOperationLog("dataMaintainence_modifyDebugLog_operateName", 1, "debugLog_objectName", (Exception)((Object)new LegoCheckedException(1073947434L)));
        }
        this.writeSucOperationLog("dataMaintainence_modifyDebugLog_operateName", 1, "debugLog_objectName", "dataMaintainence_modifyDebugLog_operateDetail", new String[]{preLevel, level});
        return Response.ok().build();
    }

    @Override
    public String queryLogLevel() {
        logger.trace((Object)"enter queryLogLevel");
        this.checkUserOperationAuthority("dataMaintainence_queryDebugLog_operateName", 2, "ism.drm.sys.exportrlog.setting.operateID");
        Level level = LogManager.getLogger((String)LOGGER_LEGO_NAME).getLevel();
        JSONObject resultObject = new JSONObject();
        resultObject.put((Object)"level", (Object)level.toString().toUpperCase(Locale.US));
        return resultObject.toString();
    }

    private boolean configBackgroundLog(String paramString) {
        ILogConfigService localILogConfigService = SystemRestServiceImpl.getService();
        if (localILogConfigService == null) {
            logger.error((Object)"Get log config Service failed.");
            return false;
        }
        boolean bool = localILogConfigService.changeLevel(paramString);
        if (bool) {
            logger.warn((Object)("Succeeded in modifying background log level. The level is \"" + paramString + "\""));
            return true;
        }
        logger.error((Object)("Failed in modifying background log level. The level is \"" + paramString + "\""));
        return false;
    }

    public static ILogConfigService getService() {
        ServiceContext localServiceContext = ServiceContext.getInstance();
        ILogConfigService localLogConfigService = (ILogConfigService)localServiceContext.lookup("KernelApplication/logConfigService");
        return localLogConfigService;
    }

    @Override
    public String getFtpHostKey(String ip, Integer port) {
        this.checkUserOperationAuthority("dataMaintainence_queryBackupInfo_operateName", 2, "ism.drm.dump.configdata.setting.operateID");
        String ipType = AddressUtil.ipType((String)ip);
        if ("IPV4".equals(ipType)) {
            if (!this.isIpValid(ip)) {
                logger.error((Object)"SFTP server ip address is invalid ipv4 address! please check!", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
        } else if ("IPV6".equals(ipType)) {
            if (!Ipv6AddressUtil.isValidIPv6((String)ip)) {
                logger.error((Object)"SFTP server ip address is invalid ipv6 address! please check!", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
        } else {
            logger.error((Object)"SFTP server ip address is invalid ip address! please check!", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.isPortValid(port.toString().trim())) {
            logger.error((Object)"SFTP server port number is invalid.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        IConfigDataBackupService confDataBackupService = this.getBundleService(IConfigDataBackupService.class);
        String hostKey = confDataBackupService.getFtpHostKey(ip, port);
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((String)hostKey)) {
            logger.error((Object)("Get SFTP hostKey failed. IP:\"" + ip + "\""));
            throw new LegoCheckedException(1073947450L);
        }
        jsonObject.put((Object)"hostKey", (Object)hostKey);
        return jsonObject.toString();
    }

    private ILogNotifierService getOptLogNotifierService() {
        ILogNotifierService service = this.getBundleService(ILogNotifierService.class);
        return service;
    }

    @Override
    public List<LogNotifyServer> getServers(String tarLogType) {
        this.checkUserOperationAuthority("dataMaintainence_queryLogNotify_operateName", 1, "ism.drm.sys.log.notify.scan");
        return this.getOptLogNotifierService().getNotifyServerListBy(tarLogType);
    }

    @Override
    public Response saveServer(LogNotifyServer server) {
        this.checkUserOperationAuthority("dataMaintainence_setLogNotify_operateName", 2, "ism.drm.sys.log.notify.set");
        StringBuffer buffer = new StringBuffer();
        String protocolType = server.getProtocalType();
        if (VerifyUtil.isEmpty((String)protocolType) || !CTS.equalsIgnoreCase(protocolType) && !SYSLOG.equalsIgnoreCase(protocolType) && !ELK.equalsIgnoreCase(protocolType)) {
            logger.error((Object)"protocolType is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        if (server.getIsEnabled()) {
            String protocolProps = server.getProtocalProps();
            if (!ParamChecker.checkLongText((String)protocolProps)) {
                logger.error((Object)"protocalProps is incorrect");
                throw new LegoCheckedException(1073947393L);
            }
            JSONObject props = JSONObject.fromObject((Object)protocolProps);
            String ip = props.getString("ip");
            if (!CommUtil.checkDrmIpParam((String)ip) && !CommUtil.checkDrmDomainParam((String)ip)) {
                logger.error((Object)("ip or domain error :" + ip));
                throw new LegoCheckedException(1073947393L);
            }
            String port = props.getString("port");
            if (!ValidateUtil.checkPort((long)NumberUtil.convertToLong((Object)port))) {
                throw new LegoCheckedException(1073947393L);
            }
            String tarLogType = server.getLogType();
            if (VerifyUtil.isEmpty((String)tarLogType) || !LOG_TYPES.contains(tarLogType)) {
                throw new LegoCheckedException(1073947393L);
            }
            String encrytionMode = null;
            if (props.containsKey((Object)"encryptionMode")) {
                encrytionMode = props.getString("encryptionMode");
            }
            if (!CTS.equalsIgnoreCase(protocolType)) {
                if (!SyslogEncryptionModeEnum.checkMode((String)encrytionMode)) {
                    throw new LegoCheckedException(1073947393L);
                }
                buffer.append(ip).append(',').append(port).append(',').append(encrytionMode);
            } else {
                if (!VerifyUtil.isEmpty((String)encrytionMode)) {
                    logger.error((Object)("config CTS contains encryptionMode, encryptionMode : " + encrytionMode));
                    throw new LegoCheckedException(1073947393L);
                }
                buffer.append(ip).append(',').append(port);
            }
        } else {
            buffer.append(AUTO_BACKUP_FLAG_FALSE);
        }
        try {
            this.getOptLogNotifierService().saveOrUpdateNofityServer(server);
            this.writeSucOperationLog("dataMaintainence_setLogNotify_operateName", 3, "sysLog_objectName", "dataMaintainence_setLogNotify_operateDetail", new String[]{server.getLogType(), server.getProtocalType(), buffer.toString()});
        }
        catch (Exception e) {
            logger.error((Object)("save date error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.writeFailedOperationLog("dataMaintainence_setLogNotify_operateName", 3, "sysLog_objectName", e);
        }
        return Response.ok().build();
    }

    @Override
    public Response testAutoBackupConfig() {
        this.checkUserOperationAuthority("dataMaintainence_Test_AutoBackupInfo_operateName", 3, "ism.drm.dump.configdata.setting.operateID");
        IConfigDataBackupService confDataBackupService = this.getBundleService(IConfigDataBackupService.class);
        try {
            confDataBackupService.testAutoBackupConfig();
            this.writeSucOperationLog("dataMaintainence_Test_AutoBackupInfo_operateName", 3, "systemDataBackupParams_objectName", null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("dataMaintainence_Test_AutoBackupInfo_operateName", 3, "systemDataBackupParams_objectName", e);
        }
        return Response.ok().build();
    }

    static {
        levels.put("DEBUG", Level.DEBUG);
        levels.put("INFO", Level.INFO);
        levels.put("WARN", Level.WARN);
        levels.put("ERROR", Level.ERROR);
    }
}

