/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.system.service;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.system.model.DomainInfoVo;
import com.huawei.ism.drm.rest.service.framework.system.model.ManageOneInfoVo;
import com.huawei.ism.drm.rest.service.framework.system.model.OcAccessInfoVo;
import com.huawei.ism.drm.rest.service.framework.system.service.IThirdServiceRestService;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.ism.drm.system.thirdservice.sdk.service.IDomainInfoService;
import com.huawei.ism.drm.system.thirdservice.sdk.service.IOcAccessService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import javax.ws.rs.core.Response;

public class ThirdServiceRestServiceImpl
extends AbstractRestService
implements IThirdServiceRestService {
    private static final Log logger = LogFactory.getInstance(ThirdServiceRestServiceImpl.class);
    private static final int MAX_PORT = 65535;

    @Override
    public Response saveOcAccessInfo(OcAccessInfoVo vo) {
        this.checkParam(vo);
        CloudConfig newInfo = new CloudConfig();
        newInfo.setConfigType("oc");
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("oc_password", vo.getPassword());
        prop.put("oc_port", String.valueOf(vo.getPort()));
        prop.put("oc_username", vo.getUsername());
        prop.put("oc_domain", vo.getDomain());
        newInfo.setProps(prop);
        this.checkUserOperationAuthority("thirdservie_modifyOcParams_operateName", 3, "ism.drm.thirdservice.oc.modify");
        String[] params = new String[]{vo.getDomain(), String.valueOf(vo.getPort()), vo.getUsername()};
        try {
            String token = this.getOcAccessService().getOcToken(newInfo, "");
            if (VerifyUtil.isEmpty((String)token)) {
                logger.error((Object)"token error");
                throw new LegoCheckedException(1073947407L);
            }
            this.getOcAccessService().saveOrUpdateOcAccessInfo(newInfo);
            this.writeSucOperationLog("thirdservie_modifyOcParams_operateName", 3, "ocParam_objectName", "modifyOcParam_operateDetail", params);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("thirdservie_modifyOcParams_operateName", 3, "ocParam_objectName", (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLog("thirdservie_modifyOcParams_operateName", 3, "ocParam_objectName", e);
            throw new LegoCheckedException(101L, (Throwable)e);
        }
        return Response.ok().build();
    }

    private void checkParam(OcAccessInfoVo vo) {
        if (null == vo) {
            logger.error((Object)"OcAccessInfoVo is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)vo.getDomain()) || VerifyUtil.isEmpty((String)vo.getUsername()) || VerifyUtil.isEmpty((String)vo.getPassword())) {
            logger.error((Object)"Param domain, username, password is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!(Ipv4AddressUtil.isIPv4Address((String)vo.getDomain()) || Ipv6AddressUtil.isIPv6Address((String)vo.getDomain()) || CommUtil.checkDrmDomainParam((String)vo.getDomain()))) {
            logger.error((Object)"Domain is invalid, domain=%s", new Object[]{vo.getDomain()});
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkLongText((String)vo.getUsername().trim())) {
            logger.error((Object)"Username is invalid.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkLongText((String)vo.getPassword().trim())) {
            logger.error((Object)"Password is invalid.");
            throw new LegoCheckedException(1073947393L);
        }
        if (vo.getPort() <= 0 || vo.getPort() > 65535) {
            logger.error((Object)"Port is error.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    public OcAccessInfoVo getOcAccessInfo() {
        this.checkUserOperationAuthority("thirdservie_queryOcParams_operateName", 1, "ism.drm.thirdservice.oc.scan");
        CloudConfig ocAccessInfo = this.getCloudConfigService().getCloudConfigBy("oc");
        OcAccessInfoVo vo = new OcAccessInfoVo();
        if (null != ocAccessInfo) {
            vo.setDomain((String)ocAccessInfo.getProps().get("oc_domain"));
            vo.setPort(NumberUtil.parseInteger(ocAccessInfo.getProps().get("oc_port")));
            vo.setUsername((String)ocAccessInfo.getProps().get("oc_username"));
        }
        return vo;
    }

    @Override
    public Response saveManageOneInfo(ManageOneInfoVo vo) {
        if (null == vo) {
            logger.error((Object)"param is null");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkParam(vo);
        if (!CommUtil.checkDrmIpParam((String)vo.getDomain()) && !CommUtil.checkDrmDomainParam((String)vo.getDomain())) {
            logger.error((Object)"The parameter[%s] is not a domain name or IP address.", new Object[]{vo.getDomain()});
            throw new LegoCheckedException(1073947393L);
        }
        CloudConfig newInfo = new CloudConfig();
        newInfo.setConfigType("manageOne");
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("manageOne_port", String.valueOf(vo.getPort()));
        prop.put("manageOne_domain", vo.getDomain());
        newInfo.setProps(prop);
        this.checkUserOperationAuthority("thirdservie_modifyOcParams_operateName", 3, "ism.drm.thirdservice.oc.modify");
        String[] params = new String[]{vo.getDomain(), String.valueOf(vo.getPort())};
        try {
            this.getCloudConfigService().saveOrUpdateCloudConfig(newInfo);
            this.writeSucOperationLog("thirdservie_modifyManageOneParams_operateName", 3, "manageOneParam_objectName", "modifyManageOneParams_details", params);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("thirdservie_modifyManageOneParams_operateName", 3, "manageOneParam_objectName", (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLog("thirdservie_modifyManageOneParams_operateName", 3, "manageOneParam_objectName", e);
            throw new LegoCheckedException(101L, (Throwable)e);
        }
        return Response.ok().build();
    }

    @Override
    public ManageOneInfoVo getManageOneInfo() {
        this.checkUserOperationAuthority("thirdservie_queryManageOneParams_operateName", 1, "ism.drm.thirdservice.oc.scan");
        CloudConfig accessInfo = this.getCloudConfigService().getCloudConfigBy("manageOne");
        ManageOneInfoVo vo = new ManageOneInfoVo();
        if (null != accessInfo) {
            vo.setDomain((String)accessInfo.getProps().get("manageOne_domain"));
            vo.setPort(CommUtil.convertToInteger(accessInfo.getProps().get("manageOne_port")));
        }
        return vo;
    }

    private void checkParam(ManageOneInfoVo vo) {
        if (VerifyUtil.isEmpty((String)vo.getDomain())) {
            logger.error((Object)"param is error");
            throw new LegoCheckedException(1073947393L);
        }
        int port = vo.getPort();
        if (port <= 0 || port > 65535) {
            logger.error((Object)"param is error");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private IOcAccessService getOcAccessService() {
        IOcAccessService service = this.getBundleService(IOcAccessService.class);
        return service;
    }

    private ICloudConfigService getCloudConfigService() {
        ICloudConfigService service = this.getBundleService(ICloudConfigService.class);
        return service;
    }

    private IDomainInfoService getDomainInfoService() {
        IDomainInfoService service = this.getBundleService(IDomainInfoService.class);
        return service;
    }

    private void checkParam(DomainInfoVo vo) {
        String businessDomain = vo.getBusinessDomain();
        if (VerifyUtil.isEmpty((String)businessDomain)) {
            logger.error((Object)"param is error");
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmIpParam((String)businessDomain) && !CommUtil.checkDrmDomainParam((String)businessDomain)) {
            logger.error((Object)("domainForOS is not valid:" + businessDomain));
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    public Response saveDomainInfo(DomainInfoVo vo) {
        if (null == vo) {
            logger.error((Object)"param is null");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkParam(vo);
        this.checkUserOperationAuthority("thirdservie_modifySysNetworkParams_operateName", 3, "ism.drm.thirdservice.sysnetwork.modify");
        String[] params = new String[]{vo.getBusinessDomain()};
        CloudConfig config = new CloudConfig();
        config.setConfigType("domain");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("domain_bussiness", vo.getBusinessDomain());
        config.setProps(props);
        try {
            this.getDomainInfoService().saveOrUpdateDomainInfo(config);
            this.writeSucOperationLog("thirdservie_modifySysNetworkParams_operateName", 3, "bcmNetworkParam_objectName", "modifySysNetworkParam_operateDetail", params);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("thirdservie_modifySysNetworkParams_operateName", 3, "bcmNetworkParam_objectName", (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLog("thirdservie_modifySysNetworkParams_operateName", 3, "bcmNetworkParam_objectName", e);
            throw new LegoCheckedException(101L, (Throwable)e);
        }
        return Response.ok().build();
    }

    @Override
    public DomainInfoVo getDomainInfo() {
        this.checkUserOperationAuthority("thirdservie_querySysNetworkParams_operateName", 1, "ism.drm.thirdservice.sysnetwork.scan");
        CloudConfig domainInfo = this.getDomainInfoService().getDomainInfo();
        DomainInfoVo vo = new DomainInfoVo();
        if (null != domainInfo) {
            vo.setBusinessDomain((String)domainInfo.getProps().get("domain_bussiness"));
        }
        return vo;
    }
}

