/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.system.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.system.cfgdata.sdk.service.IConfigDataBackupService;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;

public final class SystemFileUtil {
    private static Log log = FELogFactory.getInstance((String)"ui");

    private SystemFileUtil() {
    }

    public static void downloadFile(HttpServletResponse response, File downloadFile, IConfigDataBackupService service, String displayName) {
        SystemFileUtil.downloadFile(response, downloadFile, service, displayName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(HttpServletResponse response, File downloadFile, IConfigDataBackupService service, String displayName, boolean isDelFile) {
        String downloadFileName = null;
        try {
            downloadFileName = downloadFile.getCanonicalPath();
            if (null == downloadFileName) {
                log.error((Object)"downloadFileName is empty");
                return;
            }
            if (VerifyUtil.isEmpty((String)displayName)) {
                displayName = downloadFileName.substring(downloadFileName.lastIndexOf(File.separator) + 1, downloadFileName.length());
            }
        }
        catch (IOException e) {
            log.error((Object)"downloadFile", 653110170615808L);
        }
        SystemFileUtil.setResponse(response, displayName);
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        FileInputStream fileInput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(downloadFileName);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[0x100000];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                log.error((Object)"downloadFile", 653110170615808L);
            }
            catch (Throwable throwable) {
                SystemFileUtil.close(bis, bos, fileInput);
                if (isDelFile) {
                    SystemFileUtil.deleteFile(downloadFile, service);
                }
                throw throwable;
            }
            SystemFileUtil.close(bis, bos, fileInput);
            if (isDelFile) {
                SystemFileUtil.deleteFile(downloadFile, service);
            }
        }
        SystemFileUtil.close(bis, bos, fileInput);
        if (isDelFile) {
            SystemFileUtil.deleteFile(downloadFile, service);
        }
    }

    private static void setResponse(HttpServletResponse response, String displayName) {
        response.setContentType("application/x-download");
        response.setCharacterEncoding("windows-1251");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store, must-revalidate");
        response.addHeader("Content-Disposition", "attachment;filename=" + displayName);
    }

    private static void close(BufferedInputStream bis, BufferedOutputStream bos, FileInputStream fileInput) {
        if (null != fileInput) {
            try {
                fileInput.close();
            }
            catch (IOException e) {
                log.error((Object)"downloadFile", 653110170615808L);
            }
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (IOException e) {
                log.error((Object)"downloadFile", 653110170615808L);
            }
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                log.error((Object)"downloadFile", 653110170615808L);
            }
        }
    }

    public static void deleteFile(File file, IConfigDataBackupService service) {
        if (service != null) {
            service.deleteFile(file);
            log.info((Object)"delete file succ", 653110170615808L);
            return;
        }
        if (file.exists()) {
            if (file.isFile()) {
                Boolean result = file.delete();
                if (!result.booleanValue()) {
                    log.error((Object)"delete file error", 653110170615808L);
                }
            } else if (file.isDirectory()) {
                SystemFileUtil.deleteDirectory(file);
            }
        } else {
            log.error((Object)"file is not exist", 653110170615808L);
        }
    }

    private static void deleteDirectory(File file) {
        Boolean result;
        File[] files = file.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                SystemFileUtil.deleteFile(files[i], null);
            }
        }
        if (!(result = Boolean.valueOf(file.delete())).booleanValue()) {
            log.error((Object)"delete file error", 653110170615808L);
        }
    }
}

