/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.group;

import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.backup.service.INovaServerService;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.report.sdk.model.ProtectGroupStatisticInfo;
import com.huawei.ism.drm.report.sdk.service.IProtectGroupReportService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.protection.group.IProtectGroupRestService;
import com.huawei.ism.drm.rest.service.platform.protection.group.ProtectGroupValidator;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.util.RPOMeetCaculator;
import com.huawei.ism.drm.util.ReplicaUtil;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.ism.drm.util.ReverseObjectSerializableUtils;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractProtectGroupRestService
extends AbstractRestService
implements IProtectGroupRestService {
    protected static final String TYPE_PARAM_KEY = "{type}";
    private static final int MAX_DELAY_TIME = 1410;
    private static Log log = LogFactory.getInstance(AbstractProtectGroupRestService.class);
    private IResourceService resourceService = null;

    private ISiteService getSiteService() {
        return this.getBundleService(ISiteService.class);
    }

    public IResourceService getResourceService() {
        log.debug((Object)"getResourceService is invoked");
        this.resourceService = this.getBundleService(IResourceService.class);
        return this.resourceService;
    }

    protected String toProtectGroupJson(List<ProtectGroup> protectGrsours) {
        if (VerifyUtil.isEmpty(protectGrsours)) {
            log.debug((Object)"protectGrsours is empty!");
            return "[]";
        }
        JSONArray result = new JSONArray();
        for (ProtectGroup protectGroup : protectGrsours) {
            result.add((Object)this.toProtectGroupJson(protectGroup));
        }
        return result.toString();
    }

    protected String formatData(String data) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            sdf.parse(data);
            return data;
        }
        catch (ParseException ex) {
            log.debug((Object)("time Parse failed." + ex.getMessage()), 653110170615808L);
            return CommUtils.formatDate(new Date(NumberUtil.convertToLong((Object)data)));
        }
    }

    protected String toProtectGroupJson(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            log.debug((Object)"protectGroup is empty!");
            return "";
        }
        JSONObject pgJsonObj = new JSONObject();
        JSONObject templateJsonObj = new JSONObject();
        PolicyTemplate template = protectGroup.getTemplate();
        templateJsonObj.put((Object)"uuid", (Object)template.getUuid());
        templateJsonObj.put((Object)"name", (Object)template.getName());
        templateJsonObj.put((Object)"type", (Object)template.getType());
        templateJsonObj.put((Object)"description", (Object)template.getDescription());
        templateJsonObj.put((Object)"ptId", (Object)template.getPtId());
        templateJsonObj.put((Object)"subType", (Object)(template.getSubType() == 0 ? template.getType() : template.getSubType()));
        pgJsonObj.put((Object)"uuid", (Object)protectGroup.getUuid());
        pgJsonObj.put((Object)"pgId", (Object)protectGroup.getUuid());
        pgJsonObj.put((Object)"primary", (Object)protectGroup.isPrimary());
        pgJsonObj.put((Object)"name", (Object)protectGroup.getName());
        pgJsonObj.put((Object)"description", (Object)protectGroup.getDescription());
        pgJsonObj.put((Object)"poType", (Object)protectGroup.getPoType());
        pgJsonObj.put((Object)"status", (Object)protectGroup.getStatus());
        pgJsonObj.put((Object)"productSiteId", (Object)protectGroup.getProductSiteId());
        pgJsonObj.put((Object)"productSiteName", (Object)protectGroup.getProductSiteName());
        pgJsonObj.put((Object)"poProviderSN", (Object)protectGroup.getPoProviderSN());
        Long execTime = protectGroup.getLastExecTime();
        String execTimeStr = "--";
        if (execTime != null && execTime > 0L) {
            execTimeStr = CommUtils.formatDate(new Date(protectGroup.getLastExecTime()));
        }
        pgJsonObj.put((Object)"lastExecTime", (Object)execTimeStr);
        pgJsonObj.put((Object)"lastExecResult", (Object)protectGroup.getLastExecResult());
        pgJsonObj.put((Object)"template", (Object)templateJsonObj);
        Map props = protectGroup.getProps();
        JSONArray rpoJsonArray = this.extractRPOorRTO(props, "RPO_ITEM_KEY", protectGroup);
        JSONArray rtoJsonArray = this.extractRPOorRTO(props, "RTO_ITEM_KEY", protectGroup);
        pgJsonObj.put((Object)"props", (Object)props);
        pgJsonObj.put((Object)"RPO_ITEM_KEY", (Object)rpoJsonArray);
        pgJsonObj.put((Object)"RTO_ITEM_KEY", (Object)rtoJsonArray);
        Set poSet = protectGroup.getPolist();
        if (!VerifyUtil.isEmpty((Collection)poSet)) {
            for (ProtectObject po : poSet) {
                po.setProtectGroup(null);
                po.setUsedStorageResourceSet(null);
                po.setStorageMetadata(null);
                po.setProtectMo(null);
            }
        }
        pgJsonObj.put((Object)"polist", (Object)protectGroup.getPolist());
        return pgJsonObj.toString();
    }

    protected IProtectGroupService getService() {
        return (IProtectGroupService)this.getBundleService("DRM_Base", IProtectGroupService.class.getName());
    }

    protected void toLogDetailJson(Collection<ProtectGroupLogDetail> logDetailList, JSONArray results) {
        for (ProtectGroupLogDetail groupLogDetail : logDetailList) {
            JSONObject obj = new JSONObject();
            try {
                obj.put((Object)"detailId", (Object)groupLogDetail.getDetailId());
                obj.put((Object)"title", (Object)groupLogDetail.getTitle());
                obj.put((Object)"titleParams", (Object)groupLogDetail.getTitleParams());
                obj.put((Object)"info", (Object)groupLogDetail.getInfo());
                obj.put((Object)"infoParams", (Object)groupLogDetail.getInfoParams());
                obj.put((Object)"startTime", (Object)groupLogDetail.getStartTime());
                obj.put((Object)"endTime", (Object)groupLogDetail.getEndTime());
                String executeTime = this.calcExecuteTime(groupLogDetail.getStartTime(), groupLogDetail.getEndTime());
                obj.put((Object)"executeTime", (Object)executeTime);
                obj.put((Object)"result", (Object)groupLogDetail.getResult());
                obj.put((Object)"parentDetailId", (Object)groupLogDetail.getLogId());
                String parentDetailId = groupLogDetail.getLogId() + "";
                if (VerifyUtil.isEmpty((String)parentDetailId)) {
                    obj.put((Object)"parentDetailId", (Object)"0");
                }
                if (!VerifyUtil.isEmpty((Collection)groupLogDetail.getChildDetails())) {
                    this.toLogDetailJson(groupLogDetail.getChildDetails(), results);
                    return;
                }
                results.add((Object)obj);
            }
            catch (LegoCheckedException e) {
                log.error((Object)"JSON operation failed.", (Throwable)e, 653110170615808L);
            }
        }
    }

    protected void filterReplicas(ProtectGroup pg, List<ProtectGroupReplica> pgReplicaLists, Integer status, Long startTime, Long endTime) {
        this.filterReplicaTime(pg, pgReplicaLists, startTime, endTime);
        if (VerifyUtil.isEmpty(pgReplicaLists) || status != 0 && status != 1) {
            log.debug((Object)("pgReplicaLists:" + pgReplicaLists + ". status:" + status));
            return;
        }
        Iterator<ProtectGroupReplica> pgrs = pgReplicaLists.iterator();
        while (pgrs.hasNext()) {
            ProtectGroupReplica pgr = pgrs.next();
            if (status.intValue() == pgr.getStatus()) continue;
            pgrs.remove();
        }
    }

    private void filterReplicaTime(ProtectGroup pg, List<ProtectGroupReplica> pgReplicaLists, Long startTime, Long endTime) {
        if (null == pg || null == pg.getTemplate() || VerifyUtil.isEmpty(pgReplicaLists)) {
            return;
        }
        Iterator<ProtectGroupReplica> pgrs = pgReplicaLists.iterator();
        while (pgrs.hasNext()) {
            ProtectGroupReplica pgr = pgrs.next();
            if (PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(pg.getTemplate().getType()) && !ReplicaUtil.isLocalStorageReplica((ProtectGroupReplica)pgr)) {
                pgrs.remove();
                continue;
            }
            String timeStamp = pgr.getTimeStamp();
            if (VerifyUtil.isEmpty((String)timeStamp) || !NumberUtils.isDigits((String)timeStamp)) continue;
            if (!VerifyUtil.isEmpty((Object)startTime) && Long.valueOf(timeStamp).compareTo(startTime) < 0) {
                pgrs.remove();
                continue;
            }
            if (VerifyUtil.isEmpty((Object)endTime) || Long.valueOf(timeStamp).compareTo(endTime) <= 0) continue;
            pgrs.remove();
        }
    }

    protected boolean validateDbAuthInfo(Integer poType, ProtectObject po) {
        log.debug((Object)("poType:" + poType + ". po:" + po));
        IProtectObjectProviderDelegate poService = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        return poService.validateDbAuthInfo(poType.intValue(), po);
    }

    protected boolean validateIsHypermetro(ProtectGroup pg) {
        return pg.getTemplate().getType() == 25 || pg.getTemplate().getType() == 29;
    }

    protected boolean validateIsReplication(ProtectGroup pg) {
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(pg.getProps().get("serviceInstanceType"));
    }

    protected void checkCanBeRemoved(ProtectObject po) {
        if (po.getPoType() == 99) {
            log.error((Object)"potype is equals with DRM_PROTECTOBJ_REPLICATION_TYPE");
            throw new LegoCheckedException(-1L);
        }
    }

    protected boolean checkProtectGroupParam(String groupName, String pgAppType, String pgDesc, PolicyTemplate template) {
        return !CommUtils.checkDrmNameParam(groupName) || !this.checkDrmProtectObjectTypeParam(pgAppType) || !CommUtil.checkDrmDescParam((String)pgDesc) || VerifyUtil.isEmpty((Object)template) || "null".equals(groupName);
    }

    protected void checkScheduleCounts(Set<Schedule> scs, Schedule newSch) {
        for (Schedule schedule : scs) {
            if (schedule.getProtectLocation() != newSch.getProtectLocation() || schedule.getScheduleMode() != 0) continue;
            log.error((Object)("protectLocation:" + schedule.getProtectLocation() + ".new protectLocation:" + newSch.getProtectLocation() + ".scheduleMode:" + schedule.getScheduleMode()));
            throw new LegoCheckedException(-1L);
        }
    }

    protected void addProtectObject(Set<ProtectObject> protectObjectSet) {
        log.debug((Object)("protectObjectSet:" + protectObjectSet));
        for (ProtectObject po : protectObjectSet) {
            String uuid = po.getUuid();
            if (VerifyUtil.isEmpty((String)uuid)) {
                uuid = UUIDGenerator.getUUID();
            }
            po.setUuid(uuid);
        }
    }

    protected JSONArray extractRPOorRTO(Map<String, String> props, String key, ProtectGroup pg) {
        JSONArray jsonArray = new JSONArray();
        String rpoValue = props.get(key);
        if (!VerifyUtil.isEmpty((String)rpoValue)) {
            jsonArray = JSONArray.fromObject((Object)rpoValue);
            log.debug((Object)("jsonArray:" + jsonArray + ", key:" + key));
            for (JSONObject obj : jsonArray) {
                String siteId = obj.getString("siteId");
                obj.put((Object)"siteName", (Object)this.getSiteName(siteId));
                Object productSiteIdObj = obj.get("productSiteId");
                String productSiteId = null;
                if (productSiteIdObj != null && productSiteIdObj instanceof String) {
                    productSiteId = (String)productSiteIdObj;
                }
                if (productSiteId != null && !"--".equals(productSiteId)) {
                    obj.put((Object)"productSiteName", (Object)this.getSiteName(productSiteId));
                } else {
                    obj.put((Object)"productSiteName", (Object)(pg != null ? pg.getProductSiteName() : ""));
                }
                this.dealInvalidProtectGroup(key, pg, obj);
            }
            props.remove(key);
        }
        return jsonArray;
    }

    private void dealInvalidProtectGroup(String key, ProtectGroup pg, JSONObject obj) {
        if (pg == null) {
            log.error((Object)("key:" + key + ". pg is null!"));
            return;
        }
        if ("RPO_ITEM_KEY".equals(key)) {
            if (pg.getStatus() == DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus()) {
                obj.put((Object)"actualRPO", (Object)-3);
                obj.put((Object)"RPOMeetStatus", (Object)-1);
            } else {
                obj.put((Object)"RPOMeetStatus", (Object)RPOMeetCaculator.statistSingleReplicaRPOMeet((JSONObject)obj));
            }
        } else if ("RTO_ITEM_KEY".equals(key) && pg.getStatus() == DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus()) {
            obj.put((Object)"actualRTO", (Object)-3);
        }
    }

    private String getSiteName(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            log.error((Object)"siteId is empty!");
            return "";
        }
        ISiteService siteService = (ISiteService)this.getBundleService("DRM_Base", ISiteService.class.getName());
        Site site = siteService.getSiteById(siteId);
        if (site != null) {
            return site.getName();
        }
        return "";
    }

    protected void checkHyperCloneProps(PolicyTemplate policyTemplate) {
        if (policyTemplate.getType() != 16) {
            return;
        }
        String cloneSplitCofig = (String)policyTemplate.getProps().get("CLONE_SPLIT");
        if (VerifyUtil.isEmpty((String)cloneSplitCofig)) {
            return;
        }
        JSONObject prJsonObj = JSONObject.fromObject((Object)cloneSplitCofig);
        if (prJsonObj.containsKey((Object)"split_delay_time")) {
            try {
                int splitDelayTime = Integer.parseInt(prJsonObj.getString("split_delay_time"));
                if (splitDelayTime < 1 || splitDelayTime > 1410) {
                    log.error((Object)("checkHyperCloneProps failed, delay_time=" + splitDelayTime));
                    throw new LegoCheckedException(1073947393L);
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)"split_delay_time is error", (Throwable)e);
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
        }
    }

    protected void checkSnapHostNumberStr(PolicyTemplate policyTemplate) {
        List<Integer> snapshotTypeList = Arrays.asList(2, 17, 28, 19);
        if (!snapshotTypeList.contains(policyTemplate.getType())) {
            return;
        }
        Map props = policyTemplate.getProps();
        if (VerifyUtil.isEmpty((Map)props)) {
            log.error((Object)"props is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        if (policyTemplate.getType() == 2) {
            int value = NumberUtil.convertToInteger(props.get("PP_SNAPSHOT_COUNT"));
            if (value < 1 || value > 2048) {
                log.error((Object)("the snapshot num is out of the limit:[1,2048], num:" + value), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            return;
        }
        this.checkMultiSnapShotNumber(policyTemplate);
    }

    private void checkMultiSnapShotNumber(PolicyTemplate policyTemplate) {
        int remoteCnt = NumberUtil.convertToInteger(policyTemplate.getProps().get("PP_SNAPSHOT_COUNT" + DrmEnumDefine.PROTECT_LOCATION.B.getValue()));
        String localCntStr = (String)policyTemplate.getProps().get("PP_SNAPSHOT_COUNT" + DrmEnumDefine.PROTECT_LOCATION.A.getValue());
        if (policyTemplate.getType() == 28) {
            if (remoteCnt < 3 || remoteCnt > 2048) {
                log.error((Object)("the snapshot num is out of the limit:[3,2048], num:" + remoteCnt), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            if (!VerifyUtil.isEmpty((String)localCntStr)) {
                log.error((Object)("lcoalCnt is not empty " + localCntStr), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            return;
        }
        int localCnt = NumberUtil.convertToInteger((Object)localCntStr);
        if (policyTemplate.getType() == 17) {
            if (localCnt < 3 || localCnt > 2048 || remoteCnt < 3 || remoteCnt > 2048) {
                log.error((Object)("the snapshot num is out of the limit:[3,2048], num:" + localCnt + " " + remoteCnt), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
        } else if (policyTemplate.getType() == 19) {
            int localMaxNum = 2048;
            int remoteMaxNum = 2048;
            if (ProtectGroupValidator.isExistsSecondSchedule(policyTemplate, DrmEnumDefine.PROTECT_LOCATION.A.getValue())) {
                localMaxNum = 60000;
            }
            if (ProtectGroupValidator.isExistsSecondSchedule(policyTemplate, DrmEnumDefine.PROTECT_LOCATION.B.getValue())) {
                remoteMaxNum = 60000;
            }
            if (localCnt < 1 || localCnt > localMaxNum || remoteCnt < 1 || remoteCnt > remoteMaxNum) {
                log.error((Object)("the snapshot num is out of the limit:[3,2048], num:" + localCnt + " " + remoteCnt), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    protected List<QueryCondition> queryCondition(String filterType, String filterValue) {
        ArrayList<QueryCondition> qcs = new ArrayList<QueryCondition>();
        if (VerifyUtil.isEmpty((String)filterType) || VerifyUtil.isEmpty((String)filterValue)) {
            log.error((Object)("filterValue\uff1a" + filterValue + ", filterType:" + filterType));
            return qcs;
        }
        QueryCondition qc = new QueryCondition(filterType, (Object)filterValue);
        qcs.add(qc);
        return qcs;
    }

    protected boolean checkProtectObjectType(int poType) {
        if (-1 == poType) {
            return true;
        }
        return this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class).getSupportProtectObjectTypes().stream().anyMatch(type -> type.getPoType() == poType);
    }

    protected boolean checkDrmProtectObjectTypeParam(String protectObjectTypeValue) {
        if (VerifyUtil.isEmpty((String)protectObjectTypeValue) || "-1".equals(protectObjectTypeValue)) {
            return true;
        }
        try {
            int poType = Integer.parseInt(protectObjectTypeValue);
            return this.checkProtectObjectType(poType);
        }
        catch (NumberFormatException e) {
            log.debug((Object)("protectObjectTypeValue\uff1a" + protectObjectTypeValue));
            return false;
        }
    }

    protected JSONArray protectGroupReplicaListToJsonStr(List<ProtectGroupReplica> replicas) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(replicas)) {
            log.debug((Object)"replicas is empty!");
            return jsonArray;
        }
        ISiteService siteSerivce = this.getSiteService();
        HashMap<String, Site> siteIdMap = new HashMap<String, Site>();
        HashMap<String, String> ecsServers = new HashMap<String, String>();
        ArrayList<JSONObject> replicaList = new ArrayList<JSONObject>();
        HashMap<String, String> hostCacheMap = new HashMap<String, String>();
        for (ProtectGroupReplica pgr : replicas) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"id", (Object)pgr.getId());
            jsonObject.put((Object)"name", (Object)pgr.getName());
            jsonObject.put((Object)"type", (Object)pgr.getType());
            jsonObject.put((Object)"status", (Object)pgr.getStatus());
            String siteName = "--";
            Site site = this.setSiteInfo(siteSerivce, siteIdMap, pgr, jsonObject, siteName);
            jsonObject.put((Object)"index", (Object)pgr.getIndex());
            jsonObject.put((Object)"protectLocation", (Object)pgr.getProtectLocation());
            if (!VerifyUtil.isEmpty((String)pgr.getTimeStamp())) {
                String timeStr = CommUtils.formatDate(new Date(NumberUtil.convertToLong((Object)pgr.getTimeStamp())));
                jsonObject.put((Object)"timeStamp", (Object)timeStr);
                jsonArray.add((Object)jsonObject);
            } else {
                jsonObject.put((Object)"timeStamp", (Object)"--");
                replicaList.add(jsonObject);
            }
            jsonObject.put((Object)"mountStatus", (Object)pgr.getMountStatus());
            if (ReplicaMountStatus.UMOUNTED.getStatus() == pgr.getMountStatus().intValue()) {
                jsonObject.put((Object)"mountHost", (Object)"--");
            } else {
                jsonObject.put((Object)"mountHost", (Object)this.getHostName(hostCacheMap, ecsServers, pgr.getMountedHost(), pgr.getPg(), site));
            }
            jsonObject.put((Object)"generation", (Object)pgr.getGeneration());
            jsonObject.put((Object)"accessLevel", (Object)pgr.getAccessLevel());
            jsonObject.put((Object)"props", (Object)pgr.getProps());
            jsonObject.put((Object)"protectArray", (Object)pgr.getProductArray());
        }
        jsonArray.addAll(replicaList);
        return jsonArray;
    }

    private Site setSiteInfo(ISiteService siteSerivce, Map<String, Site> siteIdMap, ProtectGroupReplica pgr, JSONObject jsonObject, String siteName) {
        String siteId = pgr.getRecoverySite();
        Site site = null;
        if (siteIdMap.containsKey(siteId)) {
            site = siteIdMap.get(siteId);
        }
        if (site != null) {
            siteName = siteIdMap.get(siteId).getName();
        } else {
            site = siteSerivce.getSiteById(siteId);
            if (!VerifyUtil.isEmpty((Object)site)) {
                siteName = site.getName();
                siteIdMap.put(siteId, site);
            }
        }
        jsonObject.put((Object)"recoverySite", (Object)siteName);
        jsonObject.put((Object)"recoverySiteId", (Object)siteId);
        return site;
    }

    private String getHostName(Map<String, String> hostCacheMap, Map<String, String> ecsServers, String hostId, ProtectGroup pg, Site site) {
        if (VerifyUtil.isEmpty((String)hostId)) {
            return hostId;
        }
        if (hostCacheMap.containsKey(hostId)) {
            return hostCacheMap.get(hostId);
        }
        String hostName = hostId;
        if (!VerifyUtil.isEmpty((Object)site) && site.getIsCloudSite().booleanValue()) {
            if (ecsServers.containsKey(hostId)) {
                return ecsServers.get(hostId);
            }
            INovaServerService novaSevice = this.getBundleService(INovaServerService.class.getName(), INovaServerService.class);
            if (VerifyUtil.isEmpty((Object)novaSevice)) {
                log.warn((Object)"Can not get Nova service.");
                return hostName;
            }
            Map server = novaSevice.getNovaServer(site.getSiteId(), hostId);
            if (null != server) {
                hostName = server.get("name").toString();
                ecsServers.put(hostId, hostName);
            } else {
                log.warn((Object)"Can not get Nova(%s) server.", new Object[]{1073947393L, hostId});
            }
        }
        if (10 == pg.getPoType()) {
            HashMap<String, String> querys = new HashMap<String, String>();
            querys.put("uuid", hostId);
            List moLists = this.getBundleService(IResourceService.class).queryMoList(ManagedObject.class, querys);
            if (!VerifyUtil.isEmpty((Collection)moLists)) {
                ManagedObject mo = (ManagedObject)moLists.get(0);
                hostName = mo.getName();
            }
            hostCacheMap.put(hostId, hostName);
            return hostName;
        }
        DrResource drResource = this.getResourceService().getDrResourceBySn(hostId);
        if (null != drResource) {
            hostName = drResource.getName();
        }
        hostCacheMap.put(hostId, hostName);
        return hostName;
    }

    protected void addGroupDetailToJson(JSONArray array, ProtectGroupLogDetail groupLogDetail, JSONObject obj) {
        log.debug((Object)("array:" + array + ", obj:" + obj));
        obj.put((Object)"detailId", (Object)groupLogDetail.getDetailId());
        obj.put((Object)"title", (Object)groupLogDetail.getTitle());
        obj.put((Object)"titleParams", (Object)groupLogDetail.getTitleParams());
        obj.put((Object)"info", (Object)groupLogDetail.getInfo());
        obj.put((Object)"infoParams", (Object)groupLogDetail.getInfoParams());
        String startTime = groupLogDetail.getStartTime();
        this.addTimeJson(obj, startTime, "startTime");
        String endTime = groupLogDetail.getEndTime();
        this.addTimeJson(obj, endTime, "endTime");
        String executeTime = this.calcExecuteTime(startTime, endTime);
        obj.put((Object)"executeTime", (Object)executeTime);
        obj.put((Object)"result", (Object)groupLogDetail.getResult());
        obj.put((Object)"protectedType", (Object)groupLogDetail.getProtectedType());
        JSONArray subArray = new JSONArray();
        if (!VerifyUtil.isEmpty((Collection)groupLogDetail.getChildDetails())) {
            this.addDetailToJson(groupLogDetail, subArray);
        }
        obj.put((Object)"protectGroupLogDetails", (Object)subArray);
        array.add((Object)obj);
    }

    private void addDetailToJson(ProtectGroupLogDetail groupLogDetail, JSONArray subArray) {
        log.debug((Object)("subArray:" + subArray));
        for (ProtectGroupLogDetail logDetai : groupLogDetail.getChildDetails()) {
            JSONObject subObj = new JSONObject();
            subObj.put((Object)"detailId", (Object)logDetai.getDetailId());
            subObj.put((Object)"title", (Object)logDetai.getTitle());
            subObj.put((Object)"titleParams", (Object)logDetai.getTitleParams());
            subObj.put((Object)"parentDetailId", (Object)logDetai.getParentDetailId());
            subObj.put((Object)"info", (Object)logDetai.getInfo());
            subObj.put((Object)"infoParams", (Object)logDetai.getInfoParams());
            String subStartTime = logDetai.getStartTime();
            this.addTimeJson(subObj, subStartTime, "startTime");
            String subEndTime = logDetai.getEndTime();
            this.addTimeJson(subObj, subEndTime, "endTime");
            String executeTime = this.calcExecuteTime(subStartTime, subEndTime);
            subObj.put((Object)"executeTime", (Object)executeTime);
            subObj.put((Object)"result", (Object)logDetai.getResult());
            subArray.add((Object)subObj);
        }
    }

    private void addTimeJson(JSONObject jsonObject, String timeStr, String timeType) {
        log.debug((Object)("jsonObject:" + jsonObject + ", timeStr:" + timeStr + ", timeType:" + timeType));
        if (timeStr == null || "--".equals(timeStr)) {
            jsonObject.put((Object)timeType, (Object)"--");
        } else if (timeStr.contains("UTC")) {
            jsonObject.put((Object)timeType, (Object)timeStr);
        } else {
            jsonObject.put((Object)timeType, (Object)CommUtils.formatDate(new Date(NumberUtil.convertToLong((Object)timeStr))));
        }
    }

    protected Object protectObjectListToJsonStr(List<ProtectObject> protectObjectList) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(protectObjectList)) {
            log.debug((Object)"protectObjectList is empty!");
            return jsonArray;
        }
        for (ProtectObject po : protectObjectList) {
            jsonArray.add(this.protectObjectToJsonStr(po));
        }
        return jsonArray;
    }

    private Object protectObjectToJsonStr(ProtectObject po) {
        JSONObject poJsonObject = new JSONObject();
        poJsonObject.put((Object)"uuid", (Object)po.getUuid());
        poJsonObject.put((Object)"moUuid", (Object)po.getMoUuid());
        poJsonObject.put((Object)"name", (Object)po.getName());
        poJsonObject.put((Object)"poStatus", (Object)po.getPoStatus());
        poJsonObject.put((Object)"poType", (Object)po.getPoType());
        poJsonObject.put((Object)"providerSN", (Object)po.getProviderSN());
        poJsonObject.put((Object)"providerName", (Object)po.getProviderName());
        Map props = po.getProps();
        if (VerifyUtil.isEmpty((String)po.getProviderName()) && !VerifyUtil.isEmpty((String)po.getProviderSN())) {
            log.debug((Object)("po name:" + po.getName()));
            DrResource drResource = this.getResourceService().getDrResourceBySn(po.getProviderSN());
            String providerName = drResource == null ? "--" : drResource.getName();
            poJsonObject.put((Object)"providerName", (Object)providerName);
        }
        poJsonObject.put((Object)"props", (Object)props);
        return poJsonObject;
    }

    protected void validateProtectGroupId(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            log.debug((Object)"protectGroupId is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)pgId)) {
            log.error((Object)"protectGroupId is incorrect!");
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void validateProtectGroup(ProtectGroup protectgroup) {
        if (VerifyUtil.isEmpty((Object)protectgroup)) {
            log.debug((Object)"protectgroup is empty!");
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void validateLogId(int logId) {
        if (logId <= 0) {
            log.debug((Object)"logId <= 0!");
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    public Response lockProtectGroup(String protectGroupId) {
        log.info((Object)"begin lockProtectGroup between two rd", 90160758786988L);
        this.checkUserOperationAuthority("protectedGroup_lockProtectedGroup_operateName", SysoplogLevel.normal.getValue(), "ism.drm.protectgroup.auth.modify");
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_lockProtectedGroup_operateName", SysoplogLevel.normal.getValue(), protectGroupId);
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectGroupId, false);
        try {
            this.getService().lockProtectGroup(new String[]{protectGroupId});
            this.writeSucOperationLog("protectedGroup_lockProtectedGroup_operateName", SysoplogLevel.normal.getValue(), pg.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("protectedGroup_lockProtectedGroup_operateName", SysoplogLevel.normal.getValue(), pg.getName(), e);
        }
        log.info((Object)"end lockProtectGroup between two rd", 90160758786988L);
        return Response.ok().build();
    }

    @Override
    public Response unlockProtectGroup(String protectGroupId) {
        log.info((Object)"begin unlockProtectGroup between two rd", 90160758786988L);
        this.checkUserOperationAuthority("protectedGroup_unlockProtectedGroup_operateName", SysoplogLevel.info.getValue(), "ism.drm.protectgroup.auth.modify");
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_unlockProtectedGroup_operateName", SysoplogLevel.info.getValue(), protectGroupId);
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectGroupId, false);
        try {
            this.getService().unlockProtectGroup(new String[]{protectGroupId});
            this.writeSucOperationLog("protectedGroup_unlockProtectedGroup_operateName", SysoplogLevel.info.getValue(), pg.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("protectedGroup_unlockProtectedGroup_operateName", SysoplogLevel.info.getValue(), pg.getName(), e);
        }
        log.info((Object)("end unlockProtectGroup between two rd,pgid: " + protectGroupId), 90160758786988L);
        return Response.ok().build();
    }

    @Override
    public Response updateProtectGroupStatus(String protectGroupId, int status) {
        log.info((Object)"begin updateProtectGroupStatus between two rd", 90160758786988L);
        this.checkUserOperationAuthority("protectedGroup_refreshState_operateName", SysoplogLevel.normal.getValue(), "ism.drm.protectgroup.auth.modify");
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_refreshState_operateName", SysoplogLevel.normal.getValue(), protectGroupId);
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectGroupId, false);
        try {
            DrmEnumDefine.PROTECT_GROUP_STATUS inStatus = DrmEnumDefine.PROTECT_GROUP_STATUS.valueOf((int)status);
            this.getService().updateProtectGroupStatus(inStatus, new String[]{protectGroupId});
            this.writeSucOperationLog("protectedGroup_refreshState_operateName", SysoplogLevel.normal.getValue(), pg.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("protectedGroup_refreshState_operateName", SysoplogLevel.normal.getValue(), pg.getName(), e);
        }
        log.info((Object)("end updateProtectGroupStatus between two rd,pgid: " + protectGroupId), 90160758786988L);
        return Response.ok().build();
    }

    @GET
    @Path(value="/getProtectGroupStatisticInfo")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public RestJsonRequest getProtectGroupStatisticInfo(@QueryParam(value="protectGroupId") String protectGroupId, @QueryParam(value="range") DrmEnumDefine.REPORT_TIME_RANGE_E range, @QueryParam(value="userId") long userId) {
        log.info((Object)"begin getProtectGroupStatisticInfo between two rd", 90160758786988L);
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), protectGroupId);
        RestJsonRequest rjq = new RestJsonRequest();
        ProtectGroupStatisticInfo pgsi = ((IProtectGroupReportService)this.getBundleService("DRM_Report", IProtectGroupReportService.class.getName())).getProtectGroupExecutedInfo(protectGroupId, range, Long.valueOf(userId));
        rjq.setClasssName(ProtectGroupStatisticInfo.class.getName());
        rjq.setValue(ReverseObjectSerializableUtils.serializableObj((Object)pgsi));
        log.info((Object)"end getProtectGroupStatisticInfo between two rd", 90160758786988L);
        return rjq;
    }

    @Override
    public Response updateProtectGroupAlarm(String protectGroupId) {
        log.info((Object)"begin updateProtectGroupAlarm between two rd", 90160758786988L);
        this.checkUserOperationAuthority("protectedGroup_modifyPG_operateName", SysoplogLevel.normal.getValue(), "ism.drm.protectgroup.auth.modify");
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_modifyPG_operateName", SysoplogLevel.normal.getValue(), protectGroupId);
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectGroupId, false);
        try {
            this.getService().restoreAlarmById(protectGroupId);
            this.writeSucOperationLog("protectedGroup_modifyPG_operateName", SysoplogLevel.normal.getValue(), pg.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("protectedGroup_modifyPG_operateName", SysoplogLevel.normal.getValue(), pg.getName(), e);
        }
        log.info((Object)"end updateProtectGroupAlarm between two rd", 90160758786988L);
        return Response.ok().build();
    }

    @Override
    public Response updateProtectGroupProps(String protectGroupId, Map<String, String> props) {
        log.info((Object)"begin updateProtectGroupProps between two rd", 90160758786988L);
        this.checkUserOperationAuthority("protectedGroup_modifyPG_operateName", SysoplogLevel.normal.getValue(), "ism.drm.protectgroup.auth.modify");
        this.validateProtectGroupId(protectGroupId);
        if (VerifyUtil.isEmpty(props) || !ParamChecker.checkList(props.entrySet(), entry -> ParamChecker.checkLongText((String)((String)entry.getKey())) && ParamChecker.checkLongText((String)((String)entry.getValue())), (int)128)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("protectedGroup_modifyPG_operateName", SysoplogLevel.normal.getValue(), protectGroupId);
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectGroupId, false);
        try {
            IProtectGroupService protectGroupService = this.getBundleService(IProtectGroupService.class);
            protectGroupService.saveOrUpdateProtectGroupProps(protectGroupId, props);
            log.info((Object)("updateProtectGroupProps success. UserName: " + this.getCurrentUser().getUserName() + ", IP: " + AbstractProtectGroupRestService.getRemoteAddr(this.getRequest()) + ", PgName: " + pg.getName()), 90160758786988L);
        }
        catch (Exception e) {
            log.error((Object)("updateProtectGroupProps failed. UserName: " + this.getCurrentUser().getUserName() + ", IP: " + AbstractProtectGroupRestService.getRemoteAddr(this.getRequest()) + ", PgName: " + pg.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        log.info((Object)("end updateProtectGroupProps between two rd,pgid:" + protectGroupId), 90160758786988L);
        return Response.ok().build();
    }

    protected void writeFailedOperationLogForPo(String operationName, int level, Exception ix, Set<ProtectObject> protectObjectSet) {
        if (ix instanceof LegoCheckedException) {
            LegoCheckedException ex = (LegoCheckedException)((Object)ix);
            for (ProtectObject po : protectObjectSet) {
                SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err." + ex.getErrorCode(), po.getName(), AbstractProtectGroupRestService.getRemoteAddr(this.getRequest()));
                sysOptLog.setDetailPara(ex.getParameters());
                SysOpLogBuilder.writeOperateLog(sysOptLog);
            }
            throw ex;
        }
        for (ProtectObject po : protectObjectSet) {
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err.-1", po.getName(), AbstractProtectGroupRestService.getRemoteAddr(this.getRequest()));
            sysOptLog.setDetailPara(new String[0]);
            SysOpLogBuilder.writeOperateLog(sysOptLog);
        }
        log.error((Object)("operationName:" + operationName), -1L);
        throw new LegoCheckedException(-1L);
    }

    protected List<ProtectGroupReplica> getSiteProtectGroupReplicas(List<ProtectGroupReplica> replicas, String siteId) {
        ArrayList<ProtectGroupReplica> newReplicas = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica replica : replicas) {
            String cloudSiteId = replica.getProperty("CLOUD_SITE_ID");
            if (!VerifyUtil.isEmpty((String)cloudSiteId)) {
                if (!cloudSiteId.equals(siteId)) continue;
                newReplicas.add(replica);
                continue;
            }
            if (!replica.getRecoverySite().equals(siteId)) continue;
            newReplicas.add(replica);
        }
        return newReplicas;
    }

    protected List<ProtectGroupReplica> getGroupReplicasByPages(List<ProtectGroupReplica> replicas, Integer pageNum, Integer pageSize) {
        ArrayList<ProtectGroupReplica> newReplicas = new ArrayList<ProtectGroupReplica>();
        if (pageNum > 0) {
            int startIndex = (pageNum - 1) * pageSize;
            int endIndex = startIndex + pageSize;
            if (replicas.size() < pageSize) {
                return replicas;
            }
            if (replicas.size() - startIndex < pageSize && replicas.size() > pageSize) {
                endIndex = replicas.size();
            }
            for (int i = startIndex; i < endIndex; ++i) {
                newReplicas.add(replicas.get(i));
            }
        }
        return newReplicas;
    }

    protected void validatePolicyTemplate(PolicyTemplate policyTemplate, int pgAppType) {
        log.debug((Object)("method [validatePolicyTemplate] invoked. pgAppType:" + pgAppType + ", policyTemplate id:" + policyTemplate.getPtId()));
        IPolicyTemplateManager policyTemplateManager = this.getBundleService(IPolicyTemplateManager.class);
        PolicyTemplate policyTemplateFromDB = policyTemplateManager.getPtByUuid(policyTemplate.getUuid());
        if (null == policyTemplateFromDB) {
            log.error((Object)("cannot get policyTemplate, policyTemplate.getUuid = " + policyTemplate.getUuid()), 1073947394L);
            throw new LegoCheckedException(1073947394L);
        }
        policyTemplate.setType(policyTemplateFromDB.getType());
        this.checkHyperCloneProps(policyTemplate);
        ProtectGroupValidator.checkMountConfiguration(policyTemplate);
        this.getBundleService(IProtectGroupService.class).checkPolicyProps(pgAppType, policyTemplate);
    }
}

