/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.group;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.report.sdk.model.ProtectGroupStatisticInfo;
import com.huawei.ism.drm.report.sdk.service.IProtectGroupReportService;
import com.huawei.ism.drm.rest.service.platform.protection.group.AbstractProtectGroupRestService;
import com.huawei.ism.drm.rest.service.platform.protection.group.ProtectGroupValidator;
import com.huawei.ism.drm.rest.service.platform.protection.group.ScheduleFormater;
import com.huawei.ism.drm.rest.service.platform.protection.util.ProtectGroupExcelDetailsOperator;
import com.huawei.ism.drm.rest.service.platform.protection.util.ProtectGroupExcelUtil;
import com.huawei.ism.drm.rest.service.platform.protection.util.ProtectGroupLogExcelOperator;
import com.huawei.ism.drm.rest.util.DownloadFileUtil;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.FileExcelUtil;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class ProtectGroupBaseRestServiceImpl
extends AbstractProtectGroupRestService {
    private static Log log = LogFactory.getInstance(ProtectGroupBaseRestServiceImpl.class);
    private static final String TASK_ID = "taskId";

    @Override
    public String protectgroups(int poType, String orderBy, String orderType, int pageSize, int startPage, String siteId) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        if (!Validator.checkPageQueryParams(orderType, pageSize, startPage)) {
            log.error((Object)("orderType:" + orderType + ", pageSize:" + pageSize + ", startPage:" + startPage));
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.checkProtectObjectType(poType)) {
            log.error((Object)("poType is incorrect. poType:" + poType));
            throw new LegoCheckedException(1073947393L);
        }
        if (!Validator.canOrderBy(orderBy)) {
            log.error((Object)"Invalid orderBy");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            log.error((Object)"Invalid siteId");
            throw new LegoCheckedException(1073947393L);
        }
        boolean orderByAscend = "asc".equalsIgnoreCase(orderType);
        List<QueryCondition> queryConditions = this.constructQueryCondition(poType, siteId);
        Page page = this.getBundleService(IProtectGroupService.class).pagedQueryProtectGroup(startPage, pageSize, orderBy, orderByAscend, queryConditions, this.getCurrentUserId());
        JSONObject result = new JSONObject();
        if (VerifyUtil.isEmpty((Object)page) || VerifyUtil.isEmpty((Collection)page.getResult())) {
            result.put((Object)"totalCount", (Object)0);
            result.put((Object)"records", (Object)"[]");
            return result.toString();
        }
        List protectGrsours = page.getResult();
        result.put((Object)"totalCount", (Object)page.getTotalCount());
        result.put((Object)"records", (Object)this.toProtectGroupJson(protectGrsours));
        return result.toString();
    }

    private List<QueryCondition> constructQueryCondition(int poType, String siteId) {
        String filterName = this.getRequest().getParameter("filterName");
        String filterValue = this.getRequest().getParameter("filterValue");
        if (!ParamChecker.checkGeneralText((String)filterName) || !ParamChecker.checkGeneralText((String)filterValue)) {
            log.error((Object)"Invalid filterName or filterValue");
            throw new LegoCheckedException(1073947393L);
        }
        log.debug((Object)("poType:" + poType + ", siteId:" + siteId));
        List<QueryCondition> queryConditions = this.queryCondition(filterName, filterValue);
        if (poType != -1) {
            queryConditions.add(new QueryCondition("poType", (Object)poType));
        }
        if (!"-1".equals(siteId)) {
            this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), siteId);
            queryConditions.add(new QueryCondition("productSiteId", (Object)siteId));
        }
        return queryConditions;
    }

    @Override
    public String protectgroups(String protectgroupId) {
        log.debug((Object)("protectgroupId:" + protectgroupId));
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        this.validateProtectGroupId(protectgroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), protectgroupId);
        ProtectGroup protectGroup = this.getBundleService(IProtectGroupService.class).getProtectGroupByID(protectgroupId, false);
        this.validateProtectGroup(protectGroup);
        return this.toProtectGroupJson(protectGroup);
    }

    @Override
    public Response updateProtectGroupBasicInfo(String protectGroupId, ProtectGroup pg) {
        if (VerifyUtil.isEmpty((String)protectGroupId) || !ParamChecker.checkGeneralId((String)protectGroupId) || VerifyUtil.isEmpty((Object)pg)) {
            log.debug((Object)("protectgroupId:" + protectGroupId + ",pg:" + pg));
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("protectedGroup_modify_operateName", SysoplogLevel.normal.getValue(), "ism.drm.protectgroup.auth.modify");
        ProtectGroup oldProtectGroup = null;
        ProtectGroupValidator.updateProtectGroupBasicInfoCheck(protectGroupId, pg.getName(), pg.getDescription());
        this.checkUserBizObjAuthority("protectedGroup_modify_operateName", SysoplogLevel.normal.getValue(), protectGroupId);
        long taskId = -1L;
        try {
            oldProtectGroup = this.getService().getProtectGroupBasicInfo(protectGroupId, false);
            if (oldProtectGroup == null) {
                log.error((Object)("protectgroup [id:" + protectGroupId + "] is not existed!"), 653110170615808L);
                throw new LegoCheckedException(1073947394L);
            }
            if (this.validateIsHypermetro(oldProtectGroup) || this.validateIsReplication(oldProtectGroup)) {
                throw new LegoCheckedException(1073947453L);
            }
            pg.setUuid(protectGroupId);
            taskId = this.getService().updateProtectGroupBasicInfo(pg, Boolean.valueOf(this.isMachineToMachineReq()));
            this.writeSucOperationLog("protectedGroup_modify_operateName", SysoplogLevel.normal.getValue(), oldProtectGroup.getName(), "protectedGroup_modify_operateDetail", new String[]{oldProtectGroup.getName(), pg.getName(), VerifyUtil.isEmpty((String)oldProtectGroup.getDescription()) ? "" : oldProtectGroup.getDescription(), VerifyUtil.isEmpty((String)pg.getDescription()) ? "" : pg.getDescription()});
        }
        catch (Exception le) {
            String pgName = pg.getName();
            if (null != oldProtectGroup) {
                pgName = oldProtectGroup.getName();
            }
            this.writeFailedOperationLog("protectedGroup_modify_operateName", SysoplogLevel.normal.getValue(), pgName, le);
        }
        JSONObject obj = new JSONObject();
        obj.put((Object)TASK_ID, (Object)taskId);
        return Response.ok((Object)obj.toString()).build();
    }

    @Override
    public String getProtectGroupReplicas(String protectGroupId, Integer status, Long startTime, Long endTime) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), protectGroupId);
        List<ProtectGroupReplica> replicas = null;
        try {
            IReplicaService replicaService = this.getBundleService(IReplicaService.class);
            replicas = replicaService.queryProtectGroupReplicaByGroup(protectGroupId, "TIME_STAMP", false, false);
        }
        catch (Exception e) {
            log.debug((Object)("protectgroupId:" + protectGroupId + ",status:" + status));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectGroupId, false);
        this.filterReplicas(pg, replicas, status, startTime, endTime);
        replicas = this.sortReplicaByLocation(replicas);
        return this.protectGroupReplicaListToJsonStr(replicas).toString();
    }

    @Override
    public String pageQueryProtectGroupReplicas(String protectGroupId, Integer status, Long startTime, Long endTime, String siteId, Integer pageNum, Integer replicaType) {
        Integer pageSize = 10;
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        this.validateProtectGroupId(protectGroupId);
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), protectGroupId);
        List<Object> replicas = null;
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupByID(protectGroupId, false);
        IReplicaService replicaService = this.getBundleService(IReplicaService.class);
        Set schedules = pg.getTemplate().getSchedules();
        Integer totalCount = 0;
        boolean isHyperCDP = false;
        try {
            replicas = replicaService.queryProtectGroupReplicaByGroup(protectGroupId, "TIME_STAMP", false, true);
            if (!VerifyUtil.isEmpty((Collection)replicas)) {
                replicas = this.getSiteProtectGroupReplicas((List<ProtectGroupReplica>)replicas, siteId);
            }
            for (Schedule schedule : schedules) {
                if (schedule.getScheduleMode() != 0 || schedule.getPeriodType() != 5 || !schedule.getSourceSiteId().equals(siteId)) continue;
                replicas.addAll(replicaService.querySecondProtectGroupReplica(protectGroupId, schedule, pageNum, pageSize, startTime, endTime));
                if (schedule.getProtectedType() != ScheduleProtectedType.HYPERCDP.getValue() || replicaType != 4) continue;
                isHyperCDP = true;
                totalCount = replicaService.querySecondProtectGroupReplicaCount(protectGroupId, schedule, startTime, endTime);
            }
        }
        catch (Exception e) {
            log.debug((Object)("protectgroupId:" + protectGroupId + ",status:" + status));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (null != replicaType) {
            replicas = replicas.stream().filter(replica -> replica.getType() == replicaType.intValue()).collect(Collectors.toList());
        }
        if (!isHyperCDP) {
            this.filterReplicas(pg, replicas, status, startTime, endTime);
            totalCount = replicas.size();
            replicas = this.getGroupReplicasByPages(replicas, pageNum, pageSize);
        }
        replicas = this.sortReplicaByLocation(replicas);
        String jArray = this.protectGroupReplicaListToJsonStr(replicas).toString();
        JSONArray jsonArray = JSONArray.fromObject((Object)jArray);
        JSONObject jObj = new JSONObject();
        jObj.put((Object)"replicas", (Object)jsonArray);
        jObj.put((Object)"totalCount", (Object)totalCount);
        return jObj.toString();
    }

    private List<ProtectGroupReplica> sortReplicaByLocation(List<ProtectGroupReplica> replicas) {
        if (VerifyUtil.isEmpty(replicas)) {
            log.debug((Object)"replicas is empty!");
        }
        ArrayList<ProtectGroupReplica> result = new ArrayList<ProtectGroupReplica>(replicas);
        ArrayList<ProtectGroupReplica> toSortList = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica replica : replicas) {
            if (!VerifyUtil.isEmpty((String)replica.getTimeStamp())) continue;
            toSortList.add(replica);
        }
        result.removeAll(toSortList);
        Collections.sort(toSortList, new Comparator<ProtectGroupReplica>(){

            @Override
            public int compare(ProtectGroupReplica paramT1, ProtectGroupReplica paramT2) {
                return paramT1.getProtectLocation() - paramT2.getProtectLocation();
            }
        });
        result.addAll(toSortList);
        return result;
    }

    @Override
    public String getProtectGroupHistoryLogs(String protectGroupId, int startPage, int pageSize, String orderBy, String orderType) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), protectGroupId);
        boolean isAsc = true;
        if (orderType == null || orderType.equalsIgnoreCase("desc")) {
            isAsc = false;
        }
        Page page = this.getService().pageQueryHistoryLogFromAll(startPage, pageSize, orderBy, isAsc, protectGroupId);
        List result = page.getResult();
        long totalCount = page.getTotalCount();
        JSONObject jasonObject = new JSONObject();
        jasonObject.put((Object)"totalCount", (Object)totalCount);
        JSONArray array = new JSONArray();
        List logList = result;
        for (ProtectGroupLog groupLog : logList) {
            JSONObject obj = new JSONObject();
            try {
                obj.put((Object)"historyLogId", (Object)groupLog.getHistoryLogId());
                obj.put((Object)"info", (Object)groupLog.getInfo());
                String startTime = groupLog.getStartTime();
                obj.put((Object)"startTime", (Object)(startTime != null ? this.formatData(startTime) : "--"));
                String endTime = groupLog.getEndTime();
                obj.put((Object)"endTime", (Object)(endTime != null ? this.formatData(endTime) : "--"));
                String executeTime = this.calcExecuteTime(startTime, endTime);
                obj.put((Object)"executeTime", (Object)executeTime);
                obj.put((Object)"result", (Object)groupLog.getResult());
                array.add((Object)obj);
            }
            catch (Exception e) {
                log.error((Object)"JSON operation failed.", (Throwable)e, 653110170615808L);
            }
        }
        jasonObject.put((Object)"records", (Object)array);
        return jasonObject.toString();
    }

    @Override
    public String getProtectGroupLogDetails(String protectGroupId, int logId) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), protectGroupId);
        List result = null;
        result = -1 == logId ? this.getService().queryRunningHistoryLog(protectGroupId) : this.getService().queryHistoryLogDetailFromAll(logId, protectGroupId);
        JSONArray array = new JSONArray();
        if (!VerifyUtil.isEmpty((Collection)result)) {
            for (ProtectGroupLogDetail groupLogDetail : result) {
                JSONObject obj = new JSONObject();
                try {
                    this.addGroupDetailToJson(array, groupLogDetail, obj);
                }
                catch (LegoCheckedException e) {
                    log.error((Object)"JSON operation failed.", (Throwable)e, 653110170615808L);
                }
            }
        }
        return array.toString();
    }

    @Override
    public String getAvailableProtectObject(int poType, String deviceSn) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        Map<String, Object> queryParam = this.getExtParamInQueryParam();
        if (VerifyUtil.isEmpty((String)deviceSn) || !ParamChecker.checkGeneralId((String)deviceSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        IResourceService resourceService = (IResourceService)this.getBundleService("DRM_Base", IResourceService.class.getName());
        DrResource resource = resourceService.getDrResourceBySn(deviceSn);
        if (VerifyUtil.isEmpty((Object)resource)) {
            throw new LegoCheckedException(1073947394L);
        }
        if (resource instanceof DrHostGroup) {
            for (DrResource drHost : resource.getChildResources()) {
                this.checkUserMoAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), drHost.getDeviceSn());
            }
        } else {
            this.checkUserMoAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), deviceSn);
        }
        if (!this.checkProtectObjectType(poType)) {
            log.error((Object)("poType is incorrect. poType:" + poType));
            throw new LegoCheckedException(1073947393L);
        }
        IProtectObjectProviderDelegate poProvider = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        List poList = poProvider.getAvailableProtectObject(poType, deviceSn, queryParam);
        return this.protectObjectListToJsonStr(poList).toString();
    }

    @Override
    public Response getProtectObjectStorageInfo(ProtectObject po) {
        this.checkUserOperationAuthority("protectedGroup_create_operateName", SysoplogLevel.info.getValue(), "ism.drm.protectgroup.auth.add");
        if (VerifyUtil.isEmpty((Object)po)) {
            log.error((Object)"po is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)po.getMoUuid()) || !ParamChecker.checkGeneralId((String)po.getMoUuid())) {
            log.error((Object)"moUuid is empty or incorrect!");
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.checkProtectObjectType(po.getPoType())) {
            log.error((Object)"poType is incorrect!");
            throw new LegoCheckedException(1073947393L);
        }
        String moProviderSn = this.getMoProviderSn(po);
        if (VerifyUtil.isEmpty((String)moProviderSn)) {
            log.error((Object)"moProviderSn is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("protectedGroup_create_operateName", SysoplogLevel.info.getValue(), moProviderSn);
        IProtectObjectProviderDelegate poProviderDelegate = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        poProviderDelegate.discoveryProtectObjectStorageInfo(po.getPoType(), po, null);
        return Response.ok().build();
    }

    @Override
    public String getProtectObjcetInProtectGroupByPage(String orderBy, String orderType, int pageSize, int startPage, String protectgroupId, int poType) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        this.validateProtectGroupId(protectgroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), protectgroupId);
        if (!Validator.canOrderBy(orderBy)) {
            log.error((Object)"Invalid orderBy!");
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.checkProtectObjectType(poType)) {
            log.error((Object)("poType is incorrect. poType:" + poType));
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        String orderByField = "name";
        boolean orderByAscend = false;
        if (orderBy != null) {
            orderByField = orderBy;
        }
        if (orderType == null || orderType.equalsIgnoreCase("asc")) {
            orderByAscend = true;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            Page page = pgServices.pagedQueryProtectObjectByPg(startPage, pageSize, orderByField, orderByAscend, protectgroupId, Integer.valueOf(poType));
            long total = page.getTotalCount();
            List protectObjects = page.getResult();
            jsonObject.put((Object)"totalCount", (Object)total);
            jsonObject.put((Object)"records", this.protectObjectListToJsonStr(protectObjects));
        }
        catch (LegoCheckedException e) {
            log.error((Object)("Querying protect object by pg failed. PgId:" + protectgroupId), (Throwable)e, 90160758784001L);
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return jsonObject.toString();
    }

    private String getMoProviderSn(ProtectObject po) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("uuid", po.getMoUuid());
        List moLists = this.getBundleService(IResourceService.class).queryMoList(ManagedObject.class, query);
        if (!VerifyUtil.isEmpty((Collection)moLists)) {
            ManagedObject mo = (ManagedObject)moLists.get(0);
            po.setName(mo.getName());
            while (mo.getParentMo() != null) {
                mo = mo.getParentMo();
            }
            if (mo instanceof NetworkEntity) {
                return ((NetworkEntity)mo).getSn();
            }
        }
        log.debug((Object)"cannot get the sn!");
        return null;
    }

    @Override
    public Response enableProtectGroup(String protectgroupId) {
        this.checkUserOperationAuthority("protectedGroup_activeProtectedGroup_operateName", SysoplogLevel.normal.getValue(), "ism.drm.protectgroup.auth.enable");
        ProtectGroup pg = null;
        this.validateProtectGroupId(protectgroupId);
        this.checkUserBizObjAuthority("protectedGroup_activeProtectedGroup_operateName", SysoplogLevel.normal.getValue(), protectgroupId);
        try {
            IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
            pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
            pgServices.enableProtectGroup(protectgroupId);
            this.writeSucOperationLog("protectedGroup_activeProtectedGroup_operateName", SysoplogLevel.normal.getValue(), pg.getName(), "", new String[0]);
        }
        catch (Exception e) {
            log.error((Object)("enableProtectGroup error!" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.writeFailedOperationLog("protectedGroup_activeProtectedGroup_operateName", SysoplogLevel.normal.getValue(), pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName()), e);
        }
        return Response.ok().build();
    }

    @Override
    public Response disableProtectGroup(String protectgroupId) {
        this.checkUserOperationAuthority("protectedGroup_disableProtectedGroup_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.disable");
        ProtectGroup pg = null;
        this.validateProtectGroupId(protectgroupId);
        this.checkUserBizObjAuthority("protectedGroup_disableProtectedGroup_operateName", SysoplogLevel.warning.getValue(), protectgroupId);
        try {
            IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
            pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
            pgServices.disableProtectGroup(protectgroupId);
            this.writeSucOperationLog("protectedGroup_disableProtectedGroup_operateName", SysoplogLevel.warning.getValue(), pg.getName(), "", new String[0]);
        }
        catch (Exception e) {
            log.error((Object)("disableProtectGroup error!" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.writeFailedOperationLog("protectedGroup_disableProtectedGroup_operateName", SysoplogLevel.warning.getValue(), pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName()), e);
        }
        return Response.ok().build();
    }

    @Override
    public Response refreshProtectGroup(String protectgroupId) {
        this.checkUserOperationAuthority("protectedGroup_refreshProtectedGroup_operateName", SysoplogLevel.info.getValue(), "ism.drm.protectgroup.auth.refresh");
        ProtectGroup pg = null;
        this.validateProtectGroupId(protectgroupId);
        this.checkUserBizObjAuthority("protectedGroup_refreshProtectedGroup_operateName", SysoplogLevel.info.getValue(), protectgroupId);
        try {
            IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
            pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
            if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
                throw new LegoCheckedException(1073947453L);
            }
            pgServices.refreshProtectGroup(protectgroupId);
            this.writeSucOperationLog("protectedGroup_refreshProtectedGroup_operateName", SysoplogLevel.info.getValue(), pg.getName(), "", new String[0]);
        }
        catch (Exception e) {
            log.error((Object)("refreshProtectGroup error!" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.writeFailedOperationLog("protectedGroup_refreshProtectedGroup_operateName", SysoplogLevel.info.getValue(), pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName()), e);
        }
        return Response.ok().build();
    }

    @Override
    public Response delProtectGroup(String protectgroupId) {
        this.checkUserOperationAuthority("protectedGroup_delete_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.delete");
        ProtectGroup pg = null;
        this.validateProtectGroupId(protectgroupId);
        this.checkUserBizObjAuthority("protectedGroup_delete_operateName", SysoplogLevel.warning.getValue(), protectgroupId);
        long taskId = -1L;
        try {
            IProtectGroupService pgServices = this.getService();
            pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
            if (pg == null) {
                log.error((Object)("protectgroup [id:" + protectgroupId + "] is not existed!"), 90160758784001L);
                throw new LegoCheckedException(1073947394L);
            }
            if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
                throw new LegoCheckedException(1073947453L);
            }
            taskId = pgServices.deleteProtectGroup(protectgroupId, Boolean.valueOf(this.isMachineToMachineReq()));
            this.writeSucOperationLog("protectedGroup_delete_operateName", SysoplogLevel.warning.getValue(), pg.getName(), "", new String[0]);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("protectedGroup_delete_operateName", SysoplogLevel.warning.getValue(), pg == null ? "" : (VerifyUtil.isEmpty((String)pg.getName()) ? "" : pg.getName()), e);
        }
        JSONObject obj = new JSONObject();
        obj.put((Object)TASK_ID, (Object)taskId);
        return Response.ok((Object)obj.toString()).build();
    }

    @Override
    public String getSupportProtectObjectTypes() {
        IProtectObjectProviderDelegate iProtectObjectProvider = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        log.error((Object)"interface method [getSupportProtectObjectTypes] is invoked!");
        return this.protectObjectListToJsonStr(iProtectObjectProvider.getSupportProtectObjectTypes()).toString();
    }

    @Override
    public String getGroupBriefInfo(String pgId) {
        Map protectGroupDataMap;
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        this.validateProtectGroupId(pgId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), pgId);
        try {
            Long replicaCount;
            IProtectGroupService pgServices = this.getService();
            protectGroupDataMap = pgServices.getProtectGroupBriefInfo(pgId);
            Object propObj = protectGroupDataMap.get("props");
            JSONArray rpoJsonArray = null;
            JSONArray rtoJsonArray = null;
            ProtectGroup pg = pgServices.getProtectGroupBasicInfo(pgId, false);
            if (propObj != null) {
                Map props = (Map)propObj;
                rpoJsonArray = this.extractRPOorRTO(props, "RPO_ITEM_KEY", pg);
                rtoJsonArray = this.extractRPOorRTO(props, "RTO_ITEM_KEY", pg);
            }
            if (PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(pg.getTemplate().getType()) && (replicaCount = Long.valueOf(protectGroupDataMap.get("replicaCount").toString())) != null) {
                protectGroupDataMap.put("replicaCount", replicaCount - 1L);
            }
            ProtectGroup protectGroup = pgServices.getProtectGroupByID(pgId, false);
            Set schedules = protectGroup.getTemplate().getSchedules();
            Long replicaCount2 = Long.valueOf(protectGroupDataMap.get("replicaCount").toString());
            IReplicaService replicaService = this.getBundleService(IReplicaService.class);
            for (Schedule schedule : schedules) {
                if (schedule.getScheduleMode() != 0 || schedule.getPeriodType() != 5 || schedule.getProtectedType() != ScheduleProtectedType.HYPERCDP.getValue() || pg.getPoCount() == 0) continue;
                replicaCount2 = replicaCount2 + (long)replicaService.querySecondProtectGroupReplicaCount(pgId, schedule, null, null).intValue();
            }
            ScheduleFormater.format(new ArrayList<Schedule>(schedules));
            protectGroupDataMap.put("template", protectGroup.getTemplate());
            protectGroupDataMap.put("replicaCount", replicaCount2);
            protectGroupDataMap.put("RPO_ITEM_KEY", rpoJsonArray);
            protectGroupDataMap.put("RTO_ITEM_KEY", rtoJsonArray);
            Iterator it = protectGroupDataMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                if (protectGroupDataMap.get(key) != null) continue;
                it.remove();
            }
        }
        catch (Exception e) {
            log.error((Object)("getGroupBriefInfo error!errormsg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return JSONObject.fromObject((Object)protectGroupDataMap).toString();
    }

    @Override
    public String getPGStatisticInfo(String pgId, DrmEnumDefine.REPORT_TIME_RANGE_E range) {
        int failCount;
        int successCount;
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        this.validateProtectGroupId(pgId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), pgId);
        IProtectGroupService pgService = this.getBundleService("DRM_Base", IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup protectGroup = pgService.getProtectGroupBasicInfo(pgId, false);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            log.error((Object)"protectgroup is null");
            throw new LegoCheckedException(1073947394L);
        }
        IProtectGroupReportService reportService = this.getBundleService("DRM_Report", IProtectGroupReportService.class.getName(), IProtectGroupReportService.class);
        if (VerifyUtil.isEmpty((Object)range)) {
            range = DrmEnumDefine.REPORT_TIME_RANGE_E.LAST_24_HOURS;
        }
        ProtectGroupStatisticInfo result = null;
        result = protectGroup.isPrimary() ? reportService.getProtectGroupExecutedInfo(pgId, range, this.getCurrentUserId()) : reportService.getRemoteProtectGroupExecutedInfo(pgId, range, this.getCurrentUserId());
        if (result == null) {
            successCount = 0;
            failCount = 0;
        } else {
            successCount = result.getSuccessNum();
            failCount = result.getTotalNum() - result.getSuccessNum();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"successCount", (Object)successCount);
        jsonObject.put((Object)"failCount", (Object)failCount);
        return jsonObject.toString();
    }

    @Override
    public String getAddAvailableProtectObject(int poType, String pgId) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        this.validateProtectGroupId(pgId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), pgId);
        if (!this.checkProtectObjectType(poType)) {
            log.error((Object)("poType is incorrect. poType:" + poType));
            throw new LegoCheckedException(1073947393L);
        }
        IProtectObjectProviderDelegate poService = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        IProtectGroupService pgService = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        Map<String, Object> extParamInQueryParam = this.getExtParamInQueryParam();
        ProtectGroup group = pgService.getProtectGroupByID(pgId, false);
        CommUtils.checkObjectExists(group);
        Set polist = group.getPolist();
        if (polist == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String poProviderSN = null;
        String providerSN = null;
        for (ProtectObject po : polist) {
            if (po.getPoType() == poType) {
                poProviderSN = po.getProviderSN();
                break;
            }
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                log.error((Object)("UsedStorageResourceSet is empty!. poName:" + po.getName()));
                throw new LegoCheckedException(1073947393L);
            }
            Iterator iterator = po.getUsedStorageResourceSet().iterator();
            if (!iterator.hasNext()) continue;
            providerSN = ((ProtectObjectStorageInfo)iterator.next()).getResourceProviderSN();
        }
        if (poProviderSN == null) {
            poProviderSN = providerSN;
        }
        if (poProviderSN == null) {
            log.error((Object)"poProviderSN is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        List poList = poService.getAddAvailableProtectObject(poType, poProviderSN, pgId, extParamInQueryParam);
        return this.protectObjectListToJsonStr(poList).toString();
    }

    @Override
    public Response exportProtectGroup(int poType) {
        this.checkUserOperationAuthority("protectedGroup_exportProtectedGuop_operateName", SysoplogLevel.info.getValue(), "ism.drm.protectgroup.auth.export");
        try {
            if (!this.checkProtectObjectType(poType)) {
                log.error((Object)"poType is incorrect. poType: %s", new Object[]{String.valueOf(poType)});
                throw new LegoCheckedException(1073947393L);
            }
            IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class);
            Locale locale = RequestUtil.getLocale(super.getRequest());
            pgServices.exportProtectGroupByType(super.getCurrentUser(), poType, locale, this.isExportChecked().booleanValue());
            if (this.isExportChecked().booleanValue()) {
                this.writeSucOperationLog("protectedGroup_exportProtectedGuop_operateName", SysoplogLevel.info.getValue(), "allProtectedGroup_objectName", "", new String[0]);
            }
            return Response.ok().build();
        }
        catch (Exception le) {
            this.writeFailedOperationLog("protectedGroup_exportProtectedGuop_operateName", SysoplogLevel.info.getValue(), "poType" + poType, le);
            return Response.ok().build();
        }
    }

    @Override
    public Response downloadfile(Long taskId) {
        this.checkUserOperationAuthority("protectedGroup_downLoadProtectedGuop_operateName", SysoplogLevel.info.getValue(), "ism.drm.protectgroup.auth.export");
        BatchOperationResult result = new BatchOperationResult();
        String fileName = null;
        try {
            CommUtils.checkParamEmpty(taskId);
            IBackTaskService service = (IBackTaskService)this.getBundleService("task", "backTask");
            BackTask backTask = service.readTask(taskId.longValue());
            if (backTask == null) {
                log.error((Object)"no backTask exist:%s", new Object[]{String.valueOf(taskId)});
                throw new LegoCheckedException(1073947394L);
            }
            List nameList = URLEncodedUtils.parse((CharSequence)backTask.getTaskLink(), (Charset)StandardCharsets.UTF_8);
            for (NameValuePair pair : nameList) {
                if (!"file".equalsIgnoreCase(pair.getName())) continue;
                fileName = pair.getValue();
                break;
            }
            CommUtils.checkParamEmpty(fileName);
            ProtectGroupExcelUtil util = new ProtectGroupExcelUtil();
            File realPathFile = new File(this.getSession().getServletContext().getRealPath("")).getParentFile();
            if (realPathFile == null || realPathFile.getParentFile() == null) {
                log.error((Object)"Get parent file failed: TaskId:%s", new Object[]{String.valueOf(taskId)});
                throw new LegoCheckedException(1073947394L);
            }
            String exportFolderPath = realPathFile.getParentFile().getCanonicalPath();
            File file = new File(exportFolderPath + "/LegoRuntime/data/export/" + fileName);
            if (!file.exists() || !file.isFile()) {
                log.error((Object)"no file exist:%s", new Object[]{fileName});
                throw new LegoCheckedException(1073947394L);
            }
            String displayName = file.getName();
            int index = displayName.indexOf("-");
            if (index == 0 && displayName.startsWith("-")) {
                index = displayName.indexOf("-", 1);
            }
            if (index < 0) {
                log.error((Object)"no file exist:%s", new Object[]{fileName});
                throw new LegoCheckedException(1073947394L);
            }
            String userIdStr = displayName.substring(0, index);
            if (!NumberUtil.convertToLong((Object)userIdStr).equals(this.getCurrentUserId())) {
                log.error((Object)"file not belongs current user:%s", new Object[]{fileName});
                throw new LegoCheckedException(1073947400L);
            }
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            displayName = "ExportProtectGroup" + displayName.substring(index);
            util.downloadFile(this.getResponse(), file, displayName);
            this.writeSucOperationLog("protectedGroup_downLoadProtectedGuop_operateName", SysoplogLevel.info.getValue(), fileName, "", new String[0]);
            return Response.ok((Object)result).build();
        }
        catch (Exception le) {
            this.writeFailedOperationLog("protectedGroup_downLoadProtectedGuop_operateName", SysoplogLevel.info.getValue(), fileName, le);
            return Response.ok((Object)result).build();
        }
    }

    @Override
    public Response exportProtectGroupLog(String protectGroupId) {
        this.validateProtectGroupId(protectGroupId);
        this.checkUserOperationAuthority("protectedGroup_exportProtectedGroupLog_operateName", SysoplogLevel.info.getValue(), "ism.drm.protectgroup.auth.export");
        this.checkUserBizObjAuthority("protectedGroup_exportProtectedGroupLog_operateName", SysoplogLevel.info.getValue(), protectGroupId);
        BatchOperationResult result = new BatchOperationResult();
        ProtectGroup protectGroup = null;
        try {
            protectGroup = this.getBundleService(IProtectGroupService.class).getProtectGroupByID(protectGroupId, false);
            CommUtils.checkObjectExists(protectGroup);
            if (this.validateIsHypermetro(protectGroup) || this.validateIsReplication(protectGroup)) {
                throw new LegoCheckedException(1073947453L);
            }
            int pageSize = 20001;
            Page pageQueryProtectGroupLogs = this.getService().pageQueryHistoryLogFromAll(0, pageSize, "startTime", false, protectGroupId);
            List protectGroupLogs = pageQueryProtectGroupLogs.getResult();
            CommUtils.checkObjectExists(protectGroupLogs);
            if (protectGroupLogs.size() > 20000) {
                throw new LegoCheckedException(1574L);
            }
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            this.exportLogHelper(protectGroupLogs, result, protectGroup);
            this.writeSucOperationLog("protectedGroup_exportProtectedGroupLog_operateName", SysoplogLevel.info.getValue(), protectGroup.getName(), "", new String[0]);
        }
        catch (Exception e) {
            log.error((Object)("Export protectGroup log failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.writeFailedOperationLog("protectedGroup_exportProtectedGroupLog_operateName", SysoplogLevel.info.getValue(), protectGroup == null ? "" : protectGroup.getName(), e);
        }
        return Response.ok((Object)result).build();
    }

    @Override
    public Response exportProtectGroupLogDetails(String protectGroupId, int logId) {
        this.validateProtectGroupId(protectGroupId);
        this.validateLogId(logId);
        this.checkUserOperationAuthority("protectedGroup_exportProtectedGroupLogDetail_operateName", SysoplogLevel.info.getValue(), "ism.drm.protectgroup.auth.scan");
        this.checkUserBizObjAuthority("protectedGroup_exportProtectedGroupLogDetail_operateName", SysoplogLevel.info.getValue(), protectGroupId);
        BatchOperationResult result = new BatchOperationResult();
        ProtectGroup pg = null;
        try {
            List pgLogDetails = this.getService().queryHistoryLogDetailFromAll(logId, protectGroupId);
            CommUtils.checkObjectExists(pgLogDetails);
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            pg = this.getService().getProtectGroupByID(protectGroupId, false);
            this.exportDetailsHelper(pgLogDetails, result, pg.getName());
            this.writeSucOperationLog("protectedGroup_exportProtectedGroupLogDetail_operateName", SysoplogLevel.info.getValue(), pg.getName(), "", new String[0]);
        }
        catch (Exception e) {
            log.error((Object)("Export protectGroup log details failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.writeFailedOperationLog("protectedGroup_exportProtectedGroupLogDetail_operateName", SysoplogLevel.info.getValue(), pg == null ? "" : pg.getName(), e);
        }
        return Response.ok((Object)result).build();
    }

    private void exportDetailsHelper(List<ProtectGroupLogDetail> pgList, BatchOperationResult result, String pgName) {
        ProtectGroupExcelDetailsOperator details = new ProtectGroupExcelDetailsOperator(this);
        FileOutputStream fileOutputStream = null;
        try {
            Workbook wb = details.createExportExcel(pgList, result);
            File excelFile = new File(FileExcelUtil.getExportCSVFilePath(this.getSession(), pgName, pgList));
            fileOutputStream = new FileOutputStream(excelFile);
            wb.write((OutputStream)fileOutputStream);
            DownloadFileUtil.downloadFile(this.getResponse(), this.getRequest(), excelFile);
        }
        catch (LegoCheckedException e) {
            log.error((Object)"Creating exported excel failed.", (Throwable)e, 90160758784001L);
            throw e;
        }
        catch (Exception ex) {
            log.error((Object)("Export protectGroup log details failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)ex)));
            throw new LegoCheckedException(1073948423L, (Throwable)ex);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e, 90160758784000L);
                }
            }
        }
    }

    private void exportLogHelper(List<ProtectGroupLog> protectGroupLogs, BatchOperationResult result, ProtectGroup protectGroup) {
        ProtectGroupLogExcelOperator operator = new ProtectGroupLogExcelOperator(this);
        FileOutputStream fileOutputStream = null;
        try {
            Workbook wb = operator.createExportExcel(protectGroupLogs, result);
            File excelFile = new File(FileExcelUtil.createTempDownloadPath(this.getSession(), protectGroup.getName(), null, "xlsx"));
            fileOutputStream = new FileOutputStream(excelFile);
            wb.write((OutputStream)fileOutputStream);
            DownloadFileUtil.downloadLogFile(this.getResponse(), this.getRequest(), excelFile);
        }
        catch (LegoCheckedException e) {
            log.error((Object)"Creating exported excel failed.", (Throwable)e, 90160758784001L);
            throw e;
        }
        catch (Exception ex) {
            log.error((Object)("Export protectGroup log failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)ex)));
            throw new LegoCheckedException(1073948423L, (Throwable)ex);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e, 90160758784000L);
                }
            }
        }
    }

    @Override
    public String checkProtectGroupName(String pgname) {
        if (!CommUtil.checkDrmNameParam((String)pgname)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        JSONObject resultObject = new JSONObject();
        boolean isNotExisted = true;
        try {
            IProtectGroupService pgServices = this.getService();
            isNotExisted = pgServices.checkGroupName(null, pgname);
        }
        catch (Exception e) {
            log.error((Object)("checkGroupName failed. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        resultObject.put((Object)"isExisted", (Object)(!isNotExisted ? 1 : 0));
        return resultObject.toString();
    }

    @Override
    public String pageQueryAddAvailableProtectObject(String protectGroupId, int poType, String orderBy, String orderType, String filterName, String filterValue) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), "ism.drm.protectgroup.auth.scan");
        Map<String, Object> queryParam = this.getExtParamInQueryParam();
        PageParameter pageParame = this.getPageParameter();
        Integer startPage = pageParame.getStartPage();
        Integer pageSize = pageParame.getPageSize();
        if (!this.checkProtectObjectType(poType)) {
            log.error((Object)("poType is incorrect. poType:" + poType));
            throw new LegoCheckedException(1073947393L);
        }
        this.validateProtectGroupId(protectGroupId);
        if (!VerifyUtil.isEmpty((String)filterName) && !CommonUtil.isValidDbColumn((String)filterName)) {
            log.error((Object)"filterName is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkLongText((String)filterValue)) {
            log.error((Object)"filterValue is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.warning.getValue(), protectGroupId);
        IProtectGroupService pgServices = this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupByID(protectGroupId, false);
        String deviceSn = pg.getPoProviderSN();
        queryParam.put("orderBy", orderBy);
        queryParam.put("pageSize", pageSize);
        queryParam.put("pageIndex", startPage);
        queryParam.put("orderType", orderType);
        queryParam.put("userId", this.getCurrentUserId());
        queryParam.put("pg", pg);
        if (!VerifyUtil.isEmpty((String)filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            queryParam.put("filterName", filterName);
            queryParam.put("filterValue", filterValue);
        }
        IProtectObjectProviderDelegate poProvider = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        List poList = poProvider.getAddAvailableProtectObject(poType, deviceSn, protectGroupId, queryParam);
        Map<String, Object> queryAllParam = this.getExtParamInQueryParam();
        queryAllParam.put("pg", pg);
        if (!VerifyUtil.isEmpty((String)filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            queryAllParam.put("filterName", filterName);
            queryAllParam.put("filterValue", filterValue);
        }
        queryAllParam.put("userId", this.getCurrentUserId());
        List poAllList = poProvider.getAddAvailableProtectObject(poType, deviceSn, protectGroupId, queryAllParam);
        int totalCount = 0;
        if (null != poAllList) {
            totalCount = poAllList.size();
        }
        String records = this.protectObjectListToJsonStr(poList).toString();
        JSONObject result = new JSONObject();
        result.put((Object)"totalCount", (Object)totalCount);
        result.put((Object)"records", (Object)records);
        return result.toString();
    }
}

