/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.group;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.schedule.sdk.model.RetentionPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleRangeTime;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProtectGroupValidator {
    private static Log log = LogFactory.getInstance(ProtectGroupValidator.class);
    private static List<Integer> periodTypeList = Arrays.asList(0, 1, 2, 3, 4, 5);
    private static final List<Integer> SYNC_RATE_TEMPLATE_TYPE_LIST = Arrays.asList(0, 1, 4, 3, 6, 5, 18, 20, 23, 24, 22, 21, 34, 37, 35, 36, 33);

    public static void updateProtectGroupBasicInfoCheck(String protectGroupId, String protectGroupName, String description) {
        if (VerifyUtil.isEmpty((String)protectGroupId) || !CommUtils.checkDrmNameParam(protectGroupName) || !CommUtils.checkDrmDescParam(description) || protectGroupName.equals("null")) {
            log.error((Object)("protectGroupId:" + protectGroupId + ",protectGroupName:" + protectGroupName + ", description:" + description + ",protectGroupName:" + protectGroupName));
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void dealScheduleWhenCreatingProtectGroup(PolicyTemplate template) {
        HashSet<Schedule> addSchedules = new HashSet<Schedule>();
        Set tpSchedules = template.getSchedules();
        for (Schedule schedule : tpSchedules) {
            if (11 == template.getType()) {
                if (VerifyUtil.isEmpty((Object)schedule)) {
                    log.warn((Object)"beginTimeInt is before now!", 90160758784001L);
                    continue;
                }
                if (schedule.getScheduleMode() == 0) {
                    Schedule manualSchedule = new Schedule();
                    manualSchedule.setName(schedule.getName());
                    manualSchedule.setScheduleMode(1);
                    manualSchedule.setPolicyTemplate(template);
                    manualSchedule.setPeriodType(schedule.getPeriodType());
                    manualSchedule.setProtectLocation(schedule.getProtectLocation());
                    manualSchedule.setScheduleId(UUIDGenerator.getUUID());
                    manualSchedule.setProtectedType(schedule.getProtectedType());
                    addSchedules.add(manualSchedule);
                }
                schedule.setScheduleId(UUIDGenerator.getUUID());
                Set rangTimes = schedule.getScheduleRanges();
                if (!VerifyUtil.isEmpty((Collection)rangTimes)) {
                    for (ScheduleRangeTime rangTime : rangTimes) {
                        rangTime.setScheduleRangeId(UUIDGenerator.getUUID());
                    }
                }
            }
            ProtectGroupValidator.checkSchedule(schedule);
        }
        template.getSchedules().addAll(addSchedules);
    }

    public static void checkSchedule(Schedule schedule) {
        if (VerifyUtil.isEmpty((Object)schedule)) {
            log.warn((Object)"beginTimeInt is before now!", 90160758784001L);
            return;
        }
        ProtectGroupValidator.checkScheduleDetailForCreateProtectGroup(schedule);
        schedule.setScheduleId(UUIDGenerator.getUUID());
        Set rangTimes = schedule.getScheduleRanges();
        if (!VerifyUtil.isEmpty((Collection)rangTimes)) {
            for (ScheduleRangeTime rangTime : rangTimes) {
                rangTime.setScheduleRangeId(UUIDGenerator.getUUID());
                rangTime.setSchedule(schedule);
            }
        }
    }

    private static void checkScheduleRange(Set<ScheduleRangeTime> scheduleRanges) {
        if (!VerifyUtil.isEmpty(scheduleRanges)) {
            for (ScheduleRangeTime rang : scheduleRanges) {
                long startDate = rang.getStartTime().getTime();
                long endDate = rang.getEndTime().getTime();
                if (endDate >= startDate) continue;
                log.error((Object)("endDate:" + endDate + ", startDate:" + startDate));
                throw new LegoCheckedException(1073948456L);
            }
        }
    }

    private static long string2Long(String beginTime) {
        long beginTimeInt;
        try {
            beginTimeInt = Long.parseLong(beginTime);
        }
        catch (NumberFormatException e) {
            log.error((Object)("beginTime:" + beginTime));
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        return beginTimeInt;
    }

    private static void checkPeriodType(Schedule newSch, int periodType, int periodInterval) {
        switch (periodType) {
            case 0: {
                ProtectGroupValidator.checkParam(periodInterval, 5, 59);
                break;
            }
            case 1: {
                ProtectGroupValidator.checkParam(periodInterval, 1, 23);
                break;
            }
            case 2: {
                ProtectGroupValidator.checkPeriodTypeDayParam(newSch);
                break;
            }
            case 3: {
                ProtectGroupValidator.checkPeriodTypeWeekParam(newSch);
                break;
            }
            case 4: {
                ProtectGroupValidator.checkPeriodTypeMonthParam(newSch);
                break;
            }
            default: {
                log.error((Object)("periodType:" + periodType));
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private static void checkPeriodTypeMonthParam(Schedule newSch) {
        if (1 == newSch.getLastDayOfMonth()) {
            newSch.setDaysOfMonth("L");
        } else {
            String[] daysArray;
            String daysOfMonth = newSch.getDaysOfMonth();
            if (VerifyUtil.isEmpty((String)daysOfMonth)) {
                log.error((Object)("daysOfMonth is empty. daysOfMonth : " + daysOfMonth), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            for (String day : daysArray = daysOfMonth.split(",")) {
                ProtectGroupValidator.checkParam(NumberUtil.convertToInteger((Object)day, (LegoCheckedException)new LegoCheckedException(1073947393L)), 1, 31);
            }
            String daysOfMonthStr = ProtectGroupValidator.orderNumberStr(daysArray);
            newSch.setDaysOfMonth(daysOfMonthStr);
        }
        ProtectGroupValidator.checkTimePoint(newSch);
    }

    private static String orderNumberStr(String[] numberArray) {
        HashSet<String> numberSet = new HashSet<String>();
        numberSet.addAll(Arrays.asList(numberArray));
        ArrayList numberList = new ArrayList(numberSet);
        Collections.sort(numberList, new Comparator<String>(){

            @Override
            public int compare(String num1, String num2) {
                LegoCheckedException failException = new LegoCheckedException(1073947393L);
                Integer num1Integer = NumberUtil.convertToInteger((Object)num1, (LegoCheckedException)failException);
                Integer num2Integer = NumberUtil.convertToInteger((Object)num2, (LegoCheckedException)failException);
                return num1Integer.compareTo(num2Integer);
            }
        });
        StringBuilder sb = new StringBuilder();
        for (String number : numberList) {
            sb.append(number).append(",");
        }
        String numberStr = sb.substring(0, sb.length() - 1);
        log.debug((Object)("numberStr:" + numberStr));
        return numberStr;
    }

    private static void checkPeriodTypeWeekParam(Schedule newSch) {
        String[] daysOfWeekArray;
        String daysOfWeek = newSch.getDaysOfWeek();
        if (VerifyUtil.isEmpty((String)daysOfWeek)) {
            log.error((Object)("daysOfWeek is empty. daysOfWeek : " + daysOfWeek), 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        for (String day : daysOfWeekArray = daysOfWeek.split(",")) {
            ProtectGroupValidator.checkParam(NumberUtil.convertToInteger((Object)day, (LegoCheckedException)new LegoCheckedException(1073947393L)), 1, 7);
        }
        newSch.setDaysOfWeek(ProtectGroupValidator.arrangeDaysOfWeek(daysOfWeek));
        ProtectGroupValidator.checkTimePoint(newSch);
    }

    private static void checkPeriodTypeDayParam(Schedule newSch) {
        String[] hourArray;
        ProtectGroupValidator.checkParam(newSch.getPeriodInterval(), 1, 31);
        ProtectGroupValidator.checkTimePoint(newSch);
        String abortTaskTime = newSch.getAbortTaskTime();
        if (!VerifyUtil.isEmpty((String)abortTaskTime)) {
            String[] abortTaskTimeArray = abortTaskTime.split(":");
            if (abortTaskTimeArray.length != 2) {
                log.error((Object)("the abortTaskTime format is not ok! abortTaskTime : " + abortTaskTime), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            LegoCheckedException failException = new LegoCheckedException(1073947393L);
            Integer hour = NumberUtil.convertToInteger((Object)abortTaskTimeArray[0], (LegoCheckedException)failException);
            ProtectGroupValidator.checkParam(hour, 0, 23);
            Integer minute = NumberUtil.convertToInteger((Object)abortTaskTimeArray[1], (LegoCheckedException)failException);
            ProtectGroupValidator.checkParam(minute, 0, 59);
            String startTime = newSch.getStartTime();
            long startTimeLong = ProtectGroupValidator.string2Long(startTime);
            Calendar startTimeCalendar = Calendar.getInstance();
            startTimeCalendar.setTimeInMillis(startTimeLong);
            int startHour = startTimeCalendar.get(11);
            int startMin = startTimeCalendar.get(12);
            if (startHour == hour && startMin == minute) {
                log.error((Object)("the abortTaskTime is same to starTime! abortTaskTime : " + abortTaskTime), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
        }
        String hours = newSch.getHours();
        if (newSch.getPeriodInterval() > 1 && (hourArray = hours.split(",")).length != 1) {
            log.error((Object)("if periodInterval was more than one ,the hours size cannot be more than one! hours" + hours), 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static String arrangeDaysOfWeek(String daysOfWeek) {
        log.debug((Object)("daysOfWeek:" + daysOfWeek));
        if (daysOfWeek.length() <= 1) {
            return daysOfWeek;
        }
        String[] weeks = daysOfWeek.split(",");
        HashSet<String> weekSet = new HashSet<String>(Arrays.asList(weeks));
        if (weekSet.contains("1")) {
            weekSet.remove("1");
            if (weekSet.isEmpty()) {
                return "1";
            }
            Object[] sortedArray = weekSet.toArray(new String[weekSet.size()]);
            Arrays.sort(sortedArray);
            StringBuilder sb = new StringBuilder();
            for (Object el : sortedArray) {
                sb.append((String)el + ",");
            }
            sb.append("1");
            return sb.toString();
        }
        Object[] sortedArray = weekSet.toArray(new String[weekSet.size()]);
        Arrays.sort(sortedArray);
        StringBuilder sb = new StringBuilder();
        for (Object el : sortedArray) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((String)el);
        }
        return sb.toString();
    }

    private static void checkTimePoint(Schedule newSch) {
        String[] hourArray;
        String hours = newSch.getHours();
        String minutes = newSch.getMinutes();
        String seconds = newSch.getSeconds();
        for (String hour : hourArray = hours.split(",")) {
            ProtectGroupValidator.checkParam(NumberUtil.convertToInteger((Object)hour, (LegoCheckedException)new LegoCheckedException(1073947393L)), 0, 23);
        }
        newSch.setHours(ProtectGroupValidator.orderNumberStr(hourArray));
        ProtectGroupValidator.checkParam(NumberUtil.convertToInteger((Object)minutes, (LegoCheckedException)new LegoCheckedException(1073947393L)), 0, 59);
        String abortTaskTime = newSch.getAbortTaskTime();
        if (hourArray.length > 1 && !VerifyUtil.isEmpty((String)abortTaskTime)) {
            log.error((Object)("when more than one time, the abortTaskTime must be empty!abortTaskTime:" + abortTaskTime), 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        if (newSch.getPeriodType() != 2 && !VerifyUtil.isEmpty((String)abortTaskTime)) {
            log.error((Object)("abortTaskTime is not empty! abortTaskTime : " + abortTaskTime + ", periodType : " + newSch.getPeriodType()), 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!VerifyUtil.isEmpty((String)seconds)) {
            ProtectGroupValidator.checkParam(NumberUtil.convertToInteger((Object)seconds, (LegoCheckedException)new LegoCheckedException(1073947393L)), 0, 59);
        }
    }

    public static void checkScheduleDetailForModifyPolicy(Schedule newSch) {
        ProtectGroupValidator.checkScheduleDetail(newSch);
        ProtectGroupValidator.setScheduleRanges(newSch);
    }

    public static void checkScheduleDetailForCreateProtectGroup(Schedule newSch) {
        ProtectGroupValidator.checkScheduleDetail(newSch);
    }

    private static void checkScheduleDetail(Schedule newSch) {
        if (newSch == null) {
            log.error((Object)"newSch is null!", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupValidator.checkRetentionPolicy(newSch);
        ProtectGroupValidator.checkPeriod(newSch);
    }

    private static void checkPeriod(Schedule newSch) {
        int scheduleModel = newSch.getScheduleMode();
        String beginTime = newSch.getStartTime();
        String endTime = newSch.getEndTime();
        Set scheduleRanges = newSch.getScheduleRanges();
        int periodType = newSch.getPeriodType();
        int periodInterval = newSch.getPeriodInterval();
        if (1 == scheduleModel) {
            newSch.setStartTime(null);
            newSch.setEndTime(null);
            return;
        }
        if (5 == periodType) {
            ProtectGroupValidator.checkPeriodTypeSecondParam(newSch);
            newSch.setStartTime(null);
            newSch.setEndTime(null);
            return;
        }
        if (VerifyUtil.isEmpty((String)beginTime) || !periodTypeList.contains(periodType)) {
            throw new LegoCheckedException(1073947393L);
        }
        Date beginDate = CommUtils.parseDate(beginTime);
        if (null == beginDate) {
            log.error((Object)("beginTime is illegal! beginTime:" + beginTime));
            throw new LegoCheckedException(1073947393L);
        }
        long beginTimeInt = beginDate.getTime();
        if (beginTimeInt < new Date().getTime()) {
            log.error((Object)"beginTime is after current time!", 1073948456L);
            throw new LegoCheckedException(1073948456L);
        }
        newSch.setStartTime(String.valueOf(beginTimeInt));
        if (!VerifyUtil.isEmpty((String)endTime)) {
            Date endDate = CommUtils.parseDate(endTime);
            if (null == endDate) {
                log.error((Object)("endDate is null! endTime:" + endTime));
                throw new LegoCheckedException(1073947393L);
            }
            long endTimeInt = endDate.getTime();
            if (endTimeInt <= beginTimeInt) {
                throw new LegoCheckedException(1073948455L);
            }
            newSch.setEndTime(String.valueOf(endTimeInt));
        }
        ProtectGroupValidator.checkPeriodType(newSch, periodType, periodInterval);
        ProtectGroupValidator.checkScheduleRange(scheduleRanges);
    }

    private static void checkRetentionPolicy(Schedule newSch) {
        RetentionPolicy retentionPolicy = newSch.getRetentionPolicy();
        if (null != retentionPolicy) {
            log.info((Object)"Check retention policy: period type: %s, protected type: %s, policy: %s.", new Object[]{newSch.getPeriodType(), newSch.getProtectedType(), retentionPolicy.toString()});
            if (5 == newSch.getPeriodType()) {
                if (ScheduleProtectedType.HYPERCDP.getValue() == newSch.getProtectedType()) {
                    retentionPolicy.checkCDPCopies();
                } else {
                    retentionPolicy.checkSecondSnapshotCopies();
                }
            } else {
                retentionPolicy.checkCopies();
            }
        }
    }

    private static void setScheduleRanges(Schedule newSch) {
        int periodType = newSch.getPeriodType();
        log.debug((Object)("periodType:" + periodType));
        Set scheduleRanges = newSch.getScheduleRanges();
        HashSet<ScheduleRangeTime> srts = new HashSet<ScheduleRangeTime>();
        if (periodType == 0 || periodType == 1) {
            for (ScheduleRangeTime rangTime : scheduleRanges) {
                rangTime.setScheduleRangeId(UUIDGenerator.getUUID());
                rangTime.setSchedule(newSch);
                srts.add(rangTime);
            }
            newSch.setScheduleRanges(srts);
        } else {
            scheduleRanges.clear();
        }
    }

    private static void checkParam(int value, int min, int maxVal) {
        if (value < min || value > maxVal) {
            log.error((Object)("value:" + value + ", min:" + min + ", maxVal:" + maxVal));
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkPolicyTemplateProps(PolicyTemplate policyTemplate) {
        Map props = policyTemplate.getProps();
        if (policyTemplate.getType() == 17) {
            if (VerifyUtil.isEmpty((Map)props)) {
                log.error((Object)("props is empty! policytemplate type:" + policyTemplate.getType()), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            String protectionRelationStr = (String)props.get("protectionRelation");
            ProtectGroupValidator.checkProtecionRelation(protectionRelationStr);
        }
        ProtectGroupValidator.checkConfigRpoParam(props);
    }

    private static void checkConfigRpoParam(Map<String, String> props) {
        if (VerifyUtil.isEmpty(props)) {
            return;
        }
        String rpoSetingStr = props.get("RPO_SETTINGS");
        if (VerifyUtil.isEmpty((String)rpoSetingStr)) {
            log.debug((Object)"rpoSetingStr is empty!");
            return;
        }
        JSONObject rpoObj = JSONObject.fromObject((Object)rpoSetingStr);
        Set keySet = rpoObj.keySet();
        for (String protectLocationStr : keySet) {
            if (null == protectLocationStr || !protectLocationStr.startsWith("ProtectLocation_")) {
                log.error((Object)("protectLocationStr is illegal!rpoSetingStr:" + rpoSetingStr));
                throw new LegoCheckedException(1073947393L);
            }
            Object protectLocationObj = rpoObj.get(protectLocationStr);
            if (null == protectLocationObj) {
                log.error((Object)("protectLocationObj is null!rpoSetingStr:" + rpoSetingStr));
                throw new LegoCheckedException(1073947393L);
            }
            JSONObject value = JSONObject.fromObject((Object)protectLocationObj);
            Object enableRpoChecking = value.get("ENABLE_RPO_CHECKING");
            if (!(enableRpoChecking instanceof Boolean)) {
                log.error((Object)("enableRpoChecking is not boolean!rpoSetingStr:" + rpoSetingStr));
                throw new LegoCheckedException(1073947393L);
            }
            Boolean enableRpoCheck = (Boolean)enableRpoChecking;
            if (!enableRpoCheck.booleanValue()) continue;
            Object rpoSettingValue = value.get("RPO_SETTING_VALUE");
            if (null == rpoSettingValue) {
                log.error((Object)("rpoSettingValue is null!rpoSetingStr:" + rpoSetingStr));
                throw new LegoCheckedException(1073947393L);
            }
            JSONObject rpoSettingObj = JSONObject.fromObject((Object)rpoSettingValue);
            int day = rpoSettingObj.getInt("DAY");
            CommUtils.valueOfInt(day, 0, 31);
            int hour = rpoSettingObj.getInt("HOUR");
            CommUtils.valueOfInt(hour, 0, 23);
            int minute = rpoSettingObj.getInt("MINUTE");
            if (day > 0 || hour > 0) {
                CommUtils.valueOfInt(minute, 0, 59);
                continue;
            }
            CommUtils.valueOfInt(minute, 5, 59);
        }
    }

    private static void checkProtecionRelation(String protectionRelationStr) {
        if (VerifyUtil.isEmpty((String)protectionRelationStr)) {
            log.debug((Object)"protectionRelationStr is empty!", 1073947393L);
            return;
        }
        JSONObject protectionRelationObj = JSONObject.fromObject((Object)protectionRelationStr);
        CommUtils.checkParamEmpty(ProtectGroupValidator.getJsonValue(protectionRelationObj, "srcResourceId"), ProtectGroupValidator.getJsonValue(protectionRelationObj, "srcResourceProviderSn"), ProtectGroupValidator.getJsonValue(protectionRelationObj, "srcSiteId"));
        JSONArray jsonArray = protectionRelationObj.getJSONArray("targetResources");
        if (jsonArray == null || jsonArray.size() == 0) {
            log.error((Object)("targetResources is empty! protectionRelationStr:" + protectionRelationStr), 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            JSONObject prJsonObj = JSONObject.fromObject(iterator.next());
            CommUtils.checkParamEmpty(ProtectGroupValidator.getJsonValue(prJsonObj, "srcResourceId"), ProtectGroupValidator.getJsonValue(prJsonObj, "srcResourceProviderSn"), ProtectGroupValidator.getJsonValue(prJsonObj, "srcSiteId"));
        }
    }

    private static String getJsonValue(JSONObject jsonObj, String fieldName) {
        return jsonObj.get(fieldName) != null ? jsonObj.getString(fieldName) : "";
    }

    public static void checkPolicyTemplateSyncRate(int type, PolicyTemplate policyTemplate) {
        if (!SYNC_RATE_TEMPLATE_TYPE_LIST.contains(type)) {
            return;
        }
        Map props = policyTemplate.getProps();
        if (!props.containsKey("syncRateRecords")) {
            log.error((Object)"checkSyncRateRecords not Contains SYNC_RATE_RECORDS");
            throw new LegoCheckedException(1073947393L);
        }
        String syncRateRecordsStr = (String)props.get("syncRateRecords");
        try {
            ProtectGroupValidator.checkSyncRateRecords(syncRateRecordsStr);
        }
        catch (LegoCheckedException e) {
            log.error((Object)"checkSyncRateRecords not success", (Throwable)e);
            ExceptionUtil.rethrowException((Exception)((Object)e), (String)"", (long)1073947393L, (String[])new String[0]);
        }
        catch (Exception e) {
            log.error((Object)("checkSyncRateRecords not success" + ExceptionUtil.getErrorMessage((Throwable)e)));
            ExceptionUtil.rethrowException((Exception)e, (String)"", (long)1073947393L, (String[])new String[0]);
        }
    }

    private static void checkSyncRateRecords(String syncRateRecordsStr) {
        if (VerifyUtil.isEmpty((String)syncRateRecordsStr)) {
            log.error((Object)"syncRateRecordsStr's value is Empty!");
            throw new LegoCheckedException(1073947393L);
        }
        JSONArray syncRateJson = JSONArray.fromObject((Object)syncRateRecordsStr);
        if (!VerifyUtil.isEmpty((Collection)syncRateJson)) {
            Iterator iterator = syncRateJson.iterator();
            while (iterator.hasNext()) {
                JSONObject prJsonObj = JSONObject.fromObject(iterator.next());
                if (!prJsonObj.containsKey((Object)"startTime")) {
                    log.error((Object)"syncRatePolicy not contain startTime!", 1073947393L);
                    throw new LegoCheckedException(1073947393L);
                }
                String startTime = ProtectGroupValidator.getJsonValue(prJsonObj, "startTime");
                if (!prJsonObj.containsKey((Object)"endTime")) {
                    log.error((Object)"syncRatePolicy not contain endTime!", 1073947393L);
                    throw new LegoCheckedException(1073947393L);
                }
                String endTime = ProtectGroupValidator.getJsonValue(prJsonObj, "endTime");
                if (!prJsonObj.containsKey((Object)"protectLocation")) {
                    log.error((Object)"syncRatePolicy not contain protectLocation!", 1073947393L);
                    throw new LegoCheckedException(1073947393L);
                }
                String protectLocationStr = ProtectGroupValidator.getJsonValue(prJsonObj, "protectLocation");
                if (!prJsonObj.containsKey((Object)"syncRateLevel")) {
                    log.error((Object)"syncRatePolicy not contain syncRateLevel!", 1073947393L);
                    throw new LegoCheckedException(1073947393L);
                }
                String syncRateLevelStr = ProtectGroupValidator.getJsonValue(prJsonObj, "syncRateLevel");
                ProtectGroupValidator.checkIsSyncRateParamLegal(startTime, endTime, syncRateLevelStr, protectLocationStr);
            }
        }
    }

    private static void checkIsSyncRateParamLegal(String startTime, String endTime, String speedLevel, String protectLocation) {
        if (VerifyUtil.isEmpty((String)startTime) || VerifyUtil.isEmpty((String)endTime) || VerifyUtil.isEmpty((String)speedLevel) || VerifyUtil.isEmpty((String)protectLocation)) {
            log.error((Object)"syncRateLevel's param is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupValidator.checkStartTimeOrEndTime(startTime);
        ProtectGroupValidator.checkStartTimeOrEndTime(endTime);
        ProtectGroupValidator.checkSyncRateLevel(speedLevel);
        ProtectGroupValidator.checkProtectLocation(protectLocation);
    }

    private static void checkSyncRateLevel(String syncRateLevel) {
        syncRateLevel = Normalizer.normalize(syncRateLevel, Normalizer.Form.NFKC);
        String regex = "^[0-9]$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(syncRateLevel);
        if (!matcher.matches()) {
            log.error((Object)"SyncRateLevel is illegal!", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        Set<Integer> allSpeedLevel = ProtectGroupValidator.getAllSpeedLevel();
        if (!allSpeedLevel.contains(NumberUtil.parseInteger((Object)syncRateLevel))) {
            log.error((Object)"syncRateLevel is illegal!", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkProtectLocation(String protectLocation) {
        protectLocation = Normalizer.normalize(protectLocation, Normalizer.Form.NFKC);
        String regex = "^[0-9]$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(protectLocation);
        if (!matcher.matches()) {
            log.error((Object)"protectLocation is illegal!", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        Set<Integer> allProtectLocation = ProtectGroupValidator.getAllProtectLocation();
        if (!allProtectLocation.contains(NumberUtil.parseInteger((Object)protectLocation))) {
            log.error((Object)"protectLocation is illegal!", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkStartTimeOrEndTime(String time) {
        time = Normalizer.normalize(time, Normalizer.Form.NFKC);
        String regex = "^([01]?\\d|2[0-3]):[0][0]$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(time);
        if (!matcher.matches()) {
            log.error((Object)"startTime or EndTime is illegal!", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkIsTimeOverlap(List<String> startTimes, List<String> endTimes) {
        if (ProtectGroupValidator.checkIsAllDay(startTimes, endTimes)) {
            log.error((Object)"startTime and EndTime not 24 hours!", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        for (int i = 0; i < startTimes.size() - 1; ++i) {
            if (!ProtectGroupValidator.checkIsTimeContinuous(startTimes, endTimes, i)) continue;
            log.error((Object)"startTime and EndTime are confilct!", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static boolean checkIsTimeContinuous(List<String> startTimes, List<String> endTimes, int i) {
        if (startTimes.get(i + 1).length() >= 5 && endTimes.get(i).length() >= 5) {
            String endTime;
            String startTime = startTimes.get(i + 1).substring(startTimes.get(i + 1).length() - 5, startTimes.get(i + 1).length() - 3).trim();
            return !startTime.equals(endTime = endTimes.get(i).substring(endTimes.get(i).length() - 5, endTimes.get(i).length() - 3).trim());
        }
        return true;
    }

    private static boolean checkIsAllDay(List<String> startTimes, List<String> endTimes) {
        if (startTimes.get(0).length() >= 5 && endTimes.get(0).length() >= 5) {
            String startTime = startTimes.get(0).substring(startTimes.get(0).length() - 5, startTimes.get(0).length() - 3).trim();
            String endTime = endTimes.get(endTimes.size() - 1).substring(endTimes.get(0).length() - 5, endTimes.get(0).length() - 3).trim();
            return 0 != NumberUtil.parseInteger((Object)startTime) || 0 != NumberUtil.parseInteger((Object)endTime);
        }
        return true;
    }

    private static Set<Integer> getAllSpeedLevel() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (DmEnumDefine.SPEED_LEVEL_E speedLevel : DmEnumDefine.SPEED_LEVEL_E.values()) {
            result.add(speedLevel.getValue());
        }
        log.debug((Object)("result:" + result));
        return result;
    }

    private static Set<Integer> getAllProtectLocation() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (DrmEnumDefine.PROTECT_LOCATION protectLocation : DrmEnumDefine.PROTECT_LOCATION.values()) {
            result.add(protectLocation.getValue());
        }
        log.debug((Object)("result:" + result));
        return result;
    }

    private static void checkPeriodTypeSecondParam(Schedule newSch) {
        List<Integer> periodList = Arrays.asList(3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 60, 120, 180, 240);
        if (!periodList.contains(newSch.getPeriodInterval())) {
            log.error((Object)("periodInterval is error:" + newSch.getPeriodInterval()));
            throw new LegoCheckedException(1073947393L);
        }
        if (null != newSch.isAppConsistent() && newSch.isAppConsistent().booleanValue()) {
            log.error((Object)("periodInterval not support app consistent:" + newSch.isAppConsistent()));
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkMountConfiguration(PolicyTemplate policyTemplate) {
        if (!PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(policyTemplate.getType())) {
            return;
        }
        String mountCfgString = (String)policyTemplate.getProps().get("AUTOMOUNTCONFIGS");
        if (VerifyUtil.isEmpty((String)mountCfgString)) {
            return;
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)mountCfgString);
        boolean enabled = jsonObject.getBoolean("enabled");
        if (enabled) {
            String jsonString = jsonObject.getString("mountConfigs");
            if (VerifyUtil.isEmpty((String)jsonString)) {
                log.error((Object)"auto mount configs is empty", 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            JSONArray array = JSONArray.fromObject((Object)jsonString);
            List mountCfgs = JSONArray.toCollection((JSONArray)array, MountConfiguration.class);
            if (null == mountCfgs) {
                log.error((Object)"auto mount configs is empty", 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            for (MountConfiguration mountConfiguration : mountCfgs) {
                if (!VerifyUtil.isEmpty((String)mountConfiguration.getSiteId()) && !VerifyUtil.isEmpty((String)mountConfiguration.getHostOrGroupSn()) && !VerifyUtil.isEmpty((String)mountConfiguration.getEndTime()) && !VerifyUtil.isEmpty((String)mountConfiguration.getStartTime())) continue;
                log.error((Object)"auto mount configs's param is empty.", 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    public static boolean checkIsModifyMountConfiguration(PolicyTemplate newPt) {
        if (!PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(newPt.getType()) && 2 != newPt.getType() && 19 != newPt.getType()) {
            return false;
        }
        String mountCfgString = (String)newPt.getProps().get("AUTOMOUNTCONFIGS");
        JSONObject jsonObject = JSONObject.fromObject((Object)mountCfgString);
        boolean isModify = false;
        if (jsonObject.containsKey((Object)"modifyMountConfigs")) {
            isModify = jsonObject.getBoolean("modifyMountConfigs");
        }
        jsonObject.remove((Object)"modifyMountConfigs");
        newPt.getProps().put("AUTOMOUNTCONFIGS", jsonObject.toString());
        return isModify;
    }

    public static boolean isExistsSecondSchedule(PolicyTemplate policyTemplate, int location) {
        if (VerifyUtil.isEmpty((Collection)policyTemplate.getSchedules())) {
            return false;
        }
        for (Schedule schedule : policyTemplate.getSchedules()) {
            if (location != schedule.getProtectLocation() || schedule.getScheduleMode() != 0 || schedule.getPeriodType() != 5) continue;
            return true;
        }
        return false;
    }
}

