/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.rest.service.platform.protection.group.AbstractProtectGroupRestService;
import com.huawei.ism.drm.rest.util.ParmText;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ProtectGroupExcelDetailsOperator {
    private static final int NAME_WIDTH = 10300;
    private static final int STATU_WIDTH = 2647;
    private static final int TIME_WIDTH = 8174;
    private static final int RUN_TIME_WIDTH = 4005;
    private static final int INFO_WIDTH = 11100;
    private static final String HEAD_TAB = "    ";
    private static final Color BACK_GROUND = new Color(144, 144, 144);
    private static Log logger = FELogFactory.getInstance((String)"ui");
    private AbstractProtectGroupRestService protectGroupService;
    private BatchOperationResult result = null;

    public ProtectGroupExcelDetailsOperator(AbstractProtectGroupRestService protectGroupService) {
        this.protectGroupService = protectGroupService;
    }

    public Workbook createExportExcel(List<ProtectGroupLogDetail> protectgroups, BatchOperationResult results) {
        logger.debug((Object)"to create Export Excel..");
        this.result = results;
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        this.createHeader(sheet);
        this.createDataArea(sheet, protectgroups);
        sheet.setColumnWidth(0, 10300);
        sheet.setColumnWidth(1, 2647);
        sheet.setColumnWidth(2, 8174);
        sheet.setColumnWidth(3, 8174);
        sheet.setColumnWidth(4, 4005);
        sheet.setColumnWidth(5, 11100);
        return wb;
    }

    private void createHeader(XSSFSheet sheet) {
        logger.debug((Object)"to create excel header..");
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        this.initialHeaderCellStyle(sheet, cs);
        XSSFRow row0 = sheet.createRow(0);
        Cell cell = row0.createCell(0);
        cell.setCellValue(this.getParm("ism.drm.drp.local.name.label", null));
        cell.setCellStyle((CellStyle)cs);
        CellRangeAddress cra = new CellRangeAddress(0, 1, 0, 0);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(1);
        cell.setCellValue(this.getParm("recovery.term.colum.status.title", null));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 1, 1);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(2);
        cell.setCellValue(this.getParm("ism.drm.protect.group.log.time.start", null));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 2, 2);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(3);
        cell.setCellValue(this.getParm("ism.drm.protect.group.log.time.end", null));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 3, 3);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(4);
        cell.setCellValue(this.getParm("ism.drm.protect.group.log.time.executeTime", null));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 4, 4);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(5);
        cell.setCellValue(this.getParm("recovery.term.abstact.descriptionLabel", null));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 5, 5);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
    }

    private void initialHeaderCellStyle(XSSFSheet sheet, XSSFCellStyle cs) {
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setFillForegroundColor(new XSSFColor(BACK_GROUND));
        cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setFont((Font)font);
    }

    private void setRangeBorder(XSSFSheet sheet, CellRangeAddress cra) {
        logger.debug((Object)"to set range border..");
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
    }

    private void createDataArea(XSSFSheet sheet, List<ProtectGroupLogDetail> protectgroups) {
        int rowIndex = 2;
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        cs.setAlignment(HorizontalAlignment.LEFT);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setWrapText(true);
        ArrayList<BatchOperation> counterror = new ArrayList<BatchOperation>();
        int size = this.setCellsValue(sheet, protectgroups, rowIndex, cs, counterror, 0);
        this.result.setResult(counterror);
        this.result.setFailCount(counterror.size());
        this.result.setTotalCount(size);
    }

    private XSSFCellStyle clone(XSSFCellStyle cs, XSSFSheet sheet) {
        XSSFCellStyle cs1 = sheet.getWorkbook().createCellStyle();
        cs1.setAlignment(cs.getAlignment());
        cs1.setVerticalAlignment(cs.getVerticalAlignment());
        cs1.setBorderLeft(cs.getBorderLeft());
        cs1.setLeftBorderColor(cs.getLeftBorderColor());
        cs1.setBorderTop(cs.getBorderTop());
        cs1.setTopBorderColor(cs.getTopBorderColor());
        cs1.setBorderBottom(cs.getBorderBottom());
        cs1.setBottomBorderColor(cs.getBottomBorderColor());
        cs1.setBorderRight(cs.getBorderRight());
        cs1.setRightBorderColor(cs.getRightBorderColor());
        cs1.setWrapText(cs.getWrapText());
        return cs1;
    }

    private int setCellsValue(XSSFSheet sheet, List<ProtectGroupLogDetail> protectgroups, int rowIndex, XSSFCellStyle cs, List<BatchOperation> counterror, int num) {
        for (ProtectGroupLogDetail pgLog : protectgroups) {
            BatchOperation batchOperation = new BatchOperation();
            XSSFRow mergeRow = sheet.createRow(rowIndex);
            int rowMergeIndex = rowIndex;
            Cell cell = mergeRow.createCell(0);
            cell.setCellValue(this.getTab(num) + this.getParm(pgLog.getTitle(), pgLog.getTitleParams()));
            cell.setCellStyle((CellStyle)cs);
            CellRangeAddress cra = new CellRangeAddress(rowIndex, rowMergeIndex, 0, 0);
            this.setRangeBorder(sheet, cra);
            XSSFCellStyle cs1 = this.clone(cs, sheet);
            cs1.setAlignment(HorizontalAlignment.CENTER);
            cell = mergeRow.createCell(1);
            long poResult = pgLog.getResult();
            this.setResult(cell, poResult);
            cell.setCellStyle((CellStyle)cs1);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 1, 1);
            this.setRangeBorder(sheet, cra);
            cell = mergeRow.createCell(2);
            String startTime = pgLog.getStartTime();
            this.setTimeValue(cell, startTime);
            cell.setCellStyle((CellStyle)cs1);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 2, 2);
            this.setRangeBorder(sheet, cra);
            cell = mergeRow.createCell(3);
            String endTime = pgLog.getEndTime();
            this.setTimeValue(cell, endTime);
            cell.setCellStyle((CellStyle)cs1);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 3, 3);
            this.setRangeBorder(sheet, cra);
            cell = mergeRow.createCell(4);
            String executeTime = this.protectGroupService.calcExecuteTime(pgLog.getStartTime(), pgLog.getEndTime());
            cell.setCellValue(executeTime);
            cell.setCellStyle((CellStyle)cs1);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 4, 4);
            this.setRangeBorder(sheet, cra);
            cell = mergeRow.createCell(5);
            this.setDetail(pgLog, cell);
            cell.setCellStyle((CellStyle)cs);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 5, 5);
            this.setRangeBorder(sheet, cra);
            ++rowIndex;
            this.setCounterror(counterror, batchOperation);
            List list = pgLog.getChildDetails();
            rowIndex = this.setChild(sheet, rowIndex, cs, counterror, num, list);
        }
        return rowIndex;
    }

    private void setTimeValue(Cell cell, String startTime) {
        if (null == startTime || "--".equals(startTime)) {
            cell.setCellValue("--");
        } else {
            cell.setCellValue(CommUtils.formatData(startTime));
        }
    }

    private int setChild(XSSFSheet sheet, int rowIndex, XSSFCellStyle cs, List<BatchOperation> counterror, int num, List<ProtectGroupLogDetail> list) {
        if (!VerifyUtil.isEmpty(list)) {
            int nums = num;
            rowIndex = this.setCellsValue(sheet, list, rowIndex, cs, counterror, ++nums);
        }
        return rowIndex;
    }

    private void setCounterror(List<BatchOperation> counterror, BatchOperation batchOperation) {
        if (!VerifyUtil.isEmpty((String)batchOperation.getTargetName())) {
            counterror.add(batchOperation);
        }
    }

    private void setDetail(ProtectGroupLogDetail pgLog, Cell cell) {
        if (!"--".equals(pgLog.getInfo())) {
            cell.setCellValue(this.getParm(pgLog.getInfo(), pgLog.getInfoParams()));
        } else {
            cell.setCellValue("--");
        }
    }

    private void setResult(Cell cell, long poResult) {
        if (poResult == 0L) {
            cell.setCellValue(this.getParm("ism.drm.report.run.faild.excel.column", ""));
        } else if (poResult == 1L) {
            cell.setCellValue(this.getParm("ism.drm.report.run.success.excel.column", ""));
        } else {
            cell.setCellValue("--");
        }
    }

    private String getTab(int n) {
        StringBuffer str = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            str.append(HEAD_TAB);
        }
        return str.toString();
    }

    private String getParm(String key, String parm) {
        ArrayList<ParmText> list = new ArrayList<ParmText>();
        ParmText pt = null;
        int num = this.isParmToParm(parm);
        if (-1 == num) {
            pt = new ParmText();
            pt.setKey(key);
            pt.setParms(null);
            list.add(pt);
        } else if (0 == num) {
            String[] arr = parm.split(";");
            pt = new ParmText();
            pt.setKey(key);
            pt.setParms(arr);
            list.add(pt);
        }
        return this.toParm(list);
    }

    private String toParm(List<ParmText> list) {
        StringBuffer sText = new StringBuffer("");
        for (ParmText pt : list) {
            sText.append(this.protectGroupService.getText(pt.getKey(), pt.getParms()));
        }
        return sText.toString();
    }

    private int isParmToParm(String parm) {
        if (VerifyUtil.isEmpty((String)parm) || "--".equals(parm)) {
            return -1;
        }
        return 0;
    }
}

