/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.recovery.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.rest.service.platform.recovery.AbstractRecoveryPlanRestService;
import com.huawei.ism.drm.rest.util.ParmText;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RecoveryPlanExcelDetailsOperator {
    private static final int NAME_WIDTH = 10300;
    private static final int STATU_WIDTH = 2647;
    private static final int TIME_WIDTH = 8174;
    private static final int RUN_TIME_WIDTH = 4005;
    private static final int INFO_WIDTH = 11100;
    private static final String HEAD_TAB = "    ";
    private static final Color BACK_GROUND = new Color(144, 144, 144);
    private static final String IP_REGEX = ".(2[5][0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})";
    private static Log logger = FELogFactory.getInstance((String)"ui");
    private AbstractRecoveryPlanRestService recoveryPlanService;
    private BatchOperationResult result = null;

    public RecoveryPlanExcelDetailsOperator(AbstractRecoveryPlanRestService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public Workbook createExportExcel(List<RecoveryProcessorDetail> recoveryplans, BatchOperationResult results) {
        logger.debug((Object)"to create Export Excel..");
        this.result = results;
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        this.createHeader(sheet);
        this.createDataArea(sheet, recoveryplans);
        sheet.setColumnWidth(0, 10300);
        sheet.setColumnWidth(1, 2647);
        sheet.setColumnWidth(2, 8174);
        sheet.setColumnWidth(3, 8174);
        sheet.setColumnWidth(4, 4005);
        sheet.setColumnWidth(5, 11100);
        return wb;
    }

    private void createHeader(XSSFSheet sheet) {
        logger.debug((Object)"to create excel header..");
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        this.initialHeaderCellStyle(sheet, cs);
        XSSFRow row0 = sheet.createRow(0);
        Cell cell = row0.createCell(0);
        cell.setCellValue(this.getParm("ism.drm.drp.local.name.label", null));
        cell.setCellStyle((CellStyle)cs);
        CellRangeAddress cra = new CellRangeAddress(0, 1, 0, 0);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(1);
        cell.setCellValue(this.getParm("recovery.term.colum.status.title", null));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 1, 1);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(2);
        cell.setCellValue(this.getParm("ism.drm.protect.group.log.time.start", null));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 2, 2);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(3);
        cell.setCellValue(this.getParm("ism.drm.protect.group.log.time.end", null));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 3, 3);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(4);
        cell.setCellValue(this.getParm("ism.drm.protect.group.log.time.executeTime", null));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 4, 4);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(5);
        cell.setCellValue(this.getParm("recovery.term.abstact.descriptionLabel", null));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 5, 5);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
    }

    private void initialHeaderCellStyle(XSSFSheet sheet, XSSFCellStyle cs) {
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setFillForegroundColor(new XSSFColor(BACK_GROUND));
        cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setFont((Font)font);
    }

    private void setRangeBorder(XSSFSheet sheet, CellRangeAddress cra) {
        logger.debug((Object)"to set range border..");
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
    }

    private void createDataArea(XSSFSheet sheet, List<RecoveryProcessorDetail> recoveryplans) {
        int rowIndex = 2;
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        cs.setAlignment(HorizontalAlignment.LEFT);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setWrapText(true);
        ArrayList<BatchOperation> counterror = new ArrayList<BatchOperation>();
        int size = this.setCellsValue(sheet, recoveryplans, rowIndex, cs, counterror, 0);
        this.result.setResult(counterror);
        this.result.setFailCount(counterror.size());
        this.result.setTotalCount(size);
    }

    private XSSFCellStyle clone(XSSFCellStyle cs, XSSFSheet sheet) {
        XSSFCellStyle cs1 = sheet.getWorkbook().createCellStyle();
        cs1.setAlignment(cs.getAlignment());
        cs1.setVerticalAlignment(cs.getVerticalAlignment());
        cs1.setBorderLeft(cs.getBorderLeft());
        cs1.setLeftBorderColor(cs.getLeftBorderColor());
        cs1.setBorderTop(cs.getBorderTop());
        cs1.setTopBorderColor(cs.getTopBorderColor());
        cs1.setBorderBottom(cs.getBorderBottom());
        cs1.setBottomBorderColor(cs.getBottomBorderColor());
        cs1.setBorderRight(cs.getBorderRight());
        cs1.setRightBorderColor(cs.getRightBorderColor());
        cs1.setWrapText(cs.getWrapText());
        return cs1;
    }

    private int setCellsValue(XSSFSheet sheet, List<RecoveryProcessorDetail> recoveryplans, int rowIndex, XSSFCellStyle cs, List<BatchOperation> counterror, int num) {
        for (RecoveryProcessorDetail rpLog : recoveryplans) {
            BatchOperation batchOperation = new BatchOperation();
            XSSFRow mergeRow = sheet.createRow(rowIndex);
            int rowMergeIndex = rowIndex;
            Cell cell = mergeRow.createCell(0);
            cell.setCellValue(this.getTab(num) + this.getParm(rpLog.getProcessName(), rpLog.getProcessNameParams()));
            cell.setCellStyle((CellStyle)cs);
            CellRangeAddress cra = new CellRangeAddress(rowIndex, rowMergeIndex, 0, 0);
            this.setRangeBorder(sheet, cra);
            XSSFCellStyle cs1 = this.clone(cs, sheet);
            cs1.setAlignment(HorizontalAlignment.CENTER);
            cell = mergeRow.createCell(1);
            int poResult = rpLog.getProcessStatus();
            this.setResult(cell, poResult);
            cell.setCellStyle((CellStyle)cs1);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 1, 1);
            this.setRangeBorder(sheet, cra);
            cell = mergeRow.createCell(2);
            String startTime = rpLog.getStartTime();
            this.setTimeValue(cell, startTime);
            cell.setCellStyle((CellStyle)cs1);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 2, 2);
            this.setRangeBorder(sheet, cra);
            cell = mergeRow.createCell(3);
            String endTime = rpLog.getEndTime();
            this.setTimeValue(cell, endTime);
            cell.setCellStyle((CellStyle)cs1);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 3, 3);
            this.setRangeBorder(sheet, cra);
            cell = mergeRow.createCell(4);
            String executeTime = this.recoveryPlanService.calcExecuteTime(rpLog.getStartTime(), rpLog.getEndTime());
            cell.setCellValue(executeTime);
            cell.setCellStyle((CellStyle)cs1);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 4, 4);
            this.setRangeBorder(sheet, cra);
            cell = mergeRow.createCell(5);
            this.setDetail(rpLog, cell);
            cell.setCellStyle((CellStyle)cs);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 5, 5);
            this.setRangeBorder(sheet, cra);
            ++rowIndex;
            this.setCounterror(counterror, batchOperation);
            List list = rpLog.getChildDetails();
            rowIndex = this.setChild(sheet, rowIndex, cs, counterror, num, list);
        }
        return rowIndex;
    }

    private void setTimeValue(Cell cell, String startTime) {
        if (null == startTime || "--".equals(startTime)) {
            cell.setCellValue("--");
        } else {
            cell.setCellValue(CommUtils.formatData(startTime));
        }
    }

    private int setChild(XSSFSheet sheet, int rowIndex, XSSFCellStyle cs, List<BatchOperation> counterror, int num, List<RecoveryProcessorDetail> list) {
        if (!VerifyUtil.isEmpty(list)) {
            int nums = num;
            rowIndex = this.setCellsValue(sheet, list, rowIndex, cs, counterror, ++nums);
        }
        return rowIndex;
    }

    private void setCounterror(List<BatchOperation> counterror, BatchOperation batchOperation) {
        if (!VerifyUtil.isEmpty((String)batchOperation.getTargetName())) {
            counterror.add(batchOperation);
        }
    }

    private void setDetail(RecoveryProcessorDetail rpLog, Cell cell) {
        if (VerifyUtil.isEmpty((String)rpLog.getProcessDetail())) {
            cell.setCellValue("--");
        } else {
            cell.setCellValue(this.getParm(rpLog.getProcessDetail(), rpLog.getProcessDetailParams()));
        }
    }

    private void setResult(Cell cell, int poResult) {
        if (poResult == 0) {
            cell.setCellValue(this.getParm("ism.drm.report.run.success.excel.column", null));
        } else if (poResult == 1) {
            cell.setCellValue(this.getParm("ism.drm.report.run.faild.excel.column", null));
        } else if (poResult == 2) {
            cell.setCellValue(this.getParm("recovery.term.abstact.excute.result.part_success", null));
        } else {
            cell.setCellValue("--");
        }
    }

    private String getTab(int n) {
        StringBuffer str = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            str.append(HEAD_TAB);
        }
        return str.toString();
    }

    private String getParm(String key, String parm) {
        ArrayList<ParmText> list = new ArrayList<ParmText>();
        ParmText pt = null;
        int num = this.isParmToParm(parm);
        if (-1 == num) {
            pt = new ParmText();
            pt.setKey(key);
            pt.setParms(null);
            list.add(pt);
            return this.toParm(list);
        }
        JSONArray parms = JSONArray.fromObject((Object)parm);
        if (0 == num) {
            String[] arr = new String[parms.size()];
            for (int i = 0; i < parms.size(); ++i) {
                Object obj = parms.get(i);
                arr[i] = obj.toString();
            }
            pt = new ParmText();
            pt.setKey(key);
            pt.setParms(arr);
            list.add(pt);
        } else if (1 == num) {
            JSONObject job = JSONObject.fromObject((Object)parms.get(0));
            Set keySet = job.keySet();
            this.setList(list, job, keySet);
        }
        return this.toParm(list);
    }

    private void setList(List<ParmText> list, JSONObject job, Set<String> keySet) {
        ParmText pt = null;
        for (String name : keySet) {
            pt = new ParmText();
            Object value = job.get(name);
            JSONObject jsOb = JSONObject.fromObject((Object)JSONArray.fromObject((Object)value).get(0));
            Set jsSet = jsOb.keySet();
            String[] aParm = this.getKeyParm(jsOb, jsSet);
            pt.setKey(name.replaceAll(IP_REGEX, ""));
            pt.setParms(aParm);
            list.add(pt);
        }
    }

    private String[] getKeyParm(JSONObject jsOb, Set<String> jsSet) {
        String[] aParm = new String[jsSet.size()];
        int i = 0;
        for (String jsName : jsSet) {
            Object jsValue = jsOb.get(jsName);
            this.setParms(aParm, i, jsName, jsValue);
            ++i;
        }
        return aParm;
    }

    private void setParms(String[] aParm, int i, String jsName, Object jsValue) {
        String tParm = "";
        if (jsValue instanceof String) {
            String[] toParm = new String[]{jsValue.toString()};
            tParm = this.recoveryPlanService.getText(jsName, toParm);
        } else if (jsValue instanceof JSONArray) {
            tParm = this.recoveryPlanService.getText(jsName, this.getArryParm(jsValue));
        }
        aParm[i] = tParm;
    }

    private String[] getArryParm(Object jsValue) {
        JSONArray ja = (JSONArray)jsValue;
        String[] arr = new String[ja.size()];
        for (int i = 0; i < ja.size(); ++i) {
            arr[i] = ja.get(i).toString();
        }
        return arr;
    }

    private String toParm(List<ParmText> list) {
        StringBuffer sText = new StringBuffer("");
        for (ParmText pt : list) {
            sText.append(this.recoveryPlanService.getText(pt.getKey(), pt.getParms()));
        }
        return sText.toString();
    }

    private int isParmToParm(String parm) {
        if (VerifyUtil.isEmpty((String)parm)) {
            return -1;
        }
        try {
            JSONArray parms = JSONArray.fromObject((Object)parm);
            return this.getType(parms);
        }
        catch (Exception e) {
            logger.info((Object)"parm not a JSONObject.");
            return -1;
        }
    }

    private int getType(JSONArray parms) {
        Iterator iterator = parms.iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            return this.typeValue(obj);
        }
        return -1;
    }

    private int typeValue(Object obj) {
        if (obj instanceof String) {
            return 0;
        }
        if (obj instanceof JSONObject || obj instanceof Map) {
            return 1;
        }
        return -1;
    }
}

