/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.site;

import com.huawei.ism.cbb.base.sdk.util.ValidateUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.site.IManagementServerRestService;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.lego.cbb.nms.north.sdk.service.INorthNmsService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;

public class ManagementServerRestServiceImpl
extends AbstractRestService
implements IManagementServerRestService {
    private static final Log logger = LogFactory.getInstance(ManagementServerRestServiceImpl.class);

    @Override
    public Response removeServer(String uuid) {
        this.checkUserOperationAuthority("server_deleteServer_operateName", 2, "ism.drm.servers.auth.delete");
        if (VerifyUtil.isEmpty((String)uuid) || !ParamChecker.checkGeneralId((String)uuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer server = this.getServerService().getServer(uuid);
        if (null == server) {
            throw new LegoCheckedException(2117645L);
        }
        if (1 != server.getServerType()) {
            throw new LegoCheckedException(1073947393L);
        }
        List sites = this.getSiteService().getSites(uuid);
        if (!VerifyUtil.isEmpty((Collection)sites)) {
            this.checkUserOperationAuthority("site_deleteSite_operateName", 2, "ism.drm.site.auth.delete");
            for (Site site : sites) {
                this.checkUserBizObjAuthority("site_deleteSite_operateName", 2, site.getSiteId());
            }
        }
        String devAlias = VerifyUtil.isEmpty((String)server.getDevAlias()) ? server.getIp() : server.getDevAlias();
        try {
            this.getServerService().removeServer(uuid);
            this.writeSucOperationLog("server_deleteServer_operateName", 2, devAlias, null, null);
        }
        catch (Exception ex) {
            logger.error((Object)("Remove server fail, uuid=" + uuid + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758784000L);
            this.writeFailedOperationLog("server_deleteServer_operateName", 2, devAlias, ex);
        }
        return Response.ok().build();
    }

    @Override
    public Response updateServer(String uuid, ManagementServer server) {
        this.checkUserOperationAuthority("server_modifyServer_operateName", 3, "ism.drm.servers.auth.modify");
        if (VerifyUtil.isEmpty((String)uuid) || !ParamChecker.checkGeneralId((String)uuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (null == server) {
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer replica = this.getServerService().getServer(uuid);
        if (null == replica) {
            throw new LegoCheckedException(2117645L);
        }
        String user = HtmlStringConverter.decodeByLength(server.getUser());
        if (null != user && !VerifyUtil.isEmpty((String)user) && !"SyncAdmin".equals(user)) {
            logger.error((Object)("updateServer user is error :" + user));
            throw new LegoCheckedException(1073947393L);
        }
        String pwd = HtmlStringConverter.decodeByLength(server.getPwd());
        if (null != pwd && !pwd.isEmpty()) {
            ValidateUtil.validate((String)"^.{1,64}$", (String)pwd);
            INorthNmsService nmsService = (INorthNmsService)this.getBundleService("slave", "northNmsService");
            server.setPwd(nmsService.encrypt(pwd));
        } else {
            server.setPwd(null);
        }
        server.setUuid(uuid);
        try {
            this.getServerService().updateServer(server);
            this.writeSucOperLogForUpdateServer(replica, server);
        }
        catch (Exception ex) {
            logger.error((Object)("Update server fail, uuid=" + uuid + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758784000L);
            this.writeFailOperLogForUpdateRemoteServer(replica, ex);
        }
        return Response.ok().build();
    }

    private void writeSucOperLogForUpdateServer(ManagementServer oldInfo, ManagementServer newInfo) {
        if (0 == oldInfo.getServerType()) {
            String[] params = new String[]{oldInfo.getName(), newInfo.getName()};
            this.writeSucOperationLog("server_modifyServer_operateName", 3, oldInfo.getName(), "server_modifyLocalServerName_operateDetail", params);
        } else {
            String devAlias = VerifyUtil.isEmpty((String)oldInfo.getDevAlias()) ? oldInfo.getIp() : oldInfo.getDevAlias();
            String oldAlias = VerifyUtil.isEmpty((String)oldInfo.getDevAlias()) ? "--" : oldInfo.getDevAlias();
            String newAlias = VerifyUtil.isEmpty((String)newInfo.getDevAlias()) ? "--" : newInfo.getDevAlias();
            String oldIp = oldInfo.getIp();
            String newIp = VerifyUtil.isEmpty((String)newInfo.getIp()) ? "--" : newInfo.getIp();
            String[] params = new String[]{oldAlias, newAlias, oldIp, newIp};
            this.writeSucOperationLog("server_modifyServer_operateName", 3, devAlias, "server_modifyRemoteServerInfo_operateDetail", params);
        }
    }

    private void writeFailOperLogForUpdateRemoteServer(ManagementServer oldInfo, Exception ix) {
        String objName = null;
        objName = 0 == oldInfo.getServerType() ? oldInfo.getName() : (VerifyUtil.isEmpty((String)oldInfo.getDevAlias()) ? oldInfo.getIp() : oldInfo.getDevAlias());
        this.writeFailedOperationLog("server_modifyServer_operateName", 3, objName, ix);
    }

    @Override
    public String getServerInfo() {
        this.checkUserOperationAuthority("server_queryServer_operateName", 2, "ism.drm.servers.auth.scan");
        ManagementServer serverInfo = this.getServerService().getServerInfo();
        return this.beanToJson(serverInfo).toString();
    }

    private JSONObject beanToJson(ManagementServer bean) {
        JSONObject json = new JSONObject();
        json.put((Object)"uuid", (Object)bean.getUuid());
        json.put((Object)"name", (Object)bean.getName());
        json.put((Object)"devAlias", (Object)bean.getDevAlias());
        json.put((Object)"status", (Object)bean.getStatus());
        json.put((Object)"ip", (Object)bean.getIp());
        json.put((Object)"port", (Object)bean.getPort());
        json.put((Object)"serverType", (Object)bean.getServerType());
        json.put((Object)"version", (Object)bean.getVersion());
        json.put((Object)"user", (Object)bean.getUser());
        return json;
    }

    @Override
    public String getServers() {
        this.checkUserOperationAuthority("server_queryServer_operateName", 2, "ism.drm.servers.auth.scan");
        List servers = this.getServerService().getServers();
        JSONArray array = new JSONArray();
        for (ManagementServer server : servers) {
            array.add((Object)this.beanToJson(server));
        }
        return array.toString();
    }

    @Override
    public Response refreshServer(String uuid) {
        this.checkUserOperationAuthority("server_refreshServer_operateName", 1, "ism.drm.servers.auth.refresh");
        if (VerifyUtil.isEmpty((String)uuid) || !ParamChecker.checkGeneralId((String)uuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer replica = this.getServerService().getServer(uuid);
        if (null == replica) {
            throw new LegoCheckedException(2117645L);
        }
        if (1 != replica.getServerType()) {
            throw new LegoCheckedException(1073947393L);
        }
        List sites = this.getSiteService().getSites(uuid);
        if (!VerifyUtil.isEmpty((Collection)sites)) {
            this.checkUserOperationAuthority("site_refreshRemoteSite_operateName", 3, "ism.drm.site.auth.refresh");
            for (Site site : sites) {
                this.checkUserBizObjAuthority("site_refreshRemoteSite_operateName", 3, site.getSiteId());
            }
        }
        String alias = VerifyUtil.isEmpty((String)replica.getDevAlias()) ? replica.getIp() : replica.getDevAlias();
        try {
            this.getServerService().refreshServer(uuid, this.getCurrentUserId());
            this.writeSucOperationLog("server_refreshServer_operateName", 1, alias, null, null);
        }
        catch (Exception ex) {
            logger.error((Object)("Refresh server fail, uuid=" + uuid + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758784000L);
            this.writeFailedOperationLog("server_refreshServer_operateName", 1, alias, ex);
        }
        return Response.ok().build();
    }

    private IManagementServerService getServerService() {
        return (IManagementServerService)this.getBundleService("DRM_Base", IManagementServerService.class.getName());
    }

    private void checkAuthParams(String ip, String port, String user, String pwd) {
        if (!(CommUtil.checkDrmIpParam((String)ip) && CommUtil.checkDrmPortParam((String)port) && "SyncAdmin".equals(user))) {
            throw new LegoCheckedException(1073947393L);
        }
        ValidateUtil.validate((String)"^.{1,64}$", (String)pwd);
    }

    private ISiteService getSiteService() {
        return (ISiteService)this.getBundleService("DRM_Base", ISiteService.class.getName());
    }
}

