/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.site;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.site.ISiteRestService;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.ism.drm.util.ReverseObjectSerializableUtils;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class SiteRestServiceImpl
extends AbstractRestService
implements ISiteRestService {
    private static Log logger = LogFactory.getInstance(SiteRestServiceImpl.class);

    @Override
    public String createSite(Site site) {
        this.checkUserOperationAuthority("site_createSite_operateName", 1, "ism.drm.site.auth.add");
        this.checkParam(site);
        JSONObject json = new JSONObject();
        try {
            String siteId = this.getSiteService().createSite(site, this.getCurrentUserId());
            this.writeSucOperationLog("site_createSite_operateName", 1, site.getName(), null, null);
            json.put((Object)"siteId", (Object)siteId);
        }
        catch (Exception e) {
            logger.error((Object)("Create site failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            this.writeFailedOperationLog("site_createSite_operateName", 1, site.getName(), e);
        }
        return json.toString();
    }

    private void checkParam(Site site) {
        if (VerifyUtil.isEmpty((Object)site)) {
            throw new LegoCheckedException(1073947393L);
        }
        String serverUuid = site.getServerUuid();
        if (VerifyUtil.isEmpty((String)serverUuid) || !ParamChecker.checkGeneralId((String)serverUuid)) {
            logger.error((Object)("The serverUuid is invalid, serverUuid=" + serverUuid));
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmNameParam((String)site.getName())) {
            logger.error((Object)("The siteName is invalid, siteName=" + site.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        String siteDesc = HtmlStringConverter.decodeByLength(site.getDescription());
        if (!CommUtil.checkDrmDescParam((String)siteDesc)) {
            logger.error((Object)("The siteDesc is invalid, siteDesc=" + siteDesc));
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralText((String)site.getCloudServiceProvider())) {
            logger.error((Object)("The cloudServiceProvider is invalid, cloudServiceProvider=" + site.getCloudServiceProvider()));
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralText((String)site.getDomainName())) {
            logger.error((Object)("The domainName is invalid, domainName=" + site.getDomainName()));
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)site.getRegionId())) {
            logger.error((Object)("The regionId is invalid, regionId=" + site.getRegionId()));
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)site.getProjectId())) {
            logger.error((Object)("The projectId is invalid, projectId=" + site.getProjectId()));
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralText((String)site.getAk())) {
            logger.error((Object)"The ak is invalid.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralText((String)site.getSk())) {
            logger.error((Object)"The sk is invalid.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)site.getProxyId())) {
            logger.error((Object)("The proxyId is invalid, proxyId=" + site.getProxyId()));
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    public Response deleteSite(String siteId) {
        this.checkUserOperationAuthority("site_deleteSite_operateName", 2, "ism.drm.site.auth.delete");
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)("enter modifySite.siteId:" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            logger.error((Object)("The siteId is invalid, siteId=" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        Site site = this.getSiteService().getSiteById(siteId);
        if (null == site) {
            throw new LegoCheckedException(2117645L);
        }
        if (0 != site.getSiteType()) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("site_deleteSite_operateName", 2, siteId);
        try {
            this.getSiteService().deleteSite(siteId);
            this.writeSucOperationLog("site_deleteSite_operateName", 2, site.getName(), null, null);
        }
        catch (Exception e) {
            logger.error((Object)("Delete site failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            this.writeFailedOperationLog("site_deleteSite_operateName", 2, site.getName(), e);
        }
        return Response.ok().build();
    }

    @Override
    public Response modifySite(String siteId, Site site) {
        this.checkUserOperationAuthority("site_modifyLocalSite_operateName", 3, "ism.drm.site.auth.modify");
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)("enter modifySite.siteId:" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            logger.error((Object)("The siteId is invalid, siteId=" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)site)) {
            throw new LegoCheckedException(1073947393L);
        }
        Site replica = this.getSiteService().getSiteById(siteId);
        if (null == replica) {
            throw new LegoCheckedException(2117645L);
        }
        String siteDesc = HtmlStringConverter.decodeByLength(site.getDescription());
        if (!CommUtil.checkDrmDescParam((String)siteDesc)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("site_modifyLocalSite_operateName", 3, siteId);
        int siteType = replica.getSiteType();
        if (!VerifyUtil.isEmpty((Object)replica.getIsCloudSite()) && replica.getIsCloudSite().booleanValue()) {
            replica.setProxyId(site.getProxyId());
            replica.setRegionId(site.getRegionId());
            replica.setAk(site.getAk());
            replica.setSk(site.getSk());
            replica.setDescription(site.getDescription());
        }
        if (0 == siteType) {
            this.updateLocalSite(replica, site);
        } else if (1 == siteType) {
            this.updateRemoteSite(replica, site);
        } else {
            throw new LegoCheckedException(1073947393L);
        }
        return Response.ok().build();
    }

    private void updateLocalSite(Site replica, Site newSite) {
        String oldName = replica.getName();
        String oldDesc = replica.getDescription();
        String newName = newSite.getName();
        String newDesc = newSite.getDescription();
        if (!CommUtil.checkDrmNameParam((String)newName)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!newName.equals(oldName)) {
            replica.setName(newName);
        }
        if (null != newDesc && !newDesc.equals(oldDesc)) {
            replica.setDescription(newDesc);
        }
        try {
            this.getSiteService().updateSite(replica, newName, this.getCurrentUserId());
            this.localSuccessLog(newName);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Modify local site failed.", (Throwable)e, 90160758784000L);
            this.writeFailedOperationLog("site_modifyLocalSite_operateName", 3, oldName, (Exception)((Object)e));
            throw e;
        }
    }

    private void updateRemoteSite(Site replica, Site newSite) {
        String oldName = replica.getName();
        String oldDesc = replica.getDescription();
        String newName = newSite.getName();
        String newDesc = newSite.getDescription();
        if (null != newDesc && !newDesc.equals(oldDesc)) {
            replica.setDescription(newDesc);
        }
        try {
            this.getSiteService().updateSite(replica, newName, this.getCurrentUserId());
            this.writeSucOperationLog("site_modifyLocalSite_operateName", 3, oldName, "site_modifySite_operateDetail_2", null);
        }
        catch (Exception e) {
            logger.error((Object)("Modify remote site failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            this.writeFailedOperationLog("site_modifyLocalSite_operateName", 3, oldName, e);
        }
    }

    @Override
    public String getSites(String serverUuid, String cloudServiceProvider) {
        this.checkUserOperationAuthority("site_querySite_operateName", 2, "ism.drm.site.auth.scan");
        List sites = null;
        if (VerifyUtil.isEmpty((String)serverUuid)) {
            sites = this.getSiteService().getAllSites(this.getCurrentUserId());
        } else {
            if (!ParamChecker.checkGeneralId((String)serverUuid)) {
                logger.error((Object)("The serverUuid is invalid, serverUuid=" + serverUuid));
                throw new LegoCheckedException(1073947393L);
            }
            sites = this.getSiteService().getSites(serverUuid);
            IBizScopeManager manager = (IBizScopeManager)this.getBundleService("DRM_Base", "IBizScopeManager");
            sites = manager.filterObject(this.getCurrentUserId(), sites);
        }
        Iterator iter = sites.iterator();
        while (iter.hasNext()) {
            Site site = (Site)iter.next();
            if (VerifyUtil.isEmpty((String)cloudServiceProvider) || VerifyUtil.isEmpty((Object)site.getIsCloudSite()) || site.getIsCloudSite().booleanValue() && cloudServiceProvider.equals(site.getCloudServiceProvider())) continue;
            iter.remove();
        }
        JSONArray array = new JSONArray();
        for (DRMObject site : sites) {
            if (site instanceof Site) {
                array.add((Object)this.siteToJsonStr((Site)site));
                continue;
            }
            logger.info((Object)("Converting failed.DRMObject:" + site));
        }
        return array.toString();
    }

    @Deprecated
    public String getSites(Integer type, String name) {
        List sites = this.getSiteService().getAllSites(this.getCurrentUserId());
        JSONArray resultArray = new JSONArray();
        for (Site site : sites) {
            if (type != null && (type == 0 || type == 1) && site.getSiteType() != type.intValue() || StringUtils.isNotBlank((CharSequence)name) && !site.getName().toLowerCase(Locale.US).contains(name.toLowerCase(Locale.US))) continue;
            JSONObject jsonObject = this.siteToJsonStr(site);
            resultArray.add((Object)jsonObject);
        }
        return resultArray.toString();
    }

    private JSONObject siteToJsonStr(Site site) {
        if (site == null) {
            return new JSONObject();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"siteId", (Object)site.getSiteId());
        jsonObject.put((Object)"name", (Object)site.getName());
        jsonObject.put((Object)"siteAlias", (Object)site.getSiteAlias());
        jsonObject.put((Object)"description", (Object)site.getDescription());
        jsonObject.put((Object)"siteType", (Object)site.getSiteType());
        jsonObject.put((Object)"serverUuid", (Object)site.getServerUuid());
        jsonObject.put((Object)"isCloudSite", (Object)site.getIsCloudSite());
        jsonObject.put((Object)"cloudServiceProvider", (Object)site.getCloudServiceProvider());
        jsonObject.put((Object)"domainName", (Object)site.getDomainName());
        jsonObject.put((Object)"regionId", (Object)site.getRegionId());
        jsonObject.put((Object)"projectId", (Object)site.getProjectId());
        jsonObject.put((Object)"proxyId", (Object)site.getProxyId());
        return jsonObject;
    }

    @Override
    public String getSiteById(String siteId) {
        this.checkUserOperationAuthority("site_querySite_operateName", 2, "ism.drm.site.auth.scan");
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)("enter modifySite.siteId:" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            logger.error((Object)("The siteId is invalid, siteId=" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        Site site = this.getSiteService().getSiteById(siteId);
        if (site != null) {
            this.checkUserBizObjAuthority("site_querySite_operateName", 2, siteId);
        }
        return this.siteToJsonStr(site).toString();
    }

    @Override
    public RestJsonRequest getSiteResourcesByResType(String siteId, String type) {
        ArrayList drRes;
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (VerifyUtil.isEmpty((String)siteId) || !ParamChecker.checkGeneralId((String)siteId) || VerifyUtil.isEmpty((String)type)) {
            logger.error((Object)("enter modifySite.siteId:" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("resource_queryRes_operateName", 2, siteId);
        try {
            drRes = this.getSiteService().getAllResourceBySite(siteId, type);
        }
        catch (Exception e) {
            logger.error((Object)("query with exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            drRes = new ArrayList();
        }
        RestJsonRequest response = new RestJsonRequest();
        response.setClasssName(List.class.getName());
        response.setValue(ReverseObjectSerializableUtils.serializableObj((Object)drRes));
        return response;
    }

    private void localSuccessLog(String siteName) {
        this.writeSucOperationLog("site_modifyLocalSite_operateName", 3, siteName, "site_modifySite_operateDetail", new String[]{siteName});
    }

    @Override
    public String statSiteResource(String siteId) {
        this.checkUserOperationAuthority("site_querySite_operateName", 2, "ism.drm.site.auth.scan");
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)("enter modifySite.siteId:" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            logger.error((Object)"modifySite.siteId is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("site_querySite_operateName", 2, siteId);
        Map resStatistics = this.getSiteService().sum(siteId, this.getCurrentUserId());
        JSONObject resultObj = new JSONObject();
        resultObj.put((Object)"result", (Object)resStatistics);
        return resultObj.toString();
    }

    @Override
    public Response refreshRemoteSite(String siteId) {
        this.checkUserOperationAuthority("site_refreshRemoteSite_operateName", 3, "ism.drm.site.auth.refresh");
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)("enter modifySite.siteId:" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            logger.error((Object)("The siteId is invalid, siteId=" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        Site replica = this.getSiteService().getSiteById(siteId);
        if (null == replica) {
            throw new LegoCheckedException(1073947394L);
        }
        this.checkUserBizObjAuthority("site_refreshRemoteSite_operateName", 3, siteId);
        try {
            this.getSiteService().refreshSiteByBackTask(replica, this.getCurrentUser().getUserName());
            this.writeSucOperationLog("site_refreshRemoteSite_operateName", 3, replica.getName(), null, null);
        }
        catch (Exception e) {
            logger.error((Object)("query with exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            this.writeFailedOperationLog("site_refreshRemoteSite_operateName", 3, replica.getName(), e);
        }
        return Response.ok().build();
    }

    private ISiteService getSiteService() {
        return (ISiteService)this.getBundleService("DRM_Base", ISiteService.class.getName());
    }

    @Override
    public String showSitesRelationTopo() {
        this.checkUserOperationAuthority("site_querySite_operateName", 2, "ism.drm.site.auth.scan");
        IProtectGroupService ipgs = this.getBundleService("DRM_Base", IProtectGroupService.class.getName(), IProtectGroupService.class);
        List protectGroups = ipgs.getAllProtectGroupBasicInfo(this.getCurrentUserId(), false, true, true);
        JSONObject resultObejct = new JSONObject();
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            logger.info((Object)("The ProtectGroup search result is null,  getCurrentUserId():" + this.getCurrentUserId()));
            return resultObejct.toString();
        }
        IDrmTopoService topoService = this.getBundleService("DRM_Base", IDrmTopoService.class.getName(), IDrmTopoService.class);
        List allPgSitesRelation = topoService.getSiteLinks(protectGroups);
        JSONArray jsonLinks = new JSONArray();
        allPgSitesRelation.stream().forEach(link -> {
            JSONObject siteRelationJsonObject = JSONObject.fromObject((Object)link);
            jsonLinks.add((Object)siteRelationJsonObject);
        });
        resultObejct.put((Object)"links", (Object)jsonLinks);
        return resultObejct.toString();
    }
}

