/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.topo;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.framework.user.service.UserRestServiceValidator;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.security.sdk.service.ISecurityService;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoService;
import com.huawei.ism.drm.topo.sdk.utils.TopoUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import twaver.SerializationSettings;

public class TopoService {
    private static final long serialVersionUID = 1744044920321954230L;
    private static Log log = LogFactory.getInstance(TopoService.class);
    private static final String TOPO_BUNDLE_NAME = "DRM_Base";
    private static final String DEFUALT_BUNDLE_NAME = "DRM_Base";
    private static final List<String> LOCAL_LANG_BOUND = new ArrayList<String>(Arrays.asList("en_US", "zh_CN", "zh", "CN", "en", "EN"));
    private static long userId;

    public HttpServletRequest getRequest() {
        return (HttpServletRequest)new ThreadLocal();
    }

    public List<String> getProtectGroupTopo(String pgId, String localeString, String clientToken) {
        this.checkCSRFRequest(clientToken);
        log.info((Object)"TopoAction:getProtectGroupTopo. ", 90160758784000L);
        if (!LOCAL_LANG_BOUND.contains(localeString)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkAuthority(pgId);
        try {
            IDrmTopoService topoService = (IDrmTopoService)this.getBundleService("DRM_Base", IDrmTopoService.class.getName());
            return topoService.createProtectGroupTopoData(pgId, userId, localeString);
        }
        catch (Exception e) {
            log.error((Object)("Get ProtectGroup topo failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return new ArrayList<String>();
        }
    }

    private void checkAuthority(String pgId) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", 2, "ism.drm.protectgroup.auth.scan");
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", 2, pgId);
    }

    public List<String> getProtectGroupPollTopo(String pgId, String lunIdList, String localeString, String clientToken) {
        this.checkCSRFRequest(clientToken);
        log.info((Object)"TopoAction:getProtectGroupPollTopo. ", 90160758784000L);
        if (!LOCAL_LANG_BOUND.contains(localeString)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkAuthority(pgId);
        try {
            IDrmTopoService topoService = (IDrmTopoService)this.getBundleService("DRM_Base", IDrmTopoService.class.getName());
            return topoService.createProtectGroupPollData(pgId, lunIdList, userId, localeString);
        }
        catch (Exception e) {
            log.error((Object)("Get ProtectGroup poll topo failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return new ArrayList<String>();
        }
    }

    protected void checkUserBizObjAuthority(String operationName, int level, String objectId) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        try {
            scope.checkUserGrantedObject(this.getCurrentUserId(), objectId);
        }
        catch (LegoCheckedException e) {
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err." + e.getErrorCode(), objectId, this.getRemoteAddr(this.getRequest()));
            sysOptLog.setDetailPara(e.getParameters());
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            throw e;
        }
    }

    private <T> T getBundleService(String serviceName, Class<T> serviceClass) {
        return (T)ServiceLocator.getBundleService((String)"DRM_Base", (String)serviceName, serviceClass);
    }

    private void checkCSRFRequest(String clientToken) {
        if (StringUtils.isEmpty((CharSequence)clientToken)) {
            log.info((Object)"checkCSRFRequest. clientToken is empty.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        HttpServletRequest req = this.getRequest();
        if (req.getSession(false) != null) {
            String randomStr = (String)req.getSession().getAttribute("rd_randomStr_HW");
            if (StringUtils.isEmpty((CharSequence)randomStr)) {
                log.info((Object)"checkCSRFRequest. randomStr is empty.", 90160758784000L);
                throw new LegoCheckedException(1073947393L);
            }
            if (!randomStr.equals(clientToken)) {
                log.info((Object)"checkCSRFRequest. clientToken is not equal.", 90160758784000L);
                throw new LegoCheckedException(1073947393L);
            }
        } else {
            log.info((Object)"checkCSRFRequest. getSession is empty.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void init() {
        TopoUtil.registerGlobalClientCommonPropties();
        SerializationSettings.registerGlobalClient((String)"linkToXOffset", (String)"number");
        SerializationSettings.registerGlobalClient((String)"maxSonWidth", (String)"number");
        SerializationSettings.registerGlobalClient((String)"maxSonHeight", (String)"number");
        SerializationSettings.registerGlobalClient((String)"isUpdataLinkTag", (String)"boolean");
        SerializationSettings.registerGlobalClient((String)"netWorkPrimalName", (String)"string");
        SerializationSettings.registerGlobalClient((String)"visExchangeTargetWWN", (String)"string");
    }

    public String getToolBarToolTips(String localeString, String clientToken) {
        this.checkCSRFRequest(clientToken);
        if (!LOCAL_LANG_BOUND.contains(localeString)) {
            throw new LegoCheckedException(1073947393L);
        }
        String res = null;
        try {
            IDrmTopoService topoService = (IDrmTopoService)this.getBundleService("DRM_Base", IDrmTopoService.class.getName());
            res = topoService.getToolBarToolTips(localeString);
        }
        catch (Exception e) {
            log.error((Object)("Get ToolBarToolTips failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return res;
    }

    private User getCurrentUser() {
        HttpServletRequest request = this.getRequest();
        User user = (User)request.getAttribute("currentUser");
        if (user != null) {
            return user;
        }
        user = (User)request.getSession().getAttribute("currentUser");
        if (user != null) {
            return user;
        }
        String userName = request.getHeader("x-auth-user");
        if (!UserRestServiceValidator.checkUserName(userName).booleanValue()) {
            log.error((Object)"parameter[x-auth-user] is illegal!", 1073947393L);
            return new User();
        }
        String userPwd = request.getHeader("x-auth-key");
        ISecurityService service = (ISecurityService)ServiceContext.getInstance().lookup("DRM_Base/ISecurityService");
        if (null == service) {
            log.error((Object)"Can not find security service.", 1073947393L);
            return new User();
        }
        if (!service.isValidUser(userName, userPwd)) {
            return new User();
        }
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        user = mgr.getUserByName(userName);
        request.setAttribute("currentUser", (Object)user);
        return user;
    }

    private Object getBundleService(String bundle, String service) {
        ServiceLocator.getInstance();
        return ServiceLocator.getBundleService((String)bundle, (String)service);
    }

    public List<String> getGloabelSiteTopo(String localeString, String clientToken) {
        this.checkCSRFRequest(clientToken);
        log.info((Object)"TopoAction:getGloabelSiteTopo. ", 90160758784000L);
        if (!LOCAL_LANG_BOUND.contains(localeString)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("topology_queryOverallTopology_operateName", 2, "ism.drm.monitor.gloable.topo.auth.scan");
        try {
            IDrmTopoService topoService = (IDrmTopoService)this.getBundleService("DRM_Base", IDrmTopoService.class.getName());
            return topoService.createGlobalTopoData(userId, localeString);
        }
        catch (Exception e) {
            log.error((Object)("Get global topo failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return new ArrayList<String>();
        }
    }

    private void checkUserOperationAuthority(String operationName, int level, String i18nKey) {
        Long currentUserId = this.getCurrentUserId();
        if (currentUserId == null) {
            log.error((Object)"Cannot get current user.", 653110170615808L);
            throw new LegoCheckedException(1073947400L);
        }
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        boolean hasRight = mgr.checkUserRight(currentUserId.longValue(), i18nKey);
        if (!hasRight) {
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err.1073947400", i18nKey, this.getRemoteAddr(this.getRequest()));
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            throw new LegoCheckedException(1073947400L);
        }
    }

    private Long getCurrentUserId() {
        User user = this.getCurrentUser();
        return user.getUserId();
    }

    private String getRemoteAddr(HttpServletRequest req) {
        String ipAddress = req.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress) || !UserRestServiceValidator.checkIp(ipAddress).booleanValue()) {
            ipAddress = req.getRemoteAddr();
        } else {
            int index = ipAddress.indexOf(",");
            if (index > 0) {
                ipAddress = ipAddress.substring(0, index);
            }
        }
        return ipAddress;
    }

    private void writeSucOperationLog(String operationName, int level, String objectName, String detail, String[] parameters) {
        SysOptLog sysOptLog = SysOpLogBuilder.buildeSuccussSysOptLog(operationName, this.getCurrentUser().getUserName(), level, detail, objectName, this.getRemoteAddr(this.getRequest()));
        sysOptLog.setDetailPara(parameters);
        SysOpLogBuilder.writeOperateLog(sysOptLog);
    }

    private void writeFailedOperationLogNoException(String operationName, int level, String objectName, Exception ix) {
        if (ix instanceof LegoCheckedException) {
            LegoCheckedException ex = (LegoCheckedException)((Object)ix);
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err." + ex.getErrorCode(), objectName, this.getRemoteAddr(this.getRequest()));
            sysOptLog.setDetailPara(ex.getParameters());
            SysOpLogBuilder.writeOperateLog(sysOptLog);
        } else {
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err.-1", objectName, this.getRemoteAddr(this.getRequest()));
            sysOptLog.setDetailPara(new String[0]);
            SysOpLogBuilder.writeOperateLog(sysOptLog);
        }
    }

    public List<String> updatePollPeriod(String selectedTimeIndex, String clientToken) {
        this.checkCSRFRequest(clientToken);
        if (VerifyUtil.isEmpty((String)selectedTimeIndex)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("topology_modifyOverallTopologyRefreshPeriod_operateName", 1, "ism.drm.monitor.gloable.topo.auth.set.operateID");
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            IDrmTopoService topoService = (IDrmTopoService)this.getBundleService("DRM_Base", IDrmTopoService.class.getName());
            topoService.updatePollPeriod(selectedTimeIndex);
            resultList.add("success");
            this.writeSucOperationLog("topology_modifyOverallTopologyRefreshPeriod_operateName", 1, "overallTopologyRefreshPeriod_objectName", "", null);
        }
        catch (LegoCheckedException legoException) {
            resultList.clear();
            if (legoException.getErrorCode() == 1073947404L) {
                resultList.add("busy");
            } else {
                resultList.add("failed");
            }
            log.error((Object)"Save global topo failed. ", (Throwable)legoException, 90160758787071L);
            this.writeFailedOperationLogNoException("topology_modifyOverallTopologyRefreshPeriod_operateName", 1, "overallTopologyRefreshPeriod_objectName", (Exception)((Object)legoException));
        }
        catch (Exception e) {
            resultList.clear();
            resultList.add("failed");
            log.error((Object)("Save global topo failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.writeFailedOperationLogNoException("topology_modifyOverallTopologyRefreshPeriod_operateName", 1, "overallTopologyRefreshPeriod_objectName", e);
        }
        return resultList;
    }

    public List<String> saveTopoData(String topoXml, String clientURL, String clientToken) {
        this.checkCSRFRequest(clientToken);
        if (VerifyUtil.isEmpty((String)topoXml) || VerifyUtil.isEmpty((String)clientURL)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("topology_saveOverallTopology_operateName", 1, "ism.drm.monitor.gloable.topo.auth.set.operateID");
        ArrayList<String> resultList = new ArrayList<String>();
        String urlImageHead = "<p n='image'>";
        String strTopoXml = topoXml;
        strTopoXml = strTopoXml.replace(urlImageHead + clientURL, urlImageHead);
        try {
            IDrmTopoService topoService = (IDrmTopoService)this.getBundleService("DRM_Base", IDrmTopoService.class.getName());
            topoService.updateTopo(strTopoXml);
            resultList.add("success");
            this.writeSucOperationLog("topology_saveOverallTopology_operateName", 1, "overallTopology_objectName", "", null);
        }
        catch (LegoCheckedException legoException) {
            resultList.clear();
            resultList.add("failed");
            log.error((Object)"Save global topo failed. ", (Throwable)legoException, 90160758787071L);
            this.writeFailedOperationLogNoException("topology_saveOverallTopology_operateName", 1, "overallTopology_objectName", (Exception)((Object)legoException));
        }
        catch (Exception e) {
            resultList.clear();
            resultList.add("failed");
            log.error((Object)("Save global topo failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.writeFailedOperationLogNoException("topology_saveOverallTopology_operateName", 1, "overallTopology_objectName", e);
        }
        return resultList;
    }

    static {
        TopoService.init();
    }
}

