/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.ism.drm.web.filter.RemoteTrustManager;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.jasig.cas.client.ssl.AnyHostnameVerifier;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;

public class HttpsURLConnectionFactory
implements HttpURLConnectionFactory {
    private static final Log logger = LogFactory.getInstance(HttpsURLConnectionFactory.class);

    public HttpURLConnection buildHttpURLConnection(URLConnection conn) {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)conn;
            this.initSSLSocketFactory(httpsConnection);
            httpsConnection.setHostnameVerifier((HostnameVerifier)new AnyHostnameVerifier());
        }
        return (HttpURLConnection)conn;
    }

    private void initSSLSocketFactory(HttpsURLConnection connection) {
        SSLSocketFactory sslSocketFactory;
        SSLContext context = this.getSSLContext(connection.getURL().getHost());
        SSLSocketFactory sSLSocketFactory = sslSocketFactory = context != null ? context.getSocketFactory() : null;
        if (sslSocketFactory != null) {
            connection.setSSLSocketFactory(sslSocketFactory);
        }
    }

    private SSLContext getSSLContext(String host) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new X509TrustManager[]{new RemoteTrustManager(host)}, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
        }
        catch (KeyManagementException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
        }
        return sslContext;
    }
}

