/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.ism.drm.web.filter.ParameterizedConfiguration;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

public class ParameterizedFilterConfig
implements FilterConfig {
    private FilterConfig config;
    private ServletContext context;
    private ServletContext proxyContext;
    private ParameterizedConfiguration<ServletContext, ServletContext> handler;

    public ParameterizedFilterConfig(FilterConfig config) {
        this.config = config;
        this.context = config.getServletContext();
        this.handler = ParameterizedConfiguration.get(this.context);
        this.proxyContext = this.handler.getProxy();
    }

    public String getFilterName() {
        return this.config.getFilterName();
    }

    private boolean isHiddenParameter(String name) {
        return "wrappedFilterClass".equals(name);
    }

    public String getInitParameter(String name) {
        if (this.isHiddenParameter(name)) {
            return null;
        }
        String parameter = this.config.getInitParameter(name);
        return this.handler.normalize(parameter);
    }

    public Enumeration<String> getInitParameterNames() {
        Vector<String> names = new Vector<String>();
        Enumeration items = this.config.getInitParameterNames();
        while (items.hasMoreElements()) {
            String item = (String)items.nextElement();
            if (this.isHiddenParameter(item)) continue;
            names.add(item);
        }
        return names.elements();
    }

    public ServletContext getServletContext() {
        return this.proxyContext;
    }
}

