/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.ism.drm.web.filter.ProxyResponse;
import com.huawei.ism.drm.web.util.StaticResourceUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProxyFilter
implements Filter {
    private static Log log = LogFactory.getInstance(ProxyFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String str = httpRequest.getRequestURI();
        String uri = UriUtil.canonicalPath(str);
        String contextPath = httpRequest.getContextPath();
        if (contextPath.length() > 0) {
            uri = uri.substring(contextPath.length());
        }
        if (uri.indexOf(".") > -1) {
            try {
                boolean staticResours = StaticResourceUtil.getInstance().findStaticResource(uri, "com/huawei/htmlPages", (HttpServletRequest)request, (HttpServletResponse)response);
                if (staticResours) {
                    return;
                }
            }
            catch (Exception e) {
                log.error((Object)(" ProxyFilter do Filter " + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            }
        }
        ProxyResponse httprep = new ProxyResponse((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)httprep);
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

