/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Comparator;

public class FieldComparator
implements Comparator,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getInstance(FieldComparator.class);
    private static final String DOUBLE_LINE = "--";
    private String compareFiled;
    private boolean isAsc = true;

    public FieldComparator(String compareFiled, boolean isAsc) {
        this.compareFiled = compareFiled;
        this.isAsc = isAsc;
    }

    public int compare(Object leftParam, Object rightParam) {
        if (null == leftParam || null == rightParam) {
            return 0;
        }
        Comparable leftValue = this.getCompareValue(leftParam, this.compareFiled);
        Comparable rightValue = this.getCompareValue(rightParam, this.compareFiled);
        if (leftValue == null && rightValue == null) {
            return 0;
        }
        if (leftValue == null) {
            return this.isAsc ? -1 : 1;
        }
        if (rightValue == null) {
            return this.isAsc ? 1 : -1;
        }
        if (this.isAsc) {
            return leftValue.compareTo(rightValue);
        }
        return rightValue.compareTo(leftValue);
    }

    private Comparable getCompareValue(Object obj, String compareFiledName) {
        String[] fieldNames = compareFiledName.contains(".") ? compareFiledName.split("\\.") : new String[]{compareFiledName};
        Object fieldValue = obj;
        for (String fieldName : fieldNames) {
            if ((fieldValue = this.getFieldValue(fieldValue, fieldName)) != null) continue;
            return null;
        }
        if (fieldValue instanceof Number) {
            Number number = (Number)fieldValue;
            return Double.valueOf(number.doubleValue());
        }
        String resultStr = fieldValue.toString();
        return resultStr.equals(DOUBLE_LINE) ? null : resultStr;
    }

    private Object getFieldValue(Object obj, String fieldName) {
        Field f = this.getField(obj.getClass(), fieldName);
        if (null == f) {
            return null;
        }
        f.setAccessible(true);
        try {
            return f.get(obj);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e, -1L);
            return null;
        }
    }

    private Field getField(Class clazz, String fieldName) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        if (clazz != Object.class) {
            return this.getField(clazz.getSuperclass(), fieldName);
        }
        return null;
    }
}

