/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cxf.message.Message;

public class RequestUtil {
    public static String getClientIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (VerifyUtil.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (VerifyUtil.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (VerifyUtil.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getClientIpAddress(Message message) {
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        if (VerifyUtil.isEmpty((Object)request)) {
            return "unknown";
        }
        String ip = RequestUtil.getClientIpAddress(request);
        if (!VerifyUtil.isEmpty((String)ip) && ip.indexOf(",") != -1) {
            String[] arr = ip.split(",");
            ip = arr[arr.length - 1].trim();
        }
        return ip;
    }

    public static Locale getLocale(HttpServletRequest request) {
        if (null == request) {
            return Locale.ENGLISH;
        }
        Locale locale = null;
        HttpSession session = request.getSession(false);
        if (null != session) {
            locale = (Locale)session.getAttribute("WW_TRANS_I18N_LOCALE");
        }
        if (null == locale) {
            String language = request.getParameter("rd_language");
            if ("en".equalsIgnoreCase(language)) {
                locale = Locale.ENGLISH;
            } else if ("zh_CN".equalsIgnoreCase(language)) {
                locale = Locale.SIMPLIFIED_CHINESE;
            }
        }
        if (null == locale) {
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    public static String getFirstIPFromIPStr(String ipStr) {
        if (!VerifyUtil.isEmpty((String)ipStr) && ipStr.contains(",")) {
            String[] arr = ipStr.split(",");
            ipStr = arr[0].trim();
        }
        return ipStr;
    }
}

