/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class StringUtil {
    private static final String LOCAL_HOST_IP_FIRST = "127";
    private static final int ZERO = 0;
    private static final int ONE_HUNDRED_AND_TWENTY_EIGHT = 128;
    private static final int PORT_MIN_VALUE = 1;
    private static final int PORT_MAX_VALUE = 65535;

    private StringUtil() {
    }

    public static String appendSpaceToNullString(String srcString) {
        if ("null".equals(srcString)) {
            srcString = srcString + " ";
        }
        return srcString;
    }

    public static String deleteSpaceFromNullString(String srcString) {
        if ("null ".equals(srcString)) {
            return "null";
        }
        return srcString;
    }

    public static boolean isIpValid(String inputIp) {
        if (VerifyUtil.isEmpty((String)inputIp) || inputIp.startsWith(LOCAL_HOST_IP_FIRST)) {
            return false;
        }
        return Ipv4AddressUtil.isValidIPv4((String)inputIp) || Ipv6AddressUtil.isValidIPv6((String)inputIp);
    }

    public static boolean isIPv6Valid(String inputIp) {
        return Ipv6AddressUtil.isIPv6Address((String)inputIp);
    }

    public static boolean isIPv6PrefixValid(String ipv6Prefix) {
        if (VerifyUtil.isEmpty((String)ipv6Prefix)) {
            return false;
        }
        String reg = "^([1-9]?\\d|1[01]\\d|12[0-8])$";
        ipv6Prefix = Normalizer.normalize(ipv6Prefix, Normalizer.Form.NFKC);
        Matcher matcher = Pattern.compile(reg).matcher(ipv6Prefix);
        return matcher.matches();
    }

    public static boolean isPortRangeValid(String port) {
        String reg = "[1-9]\\d*";
        port = Normalizer.normalize(port, Normalizer.Form.NFKC);
        Matcher matcher = Pattern.compile(reg).matcher(port);
        if (!matcher.matches()) {
            return false;
        }
        int portInt = NumberUtil.convertToInteger((Object)port);
        return !VerifyUtil.isEmpty((String)port) && portInt >= 1 && portInt <= 65535;
    }

    public static boolean isStrNumberValid(String str) {
        if (VerifyUtil.isEmpty((String)str)) {
            return false;
        }
        String reg = "[1-9]\\d*|0";
        str = Normalizer.normalize(str, Normalizer.Form.NFKC);
        Matcher matcher = Pattern.compile(reg).matcher(str);
        return matcher.matches();
    }

    public static boolean validateNetMask(String mask) {
        if (!StringUtil.regNetMask(mask)) {
            return false;
        }
        String[] masks = mask.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String one : masks) {
            String binaryStr = Integer.toBinaryString(NumberUtil.convertToInteger((Object)one));
            int times = 8 - binaryStr.length();
            for (int idx = 0; idx < times; ++idx) {
                sb.append("0");
            }
            sb.append(binaryStr);
        }
        int index0 = sb.indexOf("0");
        int validate = sb.indexOf("1", index0);
        return validate <= 0;
    }

    private static boolean regNetMask(String str) {
        if (null == str || str.trim().length() <= 0) {
            return false;
        }
        String reg = "^(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[0-9]{1,2})(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[0-9]{1,2})){3}$";
        str = Normalizer.normalize(str, Normalizer.Form.NFKC);
        return Pattern.compile(reg).matcher(str).matches();
    }

    public static boolean isBooleanStrValid(String booleanStr) {
        return !VerifyUtil.isEmpty((String)booleanStr) && (booleanStr.equalsIgnoreCase(String.valueOf(Boolean.FALSE)) || booleanStr.equalsIgnoreCase(String.valueOf(Boolean.TRUE)));
    }

    public static boolean isValidSubnetprefix(String subNetPrefix) {
        int prefix;
        return StringUtils.isNotBlank((CharSequence)subNetPrefix) && (prefix = NumberUtil.convertToInteger((Object)subNetPrefix).intValue()) > 0 && prefix < 128;
    }
}

