/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.alarm.common;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.function.Function;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class KeyStoreManager
implements X509TrustManager {
    private static final Log logger = LogFactory.getInstance(KeyStoreManager.class);
    private X509TrustManager trustManager = null;
    private Function<String, String> decrypt;

    public KeyStoreManager(Function<String, String> decrypt) throws IOException {
        this.decrypt = decrypt;
        String keyStoreFile = KeyStoreManager.getRuntimePath() + "/LegoRuntime/certs/bcm.keystore";
        KeyStore keyStore = this.getKeyStore(keyStoreFile);
        this.trustManager = this.getTrustManager(keyStore);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore getKeyStore(String keyStoreFile) throws IOException {
        KeyStore keyStore = null;
        FileInputStream in = null;
        try {
            File file = new File(keyStoreFile);
            if (!file.exists()) {
                throw new IOException("keystore is not exists.");
            }
            in = new FileInputStream(file);
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(in, this.getKeyStorePwd().toCharArray());
            if (null == in) return keyStore;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("init keystore failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{""});
                throw new LegoCheckedException("Initializing KeyStore failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
            }
            catch (Throwable throwable) {
                if (null == in) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.error((Object)("Initializing KeyStore failed." + e2), new Object[]{""});
                }
                throw throwable;
            }
        }
        try {
            in.close();
            return keyStore;
        }
        catch (IOException e) {
            logger.error((Object)("Initializing KeyStore failed." + e), new Object[]{""});
            return keyStore;
        }
    }

    private String getKeyStorePwd() throws IOException {
        String legoConfig = KeyStoreManager.getRuntimePath() + "/LegoRuntime/conf/lego.properties";
        File file = new File(legoConfig);
        if (!file.exists()) {
            logger.error((Object)"getKeyStorePwd failed, config file not found.", new Object[]{""});
            throw new LegoCheckedException("getKeyStorePwd failed");
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        return this.decrypt.apply(properties.getProperty("keyStore"));
    }

    private static String getRuntimePath() throws IOException {
        Path path;
        try {
            path = Paths.get(KeyStoreManager.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException("get runtime path failed.", e);
        }
        Path runtime = Paths.get("Runtime", new String[0]);
        while (!path.getFileName().equals(runtime)) {
            path = path.getParent();
        }
        return path.toString();
    }

    private X509TrustManager getTrustManager(KeyStore keyStore) {
        if (null == keyStore) {
            throw new LegoCheckedException("The keyStore is null");
        }
        X509TrustManager defaultTrustManager = null;
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        }
        catch (KeyStoreException e) {
            throw new LegoCheckedException("Initialized TrustManager failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
        }
        catch (NoSuchAlgorithmException e) {
            throw new LegoCheckedException("Initialized TrustManager failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
        }
        return defaultTrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (null == this.trustManager) {
            logger.error((Object)"The trust manager is not initialized", new Object[]{""});
            throw new LegoCheckedException("send alarm failed, trust manager not init.");
        }
        try {
            for (int i = 0; i < chain.length; ++i) {
                chain[i].checkValidity();
            }
            this.trustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            logger.error((Throwable)e, (Object)"send alarm failed, check server cert failed.", new Object[0]);
            throw e;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

