/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.alarm.send;

import com.huawei.alarm.common.RequestParam;
import com.huawei.alarm.common.RestClientImpl;
import com.huawei.alarm.common.WccTool;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;

public class SendAlarm {
    private static final String TYPE = "--type";
    private static final String LISTENIP = "--listenIp";
    private static final String LISTENPORT = "--listenPort";
    private static final String PARAM = "--param";
    private static final String SEVERITY = "--severity";
    private static final String ALARMID = "--alarmId";
    private static final String CREATETIME = "--createTime";
    private static final String SEQUENCE = "--sequence";
    private static final String MO_NAME = "--moName";
    private static final String HACONFIG = "/ha/local/conf/ha.properties";
    private static final String USERKEY = "alarm.user";
    private static final String USERPWD = "alarm.password";
    private static final List<String> PARAMLIST = Arrays.asList("--sequence", "--listenIp", "--listenPort", "--param", "--type", "--severity", "--alarmId", "--createTime");
    private static final Log logger = LogFactory.getInstance(SendAlarm.class);
    private RequestParam param;
    private Function<String, String> decrypt;

    public SendAlarm(RequestParam param) {
        this(param, WccTool.getInstance()::decrypt);
    }

    public SendAlarm(RequestParam param, Function<String, String> decrypt) {
        this.param = param;
        this.decrypt = Objects.requireNonNull(decrypt);
    }

    public static void main(String[] args) {
        try {
            SendAlarm sender = new SendAlarm(SendAlarm.initRequestParam(args));
            String retry = SendAlarm.getOpt(args, "--retry", "1");
            int retryTimes = Math.max(NumberUtil.convertToInteger((Object)retry, (int)1), 1);
            sender.send(retryTimes, true);
        }
        catch (Exception e) {
            logger.error((Object)("sendAlarm failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{""});
            System.exit(1);
        }
        System.exit(0);
    }

    private static String getOpt(String[] items, String name, String defaultValue) {
        if (name == null || !name.startsWith("-")) {
            return null;
        }
        for (int index = 0; index < items.length; ++index) {
            String item = items[index];
            if (item.startsWith("--")) {
                if (++index >= items.length) {
                    throw new LegoCheckedException("missing option: " + name);
                }
                if (!name.equals(item)) continue;
                return items[index];
            }
            if (!item.startsWith("-")) continue;
            return Boolean.TRUE.toString();
        }
        return !name.startsWith("--") ? Boolean.FALSE.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initAuthority(boolean enable) {
        Properties properties = new Properties();
        File file = new File(SendAlarm.getHAConfigFile());
        if (!file.exists()) {
            return SendAlarm.raise(enable, "Can not find the ha.properties.", new Object[0]);
        }
        FileInputStream fip = null;
        try {
            fip = new FileInputStream(file);
            properties.load(fip);
            this.param.setUserName(properties.getProperty(USERKEY));
            String userPwd = this.decrypt.apply(properties.getProperty(USERPWD));
            this.param.setUserPwd(userPwd);
        }
        catch (Exception e) {
            boolean bl = SendAlarm.raise(enable, "initAuthority failed: " + ExceptionUtil.getErrorMessage((Throwable)e), new Object[0]);
            return bl;
        }
        finally {
            if (null != fip) {
                try {
                    fip.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e, (Object)"close failed", new Object[0]);
                }
            }
        }
        return true;
    }

    private static boolean raise(boolean enable, String template, Object ... args) {
        if (enable) {
            String message = String.format(Locale.getDefault(), template, args);
            throw new LegoCheckedException(message);
        }
        return false;
    }

    private static String getHAConfigFile() {
        try {
            String runtimePath = PathUtil.getInstallPath();
            String haConfig = runtimePath + HACONFIG;
            File file = new File(haConfig);
            if (!file.exists()) {
                throw new FileNotFoundException("ha config file not found.");
            }
            return haConfig;
        }
        catch (IOException e) {
            throw new LegoCheckedException("getHAConfigFile failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendPostRequest(boolean raise) {
        RestClientImpl restClient = null;
        try {
            restClient = new RestClientImpl(this.param.getListenIp(), this.param.getListenPort(), this.param.getUserName(), this.param.getUserPwd(), this.decrypt);
            restClient.post(this.param.getJSONFormatData());
        }
        catch (Exception e) {
            logger.error((Object)("send post request failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{""});
            boolean bl = SendAlarm.raise(raise, "sendPostRequest failed.", new Object[0]);
            return bl;
        }
        finally {
            if (null != restClient) {
                restClient.closeHttpClient();
            }
        }
        return true;
    }

    public boolean send(boolean raise) {
        return this.initAuthority(raise) && this.sendPostRequest(raise);
    }

    public boolean send(int retryTimes, boolean raise) {
        int count = 0;
        do {
            logger.info((Object)("send alarm at times #" + ++count + ": " + this.param.getJSONFormatData()));
            boolean done = this.send(retryTimes <= 1 && raise);
            if (!done) continue;
            return true;
        } while (count < retryTimes);
        return SendAlarm.raise(raise, "send alarm Failed after %s retry attempts", count);
    }

    private static RequestParam initRequestParam(String[] args) {
        RequestParam param = new RequestParam();
        block22: for (int i = 0; i < args.length && i + 1 < args.length; ++i) {
            String data = args[i + 1];
            switch (args[i]) {
                case "--listenIp": {
                    param.setListenIp(data);
                    continue block22;
                }
                case "--listenPort": {
                    param.setListenPort(data);
                    continue block22;
                }
                case "--param": {
                    param.setParam(data);
                    continue block22;
                }
                case "--type": {
                    param.setType(data);
                    continue block22;
                }
                case "--severity": {
                    param.setSeverity(data);
                    continue block22;
                }
                case "--alarmId": {
                    param.setAlarmId(data);
                    continue block22;
                }
                case "--createTime": {
                    param.setCreateTime(data);
                    continue block22;
                }
                case "--sequence": {
                    param.setSequence(data);
                    continue block22;
                }
                case "--moName": {
                    param.setMoName(data);
                    continue block22;
                }
            }
        }
        SendAlarm.checkIPAndPort(param);
        SendAlarm.checkRequestData(ALARMID, param.getAlarmId());
        SendAlarm.checkRequestData(TYPE, param.getType());
        SendAlarm.checkRequestData(SEVERITY, param.getSeverity());
        SendAlarm.checkRequestData(CREATETIME, param.getCreateTime());
        return param;
    }

    private static void checkRequestData(String key, String data) {
        if (null == data || "".equals(data)) {
            throw new LegoCheckedException("checkRequestData failed. data is null, key=" + key);
        }
        if (PARAMLIST.contains(data)) {
            throw new LegoCheckedException("checkRequestData failed, " + key + " = " + data);
        }
    }

    private static void checkIPAndPort(RequestParam param) {
        if (null == param.getListenIp() || null == param.getListenPort()) {
            throw new LegoCheckedException("ip or port is null.");
        }
        if (!Ipv4AddressUtil.isIPv4Address((String)param.getListenIp()) && !Ipv6AddressUtil.isIPv6Address((String)param.getListenIp())) {
            throw new LegoCheckedException("check ip failed. ip is " + param.getListenIp());
        }
        if (!param.getListenPort().matches("\\d{4,5}") || Integer.parseInt(param.getListenPort()) < 1024 || Integer.parseInt(param.getListenPort()) > 65535) {
            throw new LegoCheckedException("check port failed. port is " + param.getListenPort());
        }
    }
}

