/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.virtualization.alarm;

import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.lego.core.base.thread.MemeryContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlarmGenerator {
    private static Log logger = LogFactory.getInstance(AlarmGenerator.class);

    public static void sendProtectObjectConsistentAlarm(int protectionType, String protectGroupId, String[] invalidMoUuid) {
        if (null == invalidMoUuid || invalidMoUuid.length == 0) {
            return;
        }
        AlarmGenerator.sendProtectObjectConsistentAlarm(protectionType, protectGroupId, AlarmGenerator.getCollectionFromArray(invalidMoUuid));
    }

    public static void sendProtectObjectConsistentAlarm(int protectionType, String protectGroupId, Collection<String> invalidMoUuid) {
        if (VerifyUtil.isEmpty(invalidMoUuid)) {
            return;
        }
        long alarmId = 0x3230022L;
        if (protectionType == ProtectionTypeEnum.HOST_REPLICATION.getValue()) {
            alarmId = 0x3230023L;
        } else if (protectionType == ProtectionTypeEnum.SAN_HIGHAVAILABILITY.getValue() || protectionType == ProtectionTypeEnum.STORAGE_SNAPSHOT.getValue() || protectionType == ProtectionTypeEnum.STORAGE_HYPERVAULT.getValue()) {
            alarmId = 52625441L;
        }
        ProtectGroup protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId, false);
        for (String moUuid : invalidMoUuid) {
            String vmName = "";
            for (ProtectObject po : protectGroup.getPolist()) {
                if (!moUuid.equals(po.getMoUuid())) continue;
                vmName = po.getName();
                break;
            }
            try {
                if (VerifyUtil.isEmpty((String)vmName)) continue;
                AlarmReporter.sendAlarm((long)alarmId, (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{protectGroup.getUuid() + moUuid, vmName, protectGroup.getName()});
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send alarm for protectobject(" + moUuid + ")" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    public static void sendProtectObjectUnsupportedAlarm(String protectGroupId, Collection<String> unsupportedMoUuid) {
        if (VerifyUtil.isEmpty(unsupportedMoUuid)) {
            return;
        }
        ProtectGroup protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId, false);
        for (String moUuid : unsupportedMoUuid) {
            String vmName = "";
            for (ProtectObject po : protectGroup.getPolist()) {
                if (!moUuid.equals(po.getMoUuid())) continue;
                vmName = po.getName();
                break;
            }
            try {
                if (VerifyUtil.isEmpty((String)vmName)) continue;
                AlarmReporter.sendAlarm((long)52625434L, (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{protectGroupId + moUuid, vmName, protectGroup.getName()});
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send alarm for protectobject(" + moUuid + ")" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    public static void sendProtectObjectUnsupportedAlarm(String protectGroupId, String[] unsupportedMoUuid) {
        if (null == unsupportedMoUuid || unsupportedMoUuid.length == 0) {
            return;
        }
        AlarmGenerator.sendProtectObjectUnsupportedAlarm(protectGroupId, AlarmGenerator.getCollectionFromArray(unsupportedMoUuid));
    }

    public static void restoreProtectObjectAlarm(String protectGroupId, Set<String> poToBeDeleted) {
        if (VerifyUtil.isEmpty((String)protectGroupId) || VerifyUtil.isEmpty(poToBeDeleted)) {
            return;
        }
        for (String vmUuid : poToBeDeleted) {
            try {
                AlarmReporter.restoreAlarm((long)0x3230022L, (String[])new String[]{protectGroupId + vmUuid});
                AlarmReporter.restoreAlarm((long)52625441L, (String[])new String[]{protectGroupId + vmUuid});
                AlarmReporter.restoreAlarm((long)0x3230023L, (String[])new String[]{protectGroupId + vmUuid});
                AlarmReporter.restoreAlarm((long)52625434L, (String[])new String[]{protectGroupId + vmUuid});
            }
            catch (Exception e) {
                logger.error((Object)("Failed to restore alarm for protectobject(" + protectGroupId + vmUuid + ")" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    public static void restoreProtectObjectAlarm(String protectGroupId) {
        ProtectGroup protectGroup = (ProtectGroup)MemeryContext.get((Object)protectGroupId, ProtectGroup.class);
        if (protectGroup == null) {
            protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId, false);
        }
        for (ProtectObject po : protectGroup.getPolist()) {
            String vmUuid = po.getMoUuid();
            if (po.getPoStatus() == ProtectObjectStatusEnum.INVALID.getValue() || po.getPoStatus() == ProtectObjectStatusEnum.UNSUPPORTED.getValue()) continue;
            try {
                AlarmReporter.restoreAlarm((long)0x3230022L, (String[])new String[]{protectGroupId + vmUuid});
                AlarmReporter.restoreAlarm((long)52625441L, (String[])new String[]{protectGroupId + vmUuid});
                AlarmReporter.restoreAlarm((long)0x3230023L, (String[])new String[]{vmUuid});
                AlarmReporter.restoreAlarm((long)52625434L, (String[])new String[]{protectGroupId + vmUuid});
                AlarmReporter.restoreAlarm((String)"0x3230027", (String[])new String[]{po.getUuid()});
            }
            catch (Exception e) {
                logger.error((Object)("Failed to restore alarm for protectobject(" + po.getUuid() + ")" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    public static void restoreRemoveProtectObjectAlarm(String protectGroupId, Set<String> poMoUuidSet) {
        if (VerifyUtil.isEmpty((String)protectGroupId) || VerifyUtil.isEmpty(poMoUuidSet)) {
            return;
        }
        ProtectGroup protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId, false);
        for (String poMoUuid : poMoUuidSet) {
            boolean isExistInPg = false;
            for (ProtectObject po : protectGroup.getPolist()) {
                if (!poMoUuid.equals(po.getMoUuid())) continue;
                isExistInPg = true;
                break;
            }
            if (isExistInPg) continue;
            try {
                AlarmReporter.restoreAlarm((long)0x3230022L, (String[])new String[]{protectGroupId + poMoUuid});
                AlarmReporter.restoreAlarm((long)52625441L, (String[])new String[]{protectGroupId + poMoUuid});
                AlarmReporter.restoreAlarm((long)0x3230023L, (String[])new String[]{poMoUuid});
                AlarmReporter.restoreAlarm((long)52625434L, (String[])new String[]{protectGroupId + poMoUuid});
                AlarmReporter.restoreAlarm((long)0x3230020L, (String[])new String[]{poMoUuid});
            }
            catch (Exception e) {
                logger.error((Object)("Failed to restore alarm for protectobject(" + poMoUuid + ")" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    public static void sendProtectGroupInvalidAlarm(ProtectGroup protectGroup) {
        try {
            AlarmReporter.sendAlarm((long)52625421L, (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{protectGroup.getUuid(), protectGroup.getName(), protectGroup.getPoProviderSN()});
        }
        catch (Exception e) {
            logger.error((Object)("Failed to send alarm for group(" + protectGroup.getName() + ")" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    public static void sendProtectObjectRemoveAlarm(String protectGroupId, String protectGroupName, Set<ProtectObject> poToBeDeleted) {
        if (!VerifyUtil.isEmpty(poToBeDeleted)) {
            try {
                for (ProtectObject po : poToBeDeleted) {
                    AlarmReporter.sendAlarm((long)52625422L, (String)protectGroupId, (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{po.getMoUuid(), protectGroupName, po.getName()});
                    AlarmReporter.restoreAlarm((long)0x3230022L, (String[])new String[]{protectGroupId + po.getMoUuid()});
                    AlarmReporter.restoreAlarm((long)52625441L, (String[])new String[]{protectGroupId + po.getMoUuid()});
                    AlarmReporter.restoreAlarm((long)0x3230023L, (String[])new String[]{protectGroupId + po.getMoUuid()});
                    AlarmReporter.restoreAlarm((long)52625434L, (String[])new String[]{protectGroupId + po.getMoUuid()});
                }
            }
            catch (Exception e) {
                logger.error((Object)("send alarm error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
    }

    public static void sendPoRemoveAlarm(String protectGroupId, String protectGroupName, Set<ProtectObject> poToBeDeleted, Map<Long, Long> alarmId) {
        if (!VerifyUtil.isEmpty(poToBeDeleted)) {
            try {
                for (ProtectObject po : poToBeDeleted) {
                    AlarmReporter.sendAlarm((long)AlarmGenerator.getAlarmId(alarmId, 52625422L), (String)protectGroupId, (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{po.getMoUuid(), protectGroupName, po.getName()});
                    AlarmReporter.restoreAlarm((long)AlarmGenerator.getAlarmId(alarmId, 0x3230022L), (String[])new String[]{protectGroupId + po.getMoUuid()});
                    AlarmReporter.restoreAlarm((long)AlarmGenerator.getAlarmId(alarmId, 52625441L), (String[])new String[]{protectGroupId + po.getMoUuid()});
                    AlarmReporter.restoreAlarm((long)AlarmGenerator.getAlarmId(alarmId, 0x3230023L), (String[])new String[]{protectGroupId + po.getMoUuid()});
                    AlarmReporter.restoreAlarm((long)AlarmGenerator.getAlarmId(alarmId, 52625434L), (String[])new String[]{protectGroupId + po.getMoUuid()});
                }
            }
            catch (Exception e) {
                logger.error((Object)("send alarm error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
    }

    public static void operateAlarm(ProtectGroup protectGroup, boolean result) {
        boolean refreshResult = ProtectGroupUtil.refreshProtectGroupReplicas((String)protectGroup.getUuid());
        if (DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus() == protectGroup.getStatus()) {
            if (result && refreshResult) {
                logger.debug((Object)("begin create task for pg:" + protectGroup.getUuid()), 90160758786989L);
                IProtectionTaskService taskService = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
                ITaskManager protectionTaskManager = (ITaskManager)ServiceLocator.getInstance().getService(ITaskManager.class);
                List tasks = taskService.getTasks(protectGroup.getUuid());
                if (VerifyUtil.isEmpty((Collection)tasks)) {
                    taskService.createTask(protectGroup);
                }
                String groupName = protectionTaskManager.getGroupName(protectGroup.getUuid());
                protectionTaskManager.resumeGroup(groupName);
                logger.debug((Object)"end create task", 90160758786989L);
                AlarmReporter.restoreAlarm((long)52625421L, (String[])new String[]{protectGroup.getUuid()});
                ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).updateProtectGroupStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL, new String[]{protectGroup.getUuid()});
            }
        } else if (result && refreshResult) {
            logger.debug((Object)("just set normal for pg:" + protectGroup.getUuid()), 90160758786989L);
            ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).updateProtectGroupStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL, new String[]{protectGroup.getUuid()});
        } else {
            logger.debug((Object)("invalid pg:" + protectGroup.getUuid()), 90160758786989L);
            AlarmGenerator.sendProtectGroupInvalidAlarm(protectGroup);
            ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).updateProtectGroupStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID, new String[]{protectGroup.getUuid()});
        }
    }

    private static Set<String> getCollectionFromArray(String[] arg) {
        HashSet<String> result = new HashSet<String>();
        for (String s : arg) {
            result.add(s);
        }
        return result;
    }

    private static long getAlarmId(Map<Long, Long> alarmIdMap, long alarmId) {
        if (null == alarmIdMap || !alarmIdMap.containsKey(alarmId)) {
            return alarmId;
        }
        return alarmIdMap.get(alarmId);
    }
}

