/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.virtualization.alarm;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.virtualization.util.ProtectionToolsUtil;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DelPgAlarmObserverImpl
implements IObjectObserver {
    public void before(MessageEvent event) {
    }

    public void after(MessageEvent event) {
        block6: {
            int messageType;
            List objectList;
            block5: {
                objectList = event.getObjectList();
                if (VerifyUtil.isEmpty((Collection)objectList)) {
                    return;
                }
                messageType = event.getMessageType();
                if (messageType != 2) break block5;
                for (DRMObject object : objectList) {
                    if (!(object instanceof ProtectGroup)) continue;
                    ProtectGroup pg = (ProtectGroup)object;
                    String pgUuid = pg.getUuid();
                    for (ProtectObject po : pg.getPolist()) {
                        this.restoreProtectObjectAlarm(pgUuid, po.getMoUuid());
                    }
                }
                break block6;
            }
            if (messageType != 4) break block6;
            for (DRMObject object : objectList) {
                if (!(object instanceof ProtectGroup)) continue;
                ProtectGroup pg = (ProtectGroup)object;
                ProtectGroup dbPg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pg.getUuid(), false);
                Map<String, TaskResultItem> resultItemMap = ProtectionToolsUtil.getInstance().getResultItemMap(event);
                for (ProtectObject po : dbPg.getPolist()) {
                    TaskResultItem item;
                    if (pg.getPolist().contains(po) || VerifyUtil.isEmpty((Object)(item = resultItemMap.get(po.getUuid()))) || CommonConstant.BACKTASK_RESULT_SUCCESS != item.getResult()) continue;
                    this.restoreProtectObjectAlarm(po.getProtectGroup().getUuid(), po.getMoUuid());
                }
            }
        }
    }

    private void restoreProtectObjectAlarm(String pgUuid, String moUuid) {
        AlarmReporter.restoreAlarm((long)0x3230022L, (String[])new String[]{pgUuid + moUuid});
        AlarmReporter.restoreAlarm((long)52625441L, (String[])new String[]{pgUuid + moUuid});
        AlarmReporter.restoreAlarm((long)0x3230023L, (String[])new String[]{moUuid});
        AlarmReporter.restoreAlarm((long)52625434L, (String[])new String[]{pgUuid + moUuid});
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }
}

