/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.virtualization.license.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.license.sdk.ILicenseUseInter;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.drm.virtualization.sdk.service.IVirtualizationLicenseUseInter;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;

public class VirtualizationLicenseUseInterImpl
implements ILicenseUseInter {
    private static Log logger = LogFactory.getInstance(VirtualizationLicenseUseInterImpl.class);
    private static Map<String, IVirtualizationLicenseUseInter> virLicenseService = new HashMap<String, IVirtualizationLicenseUseInter>();

    public void onBind(IVirtualizationLicenseUseInter provider, Map<?, ?> properties) {
        virLicenseService.put(provider.getVmType(), provider);
    }

    public void onUnbind(IVirtualizationLicenseUseInter provider, Map<?, ?> properties) {
        virLicenseService.remove(provider.getVmType());
    }

    public int getUseCount() {
        int n;
        int result = 0;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            List mountedVms = RecoveryUtil.getMountedResources((Session)session, (Boolean)true);
            for (Map.Entry<String, IVirtualizationLicenseUseInter> entry : virLicenseService.entrySet()) {
                logger.debug((Object)("begin get vmcount by " + entry.getKey()));
                int temp = entry.getValue().getUseCount(mountedVms, session);
                logger.debug((Object)("get vmcount by " + entry.getKey() + ":" + temp));
                result += temp;
                logger.debug((Object)("end get vmcount by " + entry.getKey()));
            }
            n = result + new HashSet(mountedVms).size();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("get vm count error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                throw e;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return n;
    }

    public String getType() {
        return "LSTQDPMP";
    }
}

