/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.virtualization.observer;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ObserverManager {
    private static final Log LOGGER = LogFactory.getInstance(ObserverManager.class);
    private static Map<String, ObserverManager> mapMgr = new HashMap<String, ObserverManager>();
    private Watched observable = new Watched();

    public static synchronized ObserverManager getInstance(String type) {
        if (VerifyUtil.isEmpty((String)type)) {
            LOGGER.error((Object)"parameter type is empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ObserverManager mgr = mapMgr.get(type);
        if (null == mgr) {
            mgr = new ObserverManager();
            mapMgr.put(type, mgr);
        }
        return mgr;
    }

    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observable.deleteObserver(observer);
    }

    public void asyncNotifyAllObservers(Object obj) {
        this.observable.submitNotify(obj);
    }

    public synchronized void syncNotifyAllObservers(Object obj) {
        try {
            this.observable.notifyAllObservers(obj);
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to notify observers." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    private static class ObserverTask
    implements Runnable {
        private Object obj;
        private Watched watcher;

        public ObserverTask(Object notifyObj, Watched watcherObj) {
            this.obj = notifyObj;
            this.watcher = watcherObj;
        }

        @Override
        public void run() {
            try {
                this.watcher.notifyAllObservers(this.obj);
            }
            catch (Exception e) {
                LOGGER.error((Object)("failed to notify observers." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
    }

    private static class Watched
    extends Observable {
        private ExecutorService execService = Executors.newSingleThreadExecutor();

        private Watched() {
        }

        public void submitNotify(Object notifyObj) {
            this.execService.execute(new ObserverTask(notifyObj, this));
        }

        public void notifyAllObservers(Object notifyObj) {
            this.setChanged();
            super.notifyObservers(notifyObj);
        }
    }
}

