/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.virtualization.service.impl;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshDelegate;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ProtectGroupRefreshDelegateImpl
implements IProtectGroupRefreshDelegate {
    private static final Log logger = LogFactory.getInstance(ProtectGroupRefreshDelegateImpl.class);
    private static final String TYPE_KEY = "type";
    private Map<String, IProtectGroupRefreshService> refreshPgServiceMapping = new HashMap<String, IProtectGroupRefreshService>();

    public void onBind(IProtectGroupRefreshService service, Map<String, Object> props) {
        block3: {
            Object type;
            block4: {
                block2: {
                    type = props.get(TYPE_KEY);
                    if (!(type instanceof String)) break block2;
                    this.refreshPgServiceMapping.put((String)type, service);
                    break block3;
                }
                if (!(type instanceof String[])) break block4;
                for (String each : (String[])type) {
                    this.refreshPgServiceMapping.put(each, service);
                }
                break block3;
            }
            if (!(type instanceof Collection)) break block3;
            for (Object each : (Collection)type) {
                this.refreshPgServiceMapping.put(each.toString(), service);
            }
        }
    }

    public void onUnbind(IProtectGroupRefreshService service, Map<String, Object> props) {
        block3: {
            Object type;
            block4: {
                block2: {
                    type = props.get(TYPE_KEY);
                    if (!(type instanceof String)) break block2;
                    this.unbind((String)type);
                    break block3;
                }
                if (!(type instanceof String[])) break block4;
                for (String each : (String[])type) {
                    this.unbind(each);
                }
                break block3;
            }
            if (!(type instanceof Collection)) break block3;
            for (Object each : (Collection)type) {
                this.unbind(each.toString());
            }
        }
    }

    public void refreshProtectGroup(String cloudUuid, Set<String> forceRefreshSet) {
        ArrayList pgList = new ArrayList();
        for (ProtectGroup protectGroup : pgList) {
            if (!this.checkRefreshPgIsAvailable(protectGroup, forceRefreshSet)) {
                logger.info((Object)("PG can not be refreshed because of RecoveryPlan status:" + protectGroup.getName()), 90160758786816L);
                continue;
            }
            String type = String.valueOf(protectGroup.getTemplate().getType());
            IProtectGroupRefreshService protectGroupRefreshService = this.refreshPgServiceMapping.get(type);
            if (null != protectGroupRefreshService) {
                protectGroupRefreshService.refreshProtectGroup(protectGroup);
                continue;
            }
            logger.info((Object)("There is no refreshService for protectGroup type :" + type), 90160758786816L);
        }
        ILicenseControl licenseCtr = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        licenseCtr.checkLicenseOutOfControlAlarm(true);
    }

    private void unbind(String type) {
        this.refreshPgServiceMapping.remove(type);
    }

    private boolean checkRefreshPgIsAvailable(ProtectGroup protectGroup, Set<String> forceRefreshSet) {
        if (!VerifyUtil.isEmpty(forceRefreshSet) && forceRefreshSet.contains(protectGroup.getUuid())) {
            logger.info((Object)("the pg will be forced refreshed " + protectGroup.getName()), 90160758786816L);
            return true;
        }
        boolean isUsedProtectGroupByRp = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).isUsedProtectGroupByRp(protectGroup.getUuid());
        if (isUsedProtectGroupByRp) {
            String planId = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getAssociatedRecoveryPlanWithProtectGroup(protectGroup.getUuid());
            RecoveryPlan plan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(planId);
            if (null == plan) {
                return false;
            }
            return RecoveryToolsUtil.getInstance().isPgCanBeRefreshed(plan);
        }
        return true;
    }
}

